/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.dto.portal.ActionFunctionResp;
import com.digiwin.athena.semc.entity.portal.ActionFunctionMapping;
import com.digiwin.athena.semc.mapper.portal.UserActionMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.portal.IUserActionService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserActionServiceImpl
extends ServiceImpl<UserActionMapper, ActionFunctionMapping>
implements IUserActionService {
    @Resource
    private IamService iamService;
    @Autowired
    UserActionMapper userActionMapper;
    private static final String ACCESS_ALLOW = "allow";
    private static final Integer FUNCTION_SIDE = 0;

    public List<ActionFunctionResp> queryUserFunctionList(AuthoredUser authoredUser) {
        ArrayList functionRespList = Lists.newArrayList();
        JSONArray jsonArray = this.iamService.queryUserPermissionV2(authoredUser);
        if (CollectionUtils.isEmpty((Collection)jsonArray)) {
            return functionRespList;
        }
        ArrayList actionIdList = Lists.newArrayList();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (!StringUtils.equalsIgnoreCase((CharSequence)ACCESS_ALLOW, (CharSequence)jsonObject.getString("effect"))) continue;
            actionIdList.add(jsonObject.getString("id"));
        }
        if (CollectionUtils.isEmpty((Collection)actionIdList)) {
            return functionRespList;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"function_side", (Object)FUNCTION_SIDE);
        queryWrapper.in((Object)"action_id", (Collection)actionIdList);
        List functionMappingList = this.userActionMapper.selectList((Wrapper)queryWrapper);
        Map<String, List<ActionFunctionMapping>> actionIdMap = functionMappingList.stream().collect(Collectors.groupingBy(ActionFunctionMapping::getActionId));
        actionIdMap.forEach((k, v) -> {
            ActionFunctionResp actionFunctionResp = new ActionFunctionResp();
            actionFunctionResp.setActionId(k);
            actionFunctionResp.setActionName(((ActionFunctionMapping)v.get(0)).getActionName());
            actionFunctionResp.setFunctionList(v);
            functionRespList.add(actionFunctionResp);
        });
        return functionRespList;
    }
}

