/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.sso.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.ErpAppNameEnum;
import com.digiwin.athena.semc.dto.erpsso.AddSsoInfoReq;
import com.digiwin.athena.semc.dto.erpsso.QueryDisplayReq;
import com.digiwin.athena.semc.dto.erpsso.QuerySsoListReq;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ErpSsoParam;
import com.digiwin.athena.semc.mapper.sso.ErpSsoInfoMapper;
import com.digiwin.athena.semc.mapper.sso.ErpSsoParamMapper;
import com.digiwin.athena.semc.service.sso.IErpSsoInfoService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ErpSsoInfoServiceImpl
extends ServiceImpl<ErpSsoInfoMapper, ErpSsoInfo>
implements IErpSsoInfoService {
    @Autowired
    ErpSsoParamMapper erpSsoParamMapper;
    @Autowired
    ErpSsoInfoMapper erpSsoInfoMapper;

    public List<ErpSsoInfo> querySsoList(String tenantId, Integer protocolType) {
        QuerySsoListReq querySsoListReq = new QuerySsoListReq();
        if (StringUtils.isNotBlank((CharSequence)tenantId)) {
            querySsoListReq.setTenantId(tenantId);
        }
        querySsoListReq.setProtocolType(protocolType);
        List ssoInfoList = this.erpSsoInfoMapper.querySsoListByScope(querySsoListReq);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)ssoInfoList)) {
            return ssoInfoList;
        }
        List ssoParamList = this.erpSsoParamMapper.selectList((Wrapper)Wrappers.emptyWrapper());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)ssoParamList)) {
            return ssoInfoList;
        }
        Map<Long, List<ErpSsoParam>> infoIdMap = ssoParamList.stream().collect(Collectors.groupingBy(ErpSsoParam::getSsoInfoId));
        ssoInfoList.forEach(x -> {
            List paramList = (List)infoIdMap.get(x.getId());
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)paramList)) {
                HashMap paramMap = Maps.newHashMap();
                paramList.forEach(y -> paramMap.put(y.getParam(), y.getValue()));
                if (MapUtils.isEmpty((Map)x.getExt())) {
                    x.setExt((Map)paramMap);
                } else {
                    x.getExt().putAll(paramMap);
                }
            }
        });
        return ssoInfoList;
    }

    public List<ErpSsoInfo> existByNameOrAppToken(Long id, String appCode, String appName, String appToken) {
        QueryWrapper infoQueryWrapper = new QueryWrapper();
        if (id != null) {
            infoQueryWrapper.ne((Object)"id", (Object)id);
        }
        if (StringUtils.isBlank((CharSequence)appToken)) {
            infoQueryWrapper.and(x -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.eq((Object)"name", (Object)appName)).or()).eq((Object)"code", (Object)appCode);
            });
        } else {
            infoQueryWrapper.and(x -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)x.eq((Object)"name", (Object)appName)).or()).eq((Object)"code", (Object)appCode)).or()).eq((Object)"app_token", (Object)appToken);
            });
        }
        return this.erpSsoInfoMapper.selectList((Wrapper)infoQueryWrapper);
    }

    @Transactional
    public Long saveOrUpdateSsoInfo(AddSsoInfoReq addSsoInfoReq) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        ErpSsoInfo erpSsoInfo = new ErpSsoInfo();
        erpSsoInfo.setId(addSsoInfoReq.getId());
        erpSsoInfo.setAppSid(addSsoInfoReq.getAppSid());
        erpSsoInfo.setTenantId(tenantId);
        erpSsoInfo.setCode(addSsoInfoReq.getCode());
        erpSsoInfo.setName(addSsoInfoReq.getName());
        erpSsoInfo.setAppDesc(addSsoInfoReq.getDesc());
        erpSsoInfo.setLocationType(addSsoInfoReq.getLocationType());
        erpSsoInfo.setPrefix(addSsoInfoReq.getPrefix());
        erpSsoInfo.setClientLocation(addSsoInfoReq.getClientLocation());
        erpSsoInfo.setProtocolType(addSsoInfoReq.getProtocolType());
        erpSsoInfo.setCasServerUrl(addSsoInfoReq.getCasServerUrl());
        erpSsoInfo.setBase64Encode(addSsoInfoReq.getBase64Encode() == null ? Constants.ERP_URL_NO_NEEDBASE64 : addSsoInfoReq.getBase64Encode());
        erpSsoInfo.setAppToken(addSsoInfoReq.getAppToken());
        erpSsoInfo.setCallBackUrl(String.format("http://www.%s.com", addSsoInfoReq.getCode()));
        erpSsoInfo.setAppId(addSsoInfoReq.getAppId());
        erpSsoInfo.setAppSecret(addSsoInfoReq.getAppSecret());
        erpSsoInfo.setUserBindFlag(addSsoInfoReq.getUserBindFlag());
        if (erpSsoInfo.getId() == null) {
            this.erpSsoInfoMapper.insert((Object)erpSsoInfo);
            this.saveSsoParam(addSsoInfoReq, tenantId, erpSsoInfo.getId());
        } else {
            this.erpSsoInfoMapper.updateById((Object)erpSsoInfo);
            this.deleteErpSsoParams(erpSsoInfo.getId());
            this.saveSsoParam(addSsoInfoReq, tenantId, erpSsoInfo.getId());
        }
        return erpSsoInfo.getId();
    }

    private void saveSsoParam(AddSsoInfoReq addSsoInfoReq, String tenantId, Long ssoId) {
        ArrayList erpSsoParamList = Lists.newArrayList();
        JSONObject jsonObject = JSONObject.parseObject((String)addSsoInfoReq.getExt());
        if (jsonObject != null) {
            jsonObject.forEach((k, v) -> {
                ErpSsoParam erpSsoParam = new ErpSsoParam();
                erpSsoParam.setSsoInfoId(ssoId);
                erpSsoParam.setTenantId(tenantId);
                erpSsoParam.setParam(k);
                erpSsoParam.setValue(String.valueOf(v));
                erpSsoParamList.add(erpSsoParam);
            });
            this.erpSsoParamMapper.batchInsertSsoParamList((List)erpSsoParamList);
        }
    }

    public void deleteErpSsoParams(Long ssoId) {
        ErpSsoParam param = new ErpSsoParam();
        param.setSsoInfoId(ssoId);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.setEntity((Object)param);
        this.erpSsoParamMapper.delete((Wrapper)queryWrapper);
    }

    public ErpSsoInfo querySsoInfo(Long ssoId) {
        QueryWrapper infoQueryWrapper = new QueryWrapper();
        infoQueryWrapper.eq((Object)"id", (Object)ssoId);
        ErpSsoInfo erpSsoInfo = (ErpSsoInfo)this.erpSsoInfoMapper.selectOne((Wrapper)infoQueryWrapper);
        QueryWrapper paramWrapper = new QueryWrapper();
        paramWrapper.eq((Object)"sso_info_id", (Object)ssoId);
        List ssoParamList = this.erpSsoParamMapper.selectList((Wrapper)paramWrapper);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)ssoParamList)) {
            HashMap paramMap = Maps.newHashMap();
            ssoParamList.forEach(y -> paramMap.put(y.getParam(), y.getValue()));
            erpSsoInfo.setExt((Map)paramMap);
        }
        return erpSsoInfo;
    }

    public int updateSsoStatus(Long ssoInfoId, Integer status) {
        return ((ErpSsoInfoMapper)this.baseMapper).updateStatusById(ssoInfoId, status, AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
    }

    public void updateBindFlag(List<Long> ssoIdList, Integer userBindFlag) {
        ((ErpSsoInfoMapper)this.baseMapper).updateBindFlag(ssoIdList, userBindFlag, AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
    }

    public List<ErpSsoInfo> querySsoListByScope(QuerySsoListReq querySsoListReq) {
        return ((ErpSsoInfoMapper)this.baseMapper).querySsoListByScope(querySsoListReq);
    }

    public List<String> queryTenantIdByAppId(String appId) {
        return ((ErpSsoInfoMapper)this.baseMapper).queryTenantIdByAppId(appId);
    }

    public Map<Long, ErpSsoInfo> getErpInfoMap(List<String> csIdList) {
        Map<Long, Object> erpInfoMap = new HashMap<Long, ErpSsoInfo>();
        if (CollectionUtils.isEmpty(csIdList)) {
            return erpInfoMap;
        }
        QuerySsoListReq querySsoListReq = new QuerySsoListReq();
        List idList = csIdList.stream().map(Long::parseLong).collect(Collectors.toList());
        querySsoListReq.setIdList(idList);
        List erpInfoList = this.erpSsoInfoMapper.querySsoListByScope(querySsoListReq);
        erpInfoMap = erpInfoList.stream().collect(Collectors.toMap(ErpSsoInfo::getId, Function.identity(), (a, b) -> a));
        return erpInfoMap;
    }

    public List<ErpSsoInfo> erpSsoInfoWithParams() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"valid_status", (Object)Constants.VALID_STATUS_ENABLE);
        List infos = this.erpSsoInfoMapper.selectList((Wrapper)queryWrapper);
        List params = this.erpSsoParamMapper.selectList((Wrapper)Wrappers.emptyWrapper());
        for (ErpSsoInfo info : infos) {
            this.generateFullPath(info, params);
        }
        return infos;
    }

    public ErpSsoInfo erpSsoInfoWithParams(AuthoredUser user, QueryDisplayReq req) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"valid_status", (Object)Constants.VALID_STATUS_ENABLE);
        queryWrapper.eq((Object)"code", (Object)req.getErpAppName());
        List infos = this.erpSsoInfoMapper.selectList((Wrapper)queryWrapper);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)infos)) {
            return null;
        }
        ErpSsoInfo info = (ErpSsoInfo)infos.get(0);
        QueryWrapper queryParamWrapper = new QueryWrapper();
        queryParamWrapper.eq((Object)"sso_info_id", (Object)info.getId());
        List params = this.erpSsoParamMapper.selectList((Wrapper)queryParamWrapper);
        if (ErpAppNameEnum.E10.getValue().equalsIgnoreCase(req.getErpAppName())) {
            this.preDealForE10(req.getDynamicParams());
        }
        this.addDynamicParams(info, params, req.getDynamicParams());
        this.generateFullPath(info, params);
        return info;
    }

    private void preDealForE10(Map<String, String> dynamicParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        Iterator<Map.Entry<String, String>> iterator = dynamicParams.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if ("PRID".equalsIgnoreCase(entry.getKey())) {
                iterator.remove();
                params.put("ProgramId", entry.getValue());
                continue;
            }
            if (!"CompanyId".equalsIgnoreCase(entry.getKey())) continue;
            iterator.remove();
            params.put("accountId", entry.getValue());
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(params)) {
            dynamicParams.putAll(params);
        }
    }

    private void addDynamicParams(ErpSsoInfo info, List<ErpSsoParam> params, Map<String, String> dynamicParams) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(dynamicParams)) {
            return;
        }
        dynamicParams.entrySet().forEach(dynamicPara -> {
            Optional<ErpSsoParam> paramOptional = params.stream().filter(param -> param.getParam().equalsIgnoreCase((String)dynamicPara.getKey())).findFirst();
            if (paramOptional.isPresent()) {
                paramOptional.get().setValue((String)dynamicPara.getValue());
            } else {
                ErpSsoParam param2 = new ErpSsoParam();
                param2.setSsoInfoId(info.getId());
                param2.setParam((String)dynamicPara.getKey());
                param2.setValue((String)dynamicPara.getValue());
                params.add(param2);
            }
        });
    }

    private void generateFullPath(ErpSsoInfo info, List<ErpSsoParam> params) {
        if (info.getProtocolType().equals(1)) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder.append(StringUtils.stripToEmpty((String)info.getPrefix())).append(StringUtils.stripToEmpty((String)info.getClientLocation())).append(StringUtils.stripToEmpty((String)info.getSuffix()));
            if (info.getLocationType() != null && Constants.PRESCRIBED_ROUTE.equals(info.getLocationType())) {
                stringBuilder.append("?");
            }
            stringBuilder2.append("appToken").append("=").append(info.getAppToken()).append("&");
            stringBuilder2.append("curLocale=").append(LocaleContextHolder.getLocale()).append("&");
            stringBuilder2.append("appCode=").append(info.getCode()).append("&");
            if (StringUtils.isBlank((CharSequence)info.getAppId())) {
                stringBuilder2.append("userToken").append("=").append(AppAuthContextHolder.getContext().getAuthoredUser().getToken());
            } else {
                stringBuilder2.append("tenantId").append("=").append(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId()).append("&");
                stringBuilder2.append("callBackUrl").append("=").append(info.getCallBackUrl()).append("&").append("appId").append("=").append(info.getAppId()).append("&").append("bindMode").append("=").append(info.getUserBindFlag());
            }
            if (Constants.BindFlagEnum.NO.getFlag().equals(info.getUserBindFlag())) {
                stringBuilder2.append("userToken").append("=").append(AppAuthContextHolder.getContext().getAuthoredUser().getToken());
            }
            for (ErpSsoParam param : params) {
                if (!Objects.equals(info.getId(), param.getSsoInfoId()) || null == param.getParam() || null == param.getValue()) continue;
                stringBuilder2.append("&");
                stringBuilder2.append(param.getParam()).append("=").append(param.getValue());
            }
            if (null == info.getExt()) {
                info.setExt(new HashMap());
            }
            String str1 = stringBuilder.toString();
            String str2 = stringBuilder2.toString();
            if (Constants.ERP_URL_NEEDBASE64.equals(info.getBase64Encode())) {
                str2 = Base64.getEncoder().encodeToString(str2.getBytes(StandardCharsets.UTF_8));
            }
            String fullpath = str1 + str2;
            info.getExt().put("_fullpath", fullpath);
        }
        if (info.getProtocolType().equals(2)) {
            if (null == info.getExt()) {
                info.setExt(new HashMap());
            }
            info.getExt().put("_fullpath", info.getCallBackUrl());
        }
        if (info.getProtocolType().equals(3)) {
            if (null == info.getExt()) {
                info.setExt(new HashMap());
            }
            info.getExt().put("_fullpath", info.getCallBackUrl());
        }
    }
}

