/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.sso.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.entity.sso.MobileSsoInfo;
import com.digiwin.athena.semc.mapper.sso.MobileSsoInfoMapper;
import com.digiwin.athena.semc.service.sso.IMobileSsoInfoService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class MobileSsoInfoServiceImpl
extends ServiceImpl<MobileSsoInfoMapper, MobileSsoInfo>
implements IMobileSsoInfoService {
    @Autowired
    MobileSsoInfoMapper mobileSsoInfoMapper;

    public List<MobileSsoInfo> existMobileApp(MobileSsoInfo mobileSsoInfo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (ObjectUtils.isNotEmpty((Object)mobileSsoInfo.getId())) {
            queryWrapper.ne((Object)"id", (Object)mobileSsoInfo.getId());
        }
        if (StringUtils.isBlank((CharSequence)mobileSsoInfo.getAppToken())) {
            queryWrapper.and(x -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.eq((Object)"app_name", (Object)mobileSsoInfo.getAppName())).or()).eq((Object)"app_code", (Object)mobileSsoInfo.getAppCode());
            });
        } else {
            queryWrapper.and(x -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)x.eq((Object)"app_name", (Object)mobileSsoInfo.getAppName())).or()).eq((Object)"app_code", (Object)mobileSsoInfo.getAppCode())).or()).eq((Object)"app_token", (Object)mobileSsoInfo.getAppToken());
            });
        }
        return this.mobileSsoInfoMapper.selectList((Wrapper)queryWrapper);
    }

    public Long saveMobileSso(MobileSsoInfo mobileSsoInfoReq) {
        mobileSsoInfoReq.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        if (ObjectUtils.isEmpty((Object)mobileSsoInfoReq.getId())) {
            this.mobileSsoInfoMapper.insert((Object)mobileSsoInfoReq);
        } else {
            this.mobileSsoInfoMapper.updateById((Object)mobileSsoInfoReq);
        }
        return mobileSsoInfoReq.getId();
    }

    public MobileSsoInfo queryMobileSsoInfo(Long id) {
        QueryWrapper infoQueryWrapper = new QueryWrapper();
        infoQueryWrapper.eq((Object)"id", (Object)id);
        return (MobileSsoInfo)this.mobileSsoInfoMapper.selectOne((Wrapper)infoQueryWrapper);
    }

    public List<MobileSsoInfo> queryMobileLinkSsoList(Long id) {
        List mobileSsoInfoList;
        QueryWrapper wrapper = new QueryWrapper();
        if (ObjectUtils.isNotEmpty((Object)id)) {
            wrapper.eq((Object)"id", (Object)id);
        }
        if (CollectionUtils.isEmpty((Collection)(mobileSsoInfoList = this.mobileSsoInfoMapper.selectList((Wrapper)wrapper)))) {
            return mobileSsoInfoList;
        }
        for (MobileSsoInfo info : mobileSsoInfoList) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(StringUtils.stripToEmpty((String)info.getCallBackUrl()));
            stringBuilder.append(info.getCallBackUrl().contains("?") ? "&" : "?");
            stringBuilder.append("appToken").append("=").append(info.getAppToken()).append("&");
            stringBuilder.append("curLocale=").append(LocaleContextHolder.getLocale()).append("&");
            stringBuilder.append("appCode=").append(info.getAppCode()).append("&");
            stringBuilder.append("tenantId").append("=").append(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId()).append("&");
            stringBuilder.append("appId").append("=").append(info.getAppId()).append("&");
            stringBuilder.append("bindMode").append("=").append(info.getUserBindFlag());
            if (Constants.BindFlagEnum.NO.getFlag().equals(info.getUserBindFlag())) {
                stringBuilder.append("&").append("userToken").append("=").append(AppAuthContextHolder.getContext().getAuthoredUser().getToken());
            }
            info.setMobileLinkUrl(stringBuilder.toString());
        }
        return mobileSsoInfoList;
    }
}

