/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.sso.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.ProtocolTypeEnum;
import com.digiwin.athena.semc.dto.erpsso.QuerySsoListReq;
import com.digiwin.athena.semc.dto.erpsso.RegisterDTO;
import com.digiwin.athena.semc.dto.erpsso.ThirdSsoInfoDto;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.mapper.sso.ThirdSsoInfoMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.sso.IThirdSsoInfoService;
import io.github.linpeilie.Converter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class ThirdSsoInfoServiceImpl
extends ServiceImpl<ThirdSsoInfoMapper, ThirdSsoInfo>
implements IThirdSsoInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdSsoInfoServiceImpl.class);
    @Resource
    private IamService iamService;
    @Autowired
    ThirdSsoInfoMapper thirdSsoInfoMapper;
    @Resource
    private Converter converter;

    public List<ThirdSsoInfo> existThirdSso(Long id, String appCode, String appName, String appToken) {
        QueryWrapper infoQueryWrapper = new QueryWrapper();
        if (id != null) {
            infoQueryWrapper.ne((Object)"id", (Object)id);
        }
        if (StringUtils.isBlank((CharSequence)appToken)) {
            infoQueryWrapper.and(x -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.eq((Object)"app_name", (Object)appName)).or()).eq((Object)"app_code", (Object)appCode);
            });
        } else {
            infoQueryWrapper.and(x -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)x.eq((Object)"app_name", (Object)appName)).or()).eq((Object)"app_code", (Object)appCode)).or()).eq((Object)"app_token", (Object)appToken);
            });
        }
        return this.thirdSsoInfoMapper.selectList((Wrapper)infoQueryWrapper);
    }

    public Long saveOrUpdateThirdSso(ThirdSsoInfo thirdSsoInfo) {
        thirdSsoInfo.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        if (thirdSsoInfo.getId() == null) {
            this.thirdSsoInfoMapper.insert((Object)thirdSsoInfo);
        } else {
            this.thirdSsoInfoMapper.updateById((Object)thirdSsoInfo);
        }
        return thirdSsoInfo.getId();
    }

    public ThirdSsoInfo queryThirdSsoInfo(Long ssoId) {
        QueryWrapper infoQueryWrapper = new QueryWrapper();
        infoQueryWrapper.eq((Object)"id", (Object)ssoId);
        return (ThirdSsoInfo)this.thirdSsoInfoMapper.selectOne((Wrapper)infoQueryWrapper);
    }

    public int updateThirdSsoStatus(Long ssoInfoId, Integer status) {
        return ((ThirdSsoInfoMapper)this.baseMapper).updateThirdStatusById(ssoInfoId, status, AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
    }

    public void updateBindFlag(List<Long> ssoIdList, Integer userBindFlag) {
        ((ThirdSsoInfoMapper)this.baseMapper).updateBindFlag(ssoIdList, userBindFlag, AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
    }

    public RegisterDTO registerApp(RegisterDTO registerDTO) throws Exception {
        Long appSid = this.iamService.registerApp(registerDTO);
        return this.iamService.queryAppInfo(appSid, registerDTO.getAppToken());
    }

    public List<ThirdSsoInfoDto> erpSsoInfoWithParams() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"valid_status", (Object)Constants.VALID_STATUS_ENABLE);
        List infos = this.thirdSsoInfoMapper.selectList((Wrapper)queryWrapper);
        ArrayList<ThirdSsoInfoDto> dtos = CollectionUtils.isEmpty((Collection)infos) ? new ArrayList<ThirdSsoInfoDto>() : infos.stream().map(info -> {
            ThirdSsoInfoDto dto = (ThirdSsoInfoDto)this.converter.convert(info, ThirdSsoInfoDto.class);
            dto.setName(info.getAppName());
            return dto;
        }).collect(Collectors.toList());
        for (ThirdSsoInfoDto info2 : dtos) {
            if (ProtocolTypeEnum.OAUTH.getType().equals(info2.getProtocolType())) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(StringUtils.stripToEmpty((String)info2.getCallBackUrl()));
                stringBuilder.append(info2.getCallBackUrl().contains("?") ? "&" : "?");
                stringBuilder.append("appToken").append("=").append(info2.getAppToken()).append("&");
                stringBuilder.append("curLocale=").append(LocaleContextHolder.getLocale()).append("&");
                stringBuilder.append("appCode=").append(info2.getAppCode()).append("&");
                stringBuilder.append("tenantId").append("=").append(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId()).append("&");
                stringBuilder.append("appId").append("=").append(info2.getAppId()).append("&");
                stringBuilder.append("bindMode").append("=").append(info2.getUserBindFlag());
                if (Constants.BindFlagEnum.NO.getFlag().equals(info2.getUserBindFlag())) {
                    stringBuilder.append("&").append("userToken").append("=").append(AppAuthContextHolder.getContext().getAuthoredUser().getToken());
                }
                if (null == info2.getExt()) {
                    info2.setExt(new HashMap());
                }
                String fullpath = stringBuilder.toString();
                info2.getExt().put("_fullpath", fullpath);
                info2.setCode(info2.getAppCode());
            }
            if (ProtocolTypeEnum.CAS.getType().equals(info2.getProtocolType())) {
                if (null == info2.getExt()) {
                    info2.setExt(new HashMap());
                }
                info2.getExt().put("_fullpath", info2.getCallBackUrl());
                info2.setCode(info2.getAppCode());
            }
            if (!ProtocolTypeEnum.SAML.getType().equals(info2.getProtocolType())) continue;
            if (null == info2.getExt()) {
                info2.setExt(new HashMap());
            }
            info2.getExt().put("_fullpath", info2.getCallBackUrl());
            info2.setCode(info2.getAppCode());
        }
        return dtos;
    }

    public List<ThirdSsoInfo> queryThirdListByScope(QuerySsoListReq querySsoListReq) {
        return ((ThirdSsoInfoMapper)this.baseMapper).queryThirdListByScope(querySsoListReq);
    }

    public Map<Long, ThirdSsoInfo> getSsoInfoMap(List<String> bsIdList) {
        Map<Long, Object> thirdSsoInfoMap = new HashMap<Long, ThirdSsoInfo>();
        if (CollectionUtils.isEmpty(bsIdList)) {
            return thirdSsoInfoMap;
        }
        QuerySsoListReq querySsoListReq = new QuerySsoListReq();
        List idList = bsIdList.stream().map(Long::parseLong).collect(Collectors.toList());
        querySsoListReq.setIdList(idList);
        List thirdSsoInfoList = this.thirdSsoInfoMapper.queryThirdListByScope(querySsoListReq);
        thirdSsoInfoMap = thirdSsoInfoList.stream().collect(Collectors.toMap(ThirdSsoInfo::getId, Function.identity(), (a, b) -> a));
        return thirdSsoInfoMap;
    }
}

