/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.temp.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.event.SyncReadListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.entity.temp.TemplateBench;
import com.digiwin.athena.semc.entity.temp.TemplateBenchCustom;
import com.digiwin.athena.semc.entity.temp.TemplateBenchImport;
import com.digiwin.athena.semc.entity.temp.TemplateInfo;
import com.digiwin.athena.semc.entity.temp.TemplateSystemCustom;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.temp.TemplateBenchCustomMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateBenchImportMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateBenchMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateInfoMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateInfoTenantMapper;
import com.digiwin.athena.semc.proxy.mdc.MdcService;
import com.digiwin.athena.semc.service.portal.IImportRecordService;
import com.digiwin.athena.semc.service.temp.TemplateBenchService;
import com.digiwin.athena.semc.service.temp.TemplateInfoService;
import com.digiwin.athena.semc.service.temp.TemplateSystemCustomService;
import com.digiwin.athena.semc.service.temp.impl.TemplateBenchWriteHandler;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.bench.JobBenchImportVo;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import com.digiwin.athena.semc.vo.temp.TemplateBenchExportVo;
import com.digiwin.athena.semc.vo.temp.TemplateBenchImportVo;
import com.digiwin.athena.semc.vo.temp.TemplateBenchVO;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.google.common.collect.Lists;
import io.github.linpeilie.Converter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TemplateBenchServiceImpl
extends ServiceImpl<TemplateBenchMapper, TemplateBench>
implements TemplateBenchService {
    @Resource
    TemplateInfoMapper templateInfoMapper;
    @Resource
    TemplateInfoTenantMapper templateInfoTenantMapper;
    @Resource
    TemplateBenchMapper templateBenchMapper;
    @Resource
    TemplateBenchCustomMapper templateBenchCustomMapper;
    @Resource
    TemplateInfoService templateInfoService;
    @Resource
    TemplateSystemCustomService templateSystemCustomService;
    @Resource
    private IImportRecordService importRecordService;
    @Resource
    TemplateBenchImportMapper templateBenchImportMapper;
    @Resource
    private EnvProperties envProperties;
    @Autowired
    MdcService mdcService;
    @Resource
    private Converter converter;

    @Transactional(rollbackFor={Exception.class})
    public TemplateBenchVO saveBenchTemp(TemplateBenchVO req) {
        TemplateInfo templateInfo = this.packageTemplateInfo(req);
        Long tempId = this.templateInfoService.saveTemp(templateInfo);
        if (null != req.getId()) {
            this.templateBenchMapper.deleteById((Serializable)req.getId());
            List laneList = this.templateBenchMapper.selectChildByTemp(req.getId());
            if (CollectionUtils.isNotEmpty((Collection)laneList)) {
                List laneIdList = laneList.stream().map(TemplateBench::getId).collect(Collectors.toList());
                this.templateBenchMapper.deleteBatchIds(laneIdList);
                this.templateBenchCustomMapper.delBenchJob(laneIdList);
            }
        }
        req.setTemplateId(tempId);
        TemplateBench bench = this.packageTemplateBench(req.getTemplateName(), tempId, Long.valueOf(0L), Integer.valueOf(0));
        this.templateBenchMapper.insert((Object)bench);
        req.setId(bench.getId());
        this.saveBenchCustom(tempId, req, bench.getId());
        if (null == req.getSubType() || !req.getSubType().equals(Constants.SubTypeEnum.PART_TENANT.getFlag())) {
            return null;
        }
        ArrayList<Long> templateIdList = new ArrayList<Long>();
        templateIdList.add(tempId);
        this.templateInfoTenantMapper.delByTemp(templateIdList);
        TemplateInfo tenantReq = new TemplateInfo();
        tenantReq.setSubTenantList(req.getSubTenantList());
        tenantReq.setGroupList(req.getGroupList());
        List tenantGroupList = this.templateInfoService.addTempTeanntList(tenantReq, tempId);
        if (CollectionUtils.isNotEmpty((Collection)tenantGroupList)) {
            this.templateInfoTenantMapper.batchInsertTenant(tenantGroupList, Utils.getUserId(), DateUtils.getNowTime((String)""));
        }
        return null;
    }

    public void saveBenchCustom(Long tempId, TemplateBenchVO req, Long benchId) {
        if (CollectionUtils.isEmpty((Collection)req.getLaneList())) {
            return;
        }
        for (int i = 0; i < req.getLaneList().size(); ++i) {
            TemplateBench bench = this.packageTemplateBench(((TemplateBench)req.getLaneList().get(i)).getName(), tempId, benchId, Integer.valueOf(i));
            this.templateBenchMapper.insert((Object)bench);
            List systemIdList = ((TemplateBench)req.getLaneList().get(i)).getSystemIdList();
            if (CollectionUtils.isEmpty((Collection)systemIdList)) continue;
            ArrayList<TemplateBenchCustom> templateBenchCustoms = new ArrayList<TemplateBenchCustom>();
            for (int m = 0; m < systemIdList.size(); ++m) {
                TemplateBenchCustom customTemp = this.packageBenchCustom(bench.getId(), (Long)systemIdList.get(m), Integer.valueOf(m));
                templateBenchCustoms.add(customTemp);
            }
            if (!CollectionUtils.isNotEmpty(templateBenchCustoms)) continue;
            this.templateBenchCustomMapper.insertBatch(templateBenchCustoms);
        }
    }

    public TemplateBenchCustom packageBenchCustom(Long benchId, Long systemId, Integer labelIndex) {
        TemplateBenchCustom customTemp = new TemplateBenchCustom();
        customTemp.setBenchId(benchId);
        customTemp.setSystemId(systemId);
        customTemp.setLabelIndex(labelIndex);
        customTemp.setTenantId(Utils.getTenantId());
        customTemp.setCreateTime(DateUtils.getNowTime((String)""));
        customTemp.setCreateUserId(Utils.getUserId());
        return customTemp;
    }

    public TemplateBench packageTemplateBench(String name, Long tempId, Long parentId, Integer labelIndex) {
        TemplateBench benchTemp = new TemplateBench();
        benchTemp.setName(name);
        benchTemp.setParentId(parentId);
        benchTemp.setTemplateId(tempId);
        benchTemp.setLabelIndex(labelIndex);
        benchTemp.setTenantId(Utils.getTenantId());
        benchTemp.setCreateTime(DateUtils.getNowTime((String)""));
        benchTemp.setCreateUserId(Utils.getUserId());
        return benchTemp;
    }

    public TemplateInfo packageTemplateInfo(TemplateBenchVO req) {
        TemplateInfo templateInfo = new TemplateInfo();
        templateInfo.setId(req.getTemplateId());
        templateInfo.setTemplateName(req.getTemplateName());
        templateInfo.setTemplateDesc(req.getTemplateDesc());
        templateInfo.setSubType(req.getSubType());
        templateInfo.setTemplateType(Constants.TemplateTypeEnum.JOB_BENCH.getVal());
        templateInfo.setStatus(req.getStatus());
        return templateInfo;
    }

    public TemplateBenchVO queryBenchByTemp(TemplateBenchVO req) {
        TemplateBenchVO benchVO = new TemplateBenchVO();
        TemplateInfo templateInfo = (TemplateInfo)this.templateInfoMapper.selectById((Serializable)req.getTemplateId());
        if (null == templateInfo) {
            return benchVO;
        }
        this.converter.convert((Object)templateInfo, (Object)benchVO);
        benchVO.setTemplateId(templateInfo.getId());
        benchVO.setId(null);
        List benchList = this.templateBenchMapper.selectBenchList(null, Long.valueOf(0L), req.getTemplateId());
        if (CollectionUtils.isEmpty((Collection)benchList)) {
            return benchVO;
        }
        benchVO.setId(((TemplateBench)benchList.get(0)).getId());
        List laneList = this.templateBenchMapper.selectBenchList(null, ((TemplateBench)benchList.get(0)).getId(), req.getTemplateId());
        if (CollectionUtils.isEmpty((Collection)laneList)) {
            return benchVO;
        }
        for (TemplateBench lane : laneList) {
            List benchCustomList = this.templateBenchCustomMapper.selectBenchJob(null, lane.getId());
            lane.setJobList(benchCustomList);
        }
        benchVO.setLaneList(laneList);
        if (null == templateInfo.getSubType() || !templateInfo.getSubType().equals(Constants.SubTypeEnum.PART_TENANT.getFlag())) {
            return benchVO;
        }
        TemplateInfo templateGroup = this.templateInfoService.getTempGroupVO(templateInfo.getId());
        benchVO.setSubTenantList(templateGroup.getSubTenantList());
        benchVO.setGroupList(templateGroup.getGroupList());
        return benchVO;
    }

    public List<TemplateBench> queryTempBenchList() {
        List benchList = this.templateInfoService.queryVisibleTempList(Constants.TemplateTypeEnum.JOB_BENCH.getVal());
        return benchList;
    }

    public List<TemplateBenchImportVo> readExcel(String fileId) {
        List excelVoList;
        DMC dmcInstance = this.mdcService.buildDmc();
        try {
            byte[] byteArray = dmcInstance.download(fileId);
            ByteArrayInputStream input = new ByteArrayInputStream(byteArray);
            SyncReadListener excelListener = new SyncReadListener();
            ExcelReader excelReader = EasyExcelFactory.read((InputStream)input).build();
            excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)0).head(TemplateBenchImportVo.class)).headRowNumber(Integer.valueOf(2))).registerReadListener((ReadListener)excelListener)).build()});
            excelReader.finish();
            excelVoList = this.mdcService.doReadSync(excelListener);
        }
        catch (Exception e) {
            this.log.error("JobBenchImport read excel occur error", (Throwable)e);
            throw new RuntimeException(e);
        }
        return excelVoList;
    }

    @Transactional(rollbackFor={Exception.class})
    public ImportExcelResp importReport(List<TemplateBenchImportVo> jobBenchImportVoList) {
        ImportExcelResp excelResp = new ImportExcelResp();
        Map<Object, Object> systemCustomTempMap = new HashMap();
        HashMap<String, ArrayList<String>> jobNameMap = new HashMap<String, ArrayList<String>>();
        HashMap benchNameIdMap = new HashMap();
        HashMap laneIdMap = new HashMap();
        HashMap benchTempIdMap = new HashMap();
        LabelSystemAllVo req = new LabelSystemAllVo();
        ArrayList<Integer> dataCategoryList = new ArrayList<Integer>();
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        req.setDataCategoryList(dataCategoryList);
        List systemCustomTempList = this.templateSystemCustomService.queryCustomList(req);
        if (CollectionUtils.isNotEmpty((Collection)systemCustomTempList)) {
            systemCustomTempMap = systemCustomTempList.stream().collect(Collectors.toMap(TemplateSystemCustom::getNameZh, Function.identity(), (a, b) -> a));
        }
        List<Object> benchNameList = new ArrayList();
        Integer benchIndex = 0;
        List jobBenchTempList = this.templateBenchMapper.selectBenchList(new ArrayList(), Long.valueOf(0L), null);
        if (CollectionUtils.isNotEmpty((Collection)jobBenchTempList)) {
            benchIndex = ((TemplateBench)jobBenchTempList.get(jobBenchTempList.size() - 1)).getLabelIndex() + 1;
            benchNameList = jobBenchTempList.stream().map(TemplateBench::getName).collect(Collectors.toList());
        }
        int successNum = 0;
        int failNum = 0;
        Integer laneIndex = 0;
        Integer jobIndex = 0;
        for (TemplateBenchImportVo jobBenchImportVo : jobBenchImportVoList) {
            StringBuilder errorSb = this.validateData(jobBenchImportVo, benchNameList, systemCustomTempMap, jobNameMap);
            if (StringUtils.isNotBlank((CharSequence)errorSb.toString())) {
                ++failNum;
                jobBenchImportVo.setFailDesc(errorSb.substring(0, errorSb.length() - 1));
                continue;
            }
            ArrayList<String> jobNameList = (ArrayList<String>)jobNameMap.get(jobBenchImportVo.getBenchName() + "_" + jobBenchImportVo.getLaneName());
            if (CollectionUtils.isEmpty((Collection)jobNameList)) {
                jobNameList = new ArrayList<String>();
            }
            jobNameList.add(jobBenchImportVo.getJobName());
            jobNameMap.put(jobBenchImportVo.getBenchName() + "_" + jobBenchImportVo.getLaneName(), jobNameList);
            jobBenchImportVo.setFailDesc(errorSb.toString());
            this.initJobBench(jobBenchImportVo, systemCustomTempMap, benchNameIdMap, benchIndex.intValue(), laneIndex.intValue(), jobIndex.intValue(), laneIdMap, benchTempIdMap);
            ++successNum;
        }
        String nowTime = DateUtils.getNowTime((String)"yyyyMMddHHmmss");
        String pathName = "\u4f5c\u4e1a\u5de5\u4f5c\u53f0\u5bfc\u5165\u8bb0\u5f55_" + nowTime + ".xlsx";
        ShareInfo shareInfo = this.importRecordService.uploadExcel(this.write(jobBenchImportVoList, pathName));
        this.initDataImport(shareInfo.getFileId(), Integer.valueOf(successNum), Integer.valueOf(failNum), nowTime);
        excelResp.setFailFileId(shareInfo.getFileId());
        excelResp.setFailFileName(shareInfo.getFileName());
        excelResp.setFailFileUrl(shareInfo.getUrl());
        String resultCode = successNum > 0 && failNum == 0 ? "2001" : (successNum > 0 && failNum > 0 ? "2002" : (successNum == 0 && failNum > 0 ? "2003" : "2003"));
        excelResp.setResultCode(resultCode);
        excelResp.setFailCount(Integer.valueOf(failNum));
        excelResp.setSuccessCount(Integer.valueOf(successNum));
        return excelResp;
    }

    public TemplateBenchImport initDataImport(String fileId, Integer successCount, Integer failCount, String nowTime) {
        TemplateBenchImport importRecord = new TemplateBenchImport();
        importRecord.setFileId(fileId);
        importRecord.setSuccessCount(successCount);
        importRecord.setFailCount(failCount);
        importRecord.setCreateUserName(Utils.getUserName());
        importRecord.setCreateUserId(Utils.getUserId());
        importRecord.setCreateTime(DateUtils.getDateFormat((String)nowTime, (String)"yyyyMMddHHmmss", (String)"yyyy-MM-dd HH:mm:ss"));
        importRecord.setModifyTime(DateUtils.getDateFormat((String)nowTime, (String)"yyyyMMddHHmmss", (String)"yyyy-MM-dd HH:mm:ss"));
        importRecord.setModifyUserId(Utils.getUserId());
        importRecord.setTenantId(Utils.getTenantId());
        this.templateBenchImportMapper.insert((Object)importRecord);
        return importRecord;
    }

    public File write(List<TemplateBenchImportVo> list, String pathName) {
        File file = new File(pathName);
        ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((File)file, JobBenchImportVo.class).registerWriteHandler((WriteHandler)Utils.initHorizontalCell())).relativeHeadRowIndex(Integer.valueOf(1))).registerWriteHandler((WriteHandler)new TemplateBenchWriteHandler())).sheet("ISV\u4f5c\u4e1a\u5de5\u4f5c\u53f0").doWrite(list);
        return file;
    }

    public void initJobBench(TemplateBenchImportVo jobBenchImportVo, Map<String, TemplateSystemCustom> systemCustomTempMap, Map<String, Long> benchNameIdMap, int benchIndex, int laneIndex, int jobIndex, Map<String, Long> laneNameIdMap, Map<Long, Long> benchTempIdMap) {
        String laneKey;
        Long laneId;
        Long benchId = benchNameIdMap.get(jobBenchImportVo.getBenchName());
        if (null == benchId) {
            TemplateBenchVO req = new TemplateBenchVO();
            req.setTemplateName(jobBenchImportVo.getBenchName());
            req.setStatus(Constants.VALID_STATUS_UNUSABLE);
            TemplateInfo templateInfo = this.packageTemplateInfo(req);
            Long tempId = this.templateInfoService.saveTemp(templateInfo);
            TemplateBench templateBench = new TemplateBench();
            templateBench.setTemplateId(tempId);
            templateBench.setName(jobBenchImportVo.getBenchName());
            templateBench.setLabelIndex(Integer.valueOf(benchIndex));
            templateBench.setParentId(Long.valueOf(0L));
            templateBench.setCreateUserId(Utils.getUserId());
            templateBench.setCreateTime(DateUtils.getNowTime((String)""));
            templateBench.setModifyTime(DateUtils.getNowTime((String)""));
            templateBench.setModifyUserId(Utils.getUserId());
            templateBench.setTenantId(Utils.getTenantId());
            this.templateBenchMapper.insert((Object)templateBench);
            benchNameIdMap.put(jobBenchImportVo.getBenchName(), templateBench.getId());
            benchId = templateBench.getId();
            ++benchIndex;
            benchTempIdMap.put(benchId, tempId);
        }
        if (null == (laneId = laneNameIdMap.get(laneKey = jobBenchImportVo.getBenchName() + jobBenchImportVo.getLaneName()))) {
            TemplateBench lane = new TemplateBench();
            Long tempId = benchTempIdMap.get(benchId);
            lane.setTemplateId(tempId);
            lane.setName(jobBenchImportVo.getLaneName());
            lane.setLabelIndex(Integer.valueOf(laneIndex));
            lane.setParentId(benchId);
            lane.setCreateUserId(Utils.getUserId());
            lane.setCreateTime(DateUtils.getNowTime((String)""));
            lane.setModifyTime(DateUtils.getNowTime((String)""));
            lane.setModifyUserId(Utils.getUserId());
            lane.setTenantId(Utils.getTenantId());
            this.templateBenchMapper.insert((Object)lane);
            laneNameIdMap.put(laneKey, lane.getId());
            laneId = lane.getId();
            ++laneIndex;
        }
        TemplateBenchCustom templateBenchCustom = new TemplateBenchCustom();
        templateBenchCustom.setBenchId(laneId);
        templateBenchCustom.setCreateUserId(Utils.getUserId());
        templateBenchCustom.setCreateTime(DateUtils.getNowTime((String)""));
        templateBenchCustom.setTenantId(Utils.getTenantId());
        templateBenchCustom.setLabelIndex(Integer.valueOf(jobIndex));
        TemplateSystemCustom systemCustomTemp = systemCustomTempMap.get(jobBenchImportVo.getJobName());
        if (null != systemCustomTemp) {
            templateBenchCustom.setSystemId(systemCustomTemp.getId());
            this.templateBenchCustomMapper.insert((Object)templateBenchCustom);
            ++jobIndex;
        }
    }

    private StringBuilder validateData(TemplateBenchImportVo jobBenchImportVo, List<String> benchNameList, Map<String, TemplateSystemCustom> systemCustomTempMap, Map<String, List<String>> jobNameMap) {
        StringBuilder errorSb = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)jobBenchImportVo.getBenchName())) {
            errorSb.append("\u201c\u5de5\u4f5c\u53f0\u540d\u79f0\u201d\u672a\u586b\u5199").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)jobBenchImportVo.getBenchName()) && jobBenchImportVo.getBenchName().length() > 12) {
            errorSb.append("\u201c\u5de5\u4f5c\u53f0\u540d\u79f0\u201d\u5185\u5bb9\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236").append(",");
        }
        if (benchNameList.contains(jobBenchImportVo.getBenchName())) {
            errorSb.append("\u201c\u5de5\u4f5c\u53f0\u540d\u79f0\u201d\u91cd\u540d").append(",");
        }
        if (StringUtils.isEmpty((CharSequence)jobBenchImportVo.getLaneName())) {
            errorSb.append("\u201c\u6cf3\u9053\u540d\u79f0\u201d\u672a\u586b\u5199").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)jobBenchImportVo.getLaneName()) && jobBenchImportVo.getLaneName().length() > 12) {
            errorSb.append("\u201c\u6cf3\u9053\u540d\u79f0\u201d\u5185\u5bb9\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)jobBenchImportVo.getBenchName()) && StringUtils.isNotEmpty((CharSequence)jobBenchImportVo.getLaneName())) {
            List<String> jobNameList = jobNameMap.get(jobBenchImportVo.getBenchName() + "_" + jobBenchImportVo.getLaneName());
            if (CollectionUtils.isEmpty(jobNameList)) {
                jobNameList = new ArrayList<String>();
            }
            if (StringUtils.isNotEmpty((CharSequence)jobBenchImportVo.getJobName()) && jobNameList.contains(jobBenchImportVo.getJobName())) {
                errorSb.append("\u201c\u4f5c\u4e1a\u540d\u79f0\u201d\u91cd\u540d").append(",");
            }
        }
        if (StringUtils.isEmpty((CharSequence)jobBenchImportVo.getJobName())) {
            errorSb.append("\u201c\u4f5c\u4e1a\u540d\u79f0\u201d\u672a\u586b\u5199").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)jobBenchImportVo.getJobName()) && null == systemCustomTempMap.get(jobBenchImportVo.getJobName())) {
            errorSb.append("\u201c\u4f5c\u4e1a\u540d\u79f0\u201d\u503c\u9519\u8bef").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)jobBenchImportVo.getJobName()) && null != systemCustomTempMap.get(jobBenchImportVo.getJobName())) {
            TemplateSystemCustom systemCustomTemp = systemCustomTempMap.get(jobBenchImportVo.getJobName());
            if (systemCustomTemp.getValidStatus().equals(Constants.VALID_STATUS_UNUSABLE)) {
                errorSb.append("\u5173\u8054\u4f5c\u4e1a\u672a\u542f\u7528").append(",");
            }
            if (!systemCustomTemp.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_WORK.getVal()) && !systemCustomTemp.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_APP.getVal())) {
                errorSb.append("\u201c\u4f5c\u4e1a\u540d\u79f0\u201d\u503c\u9519\u8bef").append(",");
            }
        }
        return errorSb;
    }

    public PageInfoResp<TemplateBenchImport> queryImportRecord(QueryImportRecordReq queryImportRecordReq) {
        QueryWrapper condition = new QueryWrapper();
        if (StringUtils.isBlank((CharSequence)queryImportRecordReq.getStartTime()) || StringUtils.isBlank((CharSequence)queryImportRecordReq.getEndTime())) {
            String currentDate = DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss");
            condition.ge((Object)"create_time", (Object)DateUtils.addDate((String)currentDate, (String)"yyyy-MM-dd HH:mm:ss", (int)-1, (String)"year"));
            condition.le((Object)"create_time", (Object)currentDate);
        } else {
            condition.ge((Object)"create_time", (Object)queryImportRecordReq.getStartTime());
            condition.le((Object)"create_time", (Object)queryImportRecordReq.getEndTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryImportRecordReq.getUserIdName())) {
            condition.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.like((Object)"create_user_name", (Object)queryImportRecordReq.getUserIdName())).or()).like((Object)"create_user_id", (Object)queryImportRecordReq.getUserIdName());
            });
        }
        condition.orderByDesc((Object)"create_time");
        PageInfoResp pageInfoResp = new PageInfoResp();
        pageInfoResp.setPageNo(queryImportRecordReq.getPageNum().intValue());
        pageInfoResp.setPageSize(queryImportRecordReq.getPageSize().intValue());
        pageInfoResp.setTotalPages(0);
        pageInfoResp.setTotalRecords(0);
        Page pageResult = (Page)this.templateBenchImportMapper.selectPage((IPage)new Page((long)queryImportRecordReq.getPageNum().intValue(), (long)queryImportRecordReq.getPageSize().intValue()), (Wrapper)condition);
        if (pageResult != null && CollectionUtils.isNotEmpty((Collection)pageResult.getRecords())) {
            pageResult.getRecords().forEach(m -> m.setFileUrl(this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + m.getFileId().trim()));
            pageInfoResp.setList(pageResult.getRecords());
            pageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(pageResult.getPages())));
            pageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(pageResult.getTotal())));
        } else {
            pageInfoResp.setList((List)Lists.newArrayList());
        }
        return pageInfoResp;
    }

    public List<TemplateBenchExportVo> exportReport() {
        ArrayList<TemplateBenchExportVo> jobBenchExportVoList = new ArrayList<TemplateBenchExportVo>();
        Map<Object, Object> systemCustomTempMap = new HashMap();
        LabelSystemAllVo req = new LabelSystemAllVo();
        ArrayList<Integer> dataCategoryList = new ArrayList<Integer>();
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        req.setDataCategoryList(dataCategoryList);
        List systemCustomTempList = this.templateSystemCustomService.queryCustomList(req);
        if (CollectionUtils.isNotEmpty((Collection)systemCustomTempList)) {
            systemCustomTempMap = systemCustomTempList.stream().collect(Collectors.toMap(TemplateSystemCustom::getId, Function.identity(), (a, b) -> a));
        }
        TemplateBench reqBench = new TemplateBench();
        reqBench.setParentId(Long.valueOf(0L));
        List jobBenchList = this.selectByBench(reqBench);
        for (TemplateBench jobBench : jobBenchList) {
            TemplateBench reqLane = new TemplateBench();
            reqLane.setParentId(jobBench.getId());
            List laneList = this.selectByBench(reqLane);
            if (CollectionUtils.isEmpty((Collection)laneList)) {
                jobBenchExportVoList.add(this.initJobBench(jobBench.getName(), ""));
                continue;
            }
            List laneIdList = laneList.stream().map(TemplateBench::getId).collect(Collectors.toList());
            List jobBenchCustomList = this.templateBenchCustomMapper.selectBenchBy(laneIdList, null);
            Map<Object, Object> laneSystemMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)jobBenchCustomList)) {
                laneSystemMap = jobBenchCustomList.stream().collect(Collectors.groupingBy(TemplateBenchCustom::getBenchId));
            }
            for (TemplateBench lane : laneList) {
                TemplateBenchExportVo jobBenchExportVo = new TemplateBenchExportVo();
                jobBenchExportVo.setBenchName(jobBench.getName());
                jobBenchExportVo.setLaneName(lane.getName());
                List benchCustomList = (List)laneSystemMap.get(lane.getId());
                if (CollectionUtils.isEmpty((Collection)benchCustomList)) {
                    jobBenchExportVoList.add(jobBenchExportVo);
                    continue;
                }
                for (TemplateBenchCustom benchCustom : benchCustomList) {
                    TemplateBenchExportVo jobExportVo = new TemplateBenchExportVo();
                    jobExportVo.setBenchName(jobBench.getName());
                    jobExportVo.setLaneName(lane.getName());
                    TemplateSystemCustom systemCustomTemp = (TemplateSystemCustom)systemCustomTempMap.get(benchCustom.getSystemId());
                    if (null == systemCustomTemp) continue;
                    jobExportVo.setJobName(systemCustomTemp.getNameZh());
                    jobBenchExportVoList.add(jobExportVo);
                }
            }
        }
        return jobBenchExportVoList;
    }

    public List<TemplateBench> selectByBench(TemplateBench req) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByAsc((Object)"label_index");
        if (StringUtils.isNotEmpty((CharSequence)req.getName())) {
            queryWrapper.eq((Object)"name", (Object)req.getName());
        }
        if (null != req.getId()) {
            queryWrapper.notIn((Object)"id", new Object[]{req.getId()});
        }
        if (null != req.getParentId()) {
            queryWrapper.eq((Object)"parent_id", (Object)req.getParentId());
        }
        return this.templateBenchMapper.selectList((Wrapper)queryWrapper);
    }

    public TemplateBenchExportVo initJobBench(String benchName, String laneName) {
        TemplateBenchExportVo jobBenchExportVo = new TemplateBenchExportVo();
        if (StringUtils.isNotEmpty((CharSequence)benchName)) {
            jobBenchExportVo.setBenchName(benchName);
        }
        if (StringUtils.isNotEmpty((CharSequence)laneName)) {
            jobBenchExportVo.setLaneName(laneName);
        }
        return jobBenchExportVo;
    }
}

