/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.temp.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataDto;
import com.digiwin.athena.semc.dto.portal.TemplateQueryReq;
import com.digiwin.athena.semc.dto.portal.UsePortalDetailDto;
import com.digiwin.athena.semc.dto.portal.UsePortalInfoDto;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.applink.TenantAppDTO;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.bench.JobBench;
import com.digiwin.athena.semc.entity.bench.JobBenchCustom;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.entity.portal.LabelSystemSource;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.portal.PortalInfoContent;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.entity.temp.TemplateBench;
import com.digiwin.athena.semc.entity.temp.TemplateBenchCustom;
import com.digiwin.athena.semc.entity.temp.TemplateInfo;
import com.digiwin.athena.semc.entity.temp.TemplateInfoTenant;
import com.digiwin.athena.semc.entity.temp.TemplatePortalInfo;
import com.digiwin.athena.semc.entity.temp.TemplatePortalInfoContent;
import com.digiwin.athena.semc.entity.temp.TemplateSystemCustom;
import com.digiwin.athena.semc.entity.temp.TemplateSystemData;
import com.digiwin.athena.semc.entity.temp.TemplateSystemSource;
import com.digiwin.athena.semc.entity.temp.TemplateTenantGroup;
import com.digiwin.athena.semc.entity.temp.TemplateTenantGroupItem;
import com.digiwin.athena.semc.entity.temp.TemplateUserTenant;
import com.digiwin.athena.semc.mapper.bench.JobBenchCustomMapper;
import com.digiwin.athena.semc.mapper.bench.JobBenchMapper;
import com.digiwin.athena.semc.mapper.bench.SyncJobInfoMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemCustomMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemDataMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemSourceMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateBenchCustomMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateBenchMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateInfoMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateInfoTenantMapper;
import com.digiwin.athena.semc.mapper.temp.TemplatePortalInfoContentMapper;
import com.digiwin.athena.semc.mapper.temp.TemplatePortalInfoMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemCustomMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemDataMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemSourceMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateTenantGroupItemMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateTenantGroupMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateUserTenantMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.portal.LabelSystemPreService;
import com.digiwin.athena.semc.service.temp.TemplateInfoService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.portal.LabelSystemDataAppVo;
import com.digiwin.athena.semc.vo.portal.QueryTempAppListVo;
import com.digiwin.athena.semc.vo.temp.TemplateTenantGroupVO;
import com.digiwin.athena.semc.vo.temp.TemplateTenantVO;
import io.github.linpeilie.Converter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TemplateInfoServiceImpl
extends ServiceImpl<TemplateInfoMapper, TemplateInfo>
implements TemplateInfoService {
    @Resource
    TemplateInfoMapper templateInfoMapper;
    @Resource
    TemplateInfoTenantMapper templateInfoTenantMapper;
    @Resource
    TemplateTenantGroupMapper templateTenantGroupMapper;
    @Resource
    private TemplateTenantGroupItemMapper templateTenantGroupItemMapper;
    @Autowired
    JobBenchMapper jobBenchMapper;
    @Autowired
    JobBenchCustomMapper jobBenchCustomMapper;
    @Autowired
    LabelSystemSourceMapper labelSystemSourceMapper;
    @Resource
    TemplateSystemSourceMapper templateSystemSourceMapper;
    @Autowired
    LabelSystemDataMapper labelSystemDataMapper;
    @Autowired
    TemplateSystemDataMapper templateStystemDataMapper;
    @Autowired
    LabelSystemDataService labelSystemDataService;
    @Resource
    private IamService iamService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    LabelSystemPreService labelSystemPreService;
    @Autowired
    LabelSystemCustomMapper labelSystemCustomMapper;
    @Resource
    TemplateSystemCustomMapper templateSystemCustomMapper;
    @Autowired
    SyncJobInfoMapper syncJobInfoMapper;
    @Resource
    TemplatePortalInfoMapper templatePortalInfoMapper;
    @Resource
    TemplatePortalInfoContentMapper templatePortalInfoContentMapper;
    @Autowired
    TemplateBenchMapper templateBenchMapper;
    @Autowired
    TemplateBenchCustomMapper templateBenchCustomMapper;
    @Resource
    TemplateUserTenantMapper templateUserTenantMapper;
    @Resource
    private Converter converter;

    public ResultPageBean pageQuery(TemplateQueryReq req) {
        List templateInfoList = this.templateInfoMapper.queryByTemp(req, null);
        Integer totalResults = templateInfoList.size();
        templateInfoList = templateInfoList.stream().skip((long)(req.getPageNum() - 1) * req.getPageSize().longValue()).limit(req.getPageSize().intValue()).collect(Collectors.toList());
        this.packageTempTenant(templateInfoList);
        ResultPageBean resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance(templateInfoList, (PageInfo)PageInfo.getPageInfo((Integer)req.getPageNum(), (Integer)req.getPageSize(), (Integer)totalResults)));
        return resultPageBean;
    }

    public void packageTempTenant(List<TemplateInfo> templateInfoList) {
        if (CollectionUtils.isEmpty(templateInfoList)) {
            return;
        }
        List partTempList = templateInfoList.stream().filter(x -> Constants.SubTypeEnum.PART_TENANT.getFlag().equals(x.getSubType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(partTempList)) {
            return;
        }
        List tempIdList = partTempList.stream().map(TemplateInfo::getId).collect(Collectors.toList());
        List tenantGroupList = this.templateInfoTenantMapper.selectByTemp(tempIdList);
        Map<Object, Object> tenantGroupTempMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)tenantGroupList)) {
            tenantGroupTempMap = tenantGroupList.stream().collect(Collectors.groupingBy(TemplateInfoTenant::getTemplateId));
        }
        List groupAllList = tenantGroupList.stream().filter(x -> Constants.SelectTypeEnum.RELEASE_BY_GROUP.getFlag().equals(x.getSelectType())).collect(Collectors.toList());
        List tenantGroupVOList = new ArrayList();
        Map<Object, Object> tenantGroupVOMap = new HashMap();
        if (CollectionUtils.isNotEmpty(groupAllList)) {
            List groupIdList = groupAllList.stream().map(TemplateInfoTenant::getGroupTenantId).collect(Collectors.toList());
            tenantGroupVOList = this.templateTenantGroupMapper.selectByIds(groupIdList);
        }
        if (CollectionUtils.isNotEmpty(tenantGroupVOList)) {
            tenantGroupVOMap = tenantGroupVOList.stream().collect(Collectors.toMap(value -> value.getId(), value -> value, (key1, key2) -> key1));
        }
        for (TemplateInfo templateInfo : templateInfoList) {
            if (null == templateInfo.getSubType() || !templateInfo.getSubType().equals(Constants.SubTypeEnum.PART_TENANT.getFlag())) continue;
            List infoTenantList = (List)tenantGroupTempMap.get(templateInfo.getId());
            ArrayList<TemplateTenantVO> tenantList = new ArrayList<TemplateTenantVO>();
            ArrayList<Object> groupList = new ArrayList<Object>();
            if (CollectionUtils.isEmpty((Collection)infoTenantList)) continue;
            for (TemplateInfoTenant tenant : infoTenantList) {
                if (tenant.getSelectType().equals(Constants.SelectTypeEnum.RELEASE_BY_TENANT.getFlag())) {
                    TemplateTenantVO tenantVO = new TemplateTenantVO();
                    tenantVO.setSubTenantId(tenant.getGroupTenantId());
                    tenantVO.setSubTenantName(tenant.getSubTenantName());
                    tenantList.add(tenantVO);
                }
                if (!tenant.getSelectType().equals(Constants.SelectTypeEnum.RELEASE_BY_GROUP.getFlag()) || null == tenantGroupVOMap.get(Long.parseLong(tenant.getGroupTenantId()))) continue;
                groupList.add(tenantGroupVOMap.get(Long.parseLong(tenant.getGroupTenantId())));
            }
            templateInfo.setSubTenantList(tenantList);
            templateInfo.setGroupList(groupList);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Long saveTemp(TemplateInfo req) {
        Long id = req.getId();
        req.setModifyTime(DateUtils.getNowTime((String)""));
        req.setModifyUserId(Utils.getUserId());
        req.setModifyUserName(Utils.getUserName());
        if (null == req.getStatus()) {
            req.setStatus(Constants.TemplateStatusEnum.NO_RELEASE.getVal());
        }
        if (null == req.getId()) {
            req.setTenantId(Utils.getTenantId());
            req.setTemplateSort(Integer.valueOf(3));
            req.setCreateTime(DateUtils.getNowTime((String)""));
            req.setCreateUserName(Utils.getUserName());
            req.setCreateUserId(Utils.getUserId());
            this.templateInfoMapper.insert((Object)req);
            id = req.getId();
        } else {
            this.templateInfoMapper.upTempById(req);
        }
        return id;
    }

    public List<TemplateInfo> queryByParam(TemplateInfo req) {
        QueryWrapper condition = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)req.getTemplateNo())) {
            condition.eq((Object)"template_no", (Object)req.getTemplateNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getTemplateName())) {
            condition.eq((Object)"template_name", (Object)req.getTemplateName());
        }
        if (null != req.getTemplateType()) {
            condition.eq((Object)"template_type", (Object)req.getTemplateType());
        }
        if (null != req.getId()) {
            condition.ne((Object)"id", (Object)req.getId());
        }
        return this.templateInfoMapper.selectList((Wrapper)condition);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> batDel(List<Long> idList) {
        List jobBenchList;
        List jobBenchIdList;
        List benchTempList;
        List benchTempIdList;
        List portIds;
        List templateInfoList = this.templateInfoMapper.selectBatchIds(idList);
        List portTempList = templateInfoList.stream().filter(x -> Constants.TemplateTypeEnum.CLASSIC_PORTAL.getVal().equals(x.getTemplateType())).collect(Collectors.toList());
        List portTempIdList = portTempList.stream().map(TemplateInfo::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(portTempIdList) && CollectionUtils.isNotEmpty((Collection)(portIds = this.templatePortalInfoMapper.selByTemp(portTempIdList)))) {
            this.templatePortalInfoMapper.delByTemp(portIds);
            this.delPortalContent(portIds);
        }
        if (CollectionUtils.isNotEmpty(benchTempIdList = (benchTempList = templateInfoList.stream().filter(x -> Constants.TemplateTypeEnum.JOB_BENCH.getVal().equals(x.getTemplateType())).collect(Collectors.toList())).stream().map(TemplateInfo::getId).collect(Collectors.toList())) && CollectionUtils.isNotEmpty(jobBenchIdList = (jobBenchList = this.templateBenchMapper.selectTempBench(benchTempIdList, null)).stream().map(TemplateBench::getId).collect(Collectors.toList()))) {
            this.templateBenchMapper.deleteBatchIds(jobBenchIdList);
            this.templateBenchCustomMapper.delBenchJob(jobBenchIdList);
        }
        this.templateInfoMapper.deleteBatchIds(idList);
        return ResponseEntityWrapper.wrapperOk();
    }

    public void delPortalContent(List<Long> portalIdList) {
        QueryWrapper condition = new QueryWrapper();
        if (CollectionUtils.isNotEmpty(portalIdList)) {
            condition.in((Object)"portal_id", portalIdList);
        }
        this.templatePortalInfoContentMapper.delete((Wrapper)condition);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> updateStatus(List<Long> idList, Integer status) {
        List nnUSABLETempList;
        List templateInfoList = this.templateInfoMapper.selectBatchIds(idList);
        if (CollectionUtils.isEmpty((Collection)templateInfoList)) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u6a21\u7248\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (status.equals(Constants.VALID_STATUS_ENABLE)) {
            List validTempList = templateInfoList.stream().filter(x -> Constants.VALID_STATUS_ENABLE.equals(x.getStatus())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty((Collection)templateInfoList) && validTempList.size() == idList.size()) {
                String error = this.messageUtils.getMessage("error.message.template.updateStatus.published.msg");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
        }
        if (status.equals(Constants.VALID_STATUS_UNUSABLE) && CollectionUtils.isNotEmpty(nnUSABLETempList = templateInfoList.stream().filter(x -> Constants.VALID_STATUS_UNUSABLE.equals(x.getStatus())).collect(Collectors.toList())) && nnUSABLETempList.size() == idList.size()) {
            String error = this.messageUtils.getMessage("error.message.template.updateStatus.no.published.msg");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        List portTempList = templateInfoList.stream().filter(x -> Constants.TemplateTypeEnum.CLASSIC_PORTAL.getVal().equals(x.getTemplateType())).collect(Collectors.toList());
        List portTempIdList = portTempList.stream().map(TemplateInfo::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(portTempIdList)) {
            TemplatePortalInfo templatePortalInfo = new TemplatePortalInfo();
            templatePortalInfo.setStatus(status);
            templatePortalInfo.setModifyUserName(Utils.getUserName());
            templatePortalInfo.setModifyTime(DateUtils.getNowTime((String)""));
            templatePortalInfo.setModifyUserId(Utils.getUserId());
            this.templatePortalInfoMapper.updateByTemp(portTempIdList, templatePortalInfo);
        }
        TemplateInfo templateInfo = new TemplateInfo();
        templateInfo.setStatus(status);
        templateInfo.setModifyUserName(Utils.getUserName());
        templateInfo.setModifyTime(DateUtils.getNowTime((String)""));
        templateInfo.setModifyUserId(Utils.getUserId());
        this.templateInfoMapper.updateBat(idList, templateInfo);
        return ResponseEntityWrapper.wrapperOk();
    }

    @Transactional(rollbackFor={Exception.class})
    public Integer batTempToTenant(TemplateInfo req) {
        TemplateInfo templateInfo = new TemplateInfo();
        templateInfo.setSubType(req.getSubType());
        templateInfo.setModifyUserName(Utils.getUserName());
        templateInfo.setModifyTime(DateUtils.getNowTime((String)""));
        templateInfo.setModifyUserId(Utils.getUserId());
        this.templateInfoMapper.updateBat(req.getIdList(), templateInfo);
        this.templateInfoTenantMapper.delByTemp(req.getIdList());
        for (Long tempId : req.getIdList()) {
            List tenantGroupList = this.addTempTeanntList(req, tempId);
            if (!CollectionUtils.isNotEmpty((Collection)tenantGroupList)) continue;
            this.templateInfoTenantMapper.batchInsertTenant(tenantGroupList, Utils.getUserId(), DateUtils.getNowTime((String)""));
        }
        return null;
    }

    public List<TemplateInfoTenant> addTempTeanntList(TemplateInfo req, Long tempId) {
        TemplateInfoTenant infoTenant;
        ArrayList<TemplateInfoTenant> tenantGroupList = new ArrayList<TemplateInfoTenant>();
        if (CollectionUtils.isNotEmpty((Collection)req.getSubTenantList())) {
            for (TemplateTenantVO tenantVO : req.getSubTenantList()) {
                infoTenant = this.packageTemplateTenant(Constants.SelectTypeEnum.RELEASE_BY_TENANT.getFlag(), tempId, tenantVO.getSubTenantId());
                infoTenant.setSubTenantName(tenantVO.getSubTenantName());
                tenantGroupList.add(infoTenant);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getGroupList())) {
            for (TemplateTenantGroupVO groupVO : req.getGroupList()) {
                infoTenant = this.packageTemplateTenant(Constants.SelectTypeEnum.RELEASE_BY_GROUP.getFlag(), tempId, groupVO.getId() + "");
                tenantGroupList.add(infoTenant);
            }
        }
        return tenantGroupList;
    }

    public TemplateInfoTenant packageTemplateTenant(Integer selectType, Long tempId, String groupTenantId) {
        TemplateInfoTenant infoTenant = new TemplateInfoTenant();
        infoTenant.setTemplateId(tempId);
        infoTenant.setSelectType(selectType);
        infoTenant.setSubUserId(Utils.getUserId());
        infoTenant.setGroupTenantId(groupTenantId);
        infoTenant.setTenantId(Utils.getTenantId());
        infoTenant.setCreateUserId(Utils.getUserId());
        infoTenant.setCreateTime(DateUtils.getNowTime((String)""));
        return infoTenant;
    }

    public List<TemplateSystemSource> getSystemSource(Long portId, int serviceSource, List<Long> templateIds) {
        List<Object> systemSourceList = new ArrayList<TemplateSystemSource>();
        if (serviceSource == 0) {
            ArrayList<Integer> contentTypeList = new ArrayList<Integer>();
            contentTypeList.add(Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal());
            contentTypeList.add(Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
            List portalInfoContentList = this.templatePortalInfoContentMapper.queryPortalCont(portId, contentTypeList);
            systemSourceList = this.getSysTemSourceTemp(portalInfoContentList);
        }
        if (serviceSource == 1) {
            List benchTempList = this.templateBenchMapper.selectTempBench(templateIds, Long.valueOf(0L));
            if (CollectionUtils.isEmpty((Collection)benchTempList)) {
                return systemSourceList;
            }
            List benchIdList = benchTempList.stream().map(TemplateBench::getId).collect(Collectors.toList());
            List jobBenchTempList = this.templateBenchMapper.selectBenchByTemp(benchIdList, null);
            jobBenchTempList.addAll(benchTempList);
            if (CollectionUtils.isEmpty((Collection)jobBenchTempList)) {
                return systemSourceList;
            }
            List jobIdTempList = jobBenchTempList.stream().map(TemplateBench::getId).collect(Collectors.toList());
            List jobBenchCustomList = this.templateBenchCustomMapper.selectBenchBy(jobIdTempList, null);
            if (CollectionUtils.isEmpty((Collection)jobBenchCustomList)) {
                return systemSourceList;
            }
            List systemIdList = jobBenchCustomList.stream().map(TemplateBenchCustom::getSystemId).collect(Collectors.toList());
            systemSourceList = this.templateSystemSourceMapper.selBySystemIds(systemIdList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        }
        return systemSourceList;
    }

    public List<LabelSystemData> tempToTenData(List<TemplateSystemData> templateSystemDataList) {
        ArrayList<LabelSystemData> systemDataList = new ArrayList<LabelSystemData>();
        if (CollectionUtils.isEmpty(templateSystemDataList)) {
            return systemDataList;
        }
        for (TemplateSystemData templateSystemData : templateSystemDataList) {
            LabelSystemData systemData = (LabelSystemData)this.converter.convert((Object)templateSystemData, LabelSystemData.class);
            systemDataList.add(systemData);
        }
        return systemDataList;
    }

    public List<QueryTempAppListVo> queryTempAppList(TemplateInfo req) {
        QueryTempAppListVo linkDTO;
        ArrayList<QueryTempAppListVo> appLinkDTOList = new ArrayList<QueryTempAppListVo>();
        List<Object> dataIdList = new ArrayList();
        List systemSourceList = this.getSystemSource(req.getId(), req.getServiceSource(), req.getBenchIdList());
        if (CollectionUtils.isEmpty((Collection)systemSourceList)) {
            return appLinkDTOList;
        }
        dataIdList = systemSourceList.stream().map(TemplateSystemSource::getDataId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dataIdList)) {
            return appLinkDTOList;
        }
        List systemDataTempList = this.templateStystemDataMapper.selByIds(dataIdList);
        if (CollectionUtils.isEmpty((Collection)systemDataTempList)) {
            return appLinkDTOList;
        }
        List systemDataList = this.tempToTenData(systemDataTempList);
        LabelSystemDataAppVo systemDataAppVo = this.labelSystemDataService.getSsoAppMap(systemDataList);
        for (Map.Entry erpEntry : systemDataAppVo.getErpInfoMap().entrySet()) {
            ErpSsoInfo erpSsoInfo = (ErpSsoInfo)erpEntry.getValue();
            linkDTO = new QueryTempAppListVo();
            linkDTO.setPrimaryId(erpSsoInfo.getId() + "");
            linkDTO.setName(erpSsoInfo.getName());
            linkDTO.setSystemIdList(systemDataAppVo.getErpSystemId());
            linkDTO.setCode(erpSsoInfo.getCode());
            linkDTO.setDataSource(ApplicationTypeEnum.CS_APPLICATION.getType());
            appLinkDTOList.add(linkDTO);
        }
        for (Map.Entry thirdEntry : systemDataAppVo.getThirdSsoInfoMap().entrySet()) {
            ThirdSsoInfo thirdSsoInfo = (ThirdSsoInfo)thirdEntry.getValue();
            linkDTO = new QueryTempAppListVo();
            linkDTO.setPrimaryId(thirdSsoInfo.getId() + "");
            linkDTO.setName(thirdSsoInfo.getAppName());
            linkDTO.setCode(thirdSsoInfo.getAppCode());
            linkDTO.setSystemIdList(systemDataAppVo.getBsSystemId());
            linkDTO.setDataSource(ApplicationTypeEnum.BS_APPLICATION.getType());
            appLinkDTOList.add(linkDTO);
        }
        List preDataList = systemDataTempList.stream().filter(item -> ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        List preSystemIdList = preDataList.stream().map(TemplateSystemData::getId).collect(Collectors.toList());
        ArrayList<String> appCodeList = new ArrayList<String>();
        for (TemplateSystemData preData : preDataList) {
            PreinstalledApplication preinsApp;
            if (null == systemDataAppVo.getPreInfoMap() || null == (preinsApp = (PreinstalledApplication)systemDataAppVo.getPreInfoMap().get(Long.parseLong(preData.getAppCode()))) || appCodeList.contains(preData.getAppCode())) continue;
            appCodeList.add(preData.getAppCode());
            QueryTempAppListVo linkDTO2 = new QueryTempAppListVo();
            linkDTO2.setPrimaryId(preData.getAppCode());
            linkDTO2.setName(preinsApp.getApplicationName());
            linkDTO2.setCode(preinsApp.getApplicationCode());
            linkDTO2.setSystemIdList(preSystemIdList);
            linkDTO2.setDataSource(ApplicationTypeEnum.PRESET_APPLICATION.getType());
            appLinkDTOList.add(linkDTO2);
        }
        return appLinkDTOList;
    }

    public ResponseEntity<?> checkUserSystem(PortalInfo returnPort, List<TemplateSystemData> systemDataList) {
        List iamDataList = systemDataList.stream().filter(item -> ApplicationTypeEnum.IAM_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(iamDataList) && CollectionUtils.isNotEmpty(systemDataList)) {
            returnPort.setJumpToPage(Constants.JumpToPageEnum.CORRELATION_APP_PAGE.getVal());
            return ResponseEntityWrapper.wrapperOk((Object)returnPort);
        }
        List allTenantApps = this.iamService.queryTenantApps();
        if (CollectionUtils.isEmpty((Collection)allTenantApps)) {
            returnPort.setJumpToPage(Constants.JumpToPageEnum.NO_PERMISSION_PAGE.getVal());
            String error = this.messageUtils.getMessage("error.message.portal.app.power.error");
            returnPort.setPromptMsg(error);
            return ResponseEntityWrapper.wrapperOk((Object)returnPort);
        }
        Map<String, TenantAppDTO> iamInfoMap = allTenantApps.stream().collect(Collectors.toMap(value -> value.getId(), value -> value, (key1, key2) -> key1));
        for (TemplateSystemData iamData : iamDataList) {
            TenantAppDTO tenantAppDTO = iamInfoMap.get(iamData.getAppCode());
            if (null == tenantAppDTO) {
                returnPort.setJumpToPage(Constants.JumpToPageEnum.NO_PERMISSION_PAGE.getVal());
                String error = this.messageUtils.getMessage("error.message.portal.app.power.error");
                returnPort.setPromptMsg(error);
                return ResponseEntityWrapper.wrapperOk((Object)returnPort);
            }
            String expiredTime = tenantAppDTO.getExpiredTime();
            if (LocalDateTime.parse(expiredTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).compareTo(LocalDateTime.now()) >= 0) continue;
            returnPort.setJumpToPage(Constants.JumpToPageEnum.NO_PERMISSION_PAGE.getVal());
            String error = this.messageUtils.getMessage("error.message.portal.app.power.error");
            returnPort.setPromptMsg(error);
            return ResponseEntityWrapper.wrapperOk((Object)returnPort);
        }
        List ssoDataList = systemDataList.stream().filter(item -> !ApplicationTypeEnum.IAM_APPLICATION.getType().equals(item.getDataType()) && !ApplicationTypeEnum.VIRTUAL_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ssoDataList)) {
            returnPort.setJumpToPage(Constants.JumpToPageEnum.CORRELATION_APP_PAGE.getVal());
            return ResponseEntityWrapper.wrapperOk((Object)returnPort);
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> checkUserTemplate(Long portId) {
        TemplatePortalInfo portalInfo = this.templatePortalInfoMapper.getPortalById(portId);
        if (null == portalInfo) {
            String error = this.messageUtils.getMessage("error.message.portal.not.exist.error");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        PortalInfo returnPort = this.getInitPort(portalInfo, portalInfo.getId());
        ArrayList<Integer> contentTypeList = new ArrayList<Integer>();
        contentTypeList.add(Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal());
        contentTypeList.add(Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        contentTypeList.add(Constants.PrtalContentTypeEnum.CONTAINER.getVal());
        List portalContentTempList = this.templatePortalInfoContentMapper.queryPortalCont(portId, contentTypeList);
        if (CollectionUtils.isEmpty((Collection)portalContentTempList)) {
            returnPort.setJumpToPage(Constants.JumpToPageEnum.PORTAL_PAGE.getVal());
            returnPort.setPortalContent("");
            return ResponseEntityWrapper.wrapperOk((Object)returnPort);
        }
        List preCustomContentList = portalContentTempList.stream().filter(item -> !Constants.PrtalContentTypeEnum.CONTAINER.getVal().equals(item.getContentType())).collect(Collectors.toList());
        List systemSourceList = this.getSysTemSourceTemp(preCustomContentList);
        if (CollectionUtils.isEmpty((Collection)systemSourceList)) {
            returnPort.setJumpToPage(Constants.JumpToPageEnum.PORTAL_PAGE.getVal());
            List tenPortalContent = this.getTenPortalContent(portalContentTempList);
            returnPort.setContentList(tenPortalContent);
            return ResponseEntityWrapper.wrapperOk((Object)returnPort);
        }
        List dataIdList = systemSourceList.stream().map(TemplateSystemSource::getDataId).collect(Collectors.toList());
        List systemDataList = this.templateStystemDataMapper.selByIds(dataIdList);
        ResponseEntity checkResp = this.checkUserSystem(returnPort, systemDataList);
        if (null != checkResp) {
            return checkResp;
        }
        List contentRespTenList = this.initIamSystemData(new ArrayList(), systemDataList, portalContentTempList);
        returnPort.setJumpToPage(Constants.JumpToPageEnum.PORTAL_PAGE.getVal());
        returnPort.setContentList(contentRespTenList);
        return ResponseEntityWrapper.wrapperOk((Object)returnPort);
    }

    public List<TemplateSystemSource> getSysTemSourceTemp(List<TemplatePortalInfoContent> preCustomContentList) {
        List contentIdCusList;
        List systemSourcCusList;
        List cusContentTempList;
        List contentIdPreList;
        List systemSourcePreList;
        ArrayList<TemplateSystemSource> systemSourceTempList = new ArrayList<TemplateSystemSource>();
        List preContentTempList = preCustomContentList.stream().filter(item -> Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal().equals(item.getContentType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(preContentTempList) && CollectionUtils.isNotEmpty((Collection)(systemSourcePreList = this.templateSystemSourceMapper.selBySystemIds(contentIdPreList = preContentTempList.stream().map(TemplatePortalInfoContent::getContentId).collect(Collectors.toList()), Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal())))) {
            systemSourceTempList.addAll(systemSourcePreList);
        }
        if (CollectionUtils.isNotEmpty(cusContentTempList = preCustomContentList.stream().filter(item -> Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal().equals(item.getContentType())).collect(Collectors.toList())) && CollectionUtils.isNotEmpty((Collection)(systemSourcCusList = this.templateSystemSourceMapper.selBySystemIds(contentIdCusList = cusContentTempList.stream().map(TemplatePortalInfoContent::getContentId).collect(Collectors.toList()), Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal())))) {
            systemSourceTempList.addAll(systemSourcCusList);
        }
        return systemSourceTempList;
    }

    public List<PortalInfoContent> getTenPortalContent(List<TemplatePortalInfoContent> tempPortalContent) {
        ArrayList<PortalInfoContent> portalInfoContentList = new ArrayList<PortalInfoContent>();
        List preContentList = tempPortalContent.stream().filter(item -> null != item.getDataType()).collect(Collectors.toList());
        List dataTypeList = preContentList.stream().map(TemplatePortalInfoContent::getDataType).collect(Collectors.toList());
        List preSystemList = this.labelSystemPreService.initDefPortal(dataTypeList, Constants.ClientTypeEnum.PC.getValue());
        Map preInfoMap = preSystemList.stream().collect(Collectors.toMap(LabelSystemPre::getDataType, Function.identity(), (a, b) -> a));
        for (TemplatePortalInfoContent contentInfo : tempPortalContent) {
            PortalInfoContent portalInfoContent = new PortalInfoContent();
            contentInfo.setId(null);
            contentInfo.setTenantId(Utils.getTenantId());
            contentInfo.setPortalId(null);
            if (null == contentInfo.getDataType()) {
                this.converter.convert((Object)contentInfo, (Object)portalInfoContent);
                portalInfoContentList.add(portalInfoContent);
                continue;
            }
            LabelSystemPre systemPre = (LabelSystemPre)preInfoMap.get(contentInfo.getDataType());
            if (null != systemPre) {
                contentInfo.setContentId(systemPre.getId());
            }
            this.converter.convert((Object)contentInfo, (Object)portalInfoContent);
            portalInfoContentList.add(portalInfoContent);
        }
        return portalInfoContentList;
    }

    public Map<Long, Long> initSystemDataTen(List<Long> iamNoPermDataIdTemp, Map<String, String> ssoRelation, List<TemplateSystemData> systemDataTempList, List<Long> dataIdTenList) {
        List systemDataList = this.tempToTenData(systemDataTempList);
        LabelSystemDataAppVo labelSystemDataDto = this.labelSystemDataService.getSsoAppMapTemp(systemDataList);
        HashMap<Long, Long> systemRelation = new HashMap<Long, Long>();
        for (TemplateSystemData systemData : systemDataTempList) {
            String ssoTenVal;
            if (iamNoPermDataIdTemp.contains(systemData.getId())) continue;
            String ssoTempKey = systemData.getAppCode() + "_" + systemData.getDataType();
            if (!systemData.getDataType().equals(ApplicationTypeEnum.IAM_APPLICATION.getType()) && !systemData.getDataType().equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType()) && null != ssoRelation && StringUtils.isEmpty((CharSequence)(ssoTenVal = ssoRelation.get(ssoTempKey)))) continue;
            Map systemAppNameMap = labelSystemDataDto.getSystemAppNameMap();
            LabelSystemDataDto systemDataDto = (LabelSystemDataDto)systemAppNameMap.get(systemData.getId());
            String appName = systemDataDto == null ? "" : systemDataDto.getAppName();
            LabelSystemData systemDataReq = new LabelSystemData();
            String name = systemData.getName();
            if (StringUtils.isNotEmpty((CharSequence)appName)) {
                name = appName + "_" + systemData.getName();
            }
            systemDataReq.setName(name);
            LabelSystemData systemDataTen = this.labelSystemDataMapper.getByInit(systemDataReq);
            if (null != systemDataTen) {
                dataIdTenList.add(systemDataTen.getId());
                systemRelation.put(systemData.getId(), systemDataTen.getId());
                continue;
            }
            this.converter.convert((Object)systemData, (Object)systemDataReq);
            if (null != ssoRelation && StringUtils.isNotEmpty((CharSequence)ssoRelation.get(ssoTempKey))) {
                String ssoTenVal2 = ssoRelation.get(ssoTempKey);
                systemDataReq.setAppCode(ssoTenVal2.split("_")[0]);
                systemDataReq.setDataType(Integer.valueOf(Integer.parseInt(ssoTenVal2.split("_")[1])));
            }
            if (systemData.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_COUNT.getVal()) || systemData.getDataCategory().equals(Constants.DataCategoryEnum.BUSINESS_TODO.getVal())) {
                systemDataReq.setRestUrl("");
                systemDataReq.setMiddleSystemUid("");
                systemDataReq.setMiddleSystemName("");
                systemDataReq.setDataModel(null);
                systemDataReq.setCountCode("");
                systemDataReq.setCountContentCode("");
            }
            systemDataReq.setName(name);
            systemDataReq.setCreateUserName(Utils.getUserName());
            systemDataReq.setModifyUserName(Utils.getUserName());
            systemDataReq.setCreateUserId(Utils.getUserId());
            systemDataReq.setCreateTime(DateUtils.getNowTime((String)""));
            systemDataReq.setModifyTime(DateUtils.getNowTime((String)""));
            systemDataReq.setModifyUserId(Utils.getUserId());
            this.getSsoJobUrl(systemData, systemDataReq, systemDataDto);
            systemDataReq.setTenantId(Utils.getTenantId());
            systemDataReq.setId(null);
            this.labelSystemDataMapper.insert((Object)systemDataReq);
            dataIdTenList.add(systemDataReq.getId());
            systemRelation.put(systemData.getId(), systemDataReq.getId());
        }
        return systemRelation;
    }

    public List<PortalInfoContent> initIamSystemData(List<Long> iamNoPermDataIdTemp, List<TemplateSystemData> systemDataTempList, List<TemplatePortalInfoContent> portalContentTempList) {
        List systemDataList;
        LabelSystemDataAppVo labelSystemDataDto;
        List customContentTempList;
        List dataIdTempList = systemDataTempList.stream().map(TemplateSystemData::getId).collect(Collectors.toList());
        ArrayList dataIdTenList = new ArrayList();
        Map systemRelation = this.initSystemDataTen(iamNoPermDataIdTemp, null, systemDataTempList, dataIdTenList);
        List contentTempList = portalContentTempList.stream().filter(item -> item.getContentType() > Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal()).collect(Collectors.toList());
        this.initContentId(contentTempList);
        List portalInfoContenTenList = this.tempToTenContent(contentTempList);
        List preContentTempList = this.intPreSystem(portalContentTempList, dataIdTempList, systemRelation);
        if (CollectionUtils.isNotEmpty((Collection)preContentTempList)) {
            portalInfoContenTenList.addAll(preContentTempList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(customContentTempList = this.intCustomSystem(portalContentTempList, dataIdTempList, systemRelation, dataIdTenList, labelSystemDataDto = this.labelSystemDataService.getSsoAppMapTemp(systemDataList = this.tempToTenData(systemDataTempList)))))) {
            portalInfoContenTenList.addAll(customContentTempList);
        }
        return portalInfoContenTenList;
    }

    public List<PortalInfoContent> tempToTenContent(List<TemplatePortalInfoContent> contentTempList) {
        ArrayList<PortalInfoContent> portalInfoContenTenList = new ArrayList<PortalInfoContent>();
        for (TemplatePortalInfoContent contentTemp : contentTempList) {
            PortalInfoContent portalInfoContent = (PortalInfoContent)this.converter.convert((Object)contentTemp, PortalInfoContent.class);
            portalInfoContenTenList.add(portalInfoContent);
        }
        return portalInfoContenTenList;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> confimTenTemplate(Long portId) {
        TemplatePortalInfo portalInfo = this.templatePortalInfoMapper.getPortalById(portId);
        if (null == portalInfo) {
            String error = this.messageUtils.getMessage("error.message.portal.not.exist.error");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        PortalInfo returnPort = this.getInitPort(portalInfo, portalInfo.getId());
        ArrayList<Integer> contentTypeList = new ArrayList<Integer>();
        contentTypeList.add(Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal());
        contentTypeList.add(Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        contentTypeList.add(Constants.PrtalContentTypeEnum.CONTAINER.getVal());
        List portalContentTempList = this.templatePortalInfoContentMapper.queryPortalCont(portId, contentTypeList);
        if (CollectionUtils.isEmpty((Collection)portalContentTempList)) {
            returnPort.setJumpToPage(Constants.JumpToPageEnum.PORTAL_PAGE.getVal());
            returnPort.setPortalContent("");
            return ResponseEntityWrapper.wrapperOk((Object)returnPort);
        }
        List preCustomContentList = portalContentTempList.stream().filter(item -> !Constants.PrtalContentTypeEnum.CONTAINER.getVal().equals(item.getContentType())).collect(Collectors.toList());
        List systemSourceList = this.getSysTemSourceTemp(preCustomContentList);
        if (CollectionUtils.isEmpty((Collection)systemSourceList)) {
            returnPort.setJumpToPage(Constants.JumpToPageEnum.PORTAL_PAGE.getVal());
            List tenPortalContent = this.getTenPortalContent(portalContentTempList);
            returnPort.setContentList(tenPortalContent);
            return ResponseEntityWrapper.wrapperOk((Object)returnPort);
        }
        List dataIdList = systemSourceList.stream().map(TemplateSystemSource::getDataId).collect(Collectors.toList());
        List systemDataTempList = this.templateStystemDataMapper.selByIds(dataIdList);
        List ssoDataList = systemDataTempList.stream().filter(item -> !ApplicationTypeEnum.IAM_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ssoDataList)) {
            returnPort.setJumpToPage(Constants.JumpToPageEnum.CORRELATION_APP_PAGE.getVal());
            return ResponseEntityWrapper.wrapperOk((Object)returnPort);
        }
        ArrayList iamNoPermDataIdTemp = new ArrayList();
        systemDataTempList = this.filterNoPerIAM(systemDataTempList, iamNoPermDataIdTemp);
        List contentRespTenList = this.initIamSystemData(iamNoPermDataIdTemp, systemDataTempList, portalContentTempList);
        returnPort.setJumpToPage(Constants.JumpToPageEnum.PORTAL_PAGE.getVal());
        returnPort.setContentList(contentRespTenList);
        return ResponseEntityWrapper.wrapperOk((Object)returnPort);
    }

    public List<TemplateSystemData> filterNoPerIAM(List<TemplateSystemData> systemDataTempAllList, List<Long> iamNoPermDataIdTemp) {
        ArrayList<TemplateSystemData> systemDataTempList = new ArrayList<TemplateSystemData>();
        List iamDataList = systemDataTempAllList.stream().filter(item -> ApplicationTypeEnum.IAM_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map<Object, Object> iamInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(iamDataList)) {
            List allTenantApps = this.iamService.queryTenantApps();
            iamInfoMap = allTenantApps.stream().collect(Collectors.toMap(value -> value.getId(), value -> value, (key1, key2) -> key1));
        }
        for (TemplateSystemData systemData : systemDataTempAllList) {
            if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(systemData.getDataType())) {
                TenantAppDTO tenantAppDTO = (TenantAppDTO)iamInfoMap.get(systemData.getAppCode());
                if (null == tenantAppDTO) {
                    iamNoPermDataIdTemp.add(systemData.getId());
                    continue;
                }
                String expiredTime = tenantAppDTO.getExpiredTime();
                if (LocalDateTime.parse(expiredTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).compareTo(LocalDateTime.now()) < 0) {
                    iamNoPermDataIdTemp.add(systemData.getId());
                    continue;
                }
            }
            systemDataTempList.add(systemData);
        }
        return systemDataTempList;
    }

    @Transactional(rollbackFor={Exception.class})
    public PortalInfo usePortalInfo(UsePortalInfoDto req) {
        TemplatePortalInfo portalInfo = this.templatePortalInfoMapper.getPortalById(req.getId());
        if (null == portalInfo) {
            return null;
        }
        PortalInfo returnPort = this.getInitPort(portalInfo, req.getId());
        List portalInfoContentTempList = this.templatePortalInfoContentMapper.queryPortalCont(portalInfo.getId(), new ArrayList());
        List preCustomContentList = portalInfoContentTempList.stream().filter(item -> !Constants.PrtalContentTypeEnum.CONTAINER.getVal().equals(item.getContentType())).collect(Collectors.toList());
        List systemSourceList = this.getSysTemSourceTemp(preCustomContentList);
        List dataIdList = systemSourceList.stream().map(TemplateSystemSource::getDataId).collect(Collectors.toList());
        List systemDataTempList = this.templateStystemDataMapper.selByIds(dataIdList);
        Map ssoRelation = this.filterAppRelation(req.getAppRelationList());
        ArrayList iamNoPermDataIdTemp = new ArrayList();
        this.filterNoPerIAM(systemDataTempList, iamNoPermDataIdTemp);
        List contentRespTenList = this.initSystemData(iamNoPermDataIdTemp, ssoRelation, systemDataTempList, portalInfoContentTempList);
        returnPort.setContentList(contentRespTenList);
        return returnPort;
    }

    public PortalInfo getInitPort(TemplatePortalInfo portalInfo, Long id) {
        PortalInfo returnPort = (PortalInfo)this.converter.convert((Object)portalInfo, PortalInfo.class);
        returnPort.setId(null);
        returnPort.setPortalImgUrl("");
        returnPort.setParentId(id);
        returnPort.setTemplateId(null);
        String name = Utils.subToName((String)portalInfo.getName(), (int)30);
        returnPort.setName(name);
        returnPort.setStatus(Constants.ReleaseEnum.NO_RELEASE.getVal());
        return returnPort;
    }

    public List<PortalInfoContent> initSystemData(List<Long> iamNoPermDataIdTemp, Map<String, String> ssoRelation, List<TemplateSystemData> systemDataTempList, List<TemplatePortalInfoContent> tempPortalContentList) {
        List customContentTempList;
        ArrayList<Long> dataIdTenList = new ArrayList<Long>();
        HashMap<Long, Long> systemRelation = new HashMap<Long, Long>();
        List systemDataList = this.tempToTenData(systemDataTempList);
        LabelSystemDataAppVo labelSystemDataDto = this.labelSystemDataService.getSsoAppMapTemp(systemDataList);
        for (TemplateSystemData systemDataTemp : systemDataTempList) {
            String ssoTenVal;
            Map systemAppNameMap = labelSystemDataDto.getSystemAppNameMap();
            LabelSystemDataDto systemDataDto = (LabelSystemDataDto)systemAppNameMap.get(systemDataTemp.getId());
            String appName = systemDataDto == null ? "" : systemDataDto.getAppName();
            LabelSystemData systemDataReq = new LabelSystemData();
            if (StringUtils.isNotEmpty((CharSequence)appName)) {
                appName = appName + "_" + systemDataTemp.getName();
            }
            systemDataReq.setName(appName);
            if (iamNoPermDataIdTemp.contains(systemDataTemp.getId())) continue;
            String ssoTempKey = systemDataTemp.getAppCode() + "_" + systemDataTemp.getDataType();
            if (!systemDataTemp.getDataType().equals(ApplicationTypeEnum.IAM_APPLICATION.getType()) && !systemDataTemp.getDataType().equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType()) && null != ssoRelation && StringUtils.isEmpty((CharSequence)(ssoTenVal = ssoRelation.get(ssoTempKey)))) continue;
            LabelSystemData systemDataTen = this.labelSystemDataMapper.getByInit(systemDataReq);
            if (null != systemDataTen) {
                dataIdTenList.add(systemDataTen.getId());
                systemRelation.put(systemDataTemp.getId(), systemDataTen.getId());
                continue;
            }
            this.converter.convert((Object)systemDataTemp, (Object)systemDataReq);
            if (null != ssoRelation && StringUtils.isNotEmpty((CharSequence)ssoRelation.get(ssoTempKey))) {
                String ssoTenVal2 = ssoRelation.get(ssoTempKey);
                systemDataReq.setAppCode(ssoTenVal2.split("_")[0]);
                systemDataReq.setDataType(Integer.valueOf(Integer.parseInt(ssoTenVal2.split("_")[1])));
            }
            if (systemDataTemp.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_COUNT.getVal()) || systemDataTemp.getDataCategory().equals(Constants.DataCategoryEnum.BUSINESS_TODO.getVal())) {
                systemDataReq.setRestUrl("");
                systemDataReq.setMiddleSystemUid("");
                systemDataReq.setMiddleSystemName("");
                systemDataReq.setDataModel(null);
                systemDataReq.setCountCode("");
                systemDataReq.setCountContentCode("");
            }
            systemDataReq.setName(appName);
            systemDataReq.setCreateUserId(Utils.getUserId());
            systemDataReq.setCreateTime(DateUtils.getNowTime((String)""));
            systemDataReq.setModifyTime(DateUtils.getNowTime((String)""));
            systemDataReq.setModifyUserId(Utils.getUserId());
            this.getSsoJobUrl(systemDataTemp, systemDataReq, systemDataDto);
            systemDataReq.setTenantId(Utils.getTenantId());
            systemDataReq.setId(null);
            this.labelSystemDataMapper.insert((Object)systemDataReq);
            dataIdTenList.add(systemDataReq.getId());
            systemRelation.put(systemDataTemp.getId(), systemDataReq.getId());
        }
        List dataIdTempList = systemDataTempList.stream().map(TemplateSystemData::getId).collect(Collectors.toList());
        List contentTempList = tempPortalContentList.stream().filter(item -> item.getContentType() > Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal()).collect(Collectors.toList());
        this.initContentId(contentTempList);
        List portalInfoContentList = this.tempToTenContent(contentTempList);
        List preContentTempList = this.intPreSystem(tempPortalContentList, dataIdTempList, systemRelation);
        if (CollectionUtils.isNotEmpty((Collection)preContentTempList)) {
            portalInfoContentList.addAll(preContentTempList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(customContentTempList = this.intCustomSystem(tempPortalContentList, dataIdTempList, systemRelation, dataIdTenList, labelSystemDataDto)))) {
            portalInfoContentList.addAll(customContentTempList);
        }
        return portalInfoContentList;
    }

    public void initContentId(List<TemplatePortalInfoContent> contentTempList) {
        for (TemplatePortalInfoContent contentTemp : contentTempList) {
            contentTemp.setId(null);
        }
    }

    public String getSsoJobUrl(TemplateSystemData systemDataTemp, LabelSystemData systemDataTen, LabelSystemDataDto systemDataDto) {
        if (!systemDataTemp.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_WORK.getVal())) {
            return systemDataTemp.getCallBackUrl();
        }
        if (null == systemDataTemp.getIsJob() || systemDataTemp.getIsJob() == 1) {
            return systemDataTemp.getCallBackUrl();
        }
        if (null != systemDataTemp.getDataType() && ApplicationTypeEnum.IAM_APPLICATION.getType().equals(systemDataTemp.getDataType())) {
            return systemDataTemp.getWorkCode();
        }
        ArrayList<TemplateSystemData> systemDataList = new ArrayList<TemplateSystemData>();
        systemDataList.add(systemDataTemp);
        if (null == systemDataDto) {
            return systemDataTemp.getWorkCode();
        }
        String appId = systemDataDto.getAppId();
        List syncJobInfoList = this.syncJobInfoMapper.selByCode(appId, systemDataTemp.getWorkCode());
        if (CollectionUtils.isNotEmpty((Collection)syncJobInfoList)) {
            systemDataTen.setIsJob(Integer.valueOf(1));
            systemDataTen.setWorkCode("");
            systemDataTen.setCallBackUrl(((SyncJobInfo)syncJobInfoList.get(0)).getJobUrl());
            return ((SyncJobInfo)syncJobInfoList.get(0)).getJobUrl();
        }
        return "";
    }

    public List<PortalInfoContent> intCustomSystem(List<TemplatePortalInfoContent> tempPortalContentList, List<Long> dataIdTempList, Map<Long, Long> systemRelation, List<Long> dataIdTenList, LabelSystemDataAppVo labelSystemDataDto) {
        if (CollectionUtils.isEmpty(dataIdTempList)) {
            return new ArrayList<PortalInfoContent>();
        }
        List customContentTempList = tempPortalContentList.stream().filter(item -> Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal().equals(item.getContentType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(customContentTempList)) {
            return new ArrayList<PortalInfoContent>();
        }
        List customIdTempList = customContentTempList.stream().map(TemplatePortalInfoContent::getContentId).collect(Collectors.toList());
        List customTemList = this.templateSystemCustomMapper.selByIds(customIdTempList);
        if (CollectionUtils.isEmpty((Collection)customTemList)) {
            return new ArrayList<PortalInfoContent>();
        }
        Map customTemMap = customTemList.stream().collect(Collectors.toMap(TemplateSystemCustom::getId, Function.identity(), (a, b) -> a));
        List customSourceTempList = this.templateSystemSourceMapper.selBySystemIds(customIdTempList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        if (CollectionUtils.isEmpty((Collection)customSourceTempList)) {
            return new ArrayList<PortalInfoContent>();
        }
        Map<Long, Long> customDataTempMap = customSourceTempList.stream().collect(Collectors.toMap(TemplateSystemSource::getSystemId, TemplateSystemSource::getDataId, (a, b) -> a));
        List customSourceTenList = this.labelSystemSourceMapper.selByDataIds(dataIdTenList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        List customIdTenpList = customSourceTenList.stream().map(LabelSystemSource::getSystemId).collect(Collectors.toList());
        List customTenList = new ArrayList();
        Map<Object, Object> customTenMap = new HashMap();
        if (CollectionUtils.isNotEmpty(customIdTenpList)) {
            customTenList = this.labelSystemCustomMapper.selByIds(customIdTenpList);
            customTenMap = customTenList.stream().collect(Collectors.toMap(LabelSystemCustom::getId, Function.identity(), (a, b) -> a));
        }
        Map<Long, Long> customDataTenMap = customSourceTenList.stream().collect(Collectors.toMap(LabelSystemSource::getDataId, LabelSystemSource::getSystemId, (a, b) -> a));
        ArrayList<PortalInfoContent> customContentTenList = new ArrayList<PortalInfoContent>();
        for (TemplatePortalInfoContent customContentTemp : customContentTempList) {
            LabelSystemCustom systemCustomTen;
            Long dataIdTen;
            customContentTemp.setId(null);
            Long dataIdTemp = customDataTempMap.get(customContentTemp.getContentId());
            if (!dataIdTempList.contains(dataIdTemp) || null == (dataIdTen = systemRelation.get(dataIdTemp))) continue;
            Long customIdTen = customDataTenMap.get(dataIdTen);
            String contentName = customContentTemp.getContentName();
            if (null != customIdTen) {
                customContentTemp.setContentId(customIdTen);
                systemCustomTen = (LabelSystemCustom)customTenMap.get(customIdTen);
                contentName = systemCustomTen == null ? "" : systemCustomTen.getNameZh();
            } else {
                systemCustomTen = this.initCustomData(dataIdTemp, (TemplateSystemCustom)customTemMap.get(customContentTemp.getContentId()), dataIdTen, labelSystemDataDto);
                customContentTemp.setContentId(systemCustomTen.getId());
                customContentTemp.setContentName(systemCustomTen.getNameZh());
            }
            if (StringUtils.isEmpty((CharSequence)customContentTemp.getContentName())) {
                customContentTemp.setContentName(contentName);
            }
            PortalInfoContent portalInfoContentTen = (PortalInfoContent)this.converter.convert((Object)customContentTemp, PortalInfoContent.class);
            customContentTenList.add(portalInfoContentTen);
        }
        return customContentTenList;
    }

    public LabelSystemCustom initCustomData(Long dataIdTemp, TemplateSystemCustom systemCustomTemp, Long dataIdTen, LabelSystemDataAppVo labelSystemDataDto) {
        LabelSystemCustom customTemp;
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        Map systemAppNameMap = labelSystemDataDto.getSystemAppNameMap();
        LabelSystemDataDto systemDataDto = (LabelSystemDataDto)systemAppNameMap.get(dataIdTemp);
        String appName = systemDataDto == null ? "" : systemDataDto.getAppName();
        LabelSystemCustom systemCustomTen = (LabelSystemCustom)this.converter.convert((Object)systemCustomTemp, LabelSystemCustom.class);
        systemCustomTen.setId(null);
        String contentName = systemCustomTemp.getNameZh();
        if (StringUtils.isNotEmpty((CharSequence)appName)) {
            contentName = appName + "_" + systemCustomTemp.getNameZh();
        }
        if (null != (customTemp = this.labelSystemCustomMapper.selByName(contentName, null))) {
            return customTemp;
        }
        systemCustomTen.setNameZh(contentName);
        systemCustomTen.setCreateUserId(Utils.getUserId());
        systemCustomTen.setCreateUserName(Utils.getUserName());
        systemCustomTen.setModifyUserName(Utils.getUserName());
        systemCustomTen.setCreateTime(DateUtils.getNowTime((String)""));
        systemCustomTen.setModifyTime(DateUtils.getNowTime((String)""));
        systemCustomTen.setModifyUserId(Utils.getUserId());
        systemCustomTen.setTenantId(tenantId);
        this.labelSystemCustomMapper.insert((Object)systemCustomTen);
        LabelSystemSource systemSource = new LabelSystemSource();
        systemSource.setDataId(dataIdTen);
        systemSource.setSystemId(systemCustomTen.getId());
        systemSource.setTenantId(tenantId);
        systemSource.setCreateUserId(Utils.getUserId());
        systemSource.setCreateTime(DateUtils.getNowTime((String)""));
        systemSource.setComponentSource(Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        this.labelSystemSourceMapper.insert((Object)systemSource);
        return systemCustomTen;
    }

    public List<PortalInfoContent> intPreSystem(List<TemplatePortalInfoContent> tempPortalContentList, List<Long> dataIdTempList, Map<Long, Long> systemRelation) {
        List dataTypeList;
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        List<Object> portalInfoContentList = new ArrayList<PortalInfoContent>();
        List preContentTempList = tempPortalContentList.stream().filter(item -> Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal().equals(item.getContentType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(preContentTempList)) {
            return portalInfoContentList;
        }
        List preIdTempList = preContentTempList.stream().map(TemplatePortalInfoContent::getContentId).collect(Collectors.toList());
        List systemSourceTempList = this.templateSystemSourceMapper.selBySystemIds(preIdTempList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal());
        Map<Object, Object> preDataTempMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)systemSourceTempList)) {
            preDataTempMap = systemSourceTempList.stream().collect(Collectors.groupingBy(TemplateSystemSource::getSystemId));
        }
        if (CollectionUtils.isNotEmpty(dataTypeList = preContentTempList.stream().map(TemplatePortalInfoContent::getDataType).collect(Collectors.toList())) && dataTypeList.contains(Constants.DataTypeEnum.TYPE_TODO.getVal())) {
            dataTypeList.add(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal());
        }
        List preSystemTenList = this.labelSystemPreService.initDefPortal(dataTypeList, Constants.ClientTypeEnum.PC.getValue());
        Map preInfoTenMap = preSystemTenList.stream().collect(Collectors.toMap(LabelSystemPre::getDataType, Function.identity(), (a, b) -> a));
        List preTenIdList = preSystemTenList.stream().map(LabelSystemPre::getId).collect(Collectors.toList());
        List systemSourceTenList = this.labelSystemSourceMapper.selBySystemIds(preTenIdList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal());
        Map<Object, Object> preDataTenMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)systemSourceTenList)) {
            preDataTenMap = systemSourceTenList.stream().collect(Collectors.groupingBy(LabelSystemSource::getSystemId));
        }
        for (TemplatePortalInfoContent preContent : preContentTempList) {
            List systemSourcesTempList = (List)preDataTempMap.get(preContent.getContentId());
            LabelSystemPre preTen = (LabelSystemPre)preInfoTenMap.get(preContent.getDataType());
            if (null == preTen) continue;
            preContent.setContentId(preTen.getId());
            preContent.setId(null);
            if (CollectionUtils.isEmpty((Collection)systemSourcesTempList)) continue;
            if (preContent.getDataType().equals(Constants.DataTypeEnum.TYPE_TODO.getVal())) {
                LabelSystemPre thirdToDoPreTen = (LabelSystemPre)preInfoTenMap.get(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal());
                BeanUtils.copyProperties((Object)thirdToDoPreTen, (Object)preTen);
            }
            for (TemplateSystemSource systemSourcesTemp : systemSourcesTempList) {
                Long systemDataIdTen;
                if (!dataIdTempList.contains(systemSourcesTemp.getDataId()) || null == (systemDataIdTen = systemRelation.get(systemSourcesTemp.getDataId()))) continue;
                List<Object> dataTenIdList = new ArrayList();
                List systemSourcesList = (List)preDataTenMap.get(preTen.getId());
                if (CollectionUtils.isNotEmpty((Collection)systemSourcesList)) {
                    dataTenIdList = systemSourcesList.stream().map(LabelSystemSource::getDataId).collect(Collectors.toList());
                }
                if (dataTenIdList.contains(systemDataIdTen)) continue;
                LabelSystemSource systemSource = new LabelSystemSource();
                systemSource.setDataId(systemDataIdTen);
                systemSource.setSystemId(preTen.getId());
                systemSource.setTenantId(tenantId);
                systemSource.setCreateUserId(Utils.getUserId());
                systemSource.setCreateTime(DateUtils.getNowTime((String)""));
                systemSource.setComponentSource(Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal());
                this.labelSystemSourceMapper.insert((Object)systemSource);
                if (null == preTen) continue;
                preTen.setModifyTime(DateUtils.getNowTime((String)""));
                this.labelSystemPreService.updateById((Object)preTen);
            }
        }
        portalInfoContentList = this.tempToTenContent(preContentTempList);
        return portalInfoContentList;
    }

    public Map<String, String> filterAppRelation(List<UsePortalDetailDto> appRelationList) {
        HashMap<String, String> ssoRelation = new HashMap<String, String>();
        for (UsePortalDetailDto appRelation : appRelationList) {
            QueryTempAppListVo tempApp = appRelation.getTempApp();
            if (null == tempApp || StringUtils.isEmpty((CharSequence)tempApp.getPrimaryId()) || null == tempApp.getDataSource()) continue;
            String key = tempApp.getPrimaryId() + "_" + tempApp.getDataSource();
            AppLinkDTO ssoApp = appRelation.getSsoApp();
            if (null == ssoApp || StringUtils.isEmpty((CharSequence)ssoApp.getPrimaryId()) || null == ssoApp.getDataSource()) continue;
            String val = ssoApp.getPrimaryId() + "_" + ssoApp.getDataSource();
            ssoRelation.put(key, val);
        }
        return ssoRelation;
    }

    public ResponseEntity<?> checkBenchTemplate(List<Long> templateIds) {
        List jobIdTempList;
        PortalInfo returnPort = new PortalInfo();
        List benchTempList = this.templateBenchMapper.selectTempBench(templateIds, Long.valueOf(0L));
        if (CollectionUtils.isEmpty((Collection)benchTempList)) {
            returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
            return ResponseEntityWrapper.wrapperOk((Object)returnPort);
        }
        List benchIdList = benchTempList.stream().map(TemplateBench::getId).collect(Collectors.toList());
        List jobBenchTempList = this.templateBenchMapper.selectBenchByTemp(benchIdList, null);
        if (CollectionUtils.isNotEmpty((Collection)jobBenchTempList)) {
            benchTempList.addAll(jobBenchTempList);
        }
        if (CollectionUtils.isEmpty(jobIdTempList = benchTempList.stream().map(TemplateBench::getId).collect(Collectors.toList()))) {
            returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
            return ResponseEntityWrapper.wrapperOk((Object)returnPort);
        }
        List jobBenchCustomList = this.templateBenchCustomMapper.selectBenchBy(jobIdTempList, null);
        if (CollectionUtils.isEmpty((Collection)jobBenchCustomList)) {
            returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
            this.initBench(benchTempList);
            return ResponseEntityWrapper.wrapperOk((Object)returnPort);
        }
        List systemIdList = jobBenchCustomList.stream().map(TemplateBenchCustom::getSystemId).collect(Collectors.toList());
        List systemSourceTempList = this.templateSystemSourceMapper.selBySystemIds(systemIdList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        if (CollectionUtils.isEmpty((Collection)systemSourceTempList)) {
            returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
            this.initBench(benchTempList);
            return ResponseEntityWrapper.wrapperOk((Object)returnPort);
        }
        List dataIdTempList = systemSourceTempList.stream().map(TemplateSystemSource::getDataId).collect(Collectors.toList());
        List systemDataTempList = this.templateStystemDataMapper.selByIds(dataIdTempList);
        ResponseEntity checkResp = this.checkUserSystem(returnPort, systemDataTempList);
        if (null != checkResp) {
            return checkResp;
        }
        this.initBenchData(new ArrayList(), null, systemDataTempList, benchTempList, jobBenchCustomList, systemSourceTempList);
        returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
        return ResponseEntityWrapper.wrapperOk((Object)returnPort);
    }

    public void initBenchData(List<Long> iamNoPermDataIdTemp, Map<String, String> ssoRelation, List<TemplateSystemData> systemDataTempList, List<TemplateBench> jobBenchTempList, List<TemplateBenchCustom> jobBenchCustomList, List<TemplateSystemSource> systemSourceTempList) {
        List dataIdTempList = systemDataTempList.stream().map(TemplateSystemData::getId).collect(Collectors.toList());
        ArrayList dataIdTenList = new ArrayList();
        Map systemRelation = this.initSystemDataTen(iamNoPermDataIdTemp, ssoRelation, systemDataTempList, dataIdTenList);
        Map customDataRelationMap = this.initBenchCustom(iamNoPermDataIdTemp, systemDataTempList, dataIdTempList, dataIdTenList, jobBenchCustomList, systemSourceTempList, systemRelation);
        Map benchRelationMap = this.initBench(jobBenchTempList);
        for (TemplateBenchCustom jobBenchCustomTemp : jobBenchCustomList) {
            Long benchIdTen = (Long)benchRelationMap.get(jobBenchCustomTemp.getBenchId());
            Long systemIdTen = (Long)customDataRelationMap.get(jobBenchCustomTemp.getSystemId());
            JobBenchCustom benchCustomTen = (JobBenchCustom)this.converter.convert((Object)jobBenchCustomTemp, JobBenchCustom.class);
            benchCustomTen.setId(null);
            benchCustomTen.setBenchId(benchIdTen);
            benchCustomTen.setTenantId(Utils.getTenantId());
            benchCustomTen.setCreateTime(DateUtils.getNowTime((String)""));
            if (null == systemIdTen || null == benchIdTen) continue;
            benchCustomTen.setSystemId(systemIdTen);
            this.jobBenchCustomMapper.insert((Object)benchCustomTen);
        }
    }

    public Map<Long, Long> initBench(List<TemplateBench> jobBenchTempList) {
        HashMap<Long, Long> benchRelationMap = new HashMap<Long, Long>();
        Map<Long, List<TemplateBench>> benchLaneTempMap = jobBenchTempList.stream().collect(Collectors.groupingBy(TemplateBench::getParentId));
        List jobBenchParentTempList = jobBenchTempList.stream().filter(x -> x.getParentId().equals(0L)).collect(Collectors.toList());
        Integer index = this.jobBenchMapper.getIndexByTen(Utils.getTenantId());
        for (TemplateBench jobBenchTemp : jobBenchParentTempList) {
            if (null == index) {
                index = 0;
            }
            index = index + 1;
            JobBench jobBenchTen = (JobBench)this.converter.convert((Object)jobBenchTemp, JobBench.class);
            jobBenchTen.setLabelIndex(index);
            JobBench jobBenchParentTen = this.jobBenchMapper.checkBenchList(jobBenchTemp.getParentId(), jobBenchTemp.getName());
            if (null != jobBenchParentTen) {
                String name = Utils.subToName((String)jobBenchTemp.getName(), (int)12);
                jobBenchTen.setName(name);
            }
            jobBenchTen.setId(null);
            jobBenchTen.setTenantId(Utils.getTenantId());
            jobBenchTen.setTemplateId(null);
            this.jobBenchMapper.insert((Object)jobBenchTen);
            List<TemplateBench> laneTempList = benchLaneTempMap.get(jobBenchTemp.getId());
            for (TemplateBench childBenchTemp : laneTempList) {
                JobBench childBenchTen = (JobBench)this.converter.convert((Object)childBenchTemp, JobBench.class);
                childBenchTen.setId(null);
                childBenchTen.setParentId(jobBenchTen.getId());
                childBenchTen.setTenantId(Utils.getTenantId());
                childBenchTen.setTemplateId(null);
                childBenchTen.setCreateTime(DateUtils.getNowTime((String)""));
                this.jobBenchMapper.insert((Object)childBenchTen);
                benchRelationMap.put(childBenchTemp.getId(), childBenchTen.getId());
            }
        }
        return benchRelationMap;
    }

    public Map<Long, Long> initBenchCustom(List<Long> iamNoPermDataIdTemp, List<TemplateSystemData> systemDataTempList, List<Long> dataIdTempList, List<Long> dataIdTenList, List<TemplateBenchCustom> jobBenchCustomTempList, List<TemplateSystemSource> systemSourceTempList, Map<Long, Long> systemRelation) {
        HashMap<Long, Long> customDataRelationMap = new HashMap<Long, Long>();
        List systemDataList = this.tempToTenData(systemDataTempList);
        LabelSystemDataAppVo labelSystemDataDto = this.labelSystemDataService.getSsoAppMapTemp(systemDataList);
        List sytemIdTempList = systemSourceTempList.stream().map(TemplateSystemSource::getSystemId).collect(Collectors.toList());
        List customTempList = this.templateSystemCustomMapper.selByIds(sytemIdTempList);
        if (CollectionUtils.isEmpty((Collection)customTempList)) {
            return customDataRelationMap;
        }
        Map customTemMap = customTempList.stream().collect(Collectors.toMap(TemplateSystemCustom::getId, Function.identity(), (a, b) -> a));
        Map<Long, Long> systemDataTemMap = systemSourceTempList.stream().collect(Collectors.toMap(TemplateSystemSource::getSystemId, TemplateSystemSource::getDataId, (a, b) -> a));
        Map<Long, Long> systemDataTemCheckMap = systemSourceTempList.stream().collect(Collectors.toMap(TemplateSystemSource::getDataId, TemplateSystemSource::getSystemId, (a, b) -> a));
        List customSourceTenList = this.labelSystemSourceMapper.selByDataIds(dataIdTenList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        Map<Object, Object> customDataTenMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)customSourceTenList)) {
            customDataTenMap = customSourceTenList.stream().collect(Collectors.toMap(LabelSystemSource::getDataId, LabelSystemSource::getSystemId, (a, b) -> a));
        }
        for (TemplateBenchCustom jobBenchCustomTemp : jobBenchCustomTempList) {
            Long dataIdTen;
            Long iamNoPremDataId;
            Long dataIdTemp = systemDataTemMap.get(jobBenchCustomTemp.getSystemId());
            if (!dataIdTempList.contains(dataIdTemp) || iamNoPermDataIdTemp.contains(iamNoPremDataId = systemDataTemCheckMap.get(jobBenchCustomTemp.getSystemId())) || null == (dataIdTen = systemRelation.get(dataIdTemp))) continue;
            Long customIdTen = (Long)customDataTenMap.get(dataIdTen);
            if (null != customIdTen) {
                customDataRelationMap.put(jobBenchCustomTemp.getSystemId(), customIdTen);
                continue;
            }
            LabelSystemCustom systemCustomTen = this.initCustomData(dataIdTemp, (TemplateSystemCustom)customTemMap.get(jobBenchCustomTemp.getSystemId()), dataIdTen, labelSystemDataDto);
            customDataRelationMap.put(jobBenchCustomTemp.getSystemId(), systemCustomTen.getId());
        }
        return customDataRelationMap;
    }

    public ResponseEntity<?> confimBenchTemplate(List<Long> templateIds) {
        PortalInfo returnPort = new PortalInfo();
        List benchTempList = this.templateBenchMapper.selectTempBench(templateIds, Long.valueOf(0L));
        if (CollectionUtils.isEmpty((Collection)benchTempList)) {
            returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
            return ResponseEntityWrapper.wrapperOk((Object)returnPort);
        }
        List benchIdList = benchTempList.stream().map(TemplateBench::getId).collect(Collectors.toList());
        List jobBenchTempList = this.templateBenchMapper.selectBenchByTemp(benchIdList, null);
        jobBenchTempList.addAll(benchTempList);
        if (CollectionUtils.isEmpty((Collection)jobBenchTempList)) {
            returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
            return ResponseEntityWrapper.wrapperOk((Object)returnPort);
        }
        List jobIdTempList = jobBenchTempList.stream().map(TemplateBench::getId).collect(Collectors.toList());
        List jobBenchCustomList = this.templateBenchCustomMapper.selectBenchBy(jobIdTempList, null);
        if (CollectionUtils.isEmpty((Collection)jobBenchCustomList)) {
            returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
            this.initBench(jobBenchTempList);
            return ResponseEntityWrapper.wrapperOk((Object)returnPort);
        }
        List systemIdList = jobBenchCustomList.stream().map(TemplateBenchCustom::getSystemId).collect(Collectors.toList());
        List systemSourceTempList = this.templateSystemSourceMapper.selBySystemIds(systemIdList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        if (CollectionUtils.isEmpty((Collection)systemSourceTempList)) {
            returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
            this.initBench(jobBenchTempList);
            return ResponseEntityWrapper.wrapperOk((Object)returnPort);
        }
        List dataIdList = systemSourceTempList.stream().map(TemplateSystemSource::getDataId).collect(Collectors.toList());
        List systemDataTempList = this.templateStystemDataMapper.selByIds(dataIdList);
        List ssoDataList = systemDataTempList.stream().filter(item -> !ApplicationTypeEnum.IAM_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ssoDataList)) {
            returnPort.setJumpToPage(Constants.JumpToPageEnum.CORRELATION_APP_PAGE.getVal());
            return ResponseEntityWrapper.wrapperOk((Object)returnPort);
        }
        ArrayList iamNoPermDataIdTemp = new ArrayList();
        systemDataTempList = this.filterNoPerIAM(systemDataTempList, iamNoPermDataIdTemp);
        this.initBenchData(iamNoPermDataIdTemp, null, systemDataTempList, jobBenchTempList, jobBenchCustomList, systemSourceTempList);
        returnPort.setJumpToPage(Constants.JumpToPageEnum.JOB_BENCH_PAGE.getVal());
        return ResponseEntityWrapper.wrapperOk((Object)returnPort);
    }

    public ResponseEntity<?> useBenchTemp(UsePortalInfoDto req) {
        List benchTempList = this.templateBenchMapper.selectTempBench(req.getBenchIdList(), Long.valueOf(0L));
        if (CollectionUtils.isEmpty((Collection)benchTempList)) {
            return ResponseEntityWrapper.wrapperOk();
        }
        List benchIdList = benchTempList.stream().map(TemplateBench::getId).collect(Collectors.toList());
        List jobBenchTempList = this.templateBenchMapper.selectBenchByTemp(benchIdList, null);
        jobBenchTempList.addAll(benchTempList);
        if (CollectionUtils.isEmpty((Collection)jobBenchTempList)) {
            return ResponseEntityWrapper.wrapperOk();
        }
        List jobIdTempList = jobBenchTempList.stream().map(TemplateBench::getId).collect(Collectors.toList());
        List jobBenchCustomList = this.templateBenchCustomMapper.selectBenchBy(jobIdTempList, null);
        if (CollectionUtils.isEmpty((Collection)jobBenchCustomList)) {
            this.initBench(jobBenchTempList);
            return ResponseEntityWrapper.wrapperOk();
        }
        List systemIdList = jobBenchCustomList.stream().map(TemplateBenchCustom::getSystemId).collect(Collectors.toList());
        List systemSourceTempList = this.templateSystemSourceMapper.selBySystemIds(systemIdList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        List dataIdList = systemSourceTempList.stream().map(TemplateSystemSource::getDataId).collect(Collectors.toList());
        List systemDataTempList = this.templateStystemDataMapper.selByIds(dataIdList);
        Map ssoRelation = this.filterAppRelation(req.getAppRelationList());
        ArrayList iamNoPermDataIdTemp = new ArrayList();
        this.filterNoPerIAM(systemDataTempList, iamNoPermDataIdTemp);
        this.initBenchData(iamNoPermDataIdTemp, ssoRelation, systemDataTempList, jobBenchTempList, jobBenchCustomList, systemSourceTempList);
        return ResponseEntityWrapper.wrapperOk();
    }

    public TemplateInfo getTempGroupVO(Long tempId) {
        TemplateInfo templateInfo = new TemplateInfo();
        ArrayList<Long> templateIdList = new ArrayList<Long>();
        templateIdList.add(tempId);
        List infoTenantList = this.templateInfoTenantMapper.selectByTemp(templateIdList);
        List tenantGroupVOList = new ArrayList();
        Map<Object, Object> tenantGroupVOMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)infoTenantList)) {
            List groupIdList = infoTenantList.stream().map(TemplateInfoTenant::getGroupTenantId).collect(Collectors.toList());
            tenantGroupVOList = this.templateTenantGroupMapper.selectByIds(groupIdList);
        }
        if (CollectionUtils.isNotEmpty(tenantGroupVOList)) {
            tenantGroupVOMap = tenantGroupVOList.stream().collect(Collectors.toMap(value -> value.getId(), value -> value, (key1, key2) -> key1));
        }
        ArrayList<TemplateTenantVO> tenantList = new ArrayList<TemplateTenantVO>();
        ArrayList<Object> groupList = new ArrayList<Object>();
        for (TemplateInfoTenant tenant : infoTenantList) {
            if (tenant.getSelectType().equals(Constants.SelectTypeEnum.RELEASE_BY_TENANT.getFlag())) {
                TemplateTenantVO tenantVO = new TemplateTenantVO();
                tenantVO.setSubTenantId(tenant.getGroupTenantId());
                tenantVO.setSubTenantName(tenant.getSubTenantName());
                tenantList.add(tenantVO);
            }
            if (!tenant.getSelectType().equals(Constants.SelectTypeEnum.RELEASE_BY_GROUP.getFlag()) || null == tenantGroupVOMap.get(Long.parseLong(tenant.getGroupTenantId()))) continue;
            groupList.add(tenantGroupVOMap.get(Long.parseLong(tenant.getGroupTenantId())));
        }
        templateInfo.setSubTenantList(tenantList);
        templateInfo.setGroupList(groupList);
        return templateInfo;
    }

    public List<TemplateBench> queryVisibleTempList(Integer templateType) {
        List userTenantList;
        ArrayList<TemplateBench> benchList = new ArrayList<TemplateBench>();
        TemplateQueryReq req = new TemplateQueryReq();
        req.setTemplateType(templateType);
        ArrayList<Integer> subTypeList = new ArrayList<Integer>();
        subTypeList.add(Constants.SubTypeEnum.ALL_TENANT.getFlag());
        subTypeList.add(Constants.SubTypeEnum.PART_TENANT.getFlag());
        List templateInfoList = this.templateInfoMapper.queryByTemp(req, subTypeList);
        Map<Object, Object> tenantGroupMap = new HashMap();
        Map<Object, Object> groupMap = new HashMap();
        Map<Object, Object> groupItemMap = new HashMap();
        Map<Object, Object> userTenantMap = new HashMap();
        List<Object> tempSubUserIdList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)templateInfoList)) {
            List allTenantList = templateInfoList.stream().filter(item -> Constants.SubTypeEnum.ALL_TENANT.getFlag().equals(item.getSubType())).filter(item -> !item.getDefaultFlag().equals(Constants.DEFAULT_CONFIGURED_FLAG_YES)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(allTenantList)) {
                tempSubUserIdList = allTenantList.stream().map(BaseEntity::getCreateUserId).collect(Collectors.toList());
            }
            List tempIdList = templateInfoList.stream().map(TemplateInfo::getId).collect(Collectors.toList());
            List tenantGroupList = this.templateInfoTenantMapper.selectByTemp(tempIdList);
            tenantGroupMap = tenantGroupList.stream().collect(Collectors.groupingBy(TemplateInfoTenant::getTemplateId));
            List groupIdList = tenantGroupList.stream().filter(x -> Constants.SelectTypeEnum.RELEASE_BY_GROUP.getFlag().equals(x.getSelectType())).map(TemplateInfoTenant::getGroupTenantId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(groupIdList)) {
                List groupList = this.templateTenantGroupMapper.selectByParam(groupIdList);
                groupMap = groupList.stream().collect(Collectors.toMap(TemplateTenantGroup::getId, Function.identity()));
                List groupItemList = this.templateTenantGroupItemMapper.selectByGroup(groupIdList);
                groupItemMap = groupItemList.stream().collect(Collectors.groupingBy(TemplateTenantGroupItem::getGroupId));
            }
        }
        if (CollectionUtils.isNotEmpty(tempSubUserIdList) && CollectionUtils.isNotEmpty((Collection)(userTenantList = this.templateUserTenantMapper.selectByUserId(tempSubUserIdList)))) {
            userTenantMap = userTenantList.stream().collect(Collectors.groupingBy(TemplateUserTenant::getSubUserId));
        }
        for (TemplateInfo templateInfo : templateInfoList) {
            TemplateBench templateBench = new TemplateBench();
            templateBench.setId(templateInfo.getId());
            templateBench.setName(templateInfo.getTemplateName());
            if (templateInfo.getSubType().equals(Constants.SubTypeEnum.ALL_TENANT.getFlag()) && templateInfo.getDefaultFlag().equals(Constants.DEFAULT_CONFIGURED_FLAG_YES)) {
                benchList.add(templateBench);
                continue;
            }
            List tempTenantList = (List)userTenantMap.get(templateInfo.getCreateUserId());
            List<Object> subTenantIdList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)tempTenantList)) {
                subTenantIdList = tempTenantList.stream().map(TemplateUserTenant::getSubTenantId).collect(Collectors.toList());
            }
            if (templateInfo.getSubType().equals(Constants.SubTypeEnum.ALL_TENANT.getFlag()) && subTenantIdList.contains(Utils.getTenantId())) {
                benchList.add(templateBench);
                continue;
            }
            if (!templateInfo.getSubType().equals(Constants.SubTypeEnum.PART_TENANT.getFlag()) || !this.checkTenantAuth(templateInfo.getId(), tenantGroupMap, groupItemMap, groupMap)) continue;
            benchList.add(templateBench);
        }
        return benchList;
    }

    public boolean checkTenantAuth(Long tempId, Map<Long, List<TemplateInfoTenant>> tenantGroupMap, Map<Long, List<TemplateTenantGroupItem>> groupItemMap, Map<Long, TemplateTenantGroup> groupMap) {
        Boolean isAuth = false;
        List<TemplateInfoTenant> templateInfoTenants = tenantGroupMap.get(tempId);
        if (CollectionUtils.isEmpty(templateInfoTenants)) {
            return isAuth;
        }
        for (TemplateInfoTenant templateTenant : templateInfoTenants) {
            List groupTenantIdList;
            List<TemplateTenantGroupItem> groupItemList;
            TemplateTenantGroup group;
            if (templateTenant.getSelectType().equals(Constants.SelectTypeEnum.RELEASE_BY_TENANT.getFlag()) && templateTenant.getGroupTenantId().equals(Utils.getTenantId())) {
                isAuth = true;
                return isAuth;
            }
            if (!templateTenant.getSelectType().equals(Constants.SelectTypeEnum.RELEASE_BY_GROUP.getFlag()) || null == (group = groupMap.get(Long.parseLong(templateTenant.getGroupTenantId()))) || group.getValidStatus().equals(Constants.VALID_STATUS_UNUSABLE) || CollectionUtils.isEmpty(groupItemList = groupItemMap.get(Long.parseLong(templateTenant.getGroupTenantId()))) || !(groupTenantIdList = groupItemList.stream().map(TemplateTenantGroupItem::getSubTenantId).collect(Collectors.toList())).contains(Utils.getTenantId())) continue;
            isAuth = true;
            return isAuth;
        }
        return isAuth;
    }
}

