/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.temp.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.ComponentSourceEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.PortalInfoQueryReq;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.portal.PortalInfoContent;
import com.digiwin.athena.semc.entity.temp.TemplateBench;
import com.digiwin.athena.semc.entity.temp.TemplateInfo;
import com.digiwin.athena.semc.entity.temp.TemplatePortalInfo;
import com.digiwin.athena.semc.entity.temp.TemplatePortalInfoContent;
import com.digiwin.athena.semc.entity.temp.TemplateSystemCustom;
import com.digiwin.athena.semc.entity.temp.TemplateSystemPre;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.portal.PortalInfoContentMapper;
import com.digiwin.athena.semc.mapper.portal.PortalInfoMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateInfoMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateInfoTenantMapper;
import com.digiwin.athena.semc.mapper.temp.TemplatePortalInfoContentMapper;
import com.digiwin.athena.semc.mapper.temp.TemplatePortalInfoMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemCustomMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemPreMapper;
import com.digiwin.athena.semc.service.temp.TemplateInfoService;
import com.digiwin.athena.semc.service.temp.TemplatePortalInfoService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.temp.TemplatePortalVO;
import io.github.linpeilie.Converter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TemplatePortalInfoServiceImpl
extends ServiceImpl<TemplatePortalInfoMapper, TemplatePortalInfo>
implements TemplatePortalInfoService {
    @Resource
    TemplateInfoMapper templateInfoMapper;
    @Resource
    TemplateInfoTenantMapper templateInfoTenantMapper;
    @Resource
    TemplatePortalInfoMapper templatePortalInfoMapper;
    @Resource
    TemplatePortalInfoContentMapper templatePortalInfoContentMapper;
    @Resource
    TemplateInfoService templateInfoService;
    @Resource
    PortalInfoMapper portalInfoMapper;
    @Resource
    PortalInfoContentMapper portalInfoContentMapper;
    @Resource
    private EnvProperties envProperties;
    @Resource
    TemplateSystemCustomMapper templateSystemCustomMapper;
    @Autowired
    TemplateSystemPreMapper templateSystemPreMapper;
    @Resource(name="semcAsyncExecutor")
    private Executor asyncTaskExecutor;
    @Resource
    private Converter converter;

    @Transactional
    public Integer savePortalTemp(TemplatePortalVO req) {
        TemplateInfo templateInfo = this.packageTemplateInfo(req);
        Long tempId = this.templateInfoService.saveTemp(templateInfo);
        if (null != req.getDefaultFlag() && req.getDefaultFlag().equals(Constants.DEFAULT_CONFIGURED_FLAG_YES)) {
            this.editDefPortal(tempId, req);
        } else {
            this.saveTempPortal(tempId, req);
        }
        if (null == req.getSubType() || !req.getSubType().equals(Constants.SubTypeEnum.PART_TENANT.getFlag())) {
            return null;
        }
        ArrayList<Long> templateIdList = new ArrayList<Long>();
        templateIdList.add(tempId);
        this.templateInfoTenantMapper.delByTemp(templateIdList);
        TemplateInfo tenantReq = new TemplateInfo();
        tenantReq.setSubTenantList(req.getSubTenantList());
        tenantReq.setGroupList(req.getGroupList());
        List tenantGroupList = this.templateInfoService.addTempTeanntList(tenantReq, tempId);
        if (CollectionUtils.isNotEmpty((Collection)tenantGroupList)) {
            this.templateInfoTenantMapper.batchInsertTenant(tenantGroupList, Utils.getUserId(), DateUtils.getNowTime((String)""));
        }
        return null;
    }

    public Integer editDefPortal(Long tempId, TemplatePortalVO req) {
        TemplatePortalInfo templatePortalInfo = (TemplatePortalInfo)this.converter.convert((Object)req, TemplatePortalInfo.class);
        templatePortalInfo.setTemplateId(tempId);
        templatePortalInfo.setModifyTime(DateUtils.getNowTime((String)""));
        templatePortalInfo.setTenantId(Utils.getTenantId());
        templatePortalInfo.setModifyUserName(Utils.getUserName());
        this.templatePortalInfoMapper.upPortDefById(templatePortalInfo);
        this.templatePortalInfoContentMapper.delPortalCont(templatePortalInfo.getId());
        if (CollectionUtils.isNotEmpty((Collection)req.getContentList())) {
            this.templatePortalInfoContentMapper.batchInsert(req.getContentList(), templatePortalInfo.getId(), Utils.getTenantId());
        }
        CompletableFuture.supplyAsync(() -> this.upTenantDefPortal(req), this.asyncTaskExecutor);
        return 0;
    }

    public Integer upTenantDefPortal(TemplatePortalVO req) {
        List portalInfoList = this.portalInfoMapper.queryDefPortal("");
        for (PortalInfo portalInfo : portalInfoList) {
            portalInfo.setPortalImgId(req.getPortalImgId());
            portalInfo.setPortalContent(req.getPortalContent());
            portalInfo.setTemplateId(null);
            portalInfo.setModifyTime(DateUtils.getNowTime((String)""));
            portalInfo.setModifyUserName(Utils.getUserName());
            this.portalInfoMapper.upPortDefById(portalInfo);
            this.portalInfoContentMapper.delPortalCont(portalInfo.getId());
            if (!CollectionUtils.isNotEmpty((Collection)req.getContentList())) continue;
            ArrayList<PortalInfoContent> contentList = new ArrayList<PortalInfoContent>();
            for (TemplatePortalInfoContent contetTempList : req.getContentList()) {
                PortalInfoContent content = (PortalInfoContent)this.converter.convert((Object)contetTempList, PortalInfoContent.class);
                contentList.add(content);
            }
            this.portalInfoContentMapper.batchInsert(contentList, portalInfo.getId(), portalInfo.getTenantId());
        }
        return 0;
    }

    public void saveTempPortal(Long tempId, TemplatePortalVO req) {
        TemplatePortalInfo templatePortalInfo = (TemplatePortalInfo)this.converter.convert((Object)req, TemplatePortalInfo.class);
        templatePortalInfo.setTemplateId(tempId);
        templatePortalInfo.setModifyTime(DateUtils.getNowTime((String)""));
        templatePortalInfo.setTenantId(Utils.getTenantId());
        templatePortalInfo.setModifyUserName(Utils.getUserName());
        if (null == req.getStatus()) {
            templatePortalInfo.setStatus(Constants.ReleaseEnum.NO_RELEASE.getVal());
        }
        if (null == req.getId()) {
            templatePortalInfo.setCreateTime(DateUtils.getNowTime((String)""));
            templatePortalInfo.setCreateUserName(Utils.getUserName());
            this.templatePortalInfoMapper.insert((Object)templatePortalInfo);
        } else {
            this.templatePortalInfoMapper.updateById((Object)templatePortalInfo);
        }
        this.templatePortalInfoContentMapper.delPortalCont(templatePortalInfo.getId());
        if (CollectionUtils.isNotEmpty((Collection)req.getContentList())) {
            this.templatePortalInfoContentMapper.batchInsert(req.getContentList(), templatePortalInfo.getId(), Utils.getTenantId());
        }
    }

    public TemplateInfo packageTemplateInfo(TemplatePortalVO req) {
        TemplateInfo templateInfo = new TemplateInfo();
        templateInfo.setId(req.getTemplateId());
        templateInfo.setTemplateName(req.getName());
        templateInfo.setTemplateDesc(req.getPortalDesc());
        templateInfo.setSubType(req.getSubType());
        templateInfo.setTemplateType(Constants.TemplateTypeEnum.CLASSIC_PORTAL.getVal());
        templateInfo.setStatus(req.getStatus());
        return templateInfo;
    }

    public TemplatePortalVO getPortalTemp(TemplatePortalVO req) {
        req.setMenuGeneralFlag(Constants.GENERAL_MENU_FLAG_YES);
        TemplateInfo templateInfo = this.templateInfoMapper.getTemplateById(req.getTemplateId());
        if (null == templateInfo) {
            return req;
        }
        req.setSubType(templateInfo.getSubType());
        TemplatePortalInfo portalInfo = this.templatePortalInfoMapper.getPortalByTemp(req.getTemplateId());
        if (portalInfo == null) {
            return req;
        }
        req = (TemplatePortalVO)this.converter.convert((Object)portalInfo, TemplatePortalVO.class);
        req.setCreateTime(templateInfo.getCreateTime());
        req.setCreateUserId(templateInfo.getCreateUserId());
        req.setCreateUserName(templateInfo.getCreateUserName());
        req.setModifyUserName(templateInfo.getModifyUserName());
        req.setModifyTime(templateInfo.getModifyTime());
        req.setModifyUserId(templateInfo.getModifyUserId());
        req.setMenuGeneralFlag(Constants.GENERAL_MENU_FLAG_YES);
        List contentList = this.templatePortalInfoContentMapper.queryPortalCont(portalInfo.getId(), null);
        Map<Object, Object> preInfoMap = new HashMap();
        List preDataList = contentList.stream().filter(item -> Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal().equals(item.getContentType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(preDataList)) {
            List preIds = preDataList.stream().map(TemplatePortalInfoContent::getContentId).collect(Collectors.toList());
            List preList = this.templateSystemPreMapper.selectBatchIds(preIds);
            preInfoMap = preList.stream().collect(Collectors.toMap(TemplateSystemPre::getId, Function.identity(), (a, b) -> a));
        }
        Map<Object, Object> customInfoMap = new HashMap();
        List customDataList = contentList.stream().filter(item -> Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal().equals(item.getContentType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(customDataList)) {
            List customIds = customDataList.stream().map(TemplatePortalInfoContent::getContentId).collect(Collectors.toList());
            List customList = this.templateSystemCustomMapper.selectBatchIds((Collection)customIds);
            customInfoMap = customList.stream().collect(Collectors.toMap(TemplateSystemCustom::getId, Function.identity(), (a, b) -> a));
        }
        for (TemplatePortalInfoContent content : contentList) {
            TemplateSystemCustom systemCustom;
            if (ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode().equals(content.getContentType())) {
                TemplateSystemPre labelSystemPre = (TemplateSystemPre)preInfoMap.get(content.getContentId());
                content.setDataType(labelSystemPre == null ? null : labelSystemPre.getDataType());
                content.setContentId(labelSystemPre == null ? content.getContentId() : labelSystemPre.getId());
            }
            if (!ComponentSourceEnum.LABEL_SYSTEM_CUSTOM.getCode().equals(content.getContentType()) || (systemCustom = (TemplateSystemCustom)customInfoMap.get(content.getContentId())) == null) continue;
            content.setContentName(StringUtils.isEmpty((CharSequence)content.getContentName()) ? systemCustom.getNameZh() : content.getContentName());
            content.setClassicsIcon(systemCustom.getClassicsIcon());
        }
        req.setContentList(contentList);
        if (null == templateInfo.getSubType() || !templateInfo.getSubType().equals(Constants.SubTypeEnum.PART_TENANT.getFlag())) {
            return req;
        }
        TemplateInfo templateGroup = this.templateInfoService.getTempGroupVO(templateInfo.getId());
        req.setSubTenantList(templateGroup.getSubTenantList());
        req.setGroupList(templateGroup.getGroupList());
        return req;
    }

    public ResultPageBean pageQueryTemp(PortalInfoQueryReq req) {
        List portalTempList = this.templateInfoService.queryVisibleTempList(Constants.TemplateTypeEnum.CLASSIC_PORTAL.getVal());
        List portalInfoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)portalTempList)) {
            List tempIdList = portalTempList.stream().map(TemplateBench::getId).collect(Collectors.toList());
            portalInfoList = this.templatePortalInfoMapper.selectByISV(req, tempIdList);
        }
        for (TemplatePortalInfo portalInfo : portalInfoList) {
            if (!StringUtils.isNotEmpty((CharSequence)portalInfo.getPortalImgId())) continue;
            String portalImgUrl = this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + portalInfo.getPortalImgId();
            portalInfo.setPortalImgUrl(portalImgUrl);
        }
        ResultPageBean resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance(portalInfoList.stream().skip((long)(req.getPageNum() - 1) * req.getPageSize().longValue()).limit(req.getPageSize().intValue()).collect(Collectors.toList()), (PageInfo)PageInfo.getPageInfo((Integer)req.getPageNum(), (Integer)req.getPageSize(), (Integer)portalInfoList.size())));
        return resultPageBean;
    }
}

