/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.temp.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.event.SyncReadListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemCustomQueryReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemCustomSaveReq;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.entity.temp.TemplateSystemCustom;
import com.digiwin.athena.semc.entity.temp.TemplateSystemCustomImport;
import com.digiwin.athena.semc.entity.temp.TemplateSystemData;
import com.digiwin.athena.semc.entity.temp.TemplateSystemSource;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.temp.TemplateBenchCustomMapper;
import com.digiwin.athena.semc.mapper.temp.TemplatePortalInfoContentMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemCustomImportMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemCustomMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemDataMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemSourceMapper;
import com.digiwin.athena.semc.proxy.mdc.MdcService;
import com.digiwin.athena.semc.service.portal.IImportRecordService;
import com.digiwin.athena.semc.service.portal.impl.SystemCustomWriteHandler;
import com.digiwin.athena.semc.service.temp.TemplateSystemCustomService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import com.digiwin.athena.semc.vo.portal.LabelSystemCustomQueryVO;
import com.digiwin.athena.semc.vo.portal.SystemCustomExportVo;
import com.digiwin.athena.semc.vo.portal.SystemCustomImportVo;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import io.github.linpeilie.Converter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class TemplateSystemCustomServiceImpl
extends ServiceImpl<TemplateSystemCustomMapper, TemplateSystemCustom>
implements TemplateSystemCustomService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateSystemCustomServiceImpl.class);
    @Resource
    MessageUtils messageUtils;
    @Resource
    TemplateSystemCustomMapper templateSystemCustomMapper;
    @Resource
    TemplateSystemSourceMapper templateSystemSourceMapper;
    @Autowired
    TemplateSystemDataMapper templateStystemDataMapper;
    @Autowired
    TemplatePortalInfoContentMapper templatePortalInfoContentMapper;
    @Autowired
    MdcService mdcService;
    @Resource
    private IImportRecordService importRecordService;
    @Resource
    private EnvProperties envProperties;
    @Resource
    private TemplateSystemCustomImportMapper templateSystemCustomImportMapper;
    @Resource
    TemplateBenchCustomMapper templateBenchCustomMapper;
    @Resource
    private Converter converter;
    public static final int CLASSIC_ICON_COUNT = 20;

    public ResultPageBean pageQuery(LabelSystemCustomQueryReq labelSystemCustomQueryReq) {
        ResultPageBean resultPageBean;
        LambdaQueryWrapper queryPreWrapper = new LambdaQueryWrapper();
        queryPreWrapper.eq(TemplateSystemCustom::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        queryPreWrapper.like(!StringUtils.isEmpty((CharSequence)labelSystemCustomQueryReq.getQueryCondition().getNameZh()), TemplateSystemCustom::getNameZh, (Object)labelSystemCustomQueryReq.getQueryCondition().getNameZh());
        queryPreWrapper.eq(!Objects.isNull(labelSystemCustomQueryReq.getQueryCondition().getValidStatus()), TemplateSystemCustom::getValidStatus, (Object)labelSystemCustomQueryReq.getQueryCondition().getValidStatus());
        queryPreWrapper.in(!CollectionUtils.isEmpty((Collection)labelSystemCustomQueryReq.getQueryCondition().getDataCategory()), TemplateSystemCustom::getDataCategory, (Collection)labelSystemCustomQueryReq.getQueryCondition().getDataCategory());
        List labelSystemCustomList = this.templateSystemCustomMapper.selectList((Wrapper)queryPreWrapper);
        if (!CollectionUtils.isEmpty((Collection)labelSystemCustomList)) {
            Gson gson = new Gson();
            List labelSystemSourceList = this.templateSystemSourceMapper.listByCondition(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId(), Integer.valueOf(0), labelSystemCustomList.stream().map(TemplateSystemCustom::getId).collect(Collectors.toList()));
            LinkedList dataSourceInfoList = new LinkedList();
            labelSystemSourceList.forEach(item -> {
                LabelSystemCustomQueryVO.DataSourceInfo dataSourceInfo = (LabelSystemCustomQueryVO.DataSourceInfo)gson.fromJson(JSON.toJSONString((Object)item), LabelSystemCustomQueryVO.DataSourceInfo.class);
                dataSourceInfoList.add(dataSourceInfo);
            });
            Map<Long, List<LabelSystemCustomQueryVO.DataSourceInfo>> map = dataSourceInfoList.stream().collect(Collectors.groupingBy(LabelSystemCustomQueryVO.DataSourceInfo::getSystemId));
            List labelSystemCustomQueryVOList = labelSystemCustomList.stream().map(item -> {
                LabelSystemCustomQueryVO labelSystemCustomQueryVO = (LabelSystemCustomQueryVO)this.converter.convert(item, LabelSystemCustomQueryVO.class);
                List dataList = (List)map.get(item.getId());
                labelSystemCustomQueryVO.setComponentSource(Integer.valueOf(0));
                labelSystemCustomQueryVO.setDataSourceInfo(dataList);
                return labelSystemCustomQueryVO;
            }).collect(Collectors.toList());
            List LabelSystemCustomQuerySortVO = labelSystemCustomQueryVOList.stream().sorted(Comparator.comparing(LabelSystemCustomQueryVO::getModifyTime).reversed()).collect(Collectors.toList());
            resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance(LabelSystemCustomQuerySortVO.stream().skip((long)(labelSystemCustomQueryReq.getPageNum() - 1) * labelSystemCustomQueryReq.getPageSize().longValue()).limit(labelSystemCustomQueryReq.getPageSize().intValue()).collect(Collectors.toList()), (PageInfo)PageInfo.getPageInfo((Integer)labelSystemCustomQueryReq.getPageNum(), (Integer)labelSystemCustomQueryReq.getPageSize(), (Integer)LabelSystemCustomQuerySortVO.size())));
        } else {
            resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance((Object)labelSystemCustomList, (PageInfo)PageInfo.getPageInfo((Integer)labelSystemCustomQueryReq.getPageNum(), (Integer)labelSystemCustomQueryReq.getPageSize(), (Integer)labelSystemCustomList.size())));
        }
        return resultPageBean;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> save(LabelSystemCustomSaveReq labelSystemCustomSaveReq) {
        ResponseEntity responseEntity = this.validData(labelSystemCustomSaveReq);
        if (null != responseEntity) {
            return responseEntity;
        }
        if (Objects.isNull(labelSystemCustomSaveReq.getId())) {
            TemplateSystemCustom labelSystemCustom = (TemplateSystemCustom)this.converter.convert((Object)labelSystemCustomSaveReq, TemplateSystemCustom.class);
            labelSystemCustom.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            labelSystemCustom.setValidStatus(Integer.valueOf(0));
            labelSystemCustom.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
            labelSystemCustom.setCreateUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
            if (Constants.COUNT_COMPOENT_TYPE.equals(labelSystemCustom.getDataCategory())) {
                labelSystemCustom.setClassicsIcon(labelSystemCustomSaveReq.getClassicsIcon());
            }
            this.templateSystemCustomMapper.insert((Object)labelSystemCustom);
            if (!CollectionUtils.isEmpty((Collection)labelSystemCustomSaveReq.getDataSourceInfo())) {
                List labelSystemSourceList = labelSystemCustomSaveReq.getDataSourceInfo().stream().map(item -> {
                    TemplateSystemSource labelSystemSource = (TemplateSystemSource)this.converter.convert(item, TemplateSystemSource.class);
                    labelSystemSource.setSystemId(labelSystemCustom.getId());
                    labelSystemSource.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                    return labelSystemSource;
                }).collect(Collectors.toList());
                this.templateSystemSourceMapper.insertBatch(labelSystemSourceList);
            }
            return ResponseEntityWrapper.wrapperOk((Object)labelSystemCustom.getId());
        }
        TemplateSystemCustom labelSystemCustom = (TemplateSystemCustom)this.converter.convert((Object)labelSystemCustomSaveReq, TemplateSystemCustom.class);
        labelSystemCustom.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
        this.templateSystemCustomMapper.updateById((Object)labelSystemCustom);
        if (!CollectionUtils.isEmpty((Collection)labelSystemCustomSaveReq.getDataSourceInfo())) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(TemplateSystemSource::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            updateWrapper.in(TemplateSystemSource::getSystemId, (Collection)labelSystemCustomSaveReq.getDataSourceInfo().stream().map(LabelSystemCustomSaveReq.DataSourceInfo::getSystemId).collect(Collectors.toList()));
            this.templateSystemSourceMapper.delete((Wrapper)updateWrapper);
            List labelSystemSourceList = labelSystemCustomSaveReq.getDataSourceInfo().stream().map(item -> {
                TemplateSystemSource labelSystemSource = (TemplateSystemSource)this.converter.convert(item, TemplateSystemSource.class);
                labelSystemSource.setSystemId(labelSystemCustomSaveReq.getId());
                labelSystemSource.setComponentSource(Integer.valueOf(0));
                labelSystemSource.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                return labelSystemSource;
            }).collect(Collectors.toList());
            this.templateSystemSourceMapper.insertItemBatch(labelSystemSourceList);
        }
        return ResponseEntityWrapper.wrapperOk((Object)labelSystemCustomSaveReq.getId());
    }

    private ResponseEntity<?> validData(LabelSystemCustomSaveReq labelSystemCustomSaveReq) {
        if (Objects.nonNull(labelSystemCustomSaveReq.getId())) {
            LambdaQueryWrapper queryWrapperById = new LambdaQueryWrapper();
            queryWrapperById.eq(TemplateSystemCustom::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            queryWrapperById.eq(TemplateSystemCustom::getId, (Object)labelSystemCustomSaveReq.getId());
            TemplateSystemCustom labelSystemCustom = (TemplateSystemCustom)this.templateSystemCustomMapper.selectOne((Wrapper)queryWrapperById);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(TemplateSystemCustom::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            List labelSystemCustomList = this.templateSystemCustomMapper.selectList((Wrapper)queryWrapper);
            if (!labelSystemCustomSaveReq.getNameZh().trim().equals(labelSystemCustom.getNameZh())) {
                for (TemplateSystemCustom data : labelSystemCustomList) {
                    if (!labelSystemCustomSaveReq.getNameZh().trim().equals(data.getNameZh())) continue;
                    String error = String.format(this.messageUtils.getMessage("error.message.system.custom.name.zh.exist"), labelSystemCustomSaveReq.getNameZh());
                    return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)error);
                }
            }
        } else {
            LambdaQueryWrapper queryZhWrapper = new LambdaQueryWrapper();
            queryZhWrapper.eq(TemplateSystemCustom::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            queryZhWrapper.eq(TemplateSystemCustom::getNameZh, (Object)labelSystemCustomSaveReq.getNameZh());
            List labelSystemCustomZh = this.templateSystemCustomMapper.selectList((Wrapper)queryZhWrapper);
            LambdaQueryWrapper queryUsWrapper = new LambdaQueryWrapper();
            queryUsWrapper.eq(TemplateSystemCustom::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            queryUsWrapper.eq(TemplateSystemCustom::getNameUs, (Object)labelSystemCustomSaveReq.getNameUs());
            List labelSystemCustomUs = this.templateSystemCustomMapper.selectList((Wrapper)queryUsWrapper);
            if (labelSystemCustomZh.size() >= 1) {
                String error = String.format(this.messageUtils.getMessage("error.message.system.custom.name.zh.exist"), labelSystemCustomSaveReq.getNameZh());
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)error);
            }
            if (labelSystemCustomUs.size() >= 1) {
                String error = String.format(this.messageUtils.getMessage("error.message.system.custom.name.us.exist"), labelSystemCustomSaveReq.getNameUs());
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)error);
            }
        }
        for (LabelSystemCustomSaveReq.DataSourceInfo item : labelSystemCustomSaveReq.getDataSourceInfo()) {
            LambdaQueryWrapper queryWrapperData = new LambdaQueryWrapper();
            queryWrapperData.eq(TemplateSystemData::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            queryWrapperData.eq(TemplateSystemData::getId, (Object)item.getDataId());
            TemplateSystemData labelSystemData = (TemplateSystemData)this.templateStystemDataMapper.selectOne((Wrapper)queryWrapperData);
            if (labelSystemData.getDataCategory().equals(labelSystemCustomSaveReq.getDataCategory())) continue;
            String error = this.messageUtils.getMessage("error.message.system.pre.dara.fail");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_DATA_SOURCE, (String)error);
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> delete(List<Long> idList) {
        String tenantId;
        List contentList;
        List labelSystemCustom;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TemplateSystemCustom::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        if (idList.size() == 1) {
            queryWrapper.eq(TemplateSystemCustom::getId, (Object)idList.get(0));
            queryWrapper.eq(TemplateSystemCustom::getValidStatus, (Object)0);
            labelSystemCustom = (TemplateSystemCustom)this.templateSystemCustomMapper.selectOne((Wrapper)queryWrapper);
            if (ObjectUtils.isEmpty((Object)labelSystemCustom)) {
                String error = this.messageUtils.getMessage("error.message.system.custom.del.fail");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)error);
            }
        } else {
            queryWrapper.in(TemplateSystemCustom::getId, idList);
            labelSystemCustom = this.templateSystemCustomMapper.selectList((Wrapper)queryWrapper);
            boolean flag = labelSystemCustom.stream().anyMatch(item -> Constants.LABEL_SYSTEM_PRE_VALID_STATUS.equals(item.getValidStatus()));
            if (flag) {
                String error = this.messageUtils.getMessage("error.message.system.custom.batdel.fail");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)error);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(contentList = this.templatePortalInfoContentMapper.selPortalConent(tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId(), idList, Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal())))) {
            String error = this.messageUtils.getMessage("error.message.jd.portal.layout.del.error");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, (String)error);
        }
        List jobBenchCustomList = this.templateBenchCustomMapper.selectBenchBy(null, idList);
        if (CollectionUtils.isNotEmpty((Collection)jobBenchCustomList)) {
            String error = this.messageUtils.getMessage("error.message.job.system.data.del.error");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
        this.templateSystemCustomMapper.deleteBatchIds(idList);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(TemplateSystemSource::getSystemId, idList);
        updateWrapper.eq(TemplateSystemSource::getComponentSource, (Object)Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
        this.templateSystemSourceMapper.delete((Wrapper)updateWrapper);
        return ResponseEntityWrapper.wrapperOk();
    }

    public List<TemplateSystemCustom> queryCustomSystem(LabelSystemAllVo req) {
        QueryWrapper condition = new QueryWrapper();
        if (CollectionUtils.isNotEmpty((Collection)req.getDataCategoryList())) {
            condition.in((Object)"data_category", (Collection)req.getDataCategoryList());
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getName())) {
            condition.like((Object)"name_zh", (Object)req.getName());
        }
        condition.eq((Object)"valid_status", (Object)1);
        condition.orderByDesc((Object)"modify_time");
        return this.templateSystemCustomMapper.selectList((Wrapper)condition);
    }

    public List<SystemCustomImportVo> readExcel(String fileId) {
        List excelVoList;
        DMC dmcInstance = this.mdcService.buildDmc();
        try {
            byte[] byteArray = dmcInstance.download(fileId);
            ByteArrayInputStream input = new ByteArrayInputStream(byteArray);
            SyncReadListener excelListener = new SyncReadListener();
            ExcelReader excelReader = EasyExcelFactory.read((InputStream)input).build();
            excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)0).head(SystemCustomImportVo.class)).headRowNumber(Integer.valueOf(2))).registerReadListener((ReadListener)excelListener)).build()});
            excelReader.finish();
            excelVoList = this.mdcService.doReadSync(excelListener);
        }
        catch (Exception e) {
            log.error("SystemDataImport read excel occur error", (Throwable)e);
            throw new RuntimeException(e);
        }
        return excelVoList;
    }

    @Transactional
    public ImportExcelResp importReport(List<SystemCustomImportVo> customImportVoList) {
        List systemCustomList;
        ImportExcelResp excelResp = new ImportExcelResp();
        List<Object> customNameList = new ArrayList();
        Map<Object, Object> systemDataMap = new HashMap();
        List systemDataList = this.templateStystemDataMapper.selectList((Wrapper)new QueryWrapper());
        if (CollectionUtils.isNotEmpty((Collection)systemDataList)) {
            systemDataMap = systemDataList.stream().collect(Collectors.toMap(TemplateSystemData::getName, Function.identity(), (a, b) -> a));
        }
        if (CollectionUtils.isNotEmpty((Collection)(systemCustomList = this.templateSystemCustomMapper.selectList((Wrapper)new QueryWrapper())))) {
            customNameList = systemCustomList.stream().map(TemplateSystemCustom::getNameZh).collect(Collectors.toList());
        }
        Map categoryMap = this.initCategoryMap();
        Map statusMap = this.initStatusMap();
        int successNum = 0;
        int failNum = 0;
        int iconIndex = 0;
        int classIconAppIndex = 1;
        int classIconJobIndex = 1;
        for (SystemCustomImportVo customImportVo : customImportVoList) {
            StringBuilder errorSb = this.validateData(customImportVo, customNameList, systemDataMap, categoryMap);
            if (StringUtils.isNotBlank((CharSequence)errorSb.toString())) {
                ++failNum;
                customImportVo.setFailDesc(errorSb.substring(0, errorSb.length() - 1));
                continue;
            }
            customImportVo.setFailDesc(errorSb.toString());
            TemplateSystemCustom systemCustom = this.initLabelCustom(customImportVo, systemDataMap, categoryMap, statusMap, iconIndex, classIconAppIndex, classIconJobIndex);
            ++successNum;
            ++iconIndex;
            if (systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_WORK.getVal())) {
                ++classIconJobIndex;
            }
            if (systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_APP.getVal())) {
                ++classIconAppIndex;
            }
            if (iconIndex >= 7) {
                iconIndex = 0;
            }
            if (classIconAppIndex > 20) {
                classIconAppIndex = 1;
            }
            if (classIconJobIndex <= 20) continue;
            classIconJobIndex = 1;
        }
        String nowTime = DateUtils.getNowTime((String)"yyyyMMddHHmmss");
        ShareInfo shareInfo = this.importRecordService.uploadExcel(this.write(customImportVoList, nowTime));
        this.initDataImport(shareInfo.getFileId(), Integer.valueOf(successNum), Integer.valueOf(failNum), nowTime);
        excelResp.setFailFileId(shareInfo.getFileId());
        excelResp.setFailFileName(shareInfo.getFileName());
        excelResp.setFailFileUrl(shareInfo.getUrl());
        String resultCode = successNum > 0 && failNum == 0 ? "2001" : (successNum > 0 && failNum > 0 ? "2002" : (successNum == 0 && failNum > 0 ? "2003" : "2003"));
        excelResp.setResultCode(resultCode);
        excelResp.setFailCount(Integer.valueOf(failNum));
        excelResp.setSuccessCount(Integer.valueOf(successNum));
        return excelResp;
    }

    public TemplateSystemCustomImport initDataImport(String fileId, Integer successCount, Integer failCount, String nowTime) {
        TemplateSystemCustomImport importRecord = new TemplateSystemCustomImport();
        importRecord.setFileId(fileId);
        importRecord.setSuccessCount(successCount);
        importRecord.setFailCount(failCount);
        importRecord.setCreateUserName(Utils.getUserName());
        importRecord.setCreateUserId(Utils.getUserId());
        importRecord.setCreateTime(DateUtils.getDateFormat((String)nowTime, (String)"yyyyMMddHHmmss", (String)"yyyy-MM-dd HH:mm:ss"));
        importRecord.setModifyTime(DateUtils.getDateFormat((String)nowTime, (String)"yyyyMMddHHmmss", (String)"yyyy-MM-dd HH:mm:ss"));
        importRecord.setModifyUserId(Utils.getUserId());
        importRecord.setTenantId(Utils.getTenantId());
        this.templateSystemCustomImportMapper.insert((Object)importRecord);
        return importRecord;
    }

    public File write(List<SystemCustomImportVo> list, String nowTime) {
        File file = new File("\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u5bfc\u5165\u8bb0\u5f55_" + nowTime + ".xlsx");
        ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((File)file, SystemCustomImportVo.class).relativeHeadRowIndex(Integer.valueOf(1))).registerWriteHandler((WriteHandler)new SystemCustomWriteHandler())).registerWriteHandler((WriteHandler)Utils.initHorizontalCell())).sheet("\u81ea\u5b9a\u4e49\u7ec4\u4ef6").doWrite(list);
        return file;
    }

    public TemplateSystemCustom initLabelCustom(SystemCustomImportVo customImportVo, Map<String, TemplateSystemData> systemDataMap, Map<String, Integer> categoryMap, Map<String, Integer> statusMap, int iconIndex, int classIconAppIndex, int classIconJobIndex) {
        TemplateSystemCustom systemCustom = new TemplateSystemCustom();
        systemCustom.setNameZh(customImportVo.getNameZh());
        systemCustom.setRemark(customImportVo.getRemark());
        systemCustom.setDataCategory(categoryMap.get(customImportVo.getDataCategory()));
        systemCustom.setValidStatus(statusMap.get(customImportVo.getValidStatus()));
        systemCustom.setCreateUserName(Utils.getUserName());
        systemCustom.setModifyUserName(Utils.getUserName());
        systemCustom.setCreateUserId(Utils.getUserId());
        systemCustom.setCreateTime(DateUtils.getNowTime((String)""));
        systemCustom.setModifyTime(DateUtils.getNowTime((String)""));
        systemCustom.setModifyUserId(Utils.getUserId());
        systemCustom.setTenantId(Utils.getTenantId());
        systemCustom.setIcon(Utils.getPortCard((int)iconIndex));
        if (systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_WORK.getVal())) {
            systemCustom.setClassicsIcon("icon_tzzy_" + classIconJobIndex);
        }
        if (systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_APP.getVal())) {
            systemCustom.setClassicsIcon("icon_tzyy_" + classIconAppIndex);
        }
        this.templateSystemCustomMapper.insert((Object)systemCustom);
        TemplateSystemData systemData = systemDataMap.get(customImportVo.getDataName());
        if (null != systemData) {
            TemplateSystemSource systemSource = new TemplateSystemSource();
            systemSource.setSystemId(systemCustom.getId());
            systemSource.setDataId(systemData.getId());
            systemSource.setComponentSource(Integer.valueOf(0));
            systemSource.setCreateTime(DateUtils.getNowTime((String)""));
            systemSource.setTenantId(Utils.getTenantId());
            this.templateSystemSourceMapper.insert((Object)systemSource);
        }
        return systemCustom;
    }

    private StringBuilder validateData(SystemCustomImportVo customImportVo, List<String> customNameList, Map<String, TemplateSystemData> systemDataMap, Map<String, Integer> categoryMap) {
        TemplateSystemData systemData;
        StringBuilder errorSb = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)customImportVo.getNameZh())) {
            errorSb.append("\u201c\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u540d\u79f0\u201d\u672a\u586b\u5199").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)customImportVo.getNameZh()) && customImportVo.getNameZh().length() > 40) {
            errorSb.append("\u201c\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u540d\u79f0\u201d\u5185\u5bb9\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236").append(",");
        }
        if (customNameList.contains(customImportVo.getNameZh())) {
            errorSb.append("\u201c\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u540d\u79f0\u201d\u91cd\u590d").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)customImportVo.getNameZh())) {
            customNameList.add(customImportVo.getNameZh());
        }
        if (StringUtils.isEmpty((CharSequence)customImportVo.getDataCategory())) {
            errorSb.append("\u201c\u7ec4\u4ef6\u5206\u7c7b\u201d\u672a\u586b\u5199").append(",");
        }
        List categoryNameList = this.initCategoryNameList();
        if (StringUtils.isNotEmpty((CharSequence)customImportVo.getDataCategory()) && !categoryNameList.contains(customImportVo.getDataCategory())) {
            errorSb.append("\u201c\u7ec4\u4ef6\u5206\u7c7b\u201d\u503c\u9519\u8bef").append(",");
        }
        if (StringUtils.isEmpty((CharSequence)customImportVo.getValidStatus())) {
            errorSb.append("\u201c\u72b6\u6001\u201d\u672a\u586b\u5199").append(",");
        }
        List validStatusList = this.initValidStatusList();
        if (StringUtils.isNotEmpty((CharSequence)customImportVo.getValidStatus()) && !validStatusList.contains(customImportVo.getValidStatus())) {
            errorSb.append("\u201c\u72b6\u6001\u201d\u503c\u9519\u8bef").append(",");
        }
        if (StringUtils.isNotBlank((CharSequence)customImportVo.getRemark()) && customImportVo.getRemark().length() > 100) {
            errorSb.append("\u201c\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u5907\u6ce8\u201d\u5185\u5bb9\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236").append(",");
        }
        if (StringUtils.isEmpty((CharSequence)customImportVo.getDataName())) {
            errorSb.append("\u201c\u6570\u636e\u6e90\u540d\u79f0\u201d\u672a\u586b\u5199").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)customImportVo.getDataName()) && null == systemDataMap.get(customImportVo.getDataName())) {
            errorSb.append("\u201c\u6570\u636e\u6e90\u540d\u79f0\u201d\u503c\u9519\u8bef").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)customImportVo.getDataName()) && StringUtils.isNotEmpty((CharSequence)customImportVo.getDataCategory()) && null != systemDataMap.get(customImportVo.getDataName()) && !(systemData = systemDataMap.get(customImportVo.getDataName())).getDataCategory().equals(categoryMap.get(customImportVo.getDataCategory()))) {
            errorSb.append("\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u7c7b\u578b\u4e0e\u5173\u8054\u6570\u636e\u6e90\u7c7b\u578b\u4e0d\u4e00\u81f4").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)customImportVo.getDataName()) && null != systemDataMap.get(customImportVo.getDataName()) && (systemData = systemDataMap.get(customImportVo.getDataName())).getValidStatus().equals(Constants.VALID_STATUS_UNUSABLE)) {
            errorSb.append("\u5173\u8054\u6570\u636e\u6e90\u672a\u542f\u7528").append(",");
        }
        return errorSb;
    }

    public Map<String, Integer> initCategoryMap() {
        HashMap<String, Integer> categoryMap = new HashMap<String, Integer>();
        categoryMap.put(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal(), Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        categoryMap.put(Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal(), Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        return categoryMap;
    }

    public Map<String, Integer> initStatusMap() {
        HashMap<String, Integer> statusMap = new HashMap<String, Integer>();
        statusMap.put(Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal(), Constants.VALID_STATUS_ENABLE);
        statusMap.put(Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal(), Constants.VALID_STATUS_UNUSABLE);
        return statusMap;
    }

    public Map<Integer, String> initCategoryValMap() {
        HashMap<Integer, String> categoryMap = new HashMap<Integer, String>();
        categoryMap.put(Constants.DataCategoryEnum.CATEGORY_WORK.getVal(), Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal());
        categoryMap.put(Constants.DataCategoryEnum.CATEGORY_APP.getVal(), Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal());
        return categoryMap;
    }

    public Map<Integer, String> initStatusValMap() {
        HashMap<Integer, String> statusMap = new HashMap<Integer, String>();
        statusMap.put(Constants.DataCategoryEnum.CATEGORY_TODO.getVal(), Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal());
        statusMap.put(Constants.DataCategoryEnum.CATEGORY_REPORT.getVal(), Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal());
        return statusMap;
    }

    public List<String> initCategoryNameList() {
        ArrayList<String> categoryNameList = new ArrayList<String>();
        categoryNameList.add(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal());
        categoryNameList.add(Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal());
        return categoryNameList;
    }

    public List<String> initValidStatusList() {
        ArrayList<String> validStatusList = new ArrayList<String>();
        validStatusList.add(Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal());
        validStatusList.add(Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal());
        return validStatusList;
    }

    public PageInfoResp<TemplateSystemCustomImport> queryImportRecord(QueryImportRecordReq queryImportRecordReq) {
        QueryWrapper condition = new QueryWrapper();
        if (StringUtils.isBlank((CharSequence)queryImportRecordReq.getStartTime()) || StringUtils.isBlank((CharSequence)queryImportRecordReq.getEndTime())) {
            String currentDate = DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss");
            condition.ge((Object)"create_time", (Object)DateUtils.addDate((String)currentDate, (String)"yyyy-MM-dd HH:mm:ss", (int)-1, (String)"year"));
            condition.le((Object)"create_time", (Object)currentDate);
        } else {
            condition.ge((Object)"create_time", (Object)queryImportRecordReq.getStartTime());
            condition.le((Object)"create_time", (Object)queryImportRecordReq.getEndTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryImportRecordReq.getUserIdName())) {
            condition.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.like((Object)"create_user_name", (Object)queryImportRecordReq.getUserIdName())).or()).like((Object)"create_user_id", (Object)queryImportRecordReq.getUserIdName());
            });
        }
        condition.orderByDesc((Object)"create_time");
        PageInfoResp pageInfoResp = new PageInfoResp();
        pageInfoResp.setPageNo(queryImportRecordReq.getPageNum().intValue());
        pageInfoResp.setPageSize(queryImportRecordReq.getPageSize().intValue());
        pageInfoResp.setTotalPages(0);
        pageInfoResp.setTotalRecords(0);
        Page pageResult = (Page)this.templateSystemCustomImportMapper.selectPage((IPage)new Page((long)queryImportRecordReq.getPageNum().intValue(), (long)queryImportRecordReq.getPageSize().intValue()), (Wrapper)condition);
        if (pageResult != null && CollectionUtils.isNotEmpty((Collection)pageResult.getRecords())) {
            pageResult.getRecords().forEach(m -> m.setFileUrl(this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + m.getFileId().trim()));
            pageInfoResp.setList(pageResult.getRecords());
            pageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(pageResult.getPages())));
            pageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(pageResult.getTotal())));
        } else {
            pageInfoResp.setList((List)Lists.newArrayList());
        }
        return pageInfoResp;
    }

    public List<SystemCustomExportVo> exportReport() {
        ArrayList<SystemCustomExportVo> customExportVoList = new ArrayList<SystemCustomExportVo>();
        LabelSystemAllVo req = new LabelSystemAllVo();
        ArrayList<Integer> dataCategoryList = new ArrayList<Integer>();
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        req.setDataCategoryList(dataCategoryList);
        List systemCustomList = this.queryCustomList(req);
        if (CollectionUtils.isEmpty((Collection)systemCustomList)) {
            return customExportVoList;
        }
        List customIdList = systemCustomList.stream().map(TemplateSystemCustom::getId).collect(Collectors.toList());
        List systemSourcCusList = this.templateSystemSourceMapper.selBySystemIds(customIdList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        if (CollectionUtils.isEmpty((Collection)systemSourcCusList)) {
            return customExportVoList;
        }
        Map<Long, Long> systemSourcMap = systemSourcCusList.stream().collect(Collectors.toMap(TemplateSystemSource::getSystemId, TemplateSystemSource::getDataId, (a, b) -> a));
        List dataIdList = systemSourcCusList.stream().map(TemplateSystemSource::getDataId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dataIdList)) {
            return customExportVoList;
        }
        List systemDataList = this.templateStystemDataMapper.selByIds(dataIdList);
        Map systemDataMap = systemDataList.stream().collect(Collectors.toMap(TemplateSystemData::getId, Function.identity()));
        Map categoryMap = this.initCategoryValMap();
        Map statusMap = this.initStatusValMap();
        for (TemplateSystemCustom systemCustom : systemCustomList) {
            TemplateSystemData systemData;
            SystemCustomExportVo customExport = new SystemCustomExportVo();
            customExport.setNameZh(systemCustom.getNameZh());
            customExport.setDataCategory((String)categoryMap.get(systemCustom.getDataCategory()));
            customExport.setValidStatus((String)statusMap.get(systemCustom.getValidStatus()));
            customExport.setRemark(systemCustom.getRemark());
            Long dataId = systemSourcMap.get(systemCustom.getId());
            if (null != dataId && null != (systemData = (TemplateSystemData)systemDataMap.get(dataId))) {
                customExport.setDataName(systemData.getName());
            }
            customExportVoList.add(customExport);
        }
        return customExportVoList;
    }

    public List<TemplateSystemCustom> queryCustomList(LabelSystemAllVo req) {
        QueryWrapper condition = new QueryWrapper();
        if (CollectionUtils.isNotEmpty((Collection)req.getDataCategoryList())) {
            condition.in((Object)"data_category", (Collection)req.getDataCategoryList());
        }
        condition.orderByDesc((Object)"modify_time");
        return this.templateSystemCustomMapper.selectList((Wrapper)condition);
    }
}

