/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.temp.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.event.SyncReadListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.MaycurCodeEnum;
import com.digiwin.athena.semc.common.enums.PreinstalledApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.VirtualApplicationEnum;
import com.digiwin.athena.semc.dto.erpsso.ErpSsoSpecialDTO;
import com.digiwin.athena.semc.dto.erpsso.QuerySsoListReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataDto;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.dto.portal.QueryLabelSystemReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.applink.TenantAppDTO;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplicationInstance;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.entity.temp.TemplateSystemData;
import com.digiwin.athena.semc.entity.temp.TemplateSystemDataImport;
import com.digiwin.athena.semc.entity.temp.TemplateSystemSource;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.bench.SyncJobInfoMapper;
import com.digiwin.athena.semc.mapper.portal.PreinstalledApplicationInstanceMapper;
import com.digiwin.athena.semc.mapper.portal.PreinstalledApplicationMapper;
import com.digiwin.athena.semc.mapper.sso.ErpSsoInfoMapper;
import com.digiwin.athena.semc.mapper.sso.ThirdSsoInfoMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemDataImportMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemDataMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemSourceMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.proxy.km.service.model.AppJobDTO;
import com.digiwin.athena.semc.proxy.mdc.MdcService;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.portal.IImportRecordService;
import com.digiwin.athena.semc.service.portal.IPreinstalledApplicationService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.portal.impl.SystemDataWriteHandler;
import com.digiwin.athena.semc.service.temp.TemplateSystemDataService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.digiwin.athena.semc.vo.portal.LabelSystemDataAppVo;
import com.digiwin.athena.semc.vo.portal.SystemDataExportVo;
import com.digiwin.athena.semc.vo.portal.SystemDataImportVo;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.google.common.collect.Lists;
import io.github.linpeilie.Converter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TemplateSystemDataServiceImpl
extends ServiceImpl<TemplateSystemDataMapper, TemplateSystemData>
implements TemplateSystemDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateSystemDataServiceImpl.class);
    @Autowired
    TemplateSystemDataMapper templateStystemDataMapper;
    @Autowired
    TemplateSystemSourceMapper templateSystemSourceMapper;
    @Autowired
    ThirdSsoInfoMapper thirdSsoInfoMapper;
    @Autowired
    ErpSsoInfoMapper erpSsoInfoMapper;
    @Autowired
    PreinstalledApplicationMapper preinstalledApplicationMapper;
    @Autowired
    PreinstalledApplicationInstanceMapper preinstalledApplicationInstanceMapper;
    @Resource
    private IamService iamService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private KmService kmService;
    @Autowired
    SyncJobInfoMapper syncJobInfoMapper;
    @Resource
    private IPreinstalledApplicationService preinstalledApplicationService;
    @Autowired
    LabelSystemDataService labelSystemDataService;
    @Autowired
    MdcService mdcService;
    @Autowired
    private AppLinkService appLinkService;
    @Resource
    private IImportRecordService importRecordService;
    @Autowired
    TemplateSystemDataImportMapper templateSystemDataImportMapper;
    @Resource
    private EnvProperties envProperties;
    @Resource
    private Converter converter;

    public List<LabelSystemData> tempToLabel(List<TemplateSystemData> systemDataTempList) {
        ArrayList<LabelSystemData> labelSystemDataList = new ArrayList<LabelSystemData>();
        for (TemplateSystemData systemDataTemp : systemDataTempList) {
            LabelSystemData systemData = (LabelSystemData)this.converter.convert((Object)systemDataTemp, LabelSystemData.class);
            labelSystemDataList.add(systemData);
        }
        return labelSystemDataList;
    }

    public PageInfoResp<TemplateSystemData> queryDataList(QueryLabelSystemReq req) {
        PageInfoResp pageInfoResp = new PageInfoResp();
        Integer startNum = (req.getPageNum() - 1) * req.getPageSize();
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        List systemDataTempList = this.templateStystemDataMapper.selectByPage(req.getAppCodeList(), req, startNum, req.getPageSize(), tenantId);
        int totalCount = this.templateStystemDataMapper.selectCountBy(req.getAppCodeList(), req, tenantId);
        if (CollectionUtils.isEmpty((Collection)systemDataTempList)) {
            return pageInfoResp;
        }
        List labelSystemDataList = this.tempToLabel(systemDataTempList);
        LabelSystemDataAppVo systemDataAppVo = this.labelSystemDataService.getSsoAppMap(labelSystemDataList);
        Map erpInfoMap = systemDataAppVo.getErpInfoMap();
        Map thirdSsoInfoMap = systemDataAppVo.getThirdSsoInfoMap();
        Map athenaInfoMap = systemDataAppVo.getAthenaInfoMap();
        List appJobDTOList = new ArrayList();
        List systemDataKMList = systemDataTempList.stream().filter(x -> Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(x.getDataCategory())).filter(x -> x.getDataType().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(systemDataKMList)) {
            appJobDTOList = this.kmService.queryAppJobList();
        }
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        List preInstalledAppList = this.preinstalledApplicationService.queryPreinstalledAppList(user);
        Map preinstalledApplicationMap = preInstalledAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));
        for (TemplateSystemData systemData : systemDataTempList) {
            if (ApplicationTypeEnum.VIRTUAL_APPLICATION.getType().equals(systemData.getDataType())) {
                String name = VirtualApplicationEnum.parseNameById((String)systemData.getAppCode());
                systemData.setAppName(name);
            } else {
                String appName = this.addAppIDName(erpInfoMap, thirdSsoInfoMap, athenaInfoMap, systemData, Boolean.valueOf(false), preinstalledApplicationMap);
                systemData.setAppName(appName);
            }
            if (!StringUtils.isNotEmpty((CharSequence)systemData.getWorkCode())) continue;
            systemData.setWorkName(this.getWorkName(systemData, appJobDTOList));
        }
        int totalPages = totalCount % req.getPageSize() == 0 ? totalCount / req.getPageSize() : totalCount / req.getPageSize() + 1;
        pageInfoResp.setTotalPages(totalPages);
        pageInfoResp.setPageNo(req.getPageNum().intValue());
        pageInfoResp.setPageSize(req.getPageSize().intValue());
        pageInfoResp.setTotalRecords(totalCount);
        pageInfoResp.setList(systemDataTempList);
        return pageInfoResp;
    }

    public String getKmJobName(String appCode, String workCode, List<AppJobDTO> appJobDTOList) {
        if (CollectionUtils.isEmpty(appJobDTOList)) {
            return "";
        }
        AppJobDTO appJobDTO = appJobDTOList.stream().filter(x -> appCode.equals(x.getAppCode())).findFirst().orElse(null);
        if (appJobDTO == null) {
            return "";
        }
        AppJobDTO.Job job = appJobDTO.getData().stream().filter(x -> workCode.equals(x.getCode())).findFirst().orElse(null);
        if (job == null) {
            return "";
        }
        return job.getName();
    }

    public String getWorkName(TemplateSystemData systemData, List<AppJobDTO> appJobDTOList) {
        if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(systemData.getDataType())) {
            return this.getKmJobName(systemData.getAppCode(), systemData.getWorkCode(), appJobDTOList);
        }
        List syncJobInfoList = this.syncJobInfoMapper.selectList((Wrapper)this.getJobCondition(systemData.getAppId(), systemData.getWorkCode()));
        if (CollectionUtils.isNotEmpty((Collection)syncJobInfoList)) {
            return ((SyncJobInfo)syncJobInfoList.get(0)).getJobName();
        }
        return "";
    }

    public QueryWrapper getJobCondition(String appId, String jobCode) {
        QueryWrapper condition = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)jobCode)) {
            condition.eq((Object)"job_code", (Object)jobCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            condition.eq((Object)"app_id", (Object)appId);
        }
        return condition;
    }

    public String addAppIDName(Map<Long, ErpSsoInfo> erpInfoMap, Map<Long, ThirdSsoInfo> thirdSsoInfoMap, Map<String, TenantAppDTO> athenaInfoMap, TemplateSystemData systemData, Boolean type, Map<Long, PreinstalledApplication> preinstalledApplicationMap) {
        PreinstalledApplication preinstalledApplication;
        ThirdSsoInfo thirdSsoInfo;
        ErpSsoInfo erpSsoInfo;
        String appName = "";
        String appCode = "";
        String appId = "";
        String systemType = "";
        String appToken = "";
        String callBackUrl = "";
        int isNeedSsoUrl = 0;
        int isFixedRefresh = 0;
        if (StringUtils.isEmpty((CharSequence)systemData.getAppCode())) {
            return appName;
        }
        if (null == systemData.getDataType()) {
            return appName;
        }
        if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(systemData.getDataType()) && null != (erpSsoInfo = erpInfoMap.get(Long.parseLong(systemData.getAppCode())))) {
            appName = erpSsoInfo == null ? "" : erpSsoInfo.getName();
            appCode = erpSsoInfo == null ? "" : erpSsoInfo.getCode();
            appId = erpSsoInfo == null ? "" : erpSsoInfo.getAppId();
            systemType = "wt";
            appToken = erpSsoInfo.getAppToken();
            systemData.setProtocolType(erpSsoInfo.getProtocolType());
            callBackUrl = erpSsoInfo.getCallBackUrl();
        }
        if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(systemData.getDataType()) && (thirdSsoInfo = thirdSsoInfoMap.get(Long.parseLong(systemData.getAppCode()))) != null) {
            appName = thirdSsoInfo.getAppName();
            appCode = thirdSsoInfo.getAppCode();
            appId = thirdSsoInfo.getAppId();
            systemType = "mt";
            appToken = thirdSsoInfo.getAppToken();
            systemData.setProtocolType(thirdSsoInfo.getProtocolType());
            callBackUrl = thirdSsoInfo.getCallBackUrl();
        }
        if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(systemData.getDataType()) && null != (preinstalledApplication = preinstalledApplicationMap.get(Long.parseLong(systemData.getAppCode())))) {
            appName = preinstalledApplication.getApplicationName();
            appCode = preinstalledApplication.getApplicationCode();
            appId = preinstalledApplication.getAppId();
            systemType = this.getPreSystem(preinstalledApplication);
            appToken = preinstalledApplication.getAppToken();
            systemData.setProtocolType(preinstalledApplication.getProtocolType());
            com.alibaba.fastjson.JSONObject jsonObject = Optional.ofNullable(com.alibaba.fastjson.JSONObject.parseObject((String)preinstalledApplication.getApplicationConfig())).orElse(new com.alibaba.fastjson.JSONObject());
            callBackUrl = String.format("http://www.%s.com", jsonObject.getString("applicationCode"));
            if (MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(preinstalledApplication.getApplicationCode())) {
                isNeedSsoUrl = 1;
                isFixedRefresh = 1;
                PreinstalledApplicationInstance applicationInstance = this.preinstalledApplicationService.getPreINstance(preinstalledApplication.getId(), "", "");
                if (null != applicationInstance && null != applicationInstance.getApplicationExtConfig()) {
                    JSONObject instanceObject = applicationInstance.getApplicationExtConfig();
                    callBackUrl = instanceObject.getString("callBackUrl");
                    appId = instanceObject.getString("appId");
                }
            }
            if ("06".equals(preinstalledApplication.getProductCode()) || "100".equals(preinstalledApplication.getProductCode())) {
                isNeedSsoUrl = 1;
            }
        }
        if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(systemData.getDataType())) {
            TenantAppDTO appDTO = athenaInfoMap.get(systemData.getAppCode());
            appName = appDTO == null ? "" : appDTO.getName();
            appCode = systemData.getAppCode();
        }
        systemData.setAppId(appId);
        if (type.booleanValue()) {
            systemData.setAppCode(appCode);
            systemData.setSystemType(systemType);
            systemData.setAppToken(appToken);
            systemData.setCallBackUrl(callBackUrl);
            systemData.setIsNeedSsoUrl(isNeedSsoUrl);
            systemData.setIsFixedRefresh(isFixedRefresh);
        }
        systemData.setAppName(appName);
        return appName;
    }

    public String getPreSystem(PreinstalledApplication preinstalledApplication) {
        String systemType = "";
        if (null == preinstalledApplication.getSystemType()) {
            return systemType;
        }
        if (preinstalledApplication.getSystemType().equals(Integer.parseInt(PreinstalledApplicationTypeEnum.BS_APPLICATION.getValue()))) {
            systemType = "mt";
        }
        if (preinstalledApplication.getSystemType().equals(Integer.parseInt(PreinstalledApplicationTypeEnum.CS_APPLICATION.getValue()))) {
            systemType = "wt";
        }
        return systemType;
    }

    public Map<String, TenantAppDTO> getAthenaInfoMap(List<LabelSystemData> athenaList) {
        Map<String, TenantAppDTO> athenaInfoMap = new HashMap<String, TenantAppDTO>();
        if (CollectionUtils.isEmpty(athenaList)) {
            return athenaInfoMap;
        }
        List allTenantApps = this.iamService.queryTenantApps();
        athenaInfoMap = allTenantApps.stream().collect(Collectors.toMap(value -> value.getId(), value -> value, (key1, key2) -> key1));
        return athenaInfoMap;
    }

    public Map<Long, PreinstalledApplication> getPreInfoMap() {
        List preinstalledAppList = this.preinstalledApplicationMapper.selectList((Wrapper)new QueryWrapper());
        Map<Long, PreinstalledApplication> preInfoMap = preinstalledAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));
        return preInfoMap;
    }

    public Map<Long, ErpSsoInfo> getErpInfoMap(List<LabelSystemData> csList, LabelSystemDataAppVo systemDataAppVo) {
        Map<Long, Object> erpInfoMap = new HashMap<Long, ErpSsoInfo>();
        if (CollectionUtils.isEmpty(csList)) {
            return erpInfoMap;
        }
        List thirdFolderIdList = csList.stream().map(LabelSystemData::getAppCode).collect(Collectors.toList());
        QuerySsoListReq querySsoListReq = new QuerySsoListReq();
        List idList = thirdFolderIdList.stream().map(Long::parseLong).collect(Collectors.toList());
        querySsoListReq.setIdList(idList);
        systemDataAppVo.setErpSystemId(idList);
        List erpInfoList = this.erpSsoInfoMapper.querySsoListByScope(querySsoListReq);
        erpInfoMap = erpInfoList.stream().collect(Collectors.toMap(ErpSsoInfo::getId, Function.identity(), (a, b) -> a));
        return erpInfoMap;
    }

    public Map<Long, ThirdSsoInfo> getSsoInfoMap(List<LabelSystemData> bsList, LabelSystemDataAppVo systemDataAppVo) {
        Map<Long, Object> thirdSsoInfoMap = new HashMap<Long, ThirdSsoInfo>();
        if (CollectionUtils.isEmpty(bsList)) {
            return thirdSsoInfoMap;
        }
        List thirdFolderIdList = bsList.stream().map(LabelSystemData::getAppCode).collect(Collectors.toList());
        QuerySsoListReq querySsoListReq = new QuerySsoListReq();
        List idList = thirdFolderIdList.stream().map(Long::parseLong).collect(Collectors.toList());
        querySsoListReq.setIdList(idList);
        systemDataAppVo.setBsSystemId(idList);
        List thirdSsoInfoList = this.thirdSsoInfoMapper.queryThirdListByScope(querySsoListReq);
        thirdSsoInfoMap = thirdSsoInfoList.stream().collect(Collectors.toMap(ThirdSsoInfo::getId, Function.identity(), (a, b) -> a));
        return thirdSsoInfoMap;
    }

    @Transactional
    public ResponseEntity<?> updateValidStatus(QueryLabelSystemReq req) {
        ResponseEntity checkResp;
        TemplateSystemData systemData = (TemplateSystemData)this.templateStystemDataMapper.selectById((Serializable)req.getId());
        if (null == systemData) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_FAILED, (String)"the data source does not exist");
        }
        systemData.setId(req.getId());
        systemData.setValidStatus(req.getValidStatus());
        systemData.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
        if (Constants.VALID_STATUS_ENABLE.equals(req.getValidStatus()) && null != (checkResp = this.checkSystemData(systemData))) {
            return checkResp;
        }
        if (Constants.VALID_STATUS_UNUSABLE.equals(req.getValidStatus())) {
            ArrayList<Long> dataIds = new ArrayList<Long>();
            dataIds.add(req.getId());
            List systemSourceList = this.templateSystemSourceMapper.selByDataIds(dataIds, null);
            if (CollectionUtils.isNotEmpty((Collection)systemSourceList)) {
                String error = this.messageUtils.getMessage("error.message.system.data.stop");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
            }
        }
        this.templateStystemDataMapper.updateById((Object)systemData);
        return ResponseEntityWrapper.wrapperOk();
    }

    @Transactional
    public ResponseEntity<?> delData(QueryLabelSystemReq req) {
        List valIdDataList = new ArrayList();
        req.setValidStatus(Constants.VALID_STATUS_ENABLE);
        req.setPageNum(Constants.pageNum);
        req.setPageSize(Constants.pageSize);
        Page systemDataListPage = this.selectByParam(req);
        if (null != systemDataListPage) {
            valIdDataList = systemDataListPage.getRecords();
        }
        if (CollectionUtils.isNotEmpty(valIdDataList) && req.getIds().size() == 1) {
            String error = this.messageUtils.getMessage("error.message.system.data.delete");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
        if (CollectionUtils.isNotEmpty(valIdDataList)) {
            String error = this.messageUtils.getMessage("error.message.system.data.delete.fail");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
        this.templateStystemDataMapper.deleteBatchIds((Collection)req.getIds());
        this.templateSystemSourceMapper.delByDataIds(req.getIds(), null, null);
        return ResponseEntityWrapper.wrapperOk();
    }

    @Transactional
    public ResponseEntity<?> saveData(TemplateSystemData req) {
        TemplateSystemData labelSystemData = new TemplateSystemData();
        BeanUtils.copyProperties((Object)req, (Object)labelSystemData);
        ResponseEntity checkResp = this.checkSystemData(labelSystemData);
        if (null != checkResp) {
            return checkResp;
        }
        req.setName(req.getName().trim());
        int isExistData = this.templateStystemDataMapper.countByParam(req.getName(), req.getId(), AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        if (isExistData > 0) {
            String error = this.messageUtils.getMessage("error.message.system.data.name.exist");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        if (null != req.getId() && null != req.getValidStatus() && Constants.VALID_STATUS_UNUSABLE.equals(req.getValidStatus())) {
            ArrayList<Long> dataIds = new ArrayList<Long>();
            dataIds.add(req.getId());
            List systemSourceList = this.templateSystemSourceMapper.selByDataIds(dataIds, null);
            if (CollectionUtils.isNotEmpty((Collection)systemSourceList)) {
                String error = this.messageUtils.getMessage("error.message.system.data.stop");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
            }
        }
        req.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
        if (req.getId() == null) {
            req.setCreateUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
            this.templateStystemDataMapper.insert((Object)req);
        } else {
            this.templateStystemDataMapper.updateById((Object)req);
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    public List<TemplateSystemData> queryByIds(List<Long> ids) {
        return this.templateStystemDataMapper.selectBatchIds(ids);
    }

    public List<String> getDataNameList(Integer dataType, String appCode) {
        return this.templateStystemDataMapper.getDataNameList(dataType, appCode);
    }

    public List<TemplateSystemData> queryDataInfoBy(List<Long> ids) {
        List<Object> systemDataTempList = new ArrayList<TemplateSystemData>();
        if (CollectionUtils.isEmpty(ids)) {
            return systemDataTempList;
        }
        systemDataTempList = this.templateStystemDataMapper.selectBatchIds(ids);
        List labelSystemDataList = this.tempToLabel(systemDataTempList);
        LabelSystemDataAppVo systemDataAppVo = new LabelSystemDataAppVo();
        List csList = labelSystemDataList.stream().filter(item -> ApplicationTypeEnum.CS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map erpInfoMap = this.getErpInfoMap(csList, systemDataAppVo);
        List bsList = labelSystemDataList.stream().filter(item -> ApplicationTypeEnum.BS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map thirdSsoInfoMap = this.getSsoInfoMap(bsList, systemDataAppVo);
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        List preInstalledAppList = this.preinstalledApplicationService.queryPreinstalledAppList(user);
        Map preinstalledApplicationMap = preInstalledAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));
        for (TemplateSystemData templateSystemData : systemDataTempList) {
            HashMap athenaInfoMap = new HashMap();
            String appName = this.addAppIDName(erpInfoMap, thirdSsoInfoMap, athenaInfoMap, templateSystemData, Boolean.valueOf(true), preinstalledApplicationMap);
            templateSystemData.setAppName(appName);
        }
        return systemDataTempList;
    }

    public LabelSystemDataDto getSystemDataSso(Long id) {
        AuthoredUser user;
        List preInstalledAppList;
        Map preinstalledApplicationMap;
        PreinstalledApplication preinstalled;
        ThirdSsoInfo thirdSsoInfo;
        ErpSsoInfo erpSsoInfo;
        LabelSystemDataDto labelSystemDataDto = new LabelSystemDataDto();
        TemplateSystemData labelSystemDataTemp = (TemplateSystemData)this.templateStystemDataMapper.selectById((Serializable)id);
        if (null == labelSystemDataTemp) {
            return null;
        }
        this.converter.convert((Object)labelSystemDataTemp, (Object)labelSystemDataDto);
        if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(labelSystemDataTemp.getDataType()) && null != (erpSsoInfo = (ErpSsoInfo)this.erpSsoInfoMapper.selectById((Serializable)((Object)labelSystemDataTemp.getAppCode())))) {
            labelSystemDataDto.setAppId(erpSsoInfo.getAppId());
            labelSystemDataDto.setAppCode(erpSsoInfo.getCode());
            labelSystemDataDto.setAppName(erpSsoInfo.getName());
            labelSystemDataDto.setAppToken(erpSsoInfo.getAppToken());
            labelSystemDataDto.setUserBindFlag(erpSsoInfo.getUserBindFlag());
            labelSystemDataDto.setProtocolType(erpSsoInfo.getProtocolType());
            labelSystemDataDto.setCasServerUrl(erpSsoInfo.getCasServerUrl());
        }
        if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(labelSystemDataTemp.getDataType()) && null != (thirdSsoInfo = (ThirdSsoInfo)this.thirdSsoInfoMapper.selectById((Serializable)((Object)labelSystemDataTemp.getAppCode())))) {
            labelSystemDataDto.setAppId(thirdSsoInfo.getAppId());
            labelSystemDataDto.setAppCode(thirdSsoInfo.getAppCode());
            labelSystemDataDto.setAppName(thirdSsoInfo.getAppName());
            labelSystemDataDto.setAppToken(thirdSsoInfo.getAppToken());
            labelSystemDataDto.setUserBindFlag(thirdSsoInfo.getUserBindFlag());
            labelSystemDataDto.setProtocolType(thirdSsoInfo.getProtocolType());
            labelSystemDataDto.setCasServerUrl(thirdSsoInfo.getCasServerUrl());
        }
        if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(labelSystemDataTemp.getDataType()) && null != (preinstalled = (PreinstalledApplication)(preinstalledApplicationMap = (preInstalledAppList = this.preinstalledApplicationService.queryPreinstalledAppList(user = AppAuthContextHolder.getContext().getAuthoredUser())).stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a))).get(Long.parseLong(labelSystemDataTemp.getAppCode())))) {
            labelSystemDataDto.setAppId(preinstalled.getAppId());
            labelSystemDataDto.setAppCode(preinstalled.getApplicationCode());
            labelSystemDataDto.setAppName(preinstalled.getApplicationName());
            labelSystemDataDto.setAppSecret(preinstalled.getAppSecret());
            labelSystemDataDto.setAppToken(preinstalled.getAppToken());
            labelSystemDataDto.setUserBindFlag(preinstalled.getUserBindFlag());
            if (StringUtils.isNotEmpty((CharSequence)preinstalled.getApplicationConfig())) {
                ErpSsoSpecialDTO erpSsoSpecialDTO = (ErpSsoSpecialDTO)Optional.ofNullable(com.alibaba.fastjson.JSONObject.parseObject((String)preinstalled.getApplicationConfig(), ErpSsoSpecialDTO.class)).orElse(new ErpSsoSpecialDTO());
                labelSystemDataDto.setCallBackUrl(erpSsoSpecialDTO == null ? "" : erpSsoSpecialDTO.getCallBackUrl());
            }
            if (MaycurCodeEnum.MAYCUR_CLOUD.getType().equals(preinstalled.getApplicationCode()) || MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(preinstalled.getApplicationCode())) {
                PreinstalledApplicationInstance applicationInstance = this.preinstalledApplicationService.getPreINstance(preinstalled.getId(), "", "");
                JSONObject jsonObject = applicationInstance.getApplicationExtConfig();
                String callBackUrl = jsonObject.getString("callBackUrl");
                String appId = jsonObject.getString("appId");
                String appSecret = jsonObject.getString("appSecret");
                labelSystemDataDto.setAppId(appId);
                labelSystemDataDto.setAppSecret(appSecret);
                labelSystemDataDto.setCallBackUrl(callBackUrl);
            }
            labelSystemDataDto.setProtocolType(preinstalled.getProtocolType());
            labelSystemDataDto.setCasServerUrl(preinstalled.getCasServerUrl());
        }
        return labelSystemDataDto;
    }

    public LabelSystemDataAppVo getSsoAppMap(List<TemplateSystemData> systemDataTempList) {
        List labelSystemDataList = this.tempToLabel(systemDataTempList);
        LabelSystemDataAppVo systemDataAppVo = new LabelSystemDataAppVo();
        List csList = labelSystemDataList.stream().filter(item -> ApplicationTypeEnum.CS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map erpInfoMap = this.getErpInfoMap(csList, systemDataAppVo);
        systemDataAppVo.setErpInfoMap(erpInfoMap);
        List bsList = labelSystemDataList.stream().filter(item -> ApplicationTypeEnum.BS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map thirdSsoInfoMap = this.getSsoInfoMap(bsList, systemDataAppVo);
        systemDataAppVo.setThirdSsoInfoMap(thirdSsoInfoMap);
        Map preInfoMap = this.getPreInfoMap();
        systemDataAppVo.setPreInfoMap(preInfoMap);
        List athenaList = labelSystemDataList.stream().filter(item -> ApplicationTypeEnum.IAM_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map athenaInfoMap = this.getAthenaInfoMap(athenaList);
        systemDataAppVo.setAthenaInfoMap(athenaInfoMap);
        return systemDataAppVo;
    }

    public LabelSystemDataAppVo getSsoAppMapTemp(List<TemplateSystemData> systemDataTempList) {
        List labelSystemDataList = this.tempToLabel(systemDataTempList);
        LabelSystemDataAppVo systemDataAppVo = new LabelSystemDataAppVo();
        List csList = labelSystemDataList.stream().filter(item -> ApplicationTypeEnum.CS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map erpInfoMap = this.getErpInfoMap(csList, systemDataAppVo);
        systemDataAppVo.setErpInfoMap(erpInfoMap);
        List bsList = labelSystemDataList.stream().filter(item -> ApplicationTypeEnum.BS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map thirdSsoInfoMap = this.getSsoInfoMap(bsList, systemDataAppVo);
        systemDataAppVo.setThirdSsoInfoMap(thirdSsoInfoMap);
        List preList = labelSystemDataList.stream().filter(item -> ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map<Object, Object> preInstanceListMap = new HashMap();
        Map<Object, Object> preAppMap = new HashMap();
        if (CollectionUtils.isNotEmpty(preList)) {
            List applicationIdList = preList.stream().map(LabelSystemData::getAppCode).collect(Collectors.toList());
            List preInstanceList = this.preinstalledApplicationInstanceMapper.getPreInsBy(systemDataTempList.get(0).getTenantId(), applicationIdList, null);
            if (CollectionUtils.isNotEmpty((Collection)preInstanceList)) {
                preInstanceListMap = preInstanceList.stream().collect(Collectors.toMap(PreinstalledApplicationInstance::getPreinstalledApplicationId, Function.identity(), (a, b) -> a));
            }
            List preAppList = this.preinstalledApplicationMapper.selectBatchIds(applicationIdList);
            preAppMap = preAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));
        }
        List athenaList = labelSystemDataList.stream().filter(item -> ApplicationTypeEnum.IAM_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map athenaInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(athenaList)) {
            athenaInfoMap = this.getAthenaInfoMap(athenaList);
        }
        HashMap<Long, LabelSystemDataDto> systemAppNameMap = new HashMap<Long, LabelSystemDataDto>();
        for (TemplateSystemData systemDataTemp : systemDataTempList) {
            TenantAppDTO appDTO;
            ThirdSsoInfo thirdSsoInfo;
            ErpSsoInfo erpSsoInfo;
            LabelSystemDataDto labelSystemDataDto = new LabelSystemDataDto();
            if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(systemDataTemp.getDataType()) && null != (erpSsoInfo = (ErpSsoInfo)erpInfoMap.get(Long.parseLong(systemDataTemp.getAppCode())))) {
                labelSystemDataDto.setAppId(erpSsoInfo.getAppId());
                labelSystemDataDto.setAppCode(erpSsoInfo.getCode());
                labelSystemDataDto.setAppName(erpSsoInfo.getName());
                labelSystemDataDto.setAppToken(erpSsoInfo.getAppToken());
                labelSystemDataDto.setUserBindFlag(erpSsoInfo.getUserBindFlag());
                labelSystemDataDto.setProtocolType(erpSsoInfo.getProtocolType());
                labelSystemDataDto.setCasServerUrl(erpSsoInfo.getCasServerUrl());
            }
            if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(systemDataTemp.getDataType()) && null != (thirdSsoInfo = (ThirdSsoInfo)thirdSsoInfoMap.get(Long.parseLong(systemDataTemp.getAppCode())))) {
                labelSystemDataDto.setAppId(thirdSsoInfo.getAppId());
                labelSystemDataDto.setAppCode(thirdSsoInfo.getAppCode());
                labelSystemDataDto.setAppName(thirdSsoInfo.getAppName());
                labelSystemDataDto.setAppToken(thirdSsoInfo.getAppToken());
                labelSystemDataDto.setUserBindFlag(thirdSsoInfo.getUserBindFlag());
                labelSystemDataDto.setProtocolType(thirdSsoInfo.getProtocolType());
                labelSystemDataDto.setCasServerUrl(thirdSsoInfo.getCasServerUrl());
            }
            if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(systemDataTemp.getDataType())) {
                PreinstalledApplication preinstalledApplication;
                PreinstalledApplicationInstance preInstance = (PreinstalledApplicationInstance)preInstanceListMap.get(Long.parseLong(systemDataTemp.getAppCode()));
                if (null != preInstance) {
                    labelSystemDataDto.setAppId(preInstance.getAppId());
                    labelSystemDataDto.setAppSecret(preInstance.getAppSecret());
                }
                if (null != (preinstalledApplication = (PreinstalledApplication)preAppMap.get(Long.parseLong(systemDataTemp.getAppCode())))) {
                    labelSystemDataDto.setAppCode(preinstalledApplication.getApplicationCode());
                    labelSystemDataDto.setAppName(preinstalledApplication.getApplicationName());
                }
            }
            if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(systemDataTemp.getDataType()) && null != (appDTO = (TenantAppDTO)athenaInfoMap.get(systemDataTemp.getAppCode()))) {
                labelSystemDataDto.setAppCode(appDTO.getId());
                labelSystemDataDto.setAppName(appDTO.getName());
            }
            systemAppNameMap.put(systemDataTemp.getId(), labelSystemDataDto);
        }
        systemDataAppVo.setSystemAppNameMap(systemAppNameMap);
        return systemDataAppVo;
    }

    public ResponseEntity<?> checkSystemData(TemplateSystemData labelSystemData) {
        String error = "";
        if (StringUtils.isEmpty((CharSequence)labelSystemData.getName())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"the data source name cannot be empty");
        }
        if (StringUtils.isEmpty((CharSequence)labelSystemData.getName().trim())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"the data source name cannot be empty");
        }
        if (StringUtils.isEmpty((CharSequence)labelSystemData.getAppCode())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"the source application cannot be empty");
        }
        if (null == labelSystemData.getDataCategory()) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"the data source classification cannot be empty");
        }
        if (null == labelSystemData.getDataType()) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"The source application source cannot be empty");
        }
        if (StringUtils.isEmpty((CharSequence)labelSystemData.getWorkCode()) && Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(labelSystemData.getDataCategory()) && ApplicationTypeEnum.IAM_APPLICATION.getType().equals(labelSystemData.getDataType())) {
            error = this.messageUtils.getMessage("error.message.system.data.job.empty");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        if (!ApplicationTypeEnum.IAM_APPLICATION.getType().equals(labelSystemData.getDataType()) && null != labelSystemData.getDataModel() && Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(labelSystemData.getDataModel())) {
            if (StringUtils.isEmpty((CharSequence)labelSystemData.getMiddleSystemName())) {
                error = this.messageUtils.getMessage("error.message.system.data.middleSystemName.empty");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            if (StringUtils.isEmpty((CharSequence)labelSystemData.getMiddleSystemUid())) {
                error = this.messageUtils.getMessage("error.message.system.data.middleSystemUid.empty");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
        }
        if (!ApplicationTypeEnum.IAM_APPLICATION.getType().equals(labelSystemData.getDataType()) && null != labelSystemData.getDataModel() && Constants.DataModelEnum.MODEL_CLOUD.getVal().equals(labelSystemData.getDataModel()) && StringUtils.isEmpty((CharSequence)labelSystemData.getRestUrl())) {
            error = this.messageUtils.getMessage("error.message.system.data.restUrl.empty");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(labelSystemData.getDataType()) && !Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(labelSystemData.getDataCategory()) && !Constants.DataCategoryEnum.CATEGORY_APP.getVal().equals(labelSystemData.getDataCategory())) {
            error = this.messageUtils.getMessage("error.message.system.data.dataType.fail");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(labelSystemData.getDataType()) && StringUtils.isNotEmpty((CharSequence)labelSystemData.getCallBackUrl()) && Utils.jsonParamValid((String)labelSystemData.getCallBackUrl())) {
            error = this.messageUtils.getMessage("error.message.system.data.callBackUrl.fail");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        return null;
    }

    public Page<TemplateSystemData> selectByParam(QueryLabelSystemReq req) {
        QueryWrapper queryWrapper = new QueryWrapper();
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        queryWrapper.orderByDesc((Object)"modify_time");
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        if (CollectionUtils.isNotEmpty((Collection)req.getDataCategoryList())) {
            queryWrapper.in((Object)"data_category", (Collection)req.getDataCategoryList());
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getAppCodeList())) {
            queryWrapper.in((Object)"app_code", (Collection)req.getAppCodeList());
        }
        if (null != req.getValidStatus()) {
            queryWrapper.eq((Object)"valid_status", (Object)req.getValidStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getName())) {
            queryWrapper.like((Object)"name", (Object)req.getName());
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getIds())) {
            queryWrapper.in((Object)"id", (Collection)req.getIds());
        }
        Page systemDataPage = (Page)this.templateStystemDataMapper.selectPage((IPage)new Page((long)req.getPageNum().intValue(), (long)req.getPageSize().intValue()), (Wrapper)queryWrapper);
        return systemDataPage;
    }

    public List<SystemDataImportVo> readExcel(String fileId) {
        List excelVoList;
        DMC dmcInstance = this.mdcService.buildDmc();
        try {
            byte[] byteArray = dmcInstance.download(fileId);
            ByteArrayInputStream input = new ByteArrayInputStream(byteArray);
            SyncReadListener excelListener = new SyncReadListener();
            ExcelReader excelReader = EasyExcelFactory.read((InputStream)input).build();
            excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)0).head(SystemDataImportVo.class)).headRowNumber(Integer.valueOf(2))).registerReadListener((ReadListener)excelListener)).build()});
            excelReader.finish();
            excelVoList = this.mdcService.doReadSync(excelListener);
        }
        catch (Exception e) {
            log.error("SystemDataImport read excel occur error", (Throwable)e);
            throw new RuntimeException(e);
        }
        return excelVoList;
    }

    @Transactional
    public ImportExcelResp importReport(List<SystemDataImportVo> dataImportVoList) {
        ImportExcelResp excelResp = new ImportExcelResp();
        List<Object> nameList = new ArrayList();
        List systemDataTempList = this.templateStystemDataMapper.selectList((Wrapper)new QueryWrapper());
        if (CollectionUtils.isNotEmpty((Collection)systemDataTempList)) {
            nameList = systemDataTempList.stream().map(TemplateSystemData::getName).collect(Collectors.toList());
        }
        ArrayList nameIamList = new ArrayList();
        Map nameAppMap = this.queryAppList(nameIamList);
        List appJobListDTOList = this.kmService.queryAppJobList();
        ArrayList<TemplateSystemData> systemDataListAdd = new ArrayList<TemplateSystemData>();
        Map categoryMap = this.initCategoryMap();
        Map statusMap = this.initStatusMap();
        int successNum = 0;
        int failNum = 0;
        for (SystemDataImportVo dataImportVo : dataImportVoList) {
            StringBuilder errorSb = this.validateData(dataImportVo, nameList, nameAppMap, appJobListDTOList, nameIamList);
            if (StringUtils.isNotBlank((CharSequence)errorSb.toString())) {
                ++failNum;
                dataImportVo.setFailDesc(errorSb.substring(0, errorSb.length() - 1));
                continue;
            }
            dataImportVo.setFailDesc(errorSb.toString());
            nameList.add(dataImportVo.getName());
            TemplateSystemData labelSystemTempData = this.initLabelSystemData(dataImportVo, categoryMap, statusMap, nameAppMap, appJobListDTOList);
            systemDataListAdd.add(labelSystemTempData);
            ++successNum;
        }
        if (CollectionUtils.isNotEmpty(systemDataListAdd)) {
            this.saveBatch(systemDataListAdd);
        }
        String nowTime = DateUtils.getNowTime((String)"yyyyMMddHHmmss");
        ShareInfo shareInfo = this.importRecordService.uploadExcel(this.write(dataImportVoList, nowTime));
        this.initDataImport(shareInfo.getFileId(), Integer.valueOf(successNum), Integer.valueOf(failNum), nowTime);
        excelResp.setFailFileId(shareInfo.getFileId());
        excelResp.setFailFileName(shareInfo.getFileName());
        excelResp.setFailFileUrl(shareInfo.getUrl());
        String resultCode = successNum > 0 && failNum == 0 ? "2001" : (successNum > 0 && failNum > 0 ? "2002" : (successNum == 0 && failNum > 0 ? "2003" : "2003"));
        excelResp.setResultCode(resultCode);
        excelResp.setFailCount(Integer.valueOf(failNum));
        excelResp.setSuccessCount(Integer.valueOf(successNum));
        return excelResp;
    }

    public TemplateSystemDataImport initDataImport(String fileId, Integer successCount, Integer failCount, String nowTime) {
        TemplateSystemDataImport dataImport = new TemplateSystemDataImport();
        dataImport.setFileId(fileId);
        dataImport.setSuccessCount(successCount);
        dataImport.setFailCount(failCount);
        dataImport.setCreateUserName(Utils.getUserName());
        dataImport.setCreateUserId(Utils.getUserId());
        dataImport.setCreateTime(DateUtils.getDateFormat((String)nowTime, (String)"yyyyMMddHHmmss", (String)"yyyy-MM-dd HH:mm:ss"));
        dataImport.setModifyTime(DateUtils.getDateFormat((String)nowTime, (String)"yyyyMMddHHmmss", (String)"yyyy-MM-dd HH:mm:ss"));
        dataImport.setModifyUserId(Utils.getUserId());
        dataImport.setTenantId(Utils.getTenantId());
        this.templateSystemDataImportMapper.insert((Object)dataImport);
        return dataImport;
    }

    public File write(List<SystemDataImportVo> list, String nowTime) {
        File file = new File("\u6570\u636e\u6e90\u5bfc\u5165\u8bb0\u5f55_" + nowTime + ".xlsx");
        ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((File)file, SystemDataImportVo.class).relativeHeadRowIndex(Integer.valueOf(1))).registerWriteHandler((WriteHandler)Utils.initHorizontalCell())).registerWriteHandler((WriteHandler)new SystemDataWriteHandler())).sheet("\u6570\u636e\u6e90\u914d\u7f6e").doWrite(list);
        return file;
    }

    public TemplateSystemData initLabelSystemData(SystemDataImportVo dataImportVo, Map<String, Integer> categoryMap, Map<String, Integer> statusMap, Map<String, List<AppLinkDTO>> nameAppMap, List<AppJobDTO> appJobListDTOList) {
        TemplateSystemData labelSystemData = new TemplateSystemData();
        labelSystemData.setName(dataImportVo.getName());
        labelSystemData.setRemark(dataImportVo.getRemark());
        labelSystemData.setDataCategory(categoryMap.get(dataImportVo.getCategory()));
        labelSystemData.setValidStatus(statusMap.get(dataImportVo.getValidStatus()));
        List<AppLinkDTO> appLinkList = nameAppMap.get(dataImportVo.getAppName());
        AppLinkDTO appLinkDTO = null;
        if (CollectionUtils.isNotEmpty(appLinkList)) {
            appLinkDTO = appLinkList.get(0);
            labelSystemData.setDataType(appLinkDTO.getDataSource());
            labelSystemData.setAppCode(appLinkDTO.getPrimaryId());
        }
        if (dataImportVo.getCategory().equals(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal())) {
            if (dataImportVo.getJobType().equals(Constants.JobTypeEnum.JOB_TYPE_NAME.getVal())) {
                List jobInfoList;
                if (null != appLinkDTO && appLinkDTO.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())) {
                    Map appJobListMap = appJobListDTOList.stream().collect(Collectors.toMap(AppJobDTO::getAppCode, Function.identity(), (a, b) -> a));
                    AppJobDTO appJobDTO = (AppJobDTO)appJobListMap.get(appLinkDTO.getPrimaryId());
                    List jobList = appJobDTO.getData();
                    Map appCodeJobMap = jobList.stream().collect(Collectors.toMap(AppJobDTO.Job::getCode, Function.identity(), (a, b) -> a));
                    AppJobDTO.Job job = (AppJobDTO.Job)appCodeJobMap.get(dataImportVo.getJobVal());
                    if (null == job) {
                        Map appNameJobMap = jobList.stream().collect(Collectors.toMap(AppJobDTO.Job::getName, Function.identity(), (a, b) -> a));
                        job = (AppJobDTO.Job)appNameJobMap.get(dataImportVo.getJobVal());
                    }
                    String jobCode = job == null ? "" : job.getCode();
                    labelSystemData.setWorkCode(jobCode);
                    labelSystemData.setIsJob(Integer.valueOf(0));
                }
                if (null != appLinkDTO && !appLinkDTO.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType()) && CollectionUtils.isNotEmpty((Collection)(jobInfoList = this.syncJobInfoMapper.selByNameCode(appLinkDTO.getAppId(), dataImportVo.getJobVal())))) {
                    labelSystemData.setWorkCode(((SyncJobInfo)jobInfoList.get(0)).getJobCode());
                    labelSystemData.setIsJob(Integer.valueOf(0));
                }
            }
            if (dataImportVo.getJobType().equals(Constants.JobTypeEnum.JOB_TYPE_CALLBACK.getVal())) {
                labelSystemData.setIsJob(Integer.valueOf(1));
                labelSystemData.setCallBackUrl(dataImportVo.getJobVal());
            }
        }
        labelSystemData.setCreateUserName(Utils.getUserName());
        labelSystemData.setModifyUserName(Utils.getUserName());
        labelSystemData.setCreateUserId(Utils.getUserId());
        labelSystemData.setCreateTime(DateUtils.getNowTime((String)""));
        labelSystemData.setModifyTime(DateUtils.getNowTime((String)""));
        labelSystemData.setModifyUserId(Utils.getUserId());
        labelSystemData.setTenantId(Utils.getTenantId());
        return labelSystemData;
    }

    public Map<String, List<AppLinkDTO>> queryAppList(List<String> nameIamList) {
        HashMap<String, List<AppLinkDTO>> nameAppMap = new HashMap<String, List<AppLinkDTO>>();
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        List appLinkList = this.appLinkService.queryManageList(user);
        appLinkList = this.filterRepeatApp(appLinkList, nameIamList);
        for (AppLinkDTO appLink : appLinkList) {
            String key = appLink.getName();
            ArrayList<AppLinkDTO> appList = new ArrayList<AppLinkDTO>();
            appList.add(appLink);
            if (!nameAppMap.containsKey(key)) {
                nameAppMap.put(key, new ArrayList(appList));
                continue;
            }
            ((List)nameAppMap.get(key)).addAll(appList);
        }
        return nameAppMap;
    }

    public List<AppLinkDTO> filterRepeatApp(List<AppLinkDTO> appLinkListDT, List<String> nameIamList) {
        ArrayList<AppLinkDTO> appLinkDTOList = new ArrayList<AppLinkDTO>();
        List matchedLinkList = appLinkListDT.stream().filter(x -> x.getDataSource().equals(ApplicationTypeEnum.PRESET_APPLICATION.getType())).collect(Collectors.toList());
        Map preListMap = matchedLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getAppId, Function.identity(), (a, b) -> a));
        List iamLinkList = appLinkListDT.stream().filter(x -> x.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(iamLinkList)) {
            List<Object> namesIamList = iamLinkList.stream().map(AppLinkDTO::getName).collect(Collectors.toList());
            namesIamList = nameIamList;
        }
        Map iamListMap = iamLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getPrimaryId, Function.identity(), (a, b) -> a));
        for (AppLinkDTO appLink : appLinkListDT) {
            AppLinkDTO iamData = (AppLinkDTO)iamListMap.get(appLink.getApplicationAppId());
            if (appLink.getDataSource().equals(ApplicationTypeEnum.PRESET_APPLICATION.getType()) && null != iamData) continue;
            AppLinkDTO preData = (AppLinkDTO)preListMap.get(appLink.getPrimaryId());
            if (!appLink.getDataSource().equals(ApplicationTypeEnum.PRESET_APPLICATION.getType()) && null != preData) {
                appLink.setName(preData.getName());
            }
            appLinkDTOList.add(appLink);
        }
        return appLinkDTOList;
    }

    private StringBuilder validateData(SystemDataImportVo dataImportVo, List<String> nameList, Map<String, List<AppLinkDTO>> nameAppMap, List<AppJobDTO> appJobListDTOList, List<String> nameIamList) {
        StringBuilder errorSb = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)dataImportVo.getName())) {
            errorSb.append("\u201c\u6570\u636e\u6e90\u540d\u79f0\u201d\u672a\u586b\u5199").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getName()) && dataImportVo.getName().length() > 500) {
            errorSb.append("\u201c\u6570\u636e\u6e90\u540d\u79f0\u201d\u5185\u5bb9\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236").append(",");
        }
        if (nameList.contains(dataImportVo.getName())) {
            errorSb.append("\u201c\u6570\u636e\u6e90\u540d\u79f0\u201d\u91cd\u540d").append(",");
        }
        AppLinkDTO appLinkDTO = null;
        if (StringUtils.isEmpty((CharSequence)dataImportVo.getAppName())) {
            errorSb.append("\u201c\u6e90\u5e94\u7528\u201d\u672a\u586b\u5199").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getAppName())) {
            List<AppLinkDTO> appLinkList = nameAppMap.get(dataImportVo.getAppName());
            if (CollectionUtils.isEmpty(appLinkList)) {
                errorSb.append("\u201c\u6e90\u5e94\u7528\u201d\u503c\u9519\u8bef").append(",");
            }
            if (CollectionUtils.isNotEmpty(appLinkList) && appLinkList.size() > 1) {
                errorSb.append("\u201c\u6e90\u5e94\u7528\u201d\u540d\u79f0\u91cd\u540d").append(",");
            }
            if (CollectionUtils.isEmpty(appLinkList) && !nameIamList.contains(dataImportVo.getAppName())) {
                errorSb.append("\u79df\u6237\u672a\u6388\u6743\u6b64\u6e90\u5e94\u7528\u6743\u9650").append(",");
            }
            if (CollectionUtils.isNotEmpty(appLinkList) && appLinkList.size() == 1) {
                appLinkDTO = appLinkList.get(0);
            }
        }
        if (StringUtils.isEmpty((CharSequence)dataImportVo.getCategory())) {
            errorSb.append("\u201c\u6570\u636e\u6e90\u5206\u7c7b\u201d\u672a\u586b\u5199").append(",");
        }
        List categoryNameList = this.initCategoryNameList();
        if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getCategory()) && !categoryNameList.contains(dataImportVo.getCategory())) {
            errorSb.append("\u201c\u6570\u636e\u6e90\u5206\u7c7b\u201d\u503c\u9519\u8bef").append(",");
        }
        if (StringUtils.isEmpty((CharSequence)dataImportVo.getValidStatus())) {
            errorSb.append("\u201c\u72b6\u6001\u201d\u672a\u586b\u5199").append(",");
        }
        List validStatusList = this.initValidStatusList();
        if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getValidStatus()) && !validStatusList.contains(dataImportVo.getValidStatus())) {
            errorSb.append("\u201c\u72b6\u6001\u201d\u503c\u9519\u8bef").append(",");
        }
        if (StringUtils.isNotBlank((CharSequence)dataImportVo.getRemark()) && dataImportVo.getRemark().length() > 100) {
            errorSb.append("\u201c\u6570\u636e\u6e90\u5907\u6ce8\u201d\u5185\u5bb9\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getCategory()) && !dataImportVo.getCategory().equals(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal())) {
            if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getJobType()) && StringUtils.isNotEmpty((CharSequence)dataImportVo.getJobVal())) {
                errorSb.append("\u201c\u6570\u636e\u6e90\u5206\u7c7b\u201d\u9009\u62e9\u4e86\u201c" + dataImportVo.getCategory() + "\u201d\uff0c\u201c\u4f5c\u4e1a\u586b\u5199\u65b9\u5f0f\u201d\u3001\u201c\u4f5c\u4e1a\u503c\u201d\u4e0d\u9700\u8981\u586b\u5199").append(",");
            } else if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getJobType())) {
                errorSb.append("\u201c\u6570\u636e\u6e90\u5206\u7c7b\u201d\u9009\u62e9\u4e86\u201c" + dataImportVo.getCategory() + "\u201d\uff0c\u201c\u4f5c\u4e1a\u586b\u5199\u65b9\u5f0f\u201d\u4e0d\u9700\u8981\u586b\u5199").append(",");
            } else if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getJobVal())) {
                errorSb.append("\u201c\u6570\u636e\u6e90\u5206\u7c7b\u201d\u9009\u62e9\u4e86\u201c" + dataImportVo.getCategory() + "\u201d\uff0c\u201c\u4f5c\u4e1a\u503c\u201d\u4e0d\u9700\u8981\u586b\u5199").append(",");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getCategory()) && dataImportVo.getCategory().equals(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal())) {
            if (StringUtils.isEmpty((CharSequence)dataImportVo.getJobVal()) && StringUtils.isEmpty((CharSequence)dataImportVo.getJobType())) {
                errorSb.append("\u201c\u6570\u636e\u6e90\u5206\u7c7b\u201d\u9009\u62e9\u4e86\u201c\u4f5c\u4e1a\u96c6\u6210\u201d\uff0c\u201c\u4f5c\u4e1a\u586b\u5199\u65b9\u5f0f\u201d\u3001\u201c\u4f5c\u4e1a\u503c\u201d\u90fd\u672a\u586b\u5199").append(",");
                return errorSb;
            }
            if (StringUtils.isEmpty((CharSequence)dataImportVo.getJobType())) {
                errorSb.append("\u201c\u6570\u636e\u6e90\u5206\u7c7b\u201d\u9009\u62e9\u4e86\u201c\u4f5c\u4e1a\u96c6\u6210\u201d\uff0c\u4f5c\u4e1a\u586b\u5199\u65b9\u5f0f\u672a\u586b\u5199").append(",");
            }
            List jobTypeList = this.initJobTypeList();
            if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getJobType()) && !jobTypeList.contains(dataImportVo.getJobType())) {
                errorSb.append("\u4f5c\u4e1a\u586b\u5199\u65b9\u5f0f\u503c\u9519\u8bef").append(",");
            }
            if (StringUtils.isEmpty((CharSequence)dataImportVo.getJobVal())) {
                errorSb.append("\u6570\u636e\u6e90\u5206\u7c7b\u201d\u9009\u62e9\u4e86\u201c\u4f5c\u4e1a\u96c6\u6210\u201d\uff0c\u4f5c\u4e1a\u503c\u672a\u586b\u5199").append(",");
                return errorSb;
            }
            if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getJobVal()) && dataImportVo.getJobVal().length() > 500) {
                errorSb.append("\u201c\u4f5c\u4e1a\u503c\u201d\u5185\u5bb9\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236").append(",");
            }
            if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getJobType()) && StringUtils.isNotEmpty((CharSequence)dataImportVo.getJobVal()) && dataImportVo.getJobType().equals(Constants.JobTypeEnum.JOB_TYPE_NAME.getVal())) {
                if (null != appLinkDTO && appLinkDTO.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())) {
                    Map appJobListMap = appJobListDTOList.stream().collect(Collectors.toMap(AppJobDTO::getAppCode, Function.identity(), (a, b) -> a));
                    AppJobDTO appJobDTO = (AppJobDTO)appJobListMap.get(appLinkDTO.getPrimaryId());
                    if (null == appJobListMap || null == appJobDTO) {
                        errorSb.append("\u4f5c\u4e1a\u503c\u9519\u8bef").append(",");
                        return errorSb;
                    }
                    List jobList = appJobDTO.getData();
                    if (CollectionUtils.isEmpty((Collection)jobList)) {
                        errorSb.append("\u4f5c\u4e1a\u503c\u9519\u8bef").append(",");
                        return errorSb;
                    }
                    List jobCodeList = jobList.stream().map(AppJobDTO.Job::getCode).collect(Collectors.toList());
                    List jobNameList = jobList.stream().map(AppJobDTO.Job::getName).collect(Collectors.toList());
                    if (!jobNameList.contains(dataImportVo.getJobVal()) && !jobCodeList.contains(dataImportVo.getJobVal())) {
                        errorSb.append("\u4f5c\u4e1a\u503c\u9519\u8bef").append(",");
                        return errorSb;
                    }
                }
                if (null != appLinkDTO && !appLinkDTO.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())) {
                    List jobInfoList = this.syncJobInfoMapper.selByNameCode(appLinkDTO.getAppId(), dataImportVo.getJobVal());
                    if (CollectionUtils.isEmpty((Collection)jobInfoList)) {
                        errorSb.append("\u4f5c\u4e1a\u503c\u9519\u8bef").append(",");
                        return errorSb;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)jobInfoList) && jobInfoList.size() > 1) {
                        errorSb.append("\u4f5c\u4e1a\u503c\u91cd\u590d").append(",");
                        return errorSb;
                    }
                }
            }
        }
        return errorSb;
    }

    public Map<String, Integer> initCategoryMap() {
        HashMap<String, Integer> categoryMap = new HashMap<String, Integer>();
        categoryMap.put(Constants.DataCategoryNameEnum.CATEGORY_TODO_NAME.getVal(), Constants.DataCategoryEnum.CATEGORY_TODO.getVal());
        categoryMap.put(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal(), Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        categoryMap.put(Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal(), Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        return categoryMap;
    }

    public Map<String, Integer> initStatusMap() {
        HashMap<String, Integer> statusMap = new HashMap<String, Integer>();
        statusMap.put(Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal(), Constants.VALID_STATUS_ENABLE);
        statusMap.put(Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal(), Constants.VALID_STATUS_UNUSABLE);
        return statusMap;
    }

    public Map<Integer, String> initCategoryValMap() {
        HashMap<Integer, String> categoryMap = new HashMap<Integer, String>();
        categoryMap.put(Constants.DataCategoryEnum.CATEGORY_TODO.getVal(), Constants.DataCategoryNameEnum.CATEGORY_TODO_NAME.getVal());
        categoryMap.put(Constants.DataCategoryEnum.CATEGORY_WORK.getVal(), Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal());
        categoryMap.put(Constants.DataCategoryEnum.CATEGORY_APP.getVal(), Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal());
        return categoryMap;
    }

    public Map<Integer, String> initStatusValMap() {
        HashMap<Integer, String> statusMap = new HashMap<Integer, String>();
        statusMap.put(Constants.DataCategoryEnum.CATEGORY_TODO.getVal(), Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal());
        statusMap.put(Constants.DataCategoryEnum.CATEGORY_REPORT.getVal(), Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal());
        return statusMap;
    }

    public List<String> initCategoryNameList() {
        ArrayList<String> categoryNameList = new ArrayList<String>();
        categoryNameList.add(Constants.DataCategoryNameEnum.CATEGORY_TODO_NAME.getVal());
        categoryNameList.add(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal());
        categoryNameList.add(Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal());
        return categoryNameList;
    }

    public List<String> initValidStatusList() {
        ArrayList<String> validStatusList = new ArrayList<String>();
        validStatusList.add(Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal());
        validStatusList.add(Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal());
        return validStatusList;
    }

    public List<String> initJobTypeList() {
        ArrayList<String> jobTypeList = new ArrayList<String>();
        jobTypeList.add(Constants.JobTypeEnum.JOB_TYPE_NAME.getVal());
        jobTypeList.add(Constants.JobTypeEnum.JOB_TYPE_CALLBACK.getVal());
        return jobTypeList;
    }

    public PageInfoResp<TemplateSystemDataImport> queryImportRecord(QueryImportRecordReq queryImportRecordReq) {
        QueryWrapper condition = new QueryWrapper();
        if (StringUtils.isBlank((CharSequence)queryImportRecordReq.getStartTime()) || StringUtils.isBlank((CharSequence)queryImportRecordReq.getEndTime())) {
            String currentDate = DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss");
            condition.ge((Object)"create_time", (Object)DateUtils.addDate((String)currentDate, (String)"yyyy-MM-dd HH:mm:ss", (int)-1, (String)"year"));
            condition.le((Object)"create_time", (Object)currentDate);
        } else {
            condition.ge((Object)"create_time", (Object)queryImportRecordReq.getStartTime());
            condition.le((Object)"create_time", (Object)queryImportRecordReq.getEndTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryImportRecordReq.getUserIdName())) {
            condition.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.like((Object)"create_user_name", (Object)queryImportRecordReq.getUserIdName())).or()).like((Object)"create_user_id", (Object)queryImportRecordReq.getUserIdName());
            });
        }
        condition.orderByDesc((Object)"create_time");
        PageInfoResp pageInfoResp = new PageInfoResp();
        pageInfoResp.setPageNo(queryImportRecordReq.getPageNum().intValue());
        pageInfoResp.setPageSize(queryImportRecordReq.getPageSize().intValue());
        pageInfoResp.setTotalPages(0);
        pageInfoResp.setTotalRecords(0);
        Page pageResult = (Page)this.templateSystemDataImportMapper.selectPage((IPage)new Page((long)queryImportRecordReq.getPageNum().intValue(), (long)queryImportRecordReq.getPageSize().intValue()), (Wrapper)condition);
        if (pageResult != null && CollectionUtils.isNotEmpty((Collection)pageResult.getRecords())) {
            pageResult.getRecords().forEach(m -> m.setFileUrl(this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + m.getFileId().trim()));
            pageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(pageResult.getPages())));
            pageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(pageResult.getTotal())));
            pageInfoResp.setList(pageResult.getRecords());
        } else {
            pageInfoResp.setList((List)Lists.newArrayList());
        }
        return pageInfoResp;
    }

    public List<SystemDataExportVo> exportReport() {
        ArrayList excelVoList = Lists.newArrayList();
        List systemDataTempList = this.getExportData();
        if (CollectionUtils.isEmpty((Collection)systemDataTempList)) {
            return excelVoList;
        }
        Map categoryMap = this.initCategoryValMap();
        Map statusMap = this.initStatusValMap();
        LabelSystemDataAppVo systemDataAppVo = this.getSsoAppMap(systemDataTempList);
        Map erpInfoMap = systemDataAppVo.getErpInfoMap();
        Map thirdSsoInfoMap = systemDataAppVo.getThirdSsoInfoMap();
        Map athenaInfoMap = systemDataAppVo.getAthenaInfoMap();
        List appJobListDTOList = this.kmService.queryAppJobList();
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        List preInstalledAppList = this.preinstalledApplicationService.queryPreinstalledAppList(user);
        Map preinstalledApplicationMap = preInstalledAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));
        for (TemplateSystemData systemData : systemDataTempList) {
            SystemDataExportVo dataExportVo = new SystemDataExportVo();
            dataExportVo.setName(systemData.getName());
            dataExportVo.setRemark(systemData.getRemark());
            dataExportVo.setCategory((String)categoryMap.get(systemData.getDataCategory()));
            dataExportVo.setValidStatus((String)statusMap.get(systemData.getValidStatus()));
            String appName = this.addAppIDName(erpInfoMap, thirdSsoInfoMap, athenaInfoMap, systemData, Boolean.valueOf(false), preinstalledApplicationMap);
            dataExportVo.setAppName(appName);
            String jobType = "";
            String jobVal = "";
            if (Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(systemData.getDataCategory())) {
                if (null != systemData.getIsJob() && systemData.getIsJob() == 1) {
                    jobType = Constants.JobTypeEnum.JOB_TYPE_CALLBACK.getVal();
                    jobVal = systemData.getCallBackUrl();
                } else {
                    jobType = Constants.JobTypeEnum.JOB_TYPE_NAME.getVal();
                    if (StringUtils.isNotEmpty((CharSequence)systemData.getWorkCode())) {
                        jobVal = this.getWorkName(systemData, appJobListDTOList);
                    }
                }
            }
            dataExportVo.setJobType(jobType);
            dataExportVo.setJobVal(jobVal);
            excelVoList.add(dataExportVo);
        }
        return excelVoList;
    }

    public List<TemplateSystemData> getExportData() {
        QueryWrapper condition = new QueryWrapper();
        ArrayList<Integer> categoryList = new ArrayList<Integer>();
        categoryList.add(Constants.DataCategoryEnum.CATEGORY_TODO.getVal());
        categoryList.add(Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        categoryList.add(Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        condition.in((Object)"data_category", categoryList);
        condition.orderByDesc((Object)"modify_time");
        return this.templateStystemDataMapper.selectList((Wrapper)condition);
    }

    public List<Long> selectBySystemId(Long systemID) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (null != systemID) {
            queryWrapper.eq((Object)"system_id", (Object)systemID);
        }
        queryWrapper.eq((Object)"component_source", (Object)Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
        List systemSourceList = this.templateSystemSourceMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)systemSourceList)) {
            return new ArrayList<Long>();
        }
        List<Long> dataIdList = systemSourceList.stream().map(TemplateSystemSource::getDataId).distinct().collect(Collectors.toList());
        return dataIdList;
    }
}

