/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.temp.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.ComponentSourceEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataSourceUpdateReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreQueryReq;
import com.digiwin.athena.semc.entity.temp.TemplateSystemCustom;
import com.digiwin.athena.semc.entity.temp.TemplateSystemData;
import com.digiwin.athena.semc.entity.temp.TemplateSystemPre;
import com.digiwin.athena.semc.entity.temp.TemplateSystemSource;
import com.digiwin.athena.semc.mapper.temp.TemplateBenchCustomMapper;
import com.digiwin.athena.semc.mapper.temp.TemplatePortalInfoContentMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemCustomMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemDataMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemPreMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateSystemSourceMapper;
import com.digiwin.athena.semc.service.cache.RedisLock;
import com.digiwin.athena.semc.service.temp.TemplateSystemPreService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import com.digiwin.athena.semc.vo.portal.LabelSystemPreCustomVo;
import com.digiwin.athena.semc.vo.portal.LabelSystemPreQueryVO;
import com.google.gson.Gson;
import io.github.linpeilie.Converter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TemplateSystemPreServiceImpl
extends ServiceImpl<TemplateSystemPreMapper, TemplateSystemPre>
implements TemplateSystemPreService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateSystemPreServiceImpl.class);
    @Autowired
    MessageUtils messageUtils;
    @Autowired
    TemplateSystemPreMapper templateSystemPreMapper;
    @Autowired
    TemplateSystemSourceMapper templateSystemSourceMapper;
    @Autowired
    TemplateSystemDataMapper templateSystemDataMapper;
    @Autowired
    TemplateSystemCustomMapper templateSystemCustomMapper;
    @Autowired
    TemplateBenchCustomMapper templateBenchCustomMapper;
    @Autowired
    TemplatePortalInfoContentMapper templatePortalInfoContentMapper;
    @Resource
    private Converter converter;

    public ResultPageBean pageQuery(LabelSystemPreQueryReq labelSystemPreQueryReq) {
        this.initPreData();
        List systemPreList = this.selectByParam(labelSystemPreQueryReq);
        if (CollectionUtils.isEmpty((Collection)systemPreList)) {
            return ResultPageBean.success((ResponseBody)ResponseBody.getInstance((Object)systemPreList, (PageInfo)PageInfo.getPageInfo((Integer)labelSystemPreQueryReq.getPageNum(), (Integer)labelSystemPreQueryReq.getPageSize(), (Integer)systemPreList.size())));
        }
        Gson gson = new Gson();
        List labelSystemSourceList = this.templateSystemSourceMapper.listByCondition(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId(), Integer.valueOf(1), systemPreList.stream().map(TemplateSystemPre::getId).collect(Collectors.toList()));
        LinkedList dataSourceInfoList = new LinkedList();
        labelSystemSourceList.forEach(item -> {
            LabelSystemPreQueryVO.DataSourceInfo dataSourceInfo = (LabelSystemPreQueryVO.DataSourceInfo)gson.fromJson(JSON.toJSONString((Object)item), LabelSystemPreQueryVO.DataSourceInfo.class);
            dataSourceInfoList.add(dataSourceInfo);
        });
        Map<Long, List<LabelSystemPreQueryVO.DataSourceInfo>> map = dataSourceInfoList.stream().collect(Collectors.groupingBy(LabelSystemPreQueryVO.DataSourceInfo::getSystemId));
        LinkedList<LabelSystemPreQueryVO> labelSystemPreQueryEmptyList = new LinkedList<LabelSystemPreQueryVO>();
        for (TemplateSystemPre systemPre : systemPreList) {
            LabelSystemPreQueryVO labelSystemPreQueryVO = (LabelSystemPreQueryVO)this.converter.convert((Object)systemPre, LabelSystemPreQueryVO.class);
            labelSystemPreQueryVO.setComponentSource(ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode());
            if (Constants.IsUseDataNum.USE_DATA_FALSE.getVal().equals(systemPre.getIsUseData()) && Constants.IsEnableTrueNum.ENABLE_TRUE.getVal().equals(systemPre.getIsEnableTrue())) {
                labelSystemPreQueryVO.setModifyUserName("");
                labelSystemPreQueryVO.setModifyUserId("");
                labelSystemPreQueryVO.setModifyTime("");
            }
            List<LabelSystemPreQueryVO.DataSourceInfo> dataList = map.get(systemPre.getId());
            labelSystemPreQueryVO.setDataSourceInfo(dataList);
            labelSystemPreQueryEmptyList.add(labelSystemPreQueryVO);
        }
        ResultPageBean resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance(labelSystemPreQueryEmptyList.stream().skip((long)(labelSystemPreQueryReq.getPageNum() - 1) * labelSystemPreQueryReq.getPageSize().longValue()).limit(labelSystemPreQueryReq.getPageSize().intValue()).collect(Collectors.toList()), (PageInfo)PageInfo.getPageInfo((Integer)labelSystemPreQueryReq.getPageNum(), (Integer)labelSystemPreQueryReq.getPageSize(), (Integer)labelSystemPreQueryEmptyList.size())));
        return resultPageBean;
    }

    public List<TemplateSystemPre> selectByParam(LabelSystemPreQueryReq queryReq) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)Utils.getTenantId());
        queryWrapper.orderByDesc((Object)"modify_time");
        if (StringUtils.isNotEmpty((CharSequence)queryReq.getQueryCondition().getName())) {
            queryWrapper.like((Object)"name", (Object)queryReq.getQueryCondition().getName());
        }
        if (null != queryReq.getQueryCondition().getValidStatus()) {
            queryWrapper.eq((Object)"valid_status", (Object)queryReq.getQueryCondition().getValidStatus());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReq.getQueryCondition().getDataCategory())) {
            queryWrapper.eq((Object)"data_category", (Object)queryReq.getQueryCondition().getDataCategory());
        }
        return this.templateSystemPreMapper.selectList((Wrapper)queryWrapper);
    }

    public Integer getDataCategory(LabelSystemDataSourceUpdateReq.DataSourceInfo item, Map<Long, TemplateSystemPre> templateSystemPreMap, Map<Long, TemplateSystemCustom> templateSystemCustomMap) {
        Integer dataCategory = null;
        if (ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode().equals(item.getComponentSource())) {
            TemplateSystemPre templateSystemPre = templateSystemPreMap.get(item.getSystemId());
            if (null == templateSystemPre) {
                templateSystemPre = (TemplateSystemPre)this.templateSystemPreMapper.selectById((Serializable)item.getSystemId());
                templateSystemPreMap.put(item.getSystemId(), templateSystemPre);
            }
            dataCategory = templateSystemPre.getDataCategory();
        } else {
            TemplateSystemCustom templateSystemCustom = templateSystemCustomMap.get(item.getSystemId());
            if (null == templateSystemCustom) {
                templateSystemCustom = (TemplateSystemCustom)this.templateSystemCustomMapper.selectById((Serializable)item.getSystemId());
                templateSystemCustomMap.put(item.getSystemId(), templateSystemCustom);
            }
            dataCategory = templateSystemCustom.getDataCategory();
        }
        return dataCategory;
    }

    @Transactional
    public ResponseEntity<?> updateDataSource(LabelSystemDataSourceUpdateReq labelSystemUpdateReq) {
        HashMap templateSystemPreMap = new HashMap();
        HashMap templateSystemCustomMap = new HashMap();
        Long systemId = null;
        Integer componentSource = null;
        ArrayList<TemplateSystemSource> templateSystemSourceList = new ArrayList<TemplateSystemSource>();
        for (LabelSystemDataSourceUpdateReq.DataSourceInfo item : labelSystemUpdateReq.getDataSourceInfo()) {
            systemId = item.getSystemId();
            componentSource = item.getComponentSource();
            if (null == item.getDataId()) continue;
            TemplateSystemData labelSystemData = (TemplateSystemData)this.templateSystemDataMapper.selectById((Serializable)item.getDataId());
            Integer dataCategory = this.getDataCategory(item, templateSystemPreMap, templateSystemCustomMap);
            if (null != dataCategory && !labelSystemData.getDataCategory().equals(dataCategory)) {
                String error = this.messageUtils.getMessage("error.message.system.pre.dara.fail");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_DATA_SOURCE, (String)error);
            }
            TemplateSystemSource templateSystemSource = (TemplateSystemSource)this.converter.convert((Object)item, TemplateSystemSource.class);
            templateSystemSource.setTenantId(Utils.getTenantId());
            templateSystemSource.setCreateTime(DateUtils.getNowTime((String)""));
            templateSystemSource.setCreateUserId(Utils.getUserId());
            templateSystemSourceList.add(templateSystemSource);
        }
        this.templateSystemSourceMapper.delByDataIds(null, systemId, componentSource);
        if (CollectionUtils.isNotEmpty((Collection)labelSystemUpdateReq.getDataSourceInfo())) {
            this.initUserName((LabelSystemDataSourceUpdateReq.DataSourceInfo)labelSystemUpdateReq.getDataSourceInfo().get(0));
        }
        if (CollectionUtils.isNotEmpty(templateSystemSourceList)) {
            this.templateSystemSourceMapper.insertBatch(templateSystemSourceList);
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    public void initUserName(LabelSystemDataSourceUpdateReq.DataSourceInfo dataSourceInfo) {
        if (dataSourceInfo.getComponentSource().equals(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal())) {
            TemplateSystemCustom labelSystemCustom = new TemplateSystemCustom();
            labelSystemCustom.setId(dataSourceInfo.getSystemId());
            labelSystemCustom.setModifyUserName(Utils.getUserName());
            labelSystemCustom.setModifyUserId(Utils.getUserId());
            labelSystemCustom.setModifyTime(DateUtils.getNowTime((String)""));
            this.templateSystemCustomMapper.updateById((Object)labelSystemCustom);
        }
        if (dataSourceInfo.getComponentSource().equals(Constants.LabelTypeEnum.SYSTEM_PRE.getVal())) {
            TemplateSystemPre labelSystemPre = new TemplateSystemPre();
            labelSystemPre.setId(dataSourceInfo.getSystemId());
            labelSystemPre.setModifyUserName(Utils.getUserName());
            labelSystemPre.setModifyUserId(Utils.getUserId());
            labelSystemPre.setModifyTime(DateUtils.getNowTime((String)""));
            this.templateSystemPreMapper.updateById((Object)labelSystemPre);
        }
    }

    @Transactional
    public ResponseEntity<?> updateValidStatus(Long id, Integer validStatus, Integer componentSource) {
        ArrayList<Long> systemIdList = new ArrayList<Long>();
        systemIdList.add(id);
        List contentList = this.templatePortalInfoContentMapper.selPortalConent(Utils.getTenantId(), systemIdList, componentSource);
        if (componentSource.equals(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal())) {
            List jsonObjectList;
            if (CollectionUtils.isNotEmpty((Collection)contentList) && validStatus.equals(Constants.ValidStatusEnum.VALID_STATUS_ON.getVal())) {
                String error = this.messageUtils.getMessage("error.message.jd.portal.layout.stop.error");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, (String)error);
            }
            ArrayList<Long> idList = new ArrayList<Long>();
            idList.add(id);
            List tempBenchCustomList = this.templateBenchCustomMapper.selectBenchBy(null, idList);
            if (CollectionUtils.isNotEmpty((Collection)tempBenchCustomList) && validStatus.equals(Constants.ValidStatusEnum.VALID_STATUS_ON.getVal())) {
                String error = this.messageUtils.getMessage("error.message.job.system.data.stop.error");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
            }
            if (validStatus.equals(Constants.ValidStatusEnum.VALID_STATUS_OFF.getVal()) && CollectionUtils.isEmpty((Collection)(jsonObjectList = this.templateSystemSourceMapper.listBySystemId(Utils.getTenantId(), id, componentSource)))) {
                String error = this.messageUtils.getMessage("error.message.system.pre.incomplete.fail");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, (String)error);
            }
        }
        if (componentSource.equals(Constants.LabelTypeEnum.SYSTEM_PRE.getVal())) {
            List jsonObjectList;
            TemplateSystemPre systemPre = (TemplateSystemPre)this.templateSystemPreMapper.selectById((Serializable)id);
            if (systemPre == null) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, (String)"component does not exist!");
            }
            if (!Constants.DataTypeEnum.TYPE_TODO.getVal().equals(systemPre.getDataType()) && !systemPre.getDataType().equals(Constants.DataTypeEnum.TYPE_INFO.getVal()) && CollectionUtils.isNotEmpty((Collection)contentList) && 0 == validStatus) {
                String error = this.messageUtils.getMessage("error.message.jd.portal.layout.stop.error");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, (String)error);
            }
            if (validStatus.equals(Constants.ValidStatusEnum.VALID_STATUS_OFF.getVal()) && !systemPre.getDataType().equals(Constants.DataTypeEnum.TYPE_INFO.getVal()) && CollectionUtils.isEmpty((Collection)(jsonObjectList = this.templateSystemSourceMapper.listBySystemId(Utils.getTenantId(), id, componentSource)))) {
                String error = this.messageUtils.getMessage("error.message.system.pre.incomplete.fail");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, (String)error);
            }
        }
        if (ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode().equals(componentSource)) {
            TemplateSystemPre templateSystemPre = new TemplateSystemPre();
            templateSystemPre.setId(id);
            templateSystemPre.setValidStatus(validStatus);
            templateSystemPre.setModifyUserName(Utils.getUserName());
            templateSystemPre.setModifyTime(DateUtils.getNowTime((String)""));
            this.templateSystemPreMapper.updateById((Object)templateSystemPre);
        } else {
            TemplateSystemCustom templateSystemCustom = new TemplateSystemCustom();
            templateSystemCustom.setId(id);
            templateSystemCustom.setValidStatus(validStatus);
            templateSystemCustom.setModifyUserName(Utils.getUserName());
            templateSystemCustom.setModifyTime(DateUtils.getNowTime((String)""));
            this.templateSystemCustomMapper.updateById((Object)templateSystemCustom);
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public List<TemplateSystemPre> initPreData() {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        List labelSystemPreList = this.getInitData(tenantId);
        RedisLock redisLock = new RedisLock("LabelSystemPre:" + tenantId);
        try {
            if (!redisLock.lock()) {
                return labelSystemPreList;
            }
        }
        catch (InterruptedException e) {
            return labelSystemPreList;
        }
        try {
            List overSystemPreList = this.getInitData("");
            List<TemplateSystemPre> insertPreList = new ArrayList();
            if (CollectionUtils.isEmpty((Collection)labelSystemPreList)) {
                insertPreList = overSystemPreList;
            } else {
                Map preListMap = labelSystemPreList.stream().collect(Collectors.toMap(TemplateSystemPre::getDataType, Function.identity(), (a, b) -> a));
                for (TemplateSystemPre overSystemPre : overSystemPreList) {
                    if (null != preListMap.get(overSystemPre.getDataType())) continue;
                    insertPreList.add(overSystemPre);
                }
            }
            if (CollectionUtils.isNotEmpty(insertPreList)) {
                labelSystemPreList = this.batchSavePreData(insertPreList, tenantId);
            }
            List list = labelSystemPreList = this.getInitData(tenantId);
            return list;
        }
        catch (Exception e) {
            log.error("LabelSystemPre initPreData error", (Throwable)e);
        }
        finally {
            redisLock.unlock();
        }
        return labelSystemPreList;
    }

    public TemplateSystemPre getPreSystemID(Integer dataType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)Utils.getTenantId());
        queryWrapper.eq((Object)"data_type", (Object)dataType);
        List labelSystemPreList = this.templateSystemPreMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)labelSystemPreList)) {
            return (TemplateSystemPre)labelSystemPreList.get(0);
        }
        return null;
    }

    public LabelSystemPreCustomVo queryAllSystem(LabelSystemAllVo req) {
        List presetList;
        LabelSystemPreCustomVo preCustomVo = new LabelSystemPreCustomVo();
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        List customList = this.templateSystemPreMapper.queryCustomSystem(tenantId, req.getName(), req.getDataCategoryList());
        if (CollectionUtils.isNotEmpty((Collection)customList)) {
            preCustomVo.setCustomList(customList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(presetList = this.templateSystemPreMapper.queryPreSystem(tenantId, req.getName())))) {
            presetList.forEach(x -> x.setName("\u4e09\u65b9\u5f85\u529e".equals(x.getName()) ? "\u5f85\u529e" : x.getName()));
            preCustomVo.setPresetList(presetList);
        }
        return preCustomVo;
    }

    public List<TemplateSystemPre> initDefPortal(List<Integer> dataCategoryList) {
        List<TemplateSystemPre> preList = this.initPreData();
        preList = preList.stream().filter(item -> dataCategoryList.contains(item.getDataType())).collect(Collectors.toList());
        return preList;
    }

    public List<TemplateSystemPre> batchSavePreData(List<TemplateSystemPre> labelSystemPreList, String tenantId) {
        ArrayList<TemplateSystemPre> systemPreTenantList = new ArrayList<TemplateSystemPre>();
        for (TemplateSystemPre labelSystemPre : labelSystemPreList) {
            TemplateSystemPre systemPreTenant = new TemplateSystemPre();
            BeanUtils.copyProperties((Object)labelSystemPre, (Object)systemPreTenant);
            labelSystemPre.setTenantId(tenantId);
            labelSystemPre.setId(null);
            this.templateSystemPreMapper.insert((Object)labelSystemPre);
            labelSystemPre.setId(labelSystemPre.getId());
            systemPreTenantList.add(labelSystemPre);
        }
        return systemPreTenantList;
    }

    public List<TemplateSystemPre> getInitData(String tenantId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)tenantId)) {
            queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        } else {
            queryWrapper.isNull((Object)"tenant_id");
        }
        List labelSystemPreList = this.templateSystemPreMapper.selectList((Wrapper)queryWrapper);
        return labelSystemPreList;
    }
}

