/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.temp.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.TemplateQueryReq;
import com.digiwin.athena.semc.entity.temp.TemplateTenantGroup;
import com.digiwin.athena.semc.entity.temp.TemplateTenantGroupItem;
import com.digiwin.athena.semc.mapper.temp.TemplateInfoTenantMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateTenantGroupItemMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateTenantGroupMapper;
import com.digiwin.athena.semc.service.temp.TemplateTenantGroupService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TemplateTenantGroupServiceImpl
extends ServiceImpl<TemplateTenantGroupMapper, TemplateTenantGroup>
implements TemplateTenantGroupService {
    @Resource
    private TemplateTenantGroupMapper templateTenantGroupMapper;
    @Resource
    private TemplateTenantGroupItemMapper templateTenantGroupItemMapper;
    @Resource
    private TemplateInfoTenantMapper templateInfoTenantMapper;

    @Transactional
    public Long saveTenantGroup(TemplateTenantGroup req) {
        req.setModifyTime(DateUtils.getNowTime((String)""));
        req.setModifyUserId(Utils.getUserId());
        req.setModifyUserName(Utils.getUserName());
        if (null == req.getId()) {
            req.setTenantId(Utils.getTenantId());
            req.setCreateUserName(Utils.getUserName());
            req.setCreateUserId(Utils.getUserId());
            req.setCreateTime(DateUtils.getNowTime((String)""));
            req.setSubUserId(Utils.getUserId());
            req.setValidStatus(Constants.VALID_STATUS_ENABLE);
            this.templateTenantGroupMapper.insert((Object)req);
        } else {
            this.templateTenantGroupMapper.updateById((Object)req);
        }
        return req.getId();
    }

    public QueryWrapper getGroupWrapper(TemplateTenantGroup req) {
        QueryWrapper condition = new QueryWrapper();
        ((QueryWrapper)condition.orderByDesc((Object)"valid_status")).orderByDesc((Object)"modify_time");
        if (StringUtils.isNotEmpty((CharSequence)req.getName())) {
            condition.like((Object)"name", (Object)req.getName());
        }
        if (null != req.getValidStatus()) {
            condition.eq((Object)"valid_status", (Object)req.getValidStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getCreateUserId())) {
            condition.eq((Object)"sub_user_id", (Object)req.getCreateUserId());
        }
        return condition;
    }

    public QueryWrapper getGroupItemWrapper(Long groupId) {
        QueryWrapper condition = new QueryWrapper();
        condition.orderByDesc((Object)"id");
        if (null != groupId) {
            condition.eq((Object)"group_id", (Object)groupId);
        }
        return condition;
    }

    @Transactional
    public Integer saveGroupTenant(TemplateTenantGroup req) {
        List tenantGroupItemList = this.templateTenantGroupItemMapper.selectList((Wrapper)this.getGroupItemWrapper(req.getId()));
        Map<Object, Object> groupItemMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)tenantGroupItemList)) {
            groupItemMap = tenantGroupItemList.stream().collect(Collectors.toMap(TemplateTenantGroupItem::getSubTenantId, Function.identity(), (a, b) -> a));
        }
        ArrayList<Long> isExistIds = new ArrayList<Long>();
        ArrayList<TemplateTenantGroupItem> addGroupItemList = new ArrayList<TemplateTenantGroupItem>();
        for (TemplateTenantGroupItem groupItem : req.getSubTenantList()) {
            TemplateTenantGroupItem groupItemDB = (TemplateTenantGroupItem)groupItemMap.get(groupItem.getSubTenantId());
            if (null == groupItemDB) {
                groupItem.setGroupId(req.getId());
                groupItem.setTenantId(Utils.getTenantId());
                groupItem.setCreateUserId(Utils.getUserId());
                groupItem.setCreateTime(DateUtils.getNowTime((String)""));
                groupItem.setModifyTime(DateUtils.getNowTime((String)""));
                groupItem.setModifyUserId(Utils.getUserId());
                addGroupItemList.add(groupItem);
                continue;
            }
            isExistIds.add(groupItemDB.getId());
        }
        if (CollectionUtils.isNotEmpty(isExistIds)) {
            this.templateTenantGroupItemMapper.delTenantBy(req.getId(), isExistIds);
        }
        if (CollectionUtils.isNotEmpty(addGroupItemList)) {
            this.templateTenantGroupItemMapper.batchInsert(addGroupItemList, req.getId());
        }
        return null;
    }

    public List<TemplateTenantGroupItem> queryGroupTenant(Long groupId) {
        List tenantGroupItemList = this.templateTenantGroupItemMapper.selectList((Wrapper)this.getGroupItemWrapper(groupId));
        return tenantGroupItemList;
    }

    public List<TemplateTenantGroup> selTenantGroup(TemplateTenantGroup req) {
        req.setCreateUserId(Utils.getUserId());
        List tenantGroupList = this.templateTenantGroupMapper.selectList((Wrapper)this.getGroupWrapper(req));
        return tenantGroupList;
    }

    public ResultPageBean pageQueryGroupTenant(TemplateQueryReq req) {
        List tenantGroupItemList = this.templateTenantGroupItemMapper.selectByParam(req.getGroupId(), req.getTenantNameId());
        ResultPageBean resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance(tenantGroupItemList.stream().skip((long)(req.getPageNum() - 1) * req.getPageSize().longValue()).limit(req.getPageSize().intValue()).collect(Collectors.toList()), (PageInfo)PageInfo.getPageInfo((Integer)req.getPageNum(), (Integer)req.getPageSize(), (Integer)tenantGroupItemList.size())));
        return resultPageBean;
    }

    @Transactional
    public Integer updateStatus(TemplateQueryReq req) {
        TemplateTenantGroup tenantGroup = new TemplateTenantGroup();
        tenantGroup.setValidStatus(req.getValidStatus());
        tenantGroup.setModifyTime(DateUtils.getNowTime((String)""));
        tenantGroup.setModifyUserId(Utils.getUserId());
        tenantGroup.setModifyUserName(Utils.getUserName());
        return this.templateTenantGroupMapper.updateStatus(tenantGroup, req.getIdList());
    }

    @Transactional
    public Integer delGroup(TemplateQueryReq req) {
        this.templateTenantGroupMapper.deleteById((Serializable)req.getId());
        this.templateTenantGroupItemMapper.delGroupItem(req.getId(), null);
        ArrayList<String> groupTenantIds = new ArrayList<String>();
        groupTenantIds.add(req.getId() + "");
        this.templateInfoTenantMapper.delTenantBy("", groupTenantIds, Constants.SelectTypeEnum.RELEASE_BY_GROUP.getFlag());
        return null;
    }

    @Transactional
    public Integer delGroupTenant(List<Long> idList) {
        return this.templateTenantGroupItemMapper.deleteBatchIds(idList);
    }

    public List<TemplateTenantGroup> selGroupBy(TemplateTenantGroup req) {
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"sub_user_id", (Object)Utils.getUserId());
        if (StringUtils.isNotEmpty((CharSequence)req.getName())) {
            condition.eq((Object)"name", (Object)req.getName());
        }
        if (null != req.getId()) {
            condition.ne((Object)"id", (Object)req.getId());
        }
        return this.templateTenantGroupMapper.selectList((Wrapper)condition);
    }
}

