/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.temp.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.TemplateQueryReq;
import com.digiwin.athena.semc.entity.temp.TemplateTenantGroup;
import com.digiwin.athena.semc.entity.temp.TemplateUserMapping;
import com.digiwin.athena.semc.entity.temp.TemplateUserTenant;
import com.digiwin.athena.semc.mapper.temp.TemplateInfoTenantMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateTenantGroupItemMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateTenantGroupMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateUserMappingMapper;
import com.digiwin.athena.semc.mapper.temp.TemplateUserTenantMapper;
import com.digiwin.athena.semc.service.temp.TemplateUserMappingService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TemplateUserMappingServiceImpl
extends ServiceImpl<TemplateUserMappingMapper, TemplateUserMapping>
implements TemplateUserMappingService {
    @Resource
    private TemplateUserMappingMapper templateUserMappingMapper;
    @Resource
    private TemplateUserTenantMapper templateUserTenantMapper;
    @Resource
    private TemplateTenantGroupMapper templateTenantGroupMapper;
    @Resource
    private TemplateTenantGroupItemMapper templateTenantGroupItemMapper;
    @Resource
    private TemplateInfoTenantMapper templateInfoTenantMapper;

    public List<TemplateUserMapping> selAllMappingUser(String subUserNameId) {
        List userMappingList = this.setectBy(null, subUserNameId);
        return userMappingList;
    }

    public List<TemplateUserMapping> setectBy(List<String> userIdList, String subUserNameId) {
        QueryWrapper condition = new QueryWrapper();
        ((QueryWrapper)condition.orderByDesc((Object)"modify_time")).orderByDesc((Object)"id");
        if (CollectionUtils.isNotEmpty(userIdList)) {
            condition.in((Object)"sub_user_id", userIdList);
        }
        if (StringUtils.isNotEmpty((CharSequence)subUserNameId)) {
            ((QueryWrapper)((QueryWrapper)condition.like((Object)"sub_user_id", (Object)subUserNameId)).or()).like((Object)"sub_user_name", (Object)subUserNameId);
        }
        List userMappingList = this.templateUserMappingMapper.selectList((Wrapper)condition);
        return userMappingList;
    }

    public List<TemplateUserTenant> selectByTenant(List<Long> mappingIdList, List<Long> notInIdList, Long mappingId) {
        QueryWrapper condition = new QueryWrapper();
        if (CollectionUtils.isNotEmpty(mappingIdList)) {
            condition.in((Object)"mapping_id", mappingIdList);
        }
        if (CollectionUtils.isNotEmpty(notInIdList)) {
            condition.notIn((Object)"id", notInIdList);
        }
        if (null != mappingId) {
            condition.eq((Object)"mapping_id", (Object)mappingId);
        }
        List userTenantList = this.templateUserTenantMapper.selectList((Wrapper)condition);
        return userTenantList;
    }

    public ResultPageBean pageQueryUserTenant(TemplateQueryReq req) {
        List userTenantList = this.templateUserTenantMapper.selectByParam(req.getId(), req.getTenantNameId());
        ResultPageBean resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance(userTenantList.stream().skip((long)(req.getPageNum() - 1) * req.getPageSize().longValue()).limit(req.getPageSize().intValue()).collect(Collectors.toList()), (PageInfo)PageInfo.getPageInfo((Integer)req.getPageNum(), (Integer)req.getPageSize(), (Integer)userTenantList.size())));
        return resultPageBean;
    }

    public ResultPageBean pageLongUserTenant(TemplateQueryReq req) {
        ArrayList<String> userIdList = new ArrayList<String>();
        userIdList.add(Utils.getUserId());
        List userMappingList = this.setectBy(userIdList, "");
        if (CollectionUtils.isEmpty((Collection)userMappingList)) {
            ResultPageBean resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance(userMappingList.stream().skip((long)(req.getPageNum() - 1) * req.getPageSize().longValue()).limit(req.getPageSize().intValue()).collect(Collectors.toList()), (PageInfo)PageInfo.getPageInfo((Integer)req.getPageNum(), (Integer)req.getPageSize(), (Integer)userMappingList.size())));
            return resultPageBean;
        }
        req.setId(((TemplateUserMapping)userMappingList.get(0)).getId());
        return this.pageQueryUserTenant(req);
    }

    public List<TemplateUserTenant> getLongUserTenant() {
        List<Object> userTenantList = new ArrayList<TemplateUserTenant>();
        ArrayList<String> userIdList = new ArrayList<String>();
        userIdList.add(Utils.getUserId());
        List userMappingList = this.setectBy(userIdList, "");
        if (CollectionUtils.isEmpty((Collection)userMappingList)) {
            return userTenantList;
        }
        userTenantList = this.queryUserAllTenant(((TemplateUserMapping)userMappingList.get(0)).getId());
        return userTenantList;
    }

    public List<TemplateUserTenant> queryUserAllTenant(Long id) {
        return this.templateUserTenantMapper.selectByParam(id, "");
    }

    @Transactional
    public Integer saveUserTenant(List<TemplateUserMapping> mappingList) {
        List userIdList = mappingList.stream().map(TemplateUserMapping::getSubUserId).collect(Collectors.toList());
        List userMappingList = this.setectBy(userIdList, "");
        Map<Object, Object> userMappingMap = new HashMap();
        Map<Object, Object> userTenantMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)userMappingList)) {
            userMappingMap = userMappingList.stream().collect(Collectors.toMap(TemplateUserMapping::getSubUserId, Function.identity(), (a, b) -> a));
            List mappingIdList = userMappingList.stream().map(TemplateUserMapping::getId).collect(Collectors.toList());
            List userTenantList = this.selectByTenant(mappingIdList, null, null);
            if (CollectionUtils.isNotEmpty((Collection)userTenantList)) {
                userTenantMap = userTenantList.stream().collect(Collectors.toMap(value -> value.getMappingId() + "-" + value.getSubTenantId(), value -> value, (key1, key2) -> key1));
            }
        }
        for (TemplateUserMapping mapping : mappingList) {
            TemplateUserMapping userMapping = (TemplateUserMapping)userMappingMap.get(mapping.getSubUserId());
            if (null == userMapping) {
                mapping.setCreateUserId(Utils.getUserId());
                mapping.setCreateUserName(Utils.getUserName());
                mapping.setCreateTime(DateUtils.getNowTime((String)""));
                this.templateUserMappingMapper.insert((Object)mapping);
                if (!CollectionUtils.isNotEmpty((Collection)mapping.getSubTenantList())) continue;
                this.templateUserTenantMapper.batchInsert(mapping.getSubTenantList(), mapping.getId());
                continue;
            }
            this.templateUserMappingMapper.updateById((Object)userMapping);
            ArrayList<Long> isExistIds = new ArrayList<Long>();
            ArrayList<TemplateUserTenant> addTeanantList = new ArrayList<TemplateUserTenant>();
            for (TemplateUserTenant userTenant : mapping.getSubTenantList()) {
                TemplateUserTenant userTenantDB = (TemplateUserTenant)userTenantMap.get(userMapping.getId() + "-" + userTenant.getSubTenantId());
                if (null != userTenantDB) {
                    isExistIds.add(userTenantDB.getId());
                    continue;
                }
                addTeanantList.add(userTenant);
            }
            List userTenantList = this.selectByTenant(null, isExistIds, userMapping.getId());
            if (CollectionUtils.isNotEmpty((Collection)userTenantList)) {
                List delIdList = userTenantList.stream().map(TemplateUserTenant::getId).collect(Collectors.toList());
                this.templateUserTenantMapper.deleteBatchIds(delIdList);
            }
            if (!CollectionUtils.isNotEmpty(addTeanantList)) continue;
            this.templateUserTenantMapper.batchInsert(addTeanantList, userMapping.getId());
        }
        return null;
    }

    public QueryWrapper getUserTenantWrapper(Long mappingId) {
        QueryWrapper condition = new QueryWrapper();
        if (null != mappingId) {
            condition.eq((Object)"mapping_id", (Object)mappingId);
        }
        return condition;
    }

    @Transactional
    public Integer delUserMapping(Long id) {
        TemplateUserMapping userMapping = (TemplateUserMapping)this.templateUserMappingMapper.selectById((Serializable)id);
        if (null == userMapping) {
            return null;
        }
        List userTenantList = this.templateUserTenantMapper.selectList((Wrapper)this.getUserTenantWrapper(id));
        this.templateUserMappingMapper.deleteById((Serializable)id);
        this.templateUserTenantMapper.delete((Wrapper)this.getUserTenantWrapper(id));
        List tenantGroupList = this.templateTenantGroupMapper.selectTenantGroup(userMapping.getSubUserId());
        if (CollectionUtils.isNotEmpty((Collection)tenantGroupList)) {
            List groupIdList = tenantGroupList.stream().map(TemplateTenantGroup::getId).collect(Collectors.toList());
            this.templateTenantGroupItemMapper.batDelGroupItem(groupIdList, null);
        }
        if (CollectionUtils.isNotEmpty((Collection)userTenantList)) {
            List subTenantIdList = userTenantList.stream().map(TemplateUserTenant::getSubTenantId).collect(Collectors.toList());
            this.templateInfoTenantMapper.delTenantBy(userMapping.getSubUserId(), subTenantIdList, Constants.SelectTypeEnum.RELEASE_BY_TENANT.getFlag());
        }
        return null;
    }

    @Transactional
    public Integer delUserTenant(List<Long> idList) {
        List userTenantList = this.templateUserTenantMapper.selectBatchIds(idList);
        if (CollectionUtils.isEmpty((Collection)userTenantList)) {
            return null;
        }
        List subTenantIdList = userTenantList.stream().map(TemplateUserTenant::getSubTenantId).collect(Collectors.toList());
        TemplateUserMapping userMapping = (TemplateUserMapping)this.templateUserMappingMapper.selectById((Serializable)((TemplateUserTenant)userTenantList.get(0)).getMappingId());
        if (null == userMapping) {
            return null;
        }
        this.templateUserTenantMapper.deleteBatchIds(idList);
        List tenantGroupList = this.templateTenantGroupMapper.selectTenantGroup(userMapping.getSubUserId());
        if (CollectionUtils.isNotEmpty((Collection)tenantGroupList)) {
            List groupIdList = tenantGroupList.stream().map(TemplateTenantGroup::getId).collect(Collectors.toList());
            this.templateTenantGroupItemMapper.batDelGroupItem(groupIdList, subTenantIdList);
        }
        this.templateInfoTenantMapper.delTenantBy(userMapping.getSubUserId(), subTenantIdList, Constants.SelectTypeEnum.RELEASE_BY_TENANT.getFlag());
        return null;
    }
}

