/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.tenant.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.semc.annotate.AttributeExtraService;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.enums.AttributeDataTypeEnum;
import com.digiwin.athena.semc.dto.config.TenantAttributeDto;
import com.digiwin.athena.semc.entity.tenant.TenantAttributeDef;
import com.digiwin.athena.semc.entity.tenant.TenantAttributeValue;
import com.digiwin.athena.semc.mapper.tenant.TenantAttributeDefMapper;
import com.digiwin.athena.semc.mapper.tenant.TenantAttributeValueMapper;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.tenant.TenantAttributeExtraService;
import com.digiwin.athena.semc.service.tenant.impl.BaseTenantAttributeService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Objects;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class BaseTenantAttributeService
extends ServiceImpl<TenantAttributeValueMapper, TenantAttributeValue> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseTenantAttributeService.class);
    @Resource
    protected TenantAttributeDefMapper tenantAttributeDefMapper;
    @Resource
    protected MessageUtils messageUtils;
    @Resource
    private TenantAttributeExtraService tenantAttributeExtraService;
    @Resource
    private TranslateService translateService;

    protected TenantAttributeDef queryAttributeDef(String attributeCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TenantAttributeDef::getAttributeCode, (Object)attributeCode);
        return (TenantAttributeDef)this.tenantAttributeDefMapper.selectOne((Wrapper)queryWrapper);
    }

    protected TenantAttributeDto<Object> queryAttributeValue(String attributeCode) {
        Object attributeValue;
        TenantAttributeDto tenantAttribute = new TenantAttributeDto();
        tenantAttribute.setAttributeCode(attributeCode);
        TenantAttributeDef tenantAttributeDef = this.queryAttributeDef(attributeCode);
        if (Objects.isNull(tenantAttributeDef)) {
            return tenantAttribute;
        }
        String attributeName = this.translateService.translateTextCache(tenantAttributeDef.getAttributeName(), "");
        tenantAttribute.setAttributeName(attributeName);
        tenantAttribute.setRequired(tenantAttributeDef.getRequired());
        TenantAttributeValue tenantAttributeValue = (TenantAttributeValue)this.getOne((Wrapper)new LambdaQueryWrapper().eq(TenantAttributeValue::getAttributeId, (Object)tenantAttributeDef.getId()));
        if (Objects.isNull(tenantAttributeValue)) {
            attributeValue = this.defaultValue(tenantAttributeDef);
        } else {
            tenantAttribute.setAttributeId(tenantAttributeValue.getId());
            AttributeDataTypeEnum attributeDataTypeEnum = AttributeDataTypeEnum.fromCode((String)tenantAttributeDef.getDataType());
            attributeValue = Objects.nonNull(attributeDataTypeEnum) ? this.extractAttributeValue(tenantAttributeValue, attributeDataTypeEnum) : null;
        }
        tenantAttribute.setAttributeValue(attributeValue);
        return tenantAttribute;
    }

    private Object defaultValue(TenantAttributeDef tenantAttributeDef) {
        try {
            AttributeDataTypeEnum attributeDataTypeEnum = AttributeDataTypeEnum.fromCode((String)tenantAttributeDef.getDataType());
            if (Objects.nonNull(tenantAttributeDef.getDefaultValue()) && Objects.nonNull(attributeDataTypeEnum)) {
                switch (1.$SwitchMap$com$digiwin$athena$semc$common$enums$AttributeDataTypeEnum[attributeDataTypeEnum.ordinal()]) {
                    case 1: {
                        return BooleanUtils.toBooleanObject((String)tenantAttributeDef.getDefaultValue());
                    }
                    case 2: 
                    case 3: {
                        return tenantAttributeDef.getDefaultValue();
                    }
                    case 4: {
                        return NumberUtils.createInteger((String)tenantAttributeDef.getDefaultValue());
                    }
                    case 5: {
                        return new BigDecimal(tenantAttributeDef.getDefaultValue());
                    }
                    case 6: {
                        return DateUtils.StringToDate((String)tenantAttributeDef.getDefaultValue());
                    }
                }
                return null;
            }
        }
        catch (Exception e) {
            log.error("BaseTenantAttributeService.defaultValue error defaultValue:{}", (Object)tenantAttributeDef.getDefaultValue(), (Object)e);
        }
        return null;
    }

    private Object extractAttributeValue(TenantAttributeValue value, AttributeDataTypeEnum type) {
        switch (1.$SwitchMap$com$digiwin$athena$semc$common$enums$AttributeDataTypeEnum[type.ordinal()]) {
            case 1: {
                return value.getBooleanValue();
            }
            case 2: {
                return value.getVarcharValue();
            }
            case 4: {
                return value.getIntValue();
            }
            case 6: {
                return value.getDatetimeValue();
            }
            case 5: {
                return value.getDecimalValue();
            }
        }
        return null;
    }

    public ResponseEntity<BaseResultDTO<Object>> saveOrUpdateAttributeValue(TenantAttributeDto<?> attribute) {
        TenantAttributeValue tenantAttributeValue;
        TenantAttributeDef tenantAttributeDef = this.queryAttributeDef(attribute.getAttributeCode());
        if (Objects.isNull(tenantAttributeDef)) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-illegal"));
        }
        AttributeDataTypeEnum attributeDataTypeEnum = AttributeDataTypeEnum.fromCode((String)tenantAttributeDef.getDataType());
        if (Objects.isNull(attributeDataTypeEnum)) {
            log.error("attributeDataType is error DataType:{}", (Object)tenantAttributeDef.getDataType());
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-illegal"));
        }
        Object attributeValue = this.convertAttributeValue(attribute, attributeDataTypeEnum);
        if (Objects.isNull(attributeValue) || !attributeDataTypeEnum.getDataType().isInstance(attributeValue)) {
            return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-illegal"));
        }
        if (Objects.nonNull(attribute.getAttributeId())) {
            tenantAttributeValue = (TenantAttributeValue)this.getById((Serializable)attribute.getAttributeId());
            if (Objects.isNull(tenantAttributeValue)) {
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-illegal"));
            }
        } else {
            tenantAttributeValue = TenantAttributeValue.builder().attributeId(tenantAttributeDef.getId()).build();
        }
        this.buildAttributeValue(tenantAttributeValue, attributeDataTypeEnum, attributeValue);
        BaseResultDTO attributedCheck = this.attributeCheck(tenantAttributeDef, tenantAttributeValue);
        if (!attributedCheck.isOK()) {
            return ResponseEntity.ok((Object)attributedCheck);
        }
        String nowTime = DateUtils.getNowTime((String)"");
        if (Objects.nonNull(tenantAttributeValue.getId())) {
            tenantAttributeValue.setModifyTime(nowTime);
            tenantAttributeValue.setModifyUserId(Utils.getUserId());
            this.updateById((Object)tenantAttributeValue);
        } else {
            tenantAttributeValue.setTenantId(Utils.getTenantId());
            tenantAttributeValue.setCreateUserId(Utils.getUserId());
            tenantAttributeValue.setCreateTime(nowTime);
            tenantAttributeValue.setModifyTime(nowTime);
            tenantAttributeValue.setModifyUserId(Utils.getUserId());
            this.save((Object)tenantAttributeValue);
        }
        attribute.setAttributeId(tenantAttributeValue.getId());
        return ResponseEntityWrapperUtil.wrapperOk(attribute);
    }

    private void buildAttributeValue(TenantAttributeValue attribute, AttributeDataTypeEnum dataType, Object value) {
        switch (1.$SwitchMap$com$digiwin$athena$semc$common$enums$AttributeDataTypeEnum[dataType.ordinal()]) {
            case 1: {
                attribute.setBooleanValue((Boolean)value);
                break;
            }
            case 2: {
                attribute.setVarcharValue((String)value);
                break;
            }
            case 4: {
                attribute.setIntValue((Integer)value);
                break;
            }
            case 6: {
                attribute.setDatetimeValue((Date)value);
                break;
            }
            case 5: {
                attribute.setDecimalValue((Double)value);
            }
        }
    }

    private Object convertAttributeValue(TenantAttributeDto<?> attribute, AttributeDataTypeEnum dataType) {
        Object attributeValue = attribute.getAttributeValue();
        try {
            if (Objects.isNull(attributeValue) || dataType.getDataType().isInstance(attribute.getAttributeValue())) {
                return attributeValue;
            }
            if (attributeValue instanceof String) {
                switch (1.$SwitchMap$com$digiwin$athena$semc$common$enums$AttributeDataTypeEnum[dataType.ordinal()]) {
                    case 1: {
                        attributeValue = BooleanUtils.toBooleanObject((String)((String)attributeValue));
                        break;
                    }
                    case 4: {
                        attributeValue = NumberUtils.createInteger((String)((String)attributeValue));
                        break;
                    }
                    case 5: {
                        attributeValue = NumberUtils.createDouble((String)((String)attributeValue));
                        break;
                    }
                    case 6: {
                        attributeValue = DateUtils.StringToDate((String)((String)attributeValue));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("BaseTenantAttributeService.convertValue error attributeValue:{}", attributeValue, (Object)e);
        }
        return attributeValue;
    }

    private BaseResultDTO<Object> attributeCheck(TenantAttributeDef tenantAttributeDef, TenantAttributeValue tenantAttributeValue) {
        String code = null;
        try {
            Method[] methods;
            code = tenantAttributeDef.getAttributeCode();
            Class<?> cls = this.tenantAttributeExtraService.getClass();
            for (Method method : methods = cls.getDeclaredMethods()) {
                AttributeExtraService attributeCheckService = method.getAnnotation(AttributeExtraService.class);
                if (!Objects.nonNull(attributeCheckService) || !attributeCheckService.code().equals(code) || attributeCheckService.type() != 0) continue;
                try {
                    return (BaseResultDTO)method.invoke((Object)this.tenantAttributeExtraService, tenantAttributeDef, tenantAttributeValue);
                }
                catch (Exception ex) {
                    log.error("BaseTenantAttributeService.attributeCheck.invoke is error code\uff1a{}", (Object)code, (Object)ex);
                    return this.checkError();
                }
            }
            BaseResultDTO result = new BaseResultDTO();
            result.setStatus(Integer.valueOf(HttpStatus.OK.value()));
            result.setStatusDescription(HttpStatus.OK.getReasonPhrase());
            return result;
        }
        catch (Exception ex) {
            log.error("BaseTenantAttributeService.attributeCheck is error code\uff1a{}", (Object)code, (Object)ex);
            return this.checkError();
        }
    }

    private BaseResultDTO<Object> checkError() {
        BaseResultDTO result = new BaseResultDTO();
        result.setStatus(Integer.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.value()));
        result.setStatusDescription(HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
        result.setErrorCode(String.valueOf(ErrorCodeConstant.PARAM_ILLEGAL_ERROR));
        result.setErrorMessage((Object)this.messageUtils.getMessage("error.message.common.param-illegal"));
        return result;
    }
}

