/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.tenant.impl;

import com.digiwin.athena.semc.dto.config.TenantAttributeDto;
import com.digiwin.athena.semc.service.cache.ICacheService;
import com.digiwin.athena.semc.service.tenant.TenantAppService;
import com.digiwin.athena.semc.service.tenant.TenantAttributeService;
import com.digiwin.athena.semc.vo.tenant.TenantSalesPlanVO;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TenantAppServiceImpl
implements TenantAppService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantAppServiceImpl.class);
    private static final String OM_PRODUCT_CODE_ASA = "ASA";
    private static final String TENANT_ATTR_CODE_SALESPLAN = "tenantSalesPlan";
    @Resource
    private TenantAttributeService tenantAttributeService;
    @Resource
    private ICacheService cacheService;

    public TenantSalesPlanVO queryTenantSalesPlan(String tenantId) {
        TenantSalesPlanVO tenantSalesPlan = null;
        String cacheTenantSalesPlan = this.cacheService.getValue("TenantSalesPlan:" + tenantId);
        if (null != cacheTenantSalesPlan) {
            if (StringUtils.isNotBlank((CharSequence)cacheTenantSalesPlan)) {
                tenantSalesPlan = new TenantSalesPlanVO();
                tenantSalesPlan.setTenantId(tenantId);
                tenantSalesPlan.setSalesPlan(cacheTenantSalesPlan);
            }
        } else {
            TenantAttributeDto tenantSalesPlanAttr = this.tenantAttributeService.queryTenantAttributeByCode(TENANT_ATTR_CODE_SALESPLAN);
            Object tenantAttrValue = tenantSalesPlanAttr.getAttributeValue();
            if (tenantAttrValue != null && StringUtils.isNotBlank((CharSequence)tenantAttrValue.toString())) {
                String salesPlan = tenantAttrValue.toString();
                tenantSalesPlan = new TenantSalesPlanVO();
                tenantSalesPlan.setTenantId(tenantId);
                tenantSalesPlan.setSalesPlan(salesPlan);
                this.cacheService.cache("TenantSalesPlan:" + tenantId, salesPlan);
            } else {
                this.cacheService.cache("TenantSalesPlan:" + tenantId, "");
            }
        }
        return tenantSalesPlan;
    }

    public boolean isOnlyAsaSalesPlan(String tenantId) {
        TenantSalesPlanVO tenantSalesPlan = this.queryTenantSalesPlan(tenantId);
        boolean isOnlyAsa = false;
        if (tenantSalesPlan != null && OM_PRODUCT_CODE_ASA.equals(tenantSalesPlan.getSalesPlan())) {
            isOnlyAsa = true;
        }
        return isOnlyAsa;
    }
}

