/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.utils;

import com.digiwin.athena.appcore.constant.ErrorTypeEnum;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ValidationMsgUtil {
    private static final String REQUIRED = "Required";
    private static final String LENGTH_MAX = "LengthMax";
    private static final String LENGTH_MIN = "LengthMin";
    private static final String LENGTH_RANGE = "LengthRange";
    private static MessageInterpolator interpolator;
    private static Validator validator;

    public ValidationMsgUtil(LocalValidatorFactoryBean localValidatorFactoryBean) {
        interpolator = localValidatorFactoryBean.getMessageInterpolator();
        validator = localValidatorFactoryBean.getValidator();
    }

    public static <T> Set<ConstraintViolation<T>> validate(T obj) {
        return validator.validate(obj, new Class[0]);
    }

    public static <T> BaseResultDTO<String> validateFirst(T obj) {
        List actionedValidate = ValidationMsgUtil.actionValidate(obj);
        BaseResultDTO result = new BaseResultDTO();
        if (CollectionUtils.isNotEmpty((Collection)actionedValidate)) {
            result.setErrorType(ErrorTypeEnum.BUSINESS.getValue());
            result.setErrorCode(String.valueOf(ErrorCodeConstant.PARAM_MISSING_ERROR));
            result.setErrorMessage(actionedValidate.get(0));
            result.setStatus(Integer.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.value()));
        } else {
            result.setStatus(Integer.valueOf(HttpStatus.OK.value()));
            result.setStatusDescription(HttpStatus.OK.getReasonPhrase());
        }
        return result;
    }

    public static <T> BaseResultDTO<String> validateAll(T obj, String splice) {
        List actionedValidate = ValidationMsgUtil.actionValidate(obj);
        BaseResultDTO result = new BaseResultDTO();
        if (CollectionUtils.isNotEmpty((Collection)actionedValidate)) {
            result.setErrorType(ErrorTypeEnum.BUSINESS.getValue());
            result.setErrorCode(String.valueOf(ErrorCodeConstant.PARAM_MISSING_ERROR));
            result.setErrorMessage((Object)Joiner.on((String)(Objects.isNull(splice) ? ";" : splice)).join((Iterable)actionedValidate));
            result.setStatus(Integer.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.value()));
        } else {
            result.setStatus(Integer.valueOf(HttpStatus.OK.value()));
            result.setStatusDescription(HttpStatus.OK.getReasonPhrase());
        }
        return result;
    }

    private static <T> List<String> actionValidate(T obj) {
        Set violations = ValidationMsgUtil.validate(obj);
        if (!violations.isEmpty()) {
            return violations.stream().map(ConstraintViolation::getMessage).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @SafeVarargs
    public static String getMessage(String template, Pair<String, Object> ... attributes) {
        return ValidationMsgUtil.interpolate((String)template, (Map)ValidationMsgUtil.buildAttributes(attributes));
    }

    @SafeVarargs
    public static String getValidMsg(String key, Pair<String, Object> ... attributes) {
        return ValidationMsgUtil.interpolate((String)ValidationMsgUtil.buildKey((String)key), (MessageInterpolator.Context)ValidationMsgUtil.buildContext((ConstraintDescriptor)ValidationMsgUtil.buildNotNull((Map)ValidationMsgUtil.buildAttributes(attributes))));
    }

    @SafeVarargs
    public static String validRequired(String key, Pair<String, Object> ... attributes) {
        return ValidationMsgUtil.interpolate((String)ValidationMsgUtil.buildKeys((String[])new String[]{key, "Required"}), (MessageInterpolator.Context)ValidationMsgUtil.buildContext((ConstraintDescriptor)ValidationMsgUtil.buildNotNull((Map)ValidationMsgUtil.buildAttributes(attributes))));
    }

    @SafeVarargs
    public static String validLengthMax(String key, int max, Pair<String, Object> ... attributes) {
        return ValidationMsgUtil.interpolate((String)ValidationMsgUtil.buildKeys((String[])new String[]{key, "LengthMax"}), (MessageInterpolator.Context)ValidationMsgUtil.buildContext((ConstraintDescriptor)ValidationMsgUtil.buildSize(null, (Integer)max, (Map)ValidationMsgUtil.buildAttributes(attributes))));
    }

    @SafeVarargs
    public static String validLengthMin(String key, int min, Pair<String, Object> ... attributes) {
        return ValidationMsgUtil.interpolate((String)ValidationMsgUtil.buildKeys((String[])new String[]{key, "LengthMin"}), (MessageInterpolator.Context)ValidationMsgUtil.buildContext((ConstraintDescriptor)ValidationMsgUtil.buildSize((Integer)min, null, (Map)ValidationMsgUtil.buildAttributes(attributes))));
    }

    @SafeVarargs
    public static String validLengthRange(String key, int min, int max, Pair<String, Object> ... attributes) {
        return ValidationMsgUtil.interpolate((String)ValidationMsgUtil.buildKeys((String[])new String[]{key, "LengthRange"}), (MessageInterpolator.Context)ValidationMsgUtil.buildContext((ConstraintDescriptor)ValidationMsgUtil.buildSize((Integer)min, (Integer)max, (Map)ValidationMsgUtil.buildAttributes(attributes))));
    }

    public static String buildKeys(String ... keys) {
        if (ArrayUtils.isNotEmpty((Object[])keys)) {
            StringBuilder key = new StringBuilder();
            for (String s : keys) {
                key.append(ValidationMsgUtil.buildKey((String)s));
            }
            return key.toString();
        }
        return null;
    }

    public static String buildKey(String key) {
        return "{" + key + "}";
    }

    @SafeVarargs
    public static Map<String, Object> buildAttributes(Pair<String, Object> ... attributes) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (ArrayUtils.isNotEmpty((Object[])attributes)) {
            for (Pair<String, Object> attribute : attributes) {
                if (!Objects.nonNull(attribute) || !StringUtils.isNotBlank((CharSequence)((CharSequence)attribute.getKey()))) continue;
                params.put((String)attribute.getKey(), attribute.getValue());
            }
        }
        return params;
    }

    private static MessageInterpolator.Context buildContext(ConstraintDescriptor<?> constraintDescriptor) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static String interpolate(String template, MessageInterpolator.Context context) {
        return interpolator.interpolate(template, context, LocaleContextHolder.getLocale());
    }

    private static String interpolate(String template, Map<String, Object> attributes) {
        return interpolator.interpolate(template, ValidationMsgUtil.buildContext((ConstraintDescriptor)ValidationMsgUtil.buildNotNull(attributes)), LocaleContextHolder.getLocale());
    }

    public static ConstraintDescriptor<NotNull> buildNotNull(Map<String, Object> attributes) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static ConstraintDescriptor<Size> buildSize(Integer min, Integer max, Map<String, Object> attributes) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

