/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.workbench.designer.service;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.portal.PortalContentCarouselImage;
import com.digiwin.athena.semc.dto.workbench.req.WorkbenchDeployAppReqDto;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuTemplate;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuWork;
import com.digiwin.athena.semc.entity.portal.AppCustomSetting;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.PortalContentCarousel;
import com.digiwin.athena.semc.entity.portal.PortalDeployMessage;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.portal.PortalInfoContent;
import com.digiwin.athena.semc.entity.portal.RelatedApp;
import com.digiwin.athena.semc.service.menu.CustomizedMenuTemplateService;
import com.digiwin.athena.semc.service.menu.CustomizedMenuWorkService;
import com.digiwin.athena.semc.service.portal.AppCustomSettingService;
import com.digiwin.athena.semc.service.portal.LabelSystemCustomService;
import com.digiwin.athena.semc.service.portal.PortalDeployMessageService;
import com.digiwin.athena.semc.service.portal.PortalInfoContentService;
import com.digiwin.athena.semc.service.portal.PortalInfoService;
import com.digiwin.athena.semc.service.portal.RelatedAppService;
import com.digiwin.athena.semc.service.workbench.constant.EnvOperateEnum;
import com.digiwin.athena.semc.service.workbench.constant.MenuItemTypeEnum;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchAppCustomSetting;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchComponent;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchMenu;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchMenuItem;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchPortal;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchPortalContent;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchRelatedApp;
import com.digiwin.athena.semc.service.workbench.designer.po.WorkbenchDesignerData;
import com.digiwin.athena.semc.service.workbench.designer.service.AbstractWorkbenchDeployHandler;
import com.digiwin.athena.semc.service.workbench.util.WorkbenchSyncDataConverter;
import com.digiwin.athena.semc.service.workbench.util.WorkbenchUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkbenchDeployHandler
extends AbstractWorkbenchDeployHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkbenchDeployHandler.class);
    @Autowired
    private AppCustomSettingService appCustomSettingService;
    @Autowired
    private RelatedAppService relatedAppService;
    @Autowired
    private LabelSystemCustomService customComponentService;
    @Autowired
    private PortalInfoService portalService;
    @Autowired
    private PortalInfoContentService portalContentService;
    @Autowired
    private CustomizedMenuTemplateService menuService;
    @Autowired
    private CustomizedMenuWorkService menuItemService;
    @Autowired
    private PortalDeployMessageService portalDeployMessageService;

    public void deploy(WorkbenchDeployAppReqDto deployAppReq, WorkbenchDesignerData designerData) {
        String application = deployAppReq.getApplication();
        String version = EnvOperateEnum.PUBLISH.getVersion();
        String compileVersion = deployAppReq.getCompileNo();
        this.deployCustomSettings(application, version, designerData.getCustomSettings());
        this.deployRelatedApps(application, version, designerData.getRelatedApps());
        this.deployComponents(application, compileVersion, version, designerData.getComponents());
        this.deployPortals(application, compileVersion, version, designerData);
        this.uploadCarousel(designerData.getPortalContents(), designerData.getCarouselFiles());
        this.deletePortalDeployMessages(application, designerData.getPortals(), version);
    }

    private void uploadCarousel(List<WorkBenchPortalContent> portalContents, File[] carouselFiles) {
        HashMap map = Maps.newHashMap();
        if (null != carouselFiles) {
            for (File file : carouselFiles) {
                String fileName = file.getName();
                String fileId = StringUtils.substring((String)fileName, (int)0, (int)StringUtils.lastIndexOf((CharSequence)fileName, (int)46));
                map.put(fileId, file);
            }
        }
        for (WorkBenchPortalContent workBenchPortalContent : portalContents) {
            PortalContentCarousel carouselInfo = workBenchPortalContent.getCarouselInfo();
            if (null == carouselInfo) continue;
            List imageList = carouselInfo.getImageList();
            for (PortalContentCarouselImage portalContentCarouselImage : imageList) {
                File file;
                if (Objects.equals(0, portalContentCarouselImage.getImgType()) || Objects.isNull(file = (File)map.get(portalContentCarouselImage.getFileId()))) continue;
                this.uploadThumbnail(file, portalContentCarouselImage.getFileId());
            }
        }
    }

    private void deletePortalDeployMessages(String application, List<WorkBenchPortal> portals, String version) {
        if (CollectionUtils.isEmpty(portals)) {
            log.info("{}\u65e0\u6709\u6548\u5185\u5bb9\u9879\u3001\u83dc\u5355\u9879\uff0c\u8df3\u51fa\u5165\u5e93\u672a\u8bfb\u6d88\u606f", (Object)application);
            return;
        }
        Set portalDesignerIds = portals.stream().map(e -> e.getId()).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(portalDesignerIds)) {
            return;
        }
        LambdaQueryWrapper lambdaQueryWrappernew = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrappernew.in(PortalDeployMessage::getPortalId, portalDesignerIds)).eq(PortalDeployMessage::getVersion, (Object)version);
        this.portalDeployMessageService.remove((Wrapper)lambdaQueryWrappernew);
    }

    private void deployPortals(String application, String compileVersion, String version, WorkbenchDesignerData designerData) {
        if (CollectionUtils.isEmpty((Collection)designerData.getPortals())) {
            log.info("\u7f16\u8bd1\u5305\u6ca1\u6709\u95e8\u6237\u6570\u636e\uff0c\u65e0\u9700\u53d1\u7248\u95e8\u6237");
            return;
        }
        List allPortal = this.deployPortal(application, compileVersion, version, designerData.getPortals());
        this.deployPortalContents(application, compileVersion, version, designerData.getPortalContents(), allPortal);
        this.deployMenus(application, compileVersion, version, designerData.getMenus(), designerData.getMenuItems());
        this.uploadThumbnail(designerData.getThumbnailFiles(), allPortal);
    }

    private List<PortalInfo> deployPortal(String application, String compileVersion, String version, List<WorkBenchPortal> portals) {
        List addDesPortalIdList;
        List deleteDesPortalIds;
        Map desPortalMap = portals.stream().collect(Collectors.toMap(WorkBenchPortal::getId, Function.identity()));
        List existPortals = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.portalService.lambdaQuery().eq(PortalInfo::getWorkbenchAppCode, (Object)application)).eq(PortalInfo::getVersion, (Object)version)).list();
        Map existPortalMap = existPortals.stream().collect(Collectors.toMap(PortalInfo::getPortalDesignerId, Function.identity()));
        if (StringUtils.isNotEmpty((CharSequence)compileVersion) && CollectionUtils.isNotEmpty((Collection)(deleteDesPortalIds = CollectionUtil.subtractToList(existPortalMap.keySet(), desPortalMap.keySet())))) {
            this.portalService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(PortalInfo::getPortalDesignerId, (Collection)deleteDesPortalIds)).eq(PortalInfo::getWorkbenchAppCode, (Object)application)).eq(PortalInfo::getVersion, (Object)version));
        }
        ArrayList<PortalInfo> allPortal = new ArrayList<PortalInfo>();
        Set updateDesPortalIdSet = CollectionUtil.intersectionDistinct(desPortalMap.keySet(), existPortalMap.keySet(), (Collection[])new Collection[0]);
        if (CollectionUtils.isNotEmpty((Collection)updateDesPortalIdSet)) {
            List existPortalList = updateDesPortalIdSet.stream().map(desPortalId -> WorkbenchSyncDataConverter.toUpdatePortal((PortalInfo)((PortalInfo)existPortalMap.get(desPortalId)), (WorkBenchPortal)((WorkBenchPortal)desPortalMap.get(desPortalId)), (String)compileVersion)).collect(Collectors.toList());
            this.portalService.updateBatchById(existPortalList);
            allPortal.addAll(existPortalList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(addDesPortalIdList = CollectionUtil.subtractToList(desPortalMap.keySet(), existPortalMap.keySet())))) {
            List addPortalList = addDesPortalIdList.stream().map(desPortalId -> WorkbenchSyncDataConverter.toNewPortal((WorkBenchPortal)((WorkBenchPortal)desPortalMap.get(desPortalId)), (String)version, (String)compileVersion, (Long)((WorkBenchPortal)desPortalMap.get(desPortalId)).getMenuId())).collect(Collectors.toList());
            this.portalService.saveBatch(addPortalList);
            allPortal.addAll(addPortalList);
        }
        log.info("\u53d1\u7248\u95e8\u6237\u5b8c\u6210");
        return allPortal;
    }

    private void deployPortalContents(String application, String compileVersion, String version, List<WorkBenchPortalContent> desPortalContents, List<PortalInfo> allPortal) {
        if (CollectionUtils.isEmpty(desPortalContents)) {
            log.info("\u7f16\u8bd1\u5305\u6ca1\u6709\u95e8\u6237\u5185\u5bb9\u6570\u636e\uff0c\u65e0\u9700\u53d1\u7248\u95e8\u6237\u5185\u5bb9");
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)compileVersion)) {
            this.portalContentService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PortalInfoContent::getWorkbenchAppCode, (Object)application)).eq(PortalInfoContent::getVersion, (Object)version));
        } else {
            List portalContentDesIds = desPortalContents.stream().map(portalContent -> portalContent.getId()).collect(Collectors.toList());
            this.portalContentService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PortalInfoContent::getWorkbenchAppCode, (Object)application)).eq(PortalInfoContent::getVersion, (Object)version)).in(PortalInfoContent::getDesignerId, portalContentDesIds));
        }
        Map portalIdMap = allPortal.stream().collect(Collectors.toMap(PortalInfo::getPortalDesignerId, Function.identity()));
        ArrayList addNewPortalContentList = new ArrayList();
        List<WorkBenchPortalContent> sortedList = desPortalContents.stream().sorted(Comparator.comparing(WorkBenchPortalContent::getId)).collect(Collectors.toList());
        sortedList.forEach(desPortalContent -> {
            log.info("\u5f00\u59cb\u5904\u7406\u95e8\u6237\u5185\u5bb9\uff1a{}", (Object)desPortalContent.getId());
            PortalInfoContent portalContent = WorkbenchSyncDataConverter.toNewPortalContent((String)application, (WorkBenchPortalContent)desPortalContent, (Long)((PortalInfo)portalIdMap.get(desPortalContent.getPortalId())).getId(), (String)version);
            if (WorkbenchUtils.isPreComponent((WorkBenchPortalContent)desPortalContent)) {
                portalContent.setContentType(desPortalContent.getContentType());
                portalContent.setDataType(desPortalContent.getContentSubType());
            } else if (Constants.ClientTypeEnum.PC.getValue() == ((PortalInfo)portalIdMap.get(desPortalContent.getPortalId())).getClientType()) {
                if (WorkbenchUtils.isCustomComponent((WorkBenchPortalContent)desPortalContent)) {
                    portalContent.setContentId(desPortalContent.getContentId());
                }
            } else if (WorkbenchUtils.isMobileCustomComponent((WorkBenchPortalContent)desPortalContent)) {
                portalContent.setContentId(desPortalContent.getContentId());
            }
            addNewPortalContentList.add(portalContent);
        });
        this.portalContentService.saveBatch(addNewPortalContentList);
        log.info("\u53d1\u7248\u95e8\u6237\u5185\u5bb9\u5b8c\u6210");
    }

    private void deployMenus(String application, String compileVersion, String version, List<WorkBenchMenu> desMenus, List<WorkBenchMenuItem> desMenuItems) {
        List allMenuTemplates = this.deployMenuTemplates(application, compileVersion, version, desMenus);
        this.deployMenuItems(application, compileVersion, version, desMenuItems, allMenuTemplates);
    }

    private void uploadThumbnail(File[] thumbnailFiles, List<PortalInfo> allPortal) {
        if (CollectionUtils.isEmpty(allPortal)) {
            log.info("\u7f16\u8bd1\u5305\u6ca1\u6709\u7f29\u7565\u56fe\u6570\u636e\uff0c\u65e0\u9700\u4e0b\u8f7d\u7f29\u7565\u56fe");
            return;
        }
        HashMap map = Maps.newHashMap();
        for (File file : thumbnailFiles) {
            String fileName = file.getName();
            String fileId = StringUtils.substring((String)fileName, (int)0, (int)StringUtils.lastIndexOf((CharSequence)fileName, (int)46));
            map.put(fileId, file);
        }
        for (PortalInfo portalInfo : allPortal) {
            File file;
            String portalImgId = portalInfo.getPortalImgId();
            file = (File)map.get(portalImgId);
            if (Objects.isNull(file)) continue;
            this.uploadThumbnail(file, portalImgId);
        }
    }

    private List<CustomizedMenuTemplate> deployMenuTemplates(String application, String compileVersion, String version, List<WorkBenchMenu> desMenus) {
        List addDesMenuIdList;
        if (CollectionUtils.isEmpty(desMenus)) {
            log.info("\u7f16\u8bd1\u5305\u6ca1\u6709\u83dc\u5355\u6570\u636e\uff0c\u65e0\u9700\u53d1\u7248\u83dc\u5355");
            return null;
        }
        Map desMenuMap = desMenus.stream().collect(Collectors.toMap(WorkBenchMenu::getId, Function.identity()));
        List existMenuTemplates = StringUtils.isNotEmpty((CharSequence)compileVersion) ? ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.menuService.lambdaQuery().eq(CustomizedMenuTemplate::getWorkbenchAppCode, (Object)application)).eq(CustomizedMenuTemplate::getVersion, (Object)version)).list() : ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.menuService.lambdaQuery().eq(CustomizedMenuTemplate::getWorkbenchAppCode, (Object)application)).eq(CustomizedMenuTemplate::getVersion, (Object)version)).in(CustomizedMenuTemplate::getMenuDesignerId, desMenuMap.keySet())).list();
        Map existMenuTemplateMap = existMenuTemplates.stream().collect(Collectors.toMap(CustomizedMenuTemplate::getMenuDesignerId, Function.identity()));
        List delDesMenuIdList = CollectionUtil.subtractToList(existMenuTemplateMap.keySet(), desMenuMap.keySet());
        if (CollectionUtils.isNotEmpty((Collection)delDesMenuIdList)) {
            this.menuService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(CustomizedMenuTemplate::getMenuDesignerId, (Collection)delDesMenuIdList)).eq(CustomizedMenuTemplate::getVersion, (Object)version));
        }
        ArrayList<CustomizedMenuTemplate> allMenuTemplate = new ArrayList<CustomizedMenuTemplate>();
        Set updateDesMenuIdList = CollectionUtil.intersectionDistinct(existMenuTemplateMap.keySet(), desMenuMap.keySet(), (Collection[])new Collection[0]);
        if (CollectionUtils.isNotEmpty((Collection)updateDesMenuIdList)) {
            List existMenuTemplateList = updateDesMenuIdList.stream().map(desMenuId -> WorkbenchSyncDataConverter.toUpdatePublishMenu((CustomizedMenuTemplate)((CustomizedMenuTemplate)existMenuTemplateMap.get(desMenuId)), (WorkBenchMenu)((WorkBenchMenu)desMenuMap.get(desMenuId)), (String)compileVersion)).collect(Collectors.toList());
            this.menuService.updateBatchById(existMenuTemplateList);
            allMenuTemplate.addAll(existMenuTemplateList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(addDesMenuIdList = CollectionUtil.subtractToList(desMenuMap.keySet(), existMenuTemplateMap.keySet())))) {
            List addMenuTemplateList = addDesMenuIdList.stream().map(desMenuId -> WorkbenchSyncDataConverter.toNewMenu((WorkBenchMenu)((WorkBenchMenu)desMenuMap.get(desMenuId)), (String)version, (String)application, (String)compileVersion)).collect(Collectors.toList());
            this.menuService.saveBatch(addMenuTemplateList);
            allMenuTemplate.addAll(addMenuTemplateList);
        }
        log.info("\u53d1\u7248\u83dc\u5355\u6a21\u677f\u5b8c\u6210");
        return allMenuTemplate;
    }

    private void deployMenuItems(String application, String compileVersion, String version, List<WorkBenchMenuItem> desMenuItems, List<CustomizedMenuTemplate> allMenuTemplates) {
        if (CollectionUtils.isEmpty(desMenuItems)) {
            log.info("\u7f16\u8bd1\u5305\u6ca1\u6709\u83dc\u5355\u9879\u6570\u636e\uff0c\u65e0\u9700\u53d1\u7248\u83dc\u5355\u9879");
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)compileVersion)) {
            this.menuItemService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CustomizedMenuWork::getWorkbenchAppCode, (Object)application)).eq(CustomizedMenuWork::getVersion, (Object)version));
        } else {
            List desMenuTemplateIdList = desMenuItems.stream().map(menuTemplate -> menuTemplate.getMenuId()).collect(Collectors.toList());
            this.menuItemService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CustomizedMenuWork::getWorkbenchAppCode, (Object)application)).in(CustomizedMenuWork::getDesTemplateId, desMenuTemplateIdList)).eq(CustomizedMenuWork::getVersion, (Object)version));
        }
        List rootDesMenuItems = desMenuItems.stream().filter(WorkbenchUtils::isRoot).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(rootDesMenuItems)) {
            log.error("\u53d1\u7248\u65f6\u83dc\u5355\u9879\u6570\u636e\u6ca1\u6709\u6839\u8282\u70b9");
            return;
        }
        ArrayList childrenDesMenuItemList = Lists.newArrayList(desMenuItems);
        childrenDesMenuItemList.removeAll(rootDesMenuItems);
        HashMap newDesMenuItemMap = new HashMap();
        childrenDesMenuItemList.forEach(desMenuItem -> {
            List cfr_ignored_0 = newDesMenuItemMap.putIfAbsent(desMenuItem.getMenuId(), Lists.newArrayList((Object[])new WorkBenchMenuItem[]{desMenuItem}));
        });
        List desCustomCompIds = desMenuItems.stream().filter(WorkbenchUtils::isCustomComponent).map(WorkBenchMenuItem::getMenuItemSubId).collect(Collectors.toList());
        Map customCompIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(desCustomCompIds)) {
            customCompIdMap = this.toCustomCompId(version, desCustomCompIds);
        }
        Map<Long, Long> menuTemplateIdMap = allMenuTemplates.stream().collect(Collectors.toMap(CustomizedMenuTemplate::getMenuDesignerId, CustomizedMenuTemplate::getId));
        ArrayList menuWorkList = new ArrayList();
        Map finalCustomCompIdMap = customCompIdMap;
        rootDesMenuItems.stream().forEach(desMenuItem -> {
            HashMap idMapping = Maps.newHashMap();
            Long menuId = (Long)menuTemplateIdMap.get(desMenuItem.getMenuId());
            Long menuItemId = SnowflakeIdWorker.getInstance().newId();
            idMapping.put(desMenuItem.getId(), menuItemId);
            CustomizedMenuWork parentMenuItem = WorkbenchSyncDataConverter.toMenuItem((String)application, (WorkBenchMenuItem)desMenuItem, (Long)menuItemId, (Long)menuId, null, (String)version);
            if (WorkbenchUtils.isCustomComponent((WorkBenchMenuItem)desMenuItem)) {
                parentMenuItem.setMenuLabelId((Long)finalCustomCompIdMap.get(desMenuItem.getMenuItemSubId()));
                parentMenuItem.setMenuType(MenuItemTypeEnum.COMPONENT.getType());
                parentMenuItem.setMenuLabelType(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
            } else if (WorkbenchUtils.isPreComponent((WorkBenchMenuItem)desMenuItem)) {
                parentMenuItem.setMenuType(MenuItemTypeEnum.COMPONENT.getType());
                parentMenuItem.setMenuLabelType(Constants.LabelTypeEnum.SYSTEM_PRE.getVal());
                parentMenuItem.setDataType(desMenuItem.getSubCategory());
            }
            menuWorkList.add(parentMenuItem);
            if (CollectionUtils.isNotEmpty((Collection)childrenDesMenuItemList)) {
                this.buildChildMenuItem(application, desMenuItem.getId(), childrenDesMenuItemList, menuWorkList, (Map)idMapping, menuId, finalCustomCompIdMap, version);
            }
        });
        this.menuItemService.saveBatch(menuWorkList);
        log.info("\u53d1\u7248\u83dc\u5355\u5b8c\u6210");
    }

    private void buildChildMenuItem(String application, String parentId, List<WorkBenchMenuItem> workBenchMenuItemList, List<CustomizedMenuWork> menuWorkList, Map<String, Long> idMapping, Long menuId, Map<Long, Long> customCompIdMap, String version) {
        workBenchMenuItemList.forEach(workBenchMenuItem -> {
            if (StringUtils.isNotEmpty((CharSequence)workBenchMenuItem.getMenuItemParentId()) && workBenchMenuItem.getMenuItemParentId().equals(parentId)) {
                String desMenuItemId = workBenchMenuItem.getId();
                Long menuItemId = SnowflakeIdWorker.getInstance().newId();
                idMapping.put(desMenuItemId, menuItemId);
                if (null != workBenchMenuItem.getMenuItemParentId() && null == idMapping.get(workBenchMenuItem.getMenuItemParentId())) {
                    Long parentMenuItemId = SnowflakeIdWorker.getInstance().newId();
                    idMapping.put(workBenchMenuItem.getMenuItemParentId(), parentMenuItemId);
                }
                CustomizedMenuWork menuItem = WorkbenchSyncDataConverter.toMenuItem((String)application, (WorkBenchMenuItem)workBenchMenuItem, (Long)menuItemId, (Long)menuId, (Long)((Long)idMapping.get(workBenchMenuItem.getMenuItemParentId())), (String)version);
                if (WorkbenchUtils.isCustomComponent((WorkBenchMenuItem)workBenchMenuItem)) {
                    menuItem.setMenuLabelId((Long)customCompIdMap.get(workBenchMenuItem.getMenuItemSubId()));
                    menuItem.setMenuType(MenuItemTypeEnum.COMPONENT.getType());
                    menuItem.setMenuLabelType(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
                } else if (WorkbenchUtils.isPreComponent((WorkBenchMenuItem)workBenchMenuItem)) {
                    menuItem.setMenuType(MenuItemTypeEnum.COMPONENT.getType());
                    menuItem.setMenuLabelType(Constants.LabelTypeEnum.SYSTEM_PRE.getVal());
                    menuItem.setDataType(workBenchMenuItem.getSubCategory());
                }
                menuWorkList.add(menuItem);
                this.buildChildMenuItem(application, workBenchMenuItem.getId(), workBenchMenuItemList, menuWorkList, idMapping, menuId, customCompIdMap, version);
            }
        });
    }

    private Map<Long, Long> toCustomCompId(String version, List<Long> designerIds) {
        List customComps = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.customComponentService.lambdaQuery().in(LabelSystemCustom::getComponentDesignerId, designerIds)).eq(LabelSystemCustom::getVersion, (Object)version)).select(new SFunction[]{LabelSystemCustom::getComponentDesignerId, LabelSystemCustom::getId}).list();
        return customComps.stream().collect(Collectors.toMap(LabelSystemCustom::getComponentDesignerId, LabelSystemCustom::getId));
    }

    private void deployComponents(String application, String compileVersion, String version, List<WorkBenchComponent> desComponents) {
        List addDesCompIdList;
        Set updateDesCompIdList;
        List delDesCompIdList;
        if (CollectionUtils.isEmpty(desComponents)) {
            log.info("\u7f16\u8bd1\u5305\u6ca1\u6709\u90e8\u4ef6\u6570\u636e\uff0c\u65e0\u9700\u53d1\u7248\u90e8\u4ef6");
            return;
        }
        List customDesComponentList = this.filterCustomDesComponents(desComponents);
        if (CollectionUtils.isEmpty((Collection)customDesComponentList)) {
            log.info("\u7f16\u8bd1\u5305\u6ca1\u6709\u81ea\u5b9a\u4e49\u90e8\u4ef6\uff0c\u65e0\u9700\u53d1\u7248\u90e8\u4ef6");
            return;
        }
        Map desComponentMap = customDesComponentList.stream().collect(Collectors.toMap(WorkBenchComponent::getId, Function.identity()));
        List existComponents = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.customComponentService.lambdaQuery().eq(LabelSystemCustom::getWorkbenchAppCode, (Object)application)).eq(LabelSystemCustom::getVersion, (Object)version)).list();
        Map existComponentMap = existComponents.stream().collect(Collectors.toMap(LabelSystemCustom::getComponentDesignerId, Function.identity()));
        if (StringUtils.isNotEmpty((CharSequence)compileVersion) && CollectionUtils.isNotEmpty((Collection)(delDesCompIdList = CollectionUtil.subtractToList(existComponentMap.keySet(), desComponentMap.keySet())))) {
            this.customComponentService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(LabelSystemCustom::getComponentDesignerId, (Collection)delDesCompIdList)).eq(LabelSystemCustom::getVersion, (Object)version));
        }
        if (CollectionUtils.isNotEmpty((Collection)(updateDesCompIdList = CollectionUtil.intersectionDistinct(desComponentMap.keySet(), existComponentMap.keySet(), (Collection[])new Collection[0])))) {
            List existCompList = updateDesCompIdList.stream().map(desCompId -> WorkbenchSyncDataConverter.toUpdateCustomComponent((String)compileVersion, (LabelSystemCustom)((LabelSystemCustom)existComponentMap.get(desCompId)), (WorkBenchComponent)((WorkBenchComponent)desComponentMap.get(desCompId)))).collect(Collectors.toList());
            this.customComponentService.updateBatchById(existCompList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(addDesCompIdList = CollectionUtil.subtractToList(desComponentMap.keySet(), existComponentMap.keySet())))) {
            List addCompList = addDesCompIdList.stream().map(desCompId -> WorkbenchSyncDataConverter.toNewCustomComponent((String)compileVersion, (String)version, (WorkBenchComponent)((WorkBenchComponent)desComponentMap.get(desCompId)))).collect(Collectors.toList());
            this.customComponentService.saveBatch(addCompList);
        }
    }

    private List<WorkBenchComponent> filterCustomDesComponents(List<WorkBenchComponent> desComponents) {
        ArrayList<WorkBenchComponent> filterDesComponents = new ArrayList<WorkBenchComponent>();
        desComponents.stream().forEach(desComponent -> {
            if ("PC".equals(desComponent.getClientType())) {
                if (desComponent.getCategory() != Constants.DataCategoryEnum.CATEGORY_TODO.getVal() && desComponent.getCategory() != Constants.DataCategoryEnum.CATEGORY_REPORT.getVal() && desComponent.getCategory() != Constants.DataCategoryEnum.CATEGORY_NOTICE.getVal() && desComponent.getCategory() != Constants.DataCategoryEnum.CATEGORY_CURRENCY.getVal()) {
                    filterDesComponents.add((WorkBenchComponent)desComponent);
                }
            } else if ("MOBILE".equals(desComponent.getClientType()) && desComponent.getCategory() != Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal() && desComponent.getCategory() != Constants.PrtalMobileContentTypeEnum.PRE_TASK.getVal() && desComponent.getCategory() != Constants.PrtalMobileContentTypeEnum.PRE_PROJECT.getVal() && desComponent.getCategory() != Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal() && desComponent.getCategory() != Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal() && desComponent.getCategory() != Constants.PrtalMobileContentTypeEnum.CONTENT_NEWS.getVal() && desComponent.getCategory() != Constants.PrtalMobileContentTypeEnum.TITLE.getVal() && desComponent.getCategory() != Constants.PrtalMobileContentTypeEnum.DIVIDER.getVal() && desComponent.getCategory() != Constants.PrtalMobileContentTypeEnum.THIRD_TO_DO.getVal() && desComponent.getCategory() != Constants.PrtalMobileContentTypeEnum.PICTURE.getVal() && desComponent.getCategory() != Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal()) {
                filterDesComponents.add((WorkBenchComponent)desComponent);
            }
        });
        return filterDesComponents;
    }

    private void deployRelatedApps(String application, String version, List<WorkBenchRelatedApp> desRelatedApps) {
        if (CollectionUtils.isEmpty(desRelatedApps)) {
            log.info("\u7f16\u8bd1\u5305\u6ca1\u6709\u5173\u8054\u5e94\u7528\u6570\u636e\uff0c\u65e0\u9700\u53d1\u7248\u5173\u8054\u5e94\u7528");
            return;
        }
        List relatedApps = desRelatedApps.stream().map(relatedApp -> WorkbenchSyncDataConverter.toRelatedApp((WorkBenchRelatedApp)relatedApp, (String)version)).collect(Collectors.toList());
        Set eleIds = relatedApps.stream().map(RelatedApp::getEleId).collect(Collectors.toSet());
        this.relatedAppService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(RelatedApp::getEleId, eleIds)).eq(RelatedApp::getApplication, (Object)application)).eq(RelatedApp::getVersion, (Object)version));
        this.relatedAppService.saveBatch(relatedApps);
        log.info("\u53d1\u7248\u5173\u8054\u5e94\u7528\u5b8c\u6210");
    }

    private void deployCustomSettings(String application, String version, List<WorkBenchAppCustomSetting> desCustomSettings) {
        if (CollectionUtils.isEmpty(desCustomSettings)) {
            log.info("\u7f16\u8bd1\u5305\u6ca1\u6709\u5e94\u7528\u5ba2\u5236\u6570\u636e\uff0c\u65e0\u9700\u53d1\u7248\u5ba2\u5236\u5305");
            return;
        }
        List customSettings = desCustomSettings.stream().map(desCustomSetting -> WorkbenchSyncDataConverter.toCustomSetting((WorkBenchAppCustomSetting)desCustomSetting, (String)version)).collect(Collectors.toList());
        this.appCustomSettingService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppCustomSetting::getApplication, (Object)application)).eq(AppCustomSetting::getVersion, (Object)version));
        this.appCustomSettingService.saveBatch(customSettings);
        log.info("\u53d1\u7248\u5ba2\u5236\u5305\u5b8c\u6210");
    }
}

