/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.workbench.designer.service;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.semc.dto.workbench.req.WorkbenchDeployAppReqDto;
import com.digiwin.athena.semc.service.workbench.constant.WorkBenchConstant;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchAppCustomSetting;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchComponent;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchMenu;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchMenuItem;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchPortal;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchPortalContent;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchRelatedApp;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchThumbnail;
import com.digiwin.athena.semc.service.workbench.designer.po.WorkbenchDesignerData;
import com.digiwin.athena.semc.service.workbench.designer.service.WorkbenchDeployHandler;
import com.digiwin.athena.semc.util.SafeFileUtils;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class WorkbenchDeployService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkbenchDeployService.class);
    @Value(value="${compile.zipPath}")
    private String compileZipPath;
    @Value(value="${compile.dataPath}")
    private String compileDataPath;
    @Autowired
    private WorkbenchDeployHandler workbenchDeployHandler;

    public void deployApp(WorkbenchDeployAppReqDto deployAppReqDto, MultipartFile compileDataFile) {
        try {
            WorkbenchDesignerData designerData = this.parseDesignerData(deployAppReqDto, compileDataFile);
            if (null == designerData) {
                log.warn("\u6ca1\u6709\u7f16\u8bd1\u6570\u636e\uff0c\u7ed3\u675f\u53d1\u7248\uff0capplicationCode:{},deployNo:{}", (Object)deployAppReqDto.getApplication(), (Object)deployAppReqDto.getDeployNo());
                return;
            }
            this.workbenchDeployHandler.deploy(deployAppReqDto, designerData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw BusinessException.create((String)"\u90e8\u7f72\u5de5\u4f5c\u53f0\u5931\u8d25", (Throwable)ex);
        }
        finally {
            this.removeUnzipCompileDirectory(deployAppReqDto.getApplication(), deployAppReqDto.getCompileVersion());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkbenchDesignerData parseDesignerData(WorkbenchDeployAppReqDto deployAppReqDto, MultipartFile compareDataFile) {
        try (InputStream inStream = compareDataFile.getInputStream();){
            log.info("\u83b7\u53d6\u5230\u7f16\u8bd1\u5305");
            File compileDataDirector = this.unzipCompileFile(deployAppReqDto.getApplication(), deployAppReqDto.getCompileVersion(), inStream);
            log.info("\u5f00\u59cb\u89e3\u6790\u7f16\u8bd1\u6570\u636e,compileDataDirector:{}", (Object[])compileDataDirector.list());
            HashMap compileFileMap = new HashMap();
            this.loopFiles(compileDataDirector, 1, compileFileMap);
            log.info("compileFileMap:{}", compileFileMap);
            if (MapUtils.isEmpty(compileFileMap)) {
                WorkbenchDesignerData workbenchDesignerData = null;
                return workbenchDesignerData;
            }
            WorkbenchDesignerData designerData = new WorkbenchDesignerData();
            List customSettings = this.readLines((File[])compileFileMap.get("wb_appCustomSetting"), WorkBenchAppCustomSetting.class);
            designerData.setCustomSettings(customSettings);
            List relatedApps = this.readLines((File[])compileFileMap.get("wb_relatedApp"), WorkBenchRelatedApp.class);
            designerData.setRelatedApps(relatedApps);
            List components = this.readLines((File[])compileFileMap.get("wb_component"), WorkBenchComponent.class);
            designerData.setComponents(components);
            List portals = this.readLines((File[])compileFileMap.get("wb_portal"), WorkBenchPortal.class);
            designerData.setPortals(portals);
            List portalContents = this.readLines((File[])compileFileMap.get("wb_portalContent"), WorkBenchPortalContent.class);
            designerData.setPortalContents(portalContents);
            List menus = this.readLines((File[])compileFileMap.get("wb_menu"), WorkBenchMenu.class);
            designerData.setMenus(menus);
            List menuItems = this.readLines((File[])compileFileMap.get("wb_menuItem"), WorkBenchMenuItem.class);
            designerData.setMenuItems(menuItems);
            List thumbnails = this.readLines((File[])compileFileMap.get("wb_thumbnail"), WorkBenchThumbnail.class);
            designerData.setThumbnails(thumbnails);
            designerData.setThumbnailFiles((File[])compileFileMap.get("thumbnail_download_folder"));
            designerData.setCarouselFiles((File[])compileFileMap.get("carousel_download_folder"));
            WorkbenchDesignerData workbenchDesignerData = designerData;
            return workbenchDesignerData;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw BusinessException.create((String)"\u90e8\u7f72\u5de5\u4f5c\u53f0\u5931\u8d25", (Throwable)ex);
        }
    }

    private <T> List<T> readLines(File[] files, Class<T> clz) {
        if (ArrayUtil.isEmpty((Object[])files)) {
            return new ArrayList();
        }
        ArrayList<Object> results = new ArrayList<Object>();
        for (File file : files) {
            Object result = this.readFirstLine(file, clz);
            if (null == result) continue;
            results.add(result);
        }
        return results;
    }

    private <T> T readFirstLine(File file, Class<T> clz) {
        ArrayList lines = FileUtil.readLines((File)file, (Charset)StandardCharsets.UTF_8);
        lines = null != lines ? lines.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList()) : new ArrayList();
        return (T)(CollectionUtils.isNotEmpty(lines) ? JSONObject.parseObject((String)((String)lines.get(0)), clz) : null);
    }

    private void loopFiles(File file, int depth, Map<String, File[]> compileFileMap) {
        Object[] subFiles;
        log.info("\u5f00\u59cb\u89e3\u6790\u6587\u4ef6 {}", (Object)file.getAbsolutePath());
        if (!file.isDirectory()) {
            return;
        }
        String dirName = file.getName();
        if (WorkBenchConstant.WB_COLLECTION_LIST.contains(dirName) || StringUtils.equals((CharSequence)"thumbnail_download_folder", (CharSequence)dirName) || StringUtils.equals((CharSequence)"carousel_download_folder", (CharSequence)dirName)) {
            Object[] files = file.listFiles();
            if (ArrayUtil.isNotEmpty((Object[])files)) {
                compileFileMap.put(dirName, (File[])files);
            }
        } else if (depth < WorkBenchConstant.LOOP_FILE_MAX_DEPTH && ArrayUtil.isNotEmpty((Object[])(subFiles = file.listFiles()))) {
            for (Object subFile : subFiles) {
                this.loopFiles((File)subFile, ++depth, compileFileMap);
            }
        }
    }

    private File unzipCompileFile(String application, String compileVersion, InputStream inStream) {
        String applicationCompileZipPath = this.compileZipPath + File.separator + application + File.separator;
        log.info("applicationCompileZipPath {}", (Object)applicationCompileZipPath);
        String applicationCompileDataPath = this.compileDataPath + File.separator + application + File.separator;
        log.info("applicationCompileDataPath {}", (Object)applicationCompileDataPath);
        String compileDataZipPath = StrUtil.format((CharSequence)(applicationCompileZipPath + application + "_{}.zip"), (Object[])new Object[]{compileVersion});
        log.info("compileDataZipPath {}", (Object)compileDataZipPath);
        FileUtil.writeFromStream((InputStream)inStream, (String)compileDataZipPath);
        ZipUtil.unzip((String)compileDataZipPath, (String)applicationCompileDataPath);
        return SafeFileUtils.createFile((String)applicationCompileDataPath);
    }

    private void removeUnzipCompileDirectory(String application, String compileVersion) {
        FileUtil.del((String)StrUtil.format((CharSequence)(this.compileZipPath + File.separator + application + File.separator + application + "_{}.zip"), (Object[])new Object[]{compileVersion}));
        FileUtil.del((String)(this.compileDataPath + File.separator + application + File.separator));
    }
}

