/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.workbench.designer.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Tuple;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.semc.dto.workbench.req.TenantUser;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuTemplate;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuWork;
import com.digiwin.athena.semc.entity.portal.AppCustomSetting;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.PortalDeployMessage;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.portal.PortalInfoContent;
import com.digiwin.athena.semc.entity.portal.RelatedApp;
import com.digiwin.athena.semc.service.menu.CustomizedMenuTemplateService;
import com.digiwin.athena.semc.service.menu.CustomizedMenuWorkService;
import com.digiwin.athena.semc.service.portal.AppCustomSettingService;
import com.digiwin.athena.semc.service.portal.LabelSystemCustomService;
import com.digiwin.athena.semc.service.portal.PortalDeployMessageService;
import com.digiwin.athena.semc.service.portal.PortalInfoContentService;
import com.digiwin.athena.semc.service.portal.PortalInfoService;
import com.digiwin.athena.semc.service.portal.RelatedAppService;
import com.digiwin.athena.semc.service.portal.WorkbenchImageService;
import com.digiwin.athena.semc.service.workbench.constant.EnvOperateEnum;
import com.digiwin.athena.semc.service.workbench.designer.service.AbstractWorkbenchSwitchHandler;
import com.digiwin.athena.semc.service.workbench.util.WorkbenchSyncDataConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkbenchSwitchHandler
extends AbstractWorkbenchSwitchHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkbenchSwitchHandler.class);
    @Autowired
    private PortalInfoService portalService;
    @Autowired
    private PortalInfoContentService portalContentService;
    @Autowired
    private CustomizedMenuTemplateService menuService;
    @Autowired
    private CustomizedMenuWorkService menuItemService;
    @Autowired
    private LabelSystemCustomService customComponentService;
    @Autowired
    private RelatedAppService relatedAppService;
    @Autowired
    private WorkbenchImageService imageService;
    @Autowired
    private AppCustomSettingService appCustomSettingService;
    @Autowired
    private PortalDeployMessageService portalDeployMessageService;

    public void switchWorkbench(String application, List<TenantUser> users) {
        List portals = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.portalService.lambdaQuery().eq(PortalInfo::getWorkbenchAppCode, (Object)application)).eq(PortalInfo::getVersion, (Object)EnvOperateEnum.PUBLISH.getVersion())).list();
        if (CollectionUtils.isEmpty((Collection)portals)) {
            log.warn("{}\u6ca1\u6709\u8981\u5207\u7248\u7684\u95e8\u6237\uff0c\u8df3\u51fa\u5207\u7248\u64cd\u4f5c", (Object)application);
            return;
        }
        String version = EnvOperateEnum.SWITCH.getVersion();
        this.switchCustomSetting(application);
        this.switchRelatedApps(application);
        Tuple tuple = this.switchComponents(application);
        this.switchPortals(application, (Map)tuple.get(0), (Map)tuple.get(1));
        this.deletePortalDeployMessages(application, portals, version);
    }

    private void deletePortalDeployMessages(String application, List<PortalInfo> portals, String version) {
        if (CollectionUtils.isEmpty(portals)) {
            log.info("{}\u65e0\u6709\u6548\u5185\u5bb9\u9879\u3001\u83dc\u5355\u9879\uff0c\u8df3\u51fa\u5165\u5e93\u672a\u8bfb\u6d88\u606f", (Object)application);
            return;
        }
        Set portalIdset = portals.stream().map(e -> e.getPortalDesignerId()).collect(Collectors.toSet());
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.in(PortalDeployMessage::getPortalId, portalIdset)).eq(PortalDeployMessage::getVersion, (Object)version);
        this.portalDeployMessageService.remove((Wrapper)lambdaQueryWrapper);
    }

    private void switchCustomSetting(String application) {
        log.info("\u5207\u7248\u5ba2\u5236\u5305");
        List publishCustomSettingList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.appCustomSettingService.lambdaQuery().eq(AppCustomSetting::getApplication, (Object)application)).eq(AppCustomSetting::getVersion, (Object)EnvOperateEnum.PUBLISH.getVersion())).list();
        if (CollectionUtils.isEmpty((Collection)publishCustomSettingList)) {
            return;
        }
        Set releaseAppCustomSettingList = publishCustomSettingList.stream().map(WorkbenchSyncDataConverter::toReleaseAppCustomSetting).collect(Collectors.toSet());
        this.appCustomSettingService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppCustomSetting::getApplication, (Object)application)).eq(AppCustomSetting::getVersion, (Object)EnvOperateEnum.SWITCH.getVersion()));
        this.appCustomSettingService.saveBatch(releaseAppCustomSettingList);
    }

    private void switchRelatedApps(String application) {
        log.info("\u5207\u7248\u95e8\u6237\u5e94\u7528\u8868");
        List publishRelatedApps = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.relatedAppService.lambdaQuery().eq(RelatedApp::getApplication, (Object)application)).eq(RelatedApp::getVersion, (Object)EnvOperateEnum.PUBLISH.getVersion())).list();
        if (CollectionUtils.isEmpty((Collection)publishRelatedApps)) {
            return;
        }
        Set releaseRelatedApps = publishRelatedApps.stream().map(WorkbenchSyncDataConverter::toNewReleaseRelatedApp).collect(Collectors.toSet());
        this.relatedAppService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(RelatedApp::getApplication, (Object)application)).eq(RelatedApp::getVersion, (Object)EnvOperateEnum.SWITCH.getVersion()));
        this.relatedAppService.saveBatch(releaseRelatedApps);
    }

    private void switchPortals(String application, Map<Long, String> publishCompIdMap, Map<String, Long> releaseCompDesIdMap) {
        log.info("\u5207\u7248\u95e8\u6237");
        List publishPortals = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.portalService.lambdaQuery().eq(PortalInfo::getWorkbenchAppCode, (Object)application)).eq(PortalInfo::getVersion, (Object)EnvOperateEnum.PUBLISH.getVersion())).list();
        if (CollectionUtils.isEmpty((Collection)publishPortals)) {
            return;
        }
        Map portalMap = this.switchPortal(application);
        this.switchPortalContent(application, portalMap);
        Map menuTemplateMap = this.switchMenuTemplate(application);
        this.switchMenu(application, menuTemplateMap);
    }

    public Map<Long, PortalInfo> switchPortal(String application) {
        List addDesPortalIdList;
        List publishPortalList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.portalService.lambdaQuery().in(PortalInfo::getWorkbenchAppCode, new Object[]{application})).eq(PortalInfo::getVersion, (Object)EnvOperateEnum.PUBLISH.getVersion())).list();
        Map publishPortalMap = publishPortalList.stream().collect(Collectors.toMap(PortalInfo::getPortalDesignerId, Function.identity()));
        List releasePortalList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.portalService.lambdaQuery().in(PortalInfo::getWorkbenchAppCode, new Object[]{application})).eq(PortalInfo::getVersion, (Object)EnvOperateEnum.SWITCH.getVersion())).list();
        Map releasePortalMap = releasePortalList.stream().collect(Collectors.toMap(PortalInfo::getPortalDesignerId, Function.identity()));
        HashMap<Long, PortalInfo> portalMap = new HashMap<Long, PortalInfo>();
        Set updateDesPortalIdSet = CollectionUtil.intersectionDistinct(releasePortalMap.keySet(), publishPortalMap.keySet(), (Collection[])new Collection[0]);
        if (CollectionUtils.isNotEmpty((Collection)updateDesPortalIdSet)) {
            ArrayList updatePortalList = new ArrayList();
            updateDesPortalIdSet.stream().forEach(desPortalId -> {
                PortalInfo releaseUpdatePortalInfo = WorkbenchSyncDataConverter.toUpdateReleasePortal((PortalInfo)((PortalInfo)releasePortalMap.get(desPortalId)), (PortalInfo)((PortalInfo)publishPortalMap.get(desPortalId)));
                updatePortalList.add(releaseUpdatePortalInfo);
                portalMap.put(((PortalInfo)publishPortalMap.get(desPortalId)).getId(), releaseUpdatePortalInfo);
            });
            this.portalService.updateBatchById(updatePortalList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(addDesPortalIdList = CollectionUtil.subtractToList(publishPortalMap.keySet(), releasePortalMap.keySet())))) {
            ArrayList addPortalList = new ArrayList();
            addDesPortalIdList.stream().forEach(desPortalId -> {
                PortalInfo releaseUpdatePortalInfo = WorkbenchSyncDataConverter.toNewReleasePortal((PortalInfo)((PortalInfo)publishPortalMap.get(desPortalId)));
                addPortalList.add(releaseUpdatePortalInfo);
                portalMap.put(((PortalInfo)publishPortalMap.get(desPortalId)).getId(), releaseUpdatePortalInfo);
            });
            this.portalService.saveBatch(addPortalList);
        }
        log.info("\u5207\u7248\u95e8\u6237\u5b8c\u6210");
        return portalMap;
    }

    public void switchPortalContent(String application, Map<Long, PortalInfo> portalMap) {
        List publishPortalContentList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.portalContentService.lambdaQuery().in(PortalInfoContent::getWorkbenchAppCode, new Object[]{application})).eq(PortalInfoContent::getVersion, (Object)EnvOperateEnum.PUBLISH.getVersion())).list();
        Map publishPortalContentMap = publishPortalContentList.stream().collect(Collectors.toMap(PortalInfoContent::getDesignerId, Function.identity()));
        this.portalContentService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PortalInfoContent::getWorkbenchAppCode, (Object)application)).eq(PortalInfoContent::getVersion, (Object)EnvOperateEnum.SWITCH.getVersion()));
        if (null != publishPortalContentMap && !publishPortalContentMap.isEmpty()) {
            ArrayList portalInfoContentList = new ArrayList();
            publishPortalContentMap.entrySet().forEach(entry -> {
                PortalInfoContent releaseUpdatePortalContentInfo = WorkbenchSyncDataConverter.toNewReleasePortalContent((PortalInfoContent)((PortalInfoContent)entry.getValue()), (PortalInfo)((PortalInfo)portalMap.get(((PortalInfoContent)entry.getValue()).getPortalId())));
                portalInfoContentList.add(releaseUpdatePortalContentInfo);
            });
            this.portalContentService.saveBatch(portalInfoContentList);
        }
        log.info("\u5207\u7248\u95e8\u6237\u5b8c\u6210");
    }

    public Map<Long, CustomizedMenuTemplate> switchMenuTemplate(String application) {
        List addDesMenuIdList;
        log.info("\u5207\u7248\u83dc\u5355\u6a21\u677f");
        List releaseMenuTemplateList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.menuService.lambdaQuery().in(CustomizedMenuTemplate::getWorkbenchAppCode, new Object[]{application})).eq(CustomizedMenuTemplate::getVersion, (Object)EnvOperateEnum.SWITCH.getVersion())).list();
        Map releaseMenuTemplateMap = releaseMenuTemplateList.stream().collect(Collectors.toMap(CustomizedMenuTemplate::getMenuDesignerId, Function.identity()));
        List publishMenuTemplateList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.menuService.lambdaQuery().in(CustomizedMenuTemplate::getWorkbenchAppCode, new Object[]{application})).eq(CustomizedMenuTemplate::getVersion, (Object)EnvOperateEnum.PUBLISH.getVersion())).list();
        Map publishMenuTemplateMap = publishMenuTemplateList.stream().collect(Collectors.toMap(CustomizedMenuTemplate::getMenuDesignerId, Function.identity()));
        HashMap<Long, CustomizedMenuTemplate> menuTemplateMap = new HashMap<Long, CustomizedMenuTemplate>();
        Set updateDesMenuIdSet = CollectionUtil.intersectionDistinct(releaseMenuTemplateMap.keySet(), publishMenuTemplateMap.keySet(), (Collection[])new Collection[0]);
        if (CollectionUtils.isNotEmpty((Collection)updateDesMenuIdSet)) {
            ArrayList updateMenuTemplateList = new ArrayList();
            updateDesMenuIdSet.stream().forEach(desMenuCompId -> {
                CustomizedMenuTemplate releaseUpdateMenuTemplate = WorkbenchSyncDataConverter.toUpdateReleaseMenu((CustomizedMenuTemplate)((CustomizedMenuTemplate)publishMenuTemplateMap.get(desMenuCompId)), (Long)((CustomizedMenuTemplate)releaseMenuTemplateMap.get(desMenuCompId)).getId());
                updateMenuTemplateList.add(releaseUpdateMenuTemplate);
                menuTemplateMap.put(((CustomizedMenuTemplate)publishMenuTemplateMap.get(desMenuCompId)).getId(), releaseUpdateMenuTemplate);
            });
            this.menuService.updateBatchById((Collection)publishMenuTemplateList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(addDesMenuIdList = CollectionUtil.subtractToList(publishMenuTemplateMap.keySet(), releaseMenuTemplateMap.keySet())))) {
            ArrayList addMenuTemplateList = new ArrayList();
            addDesMenuIdList.stream().forEach(desMenuCompId -> {
                CustomizedMenuTemplate releaseAddMenuTemplate = WorkbenchSyncDataConverter.toNewReleaseMenu((CustomizedMenuTemplate)((CustomizedMenuTemplate)publishMenuTemplateMap.get(desMenuCompId)));
                addMenuTemplateList.add(releaseAddMenuTemplate);
                menuTemplateMap.put(((CustomizedMenuTemplate)publishMenuTemplateMap.get(desMenuCompId)).getId(), releaseAddMenuTemplate);
            });
            this.menuService.saveBatch(addMenuTemplateList);
        }
        return menuTemplateMap;
    }

    public void switchMenu(String application, Map<Long, CustomizedMenuTemplate> menuTemplateMap) {
        this.menuItemService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CustomizedMenuWork::getWorkbenchAppCode, (Object)application)).eq(CustomizedMenuWork::getVersion, (Object)EnvOperateEnum.SWITCH.getVersion()));
        List releaseMenuList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.menuItemService.lambdaQuery().eq(CustomizedMenuWork::getWorkbenchAppCode, (Object)application)).eq(CustomizedMenuWork::getVersion, (Object)EnvOperateEnum.PUBLISH.getVersion())).list();
        if (CollectionUtils.isNotEmpty((Collection)releaseMenuList)) {
            ArrayList addReleaseMenuList = new ArrayList();
            HashMap releaseMenuIdMap = new HashMap();
            HashMap releaseMenuNameMap = new HashMap();
            releaseMenuList.stream().forEach(releaseMenu -> {
                Long menuId = SnowflakeIdWorker.getInstance().newId();
                releaseMenuIdMap.put(releaseMenu.getId(), menuId);
                releaseMenuNameMap.put(releaseMenu.getId(), releaseMenu.getMenuName());
                CustomizedMenuWork newReleaseMenuItem = WorkbenchSyncDataConverter.toNewReleaseMenuItem((CustomizedMenuWork)releaseMenu, (Long)menuId);
                newReleaseMenuItem.setTemplateId(((CustomizedMenuTemplate)menuTemplateMap.get(releaseMenu.getTemplateId())).getId());
                addReleaseMenuList.add(newReleaseMenuItem);
            });
            addReleaseMenuList.stream().forEach(newReleaseMenuItem -> {
                newReleaseMenuItem.setParentName((String)releaseMenuNameMap.get(newReleaseMenuItem.getParentId()));
                newReleaseMenuItem.setParentId((Long)releaseMenuIdMap.get(newReleaseMenuItem.getParentId()));
            });
            this.menuItemService.saveBatch(addReleaseMenuList);
        }
        log.info("\u5207\u7248\u83dc\u5355\u9879\u5b8c\u6210");
    }

    private Tuple switchComponents(String application) {
        log.info("\u5207\u7248\u90e8\u4ef6");
        List publishCustomComps = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.customComponentService.lambdaQuery().eq(LabelSystemCustom::getWorkbenchAppCode, (Object)application)).eq(LabelSystemCustom::getVersion, (Object)EnvOperateEnum.PUBLISH.getVersion())).list();
        if (CollectionUtils.isEmpty((Collection)publishCustomComps)) {
            return new Tuple(new Object[]{new HashMap(), new HashMap()});
        }
        Map<Long, Long> publishCompIdMap = publishCustomComps.stream().collect(Collectors.toMap(LabelSystemCustom::getId, LabelSystemCustom::getComponentDesignerId));
        List releaseCustomComps = this.queryReleaseCustomCompIds(publishCompIdMap.values());
        Map<Object, Object> releaseCustomCompMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)releaseCustomComps)) {
            releaseCustomCompMap = releaseCustomComps.stream().collect(Collectors.toMap(LabelSystemCustom::getComponentDesignerId, Function.identity()));
        }
        ArrayList<Object> addCustomComps = new ArrayList<Object>();
        ArrayList<Object> updateCustomComps = new ArrayList<Object>();
        for (Object publishCustomComp : publishCustomComps) {
            if (releaseCustomCompMap.keySet().contains(publishCustomComp.getComponentDesignerId())) {
                updateCustomComps.add(publishCustomComp);
                continue;
            }
            addCustomComps.add(publishCustomComp);
        }
        if (CollectionUtils.isNotEmpty(updateCustomComps)) {
            HashSet<LabelSystemCustom> toUpdateCustomComps = new HashSet<LabelSystemCustom>();
            for (LabelSystemCustom labelSystemCustom : updateCustomComps) {
                LabelSystemCustom releaseCustomComp = (LabelSystemCustom)releaseCustomCompMap.get(labelSystemCustom.getComponentDesignerId());
                toUpdateCustomComps.add(WorkbenchSyncDataConverter.toUpdateReleaseCustomComponent((LabelSystemCustom)releaseCustomComp, (LabelSystemCustom)labelSystemCustom));
            }
            this.customComponentService.updateBatchById(toUpdateCustomComps);
        }
        if (CollectionUtils.isNotEmpty(addCustomComps)) {
            Set releaseCustomComp = addCustomComps.stream().map(WorkbenchSyncDataConverter::toNewReleaseCustomComponent).collect(Collectors.toSet());
            this.customComponentService.saveBatch(releaseCustomComp);
        }
        List allReleaseCustomComps = this.queryReleaseCustomCompIds(publishCompIdMap.values());
        Map<Long, Long> releaseCompDesIdMap = allReleaseCustomComps.stream().collect(Collectors.toMap(LabelSystemCustom::getComponentDesignerId, LabelSystemCustom::getId));
        return new Tuple(new Object[]{publishCompIdMap, releaseCompDesIdMap});
    }

    private List<LabelSystemCustom> queryReleaseCustomCompIds(Collection<Long> customCompDesIds) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.customComponentService.lambdaQuery().in(LabelSystemCustom::getComponentDesignerId, customCompDesIds)).eq(LabelSystemCustom::getVersion, (Object)EnvOperateEnum.SWITCH.getVersion())).list();
    }
}

