/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.workbench.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.dto.workbench.req.WorkbenchDeployAppReqDto;
import com.digiwin.athena.semc.dto.workbench.req.WorkbenchSwitchAppReqDto;
import com.digiwin.athena.semc.entity.portal.AppCustomSetting;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.service.portal.AppCustomSettingService;
import com.digiwin.athena.semc.service.portal.PortalInfoService;
import com.digiwin.athena.semc.service.workbench.WorkbenchAppService;
import com.digiwin.athena.semc.service.workbench.designer.service.WorkbenchDeleteService;
import com.digiwin.athena.semc.service.workbench.designer.service.WorkbenchDeployService;
import com.digiwin.athena.semc.service.workbench.designer.service.WorkbenchSwitchService;
import com.digiwin.athena.semc.service.workbench.util.WorkbenchDataConverter;
import com.digiwin.athena.semc.vo.workbench.AppCustomSettingVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class WorkbenchAppServiceImpl
implements WorkbenchAppService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkbenchAppServiceImpl.class);
    @Autowired
    private WorkbenchDeployService appDeployService;
    @Autowired
    private WorkbenchSwitchService workbenchSwitchService;
    @Autowired
    private AppCustomSettingService appCustomSettingService;
    @Autowired
    WorkbenchDeleteService workbenchDeleteService;
    @Autowired
    private PortalInfoService portalInfoService;

    public void deleteApp(String appCode) {
        AppAuthContextHolder.getContext().getAuthoredUser().setTenantId("SYSTEM_TENANT");
        this.workbenchDeleteService.delete(appCode);
    }

    public void deletePortal(String appCode, Long portalId) {
        AppAuthContextHolder.getContext().getAuthoredUser().setTenantId("SYSTEM_TENANT");
        this.workbenchDeleteService.deletePortal(appCode, portalId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deployApp(WorkbenchDeployAppReqDto deployAppReq, MultipartFile compileDataFile) {
        AppAuthContextHolder.getContext().getAuthoredUser().setTenantId("SYSTEM_TENANT");
        log.info("\u5f00\u59cb\u53d1\u7248\u5de5\u4f5c\u53f0{}-{}", (Object)deployAppReq.getApplication(), (Object)deployAppReq.getDeployNo());
        long startTime = System.currentTimeMillis();
        this.appDeployService.deployApp(deployAppReq, compileDataFile);
        log.info("\u90e8\u7f72\u5de5\u4f5c\u53f0{}-{}\u7ed3\u675f\uff0c\u8017\u65f6 {}ms", new Object[]{deployAppReq.getApplication(), deployAppReq.getDeployNo(), System.currentTimeMillis() - startTime});
    }

    @Transactional(rollbackFor={Exception.class})
    public void switchApp(WorkbenchSwitchAppReqDto switchAppReq) {
        AppAuthContextHolder.getContext().getAuthoredUser().setTenantId("SYSTEM_TENANT");
        log.info("\u5f00\u59cb\u5207\u7248\u5de5\u4f5c\u53f0{}-{}", (Object)switchAppReq.getApplication(), (Object)switchAppReq.getDeployNo());
        long startTime = System.currentTimeMillis();
        this.workbenchSwitchService.switchWorkbench(switchAppReq.getApplication(), switchAppReq.getTenantUsers());
        log.info("\u5207\u7248\u5de5\u4f5c\u53f0{}-{}\u7ed3\u675f\uff0c\u8017\u65f6 {}ms", new Object[]{switchAppReq.getApplication(), switchAppReq.getDeployNo(), System.currentTimeMillis() - startTime});
    }

    public List<AppCustomSettingVO> getAppCustomSetting(String application) {
        List appCustomSettings = ((LambdaQueryChainWrapper)this.appCustomSettingService.lambdaQuery().eq(AppCustomSetting::getApplication, (Object)application)).list();
        if (CollectionUtils.isEmpty((Collection)appCustomSettings)) {
            return new ArrayList<AppCustomSettingVO>();
        }
        return appCustomSettings.stream().map(arg_0 -> ((WorkbenchDataConverter)WorkbenchDataConverter.INSTANCE).toAppCustomSetting(arg_0)).collect(Collectors.toList());
    }

    public List<PortalInfo> getPortalInfos(List<Long> portalIdList) {
        AppAuthContextHolder.getContext().getAuthoredUser().setTenantId("SYSTEM_TENANT");
        List portalInfoList = ((LambdaQueryChainWrapper)this.portalInfoService.lambdaQuery().in(PortalInfo::getPortalDesignerId, portalIdList)).list();
        if (CollectionUtils.isEmpty((Collection)portalInfoList)) {
            return new ArrayList<PortalInfo>();
        }
        return portalInfoList;
    }
}

