/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.workbench.util;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuTemplate;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuWork;
import com.digiwin.athena.semc.entity.portal.AppCustomSetting;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.portal.PortalInfoContent;
import com.digiwin.athena.semc.entity.portal.RelatedApp;
import com.digiwin.athena.semc.service.workbench.constant.EnvOperateEnum;
import com.digiwin.athena.semc.service.workbench.constant.PublishSourceEnum;
import com.digiwin.athena.semc.service.workbench.designer.mongo.MultiLanguageDTO;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchAppCustomSetting;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchComponent;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchMenu;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchMenuItem;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchPortal;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchPortalContent;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchRelatedApp;
import com.digiwin.athena.semc.service.workbench.util.LanguageUtils;
import com.digiwin.athena.semc.service.workbench.util.WorkbenchUtils;
import java.time.LocalDateTime;
import java.util.Map;
import org.springframework.beans.BeanUtils;

public interface WorkbenchSyncDataConverter {
    public static LabelSystemCustom toUpdateCustomComponent(String compileVersion, LabelSystemCustom component, WorkBenchComponent designerComponent) {
        component.setNameZh(LanguageUtils.processLocaleLanguage((Map)designerComponent.getLang(), (String)"zh_CN", (String)"name", (String)designerComponent.getName()));
        component.setNameUs(LanguageUtils.processLocaleLanguage((Map)designerComponent.getLang(), (String)"en_US", (String)"name", (String)designerComponent.getName()));
        component.setClassicsIcon(designerComponent.getIcon());
        component.setDataCategory(designerComponent.getCategory());
        if (null != designerComponent.getContentConfig()) {
            component.setLinkUrl(MapUtil.getStr((Map)designerComponent.getContentConfig(), (Object)"linkUrl"));
            component.setLinkParam(MapUtil.getStr((Map)designerComponent.getContentConfig(), (Object)"linkParam"));
        }
        component.setShowType(designerComponent.getShowType());
        component.setRemark(designerComponent.getRemark());
        component.setCompileVersion(compileVersion);
        component.setContentConfig(designerComponent.getContentConfig());
        component.setModifyUserId(designerComponent.getModifyUserId());
        component.setModifyUserName(designerComponent.getModifyUserName());
        component.setModifyTime(WorkbenchUtils.formatTime((LocalDateTime)LocalDateTime.now()));
        return component;
    }

    public static LabelSystemCustom toNewCustomComponent(String compileVersion, String version, WorkBenchComponent designerComponent) {
        LabelSystemCustom component = new LabelSystemCustom();
        component.setComponentDesignerId(designerComponent.getId());
        component.setWorkbenchAppCode(designerComponent.getApplication());
        component.setNameZh(LanguageUtils.processLocaleLanguage((Map)designerComponent.getLang(), (String)"zh_CN", (String)"name", (String)designerComponent.getName()));
        component.setNameUs(LanguageUtils.processLocaleLanguage((Map)designerComponent.getLang(), (String)"en_US", (String)"name", (String)designerComponent.getName()));
        component.setClassicsIcon(designerComponent.getIcon());
        component.setDataCategory(designerComponent.getCategory());
        if ("PC".equals(designerComponent.getClientType())) {
            component.setClientType(Constants.ClientTypeTypeEnum.PC.getFlag());
        } else if ("MOBILE".equals(designerComponent.getClientType())) {
            component.setClientType(Constants.ClientTypeTypeEnum.MOBILE.getFlag());
        }
        if (null != designerComponent.getContentConfig()) {
            component.setLinkUrl(MapUtil.getStr((Map)designerComponent.getContentConfig(), (Object)"linkUrl"));
            component.setLinkParam(MapUtil.getStr((Map)designerComponent.getContentConfig(), (Object)"linkParam"));
        }
        component.setShowType(designerComponent.getShowType());
        component.setValidStatus(Constants.ValidStatusEnum.VALID_STATUS_OFF.getVal());
        component.setRemark(designerComponent.getRemark());
        component.setTenantId("SYSTEM_TENANT");
        component.setVersion(version);
        component.setCompileVersion(compileVersion);
        component.setContentConfig(designerComponent.getContentConfig());
        component.setSource(Constants.SourceEnum.ISV.getFlag());
        component.setCreateUserId(designerComponent.getCreateUserId());
        component.setCreateUserName(designerComponent.getCreateUserName());
        component.setCreateTime(WorkbenchUtils.formatTime((LocalDateTime)designerComponent.getCreateTime()));
        component.setModifyUserId(designerComponent.getModifyUserId());
        component.setModifyUserName(designerComponent.getModifyUserName());
        component.setModifyTime(WorkbenchUtils.formatTime((LocalDateTime)LocalDateTime.now()));
        return component;
    }

    public static AppCustomSetting toCustomSetting(WorkBenchAppCustomSetting designerCustomSetting, String version) {
        AppCustomSetting customSetting = new AppCustomSetting();
        customSetting.setApplication(designerCustomSetting.getApplication());
        customSetting.setPackageName(designerCustomSetting.getPackageName());
        customSetting.setRemoteEntry(designerCustomSetting.getRemoteEntry());
        customSetting.setRemoteName(designerCustomSetting.getRemoteName());
        customSetting.setExposedModule(designerCustomSetting.getExposedModule());
        customSetting.setModuleName(designerCustomSetting.getModuleName());
        customSetting.setCreateUserId(designerCustomSetting.getCreateUserId());
        customSetting.setCreateTime(WorkbenchUtils.formatTime((LocalDateTime)designerCustomSetting.getCreateTime()));
        customSetting.setModifyUserId(designerCustomSetting.getModifyUserId());
        customSetting.setModifyTime(WorkbenchUtils.formatTime((LocalDateTime)LocalDateTime.now()));
        customSetting.setDesignerId(designerCustomSetting.getId());
        customSetting.setSource(Constants.SourceEnum.ISV.getFlag());
        customSetting.setVersion(version);
        return customSetting;
    }

    public static RelatedApp toRelatedApp(WorkBenchRelatedApp designerRelatedApp, String version) {
        RelatedApp relatedApp = new RelatedApp();
        relatedApp.setApplication(designerRelatedApp.getApplication());
        relatedApp.setRelatedApplication(designerRelatedApp.getRelatedApplication());
        relatedApp.setRelatedApplicationName(designerRelatedApp.getRelatedApplicationName());
        if (null != designerRelatedApp.getLang() && null != designerRelatedApp.getLang().get("name")) {
            relatedApp.setRelatedApplicationDefName(JSONObject.toJSONString(designerRelatedApp.getLang().get("name")));
        }
        relatedApp.setEleId(designerRelatedApp.getEleId());
        relatedApp.setEleType(designerRelatedApp.getEleType());
        relatedApp.setSource(Constants.SourceEnum.ISV.getFlag());
        relatedApp.setDesignerId(Long.valueOf(Long.parseLong(designerRelatedApp.getId())));
        relatedApp.setVersion(version);
        relatedApp.setCreateUserId(designerRelatedApp.getCreateUserId());
        relatedApp.setCreateTime(WorkbenchUtils.formatTime((LocalDateTime)designerRelatedApp.getCreateTime()));
        relatedApp.setModifyUserId(designerRelatedApp.getModifyUserId());
        relatedApp.setModifyTime(WorkbenchUtils.formatTime((LocalDateTime)LocalDateTime.now()));
        return relatedApp;
    }

    public static CustomizedMenuTemplate toNewMenu(WorkBenchMenu desMenu, String version, String application, String compileVersion) {
        CustomizedMenuTemplate menu = new CustomizedMenuTemplate();
        menu.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        menu.setTemplateName(LanguageUtils.processLocaleLanguage((Map)desMenu.getLang(), (String)"zh_CN", (String)"templateName", (String)JSONObject.toJSONString((Object)desMenu.getLang())));
        menu.setTemplateNameTw(LanguageUtils.processLocaleLanguage((Map)desMenu.getLang(), (String)"zh_TW", (String)"templateName", (String)JSONObject.toJSONString((Object)desMenu.getLang())));
        menu.setTemplateDesc(LanguageUtils.processLocaleLanguage((Map)desMenu.getLang(), (String)"zh_TW", (String)"templateDesc", (String)JSONObject.toJSONString((Object)desMenu.getLang())));
        menu.setTemplateStatus(Constants.ReleaseEnum.RELEASED.getVal());
        menu.setGeneralFlag(Constants.GENERAL_MENU_FLAG_NO);
        menu.setSystemMenuFlag(desMenu.getSystemMenuFlag());
        menu.setTenantId("SYSTEM_TENANT");
        menu.setMenuDesignerId(desMenu.getId());
        menu.setVersion(version);
        menu.setCompileVersion(compileVersion);
        menu.setPublishSource(PublishSourceEnum.ISV.name());
        menu.setWorkbenchAppCode(application);
        menu.setSource(Constants.SourceEnum.ISV.getFlag());
        menu.setCreateUserId(desMenu.getCreateUserId());
        menu.setCreateUserName(desMenu.getCreateUserName());
        menu.setCreateTime(WorkbenchUtils.formatTime((LocalDateTime)desMenu.getCreateTime()));
        menu.setModifyUserId(desMenu.getModifyUserId());
        menu.setModifyUserName(desMenu.getModifyUserName());
        menu.setModifyTime(WorkbenchUtils.formatTime((LocalDateTime)desMenu.getModifyTime()));
        return menu;
    }

    public static CustomizedMenuTemplate toUpdatePublishMenu(CustomizedMenuTemplate menu, WorkBenchMenu desMenu, String compileVersion) {
        menu.setTemplateName(LanguageUtils.processLocaleLanguage((Map)desMenu.getLang(), (String)"zh_CN", (String)"templateName", (String)JSONObject.toJSONString((Object)desMenu.getLang())));
        menu.setTemplateNameTw(LanguageUtils.processLocaleLanguage((Map)desMenu.getLang(), (String)"zh_TW", (String)"templateName", (String)JSONObject.toJSONString((Object)desMenu.getLang())));
        menu.setTemplateDesc(LanguageUtils.processLocaleLanguage((Map)desMenu.getLang(), (String)"zh_TW", (String)"templateDesc", (String)JSONObject.toJSONString((Object)desMenu.getLang())));
        menu.setSystemMenuFlag(desMenu.getSystemMenuFlag());
        menu.setCompileVersion(compileVersion);
        menu.setModifyUserId(desMenu.getModifyUserId());
        menu.setModifyUserName(desMenu.getModifyUserName());
        menu.setModifyTime(WorkbenchUtils.formatTime((LocalDateTime)desMenu.getModifyTime()));
        return menu;
    }

    public static PortalInfo toNewPortal(WorkBenchPortal designerPortal, String version, String compileVersion, Long menuTemplateId) {
        PortalInfo portal = new PortalInfo();
        portal.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        if ("PC".equals(designerPortal.getClientType())) {
            portal.setClientType(Constants.ClientTypeTypeEnum.PC.getFlag());
        } else if ("MOBILE".equals(designerPortal.getClientType())) {
            portal.setClientType(Constants.ClientTypeTypeEnum.MOBILE.getFlag());
        }
        portal.setParentId(Long.valueOf(0L));
        portal.setTemplateId(Long.valueOf(0L));
        portal.setDefaultFlag(Integer.valueOf(0));
        if (null != designerPortal.getLang() && null != designerPortal.getLang().get("name")) {
            portal.setName(String.valueOf(((MultiLanguageDTO)designerPortal.getLang().get("name")).getZh_CN()));
        }
        portal.setTitle("");
        portal.setBgColor("");
        if (null != designerPortal.getLang() && null != designerPortal.getLang().get("portalDesc")) {
            portal.setPortalDesc(String.valueOf(((MultiLanguageDTO)designerPortal.getLang().get("portalDesc")).getZh_CN()));
        }
        portal.setMenuTemplateId(menuTemplateId);
        portal.setMenuTypeSource(Constants.SourceEnum.ISV.getFlag());
        portal.setStatus(Constants.ValidStatusEnum.VALID_STATUS_OFF.getVal());
        portal.setPortalContent(JSONObject.toJSONString((Object)designerPortal.getContent()));
        portal.setPortalImgId(designerPortal.getThumbnail());
        if ("MOBILE".equals(designerPortal.getClientType())) {
            portal.setPortalType(designerPortal.getCategory());
        }
        portal.setTenantId("SYSTEM_TENANT");
        portal.setVersion(version);
        portal.setCompileVersion(compileVersion);
        portal.setPublishSource(PublishSourceEnum.ISV.name());
        portal.setWorkbenchAppCode(designerPortal.getApplication());
        portal.setPortalDesignerId(designerPortal.getId());
        portal.setSource(Constants.SourceEnum.ISV.getFlag());
        portal.setCreateUserId(designerPortal.getCreateUserId());
        portal.setCreateUserName(designerPortal.getCreateUserName());
        portal.setCreateTime(WorkbenchUtils.formatTime((LocalDateTime)LocalDateTime.now()));
        portal.setModifyUserId(designerPortal.getModifyUserId());
        portal.setModifyUserName(designerPortal.getModifyUserName());
        portal.setModifyTime(WorkbenchUtils.formatTime((LocalDateTime)LocalDateTime.now()));
        return portal;
    }

    public static PortalInfo toUpdatePortal(PortalInfo portal, WorkBenchPortal designerPortal, String compileVersion) {
        if (null != designerPortal.getLang() && null != designerPortal.getLang().get("name")) {
            portal.setName(String.valueOf(((MultiLanguageDTO)designerPortal.getLang().get("name")).getZh_CN()));
        }
        if (null != designerPortal.getLang() && null != designerPortal.getLang().get("portalDesc")) {
            portal.setPortalDesc(String.valueOf(((MultiLanguageDTO)designerPortal.getLang().get("portalDesc")).getZh_CN()));
        }
        portal.setPortalContent(JSONObject.toJSONString((Object)designerPortal.getContent()));
        portal.setPortalImgId(designerPortal.getThumbnail());
        portal.setCompileVersion(compileVersion);
        portal.setPortalDesignerId(designerPortal.getId());
        portal.setMenuTemplateId(designerPortal.getMenuId());
        portal.setModifyUserId(designerPortal.getModifyUserId());
        portal.setModifyUserName(designerPortal.getModifyUserName());
        portal.setModifyTime(WorkbenchUtils.formatTime((LocalDateTime)LocalDateTime.now()));
        return portal;
    }

    public static PortalInfoContent toNewPortalContent(String application, WorkBenchPortalContent designerPortalContent, Long portalId, String version) {
        PortalInfoContent portalContent = new PortalInfoContent();
        portalContent.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        portalContent.setParentId(Long.valueOf(0L));
        portalContent.setPortalId(portalId);
        portalContent.setLabelTypeSource(Constants.SourceEnum.ISV.getFlag());
        portalContent.setContentType(designerPortalContent.getContentType());
        portalContent.setDataType(designerPortalContent.getContentSubType());
        portalContent.setContentName(designerPortalContent.getContentName());
        portalContent.setContentUuid(designerPortalContent.getContentUuid());
        portalContent.setIsNameShow(Integer.valueOf(0));
        if (null != designerPortalContent.getCarouselInfo()) {
            portalContent.setContentAttr(JSONObject.toJSONString((Object)designerPortalContent.getCarouselInfo()));
        } else {
            portalContent.setContentAttr(JSONObject.toJSONString((Object)designerPortalContent.getContentConfig()));
        }
        portalContent.setTenantId("SYSTEM_TENANT");
        portalContent.setDesignerId(designerPortalContent.getId());
        portalContent.setVersion(version);
        portalContent.setWorkbenchAppCode(application);
        portalContent.setIsNameShow(designerPortalContent.getIsNameShow());
        return portalContent;
    }

    public static LabelSystemCustom toUpdateReleaseCustomComponent(LabelSystemCustom releaseCustomComp, LabelSystemCustom publishCustomComp) {
        LabelSystemCustom existReleaseCustomComp = new LabelSystemCustom();
        BeanUtils.copyProperties((Object)publishCustomComp, (Object)existReleaseCustomComp);
        existReleaseCustomComp.setId(releaseCustomComp.getId());
        existReleaseCustomComp.setVersion(EnvOperateEnum.SWITCH.getVersion());
        existReleaseCustomComp.setCreateUserId(releaseCustomComp.getCreateUserId());
        existReleaseCustomComp.setCreateUserName(releaseCustomComp.getCreateUserName());
        existReleaseCustomComp.setCreateTime(releaseCustomComp.getCreateTime());
        existReleaseCustomComp.setModifyUserId(publishCustomComp.getModifyUserId());
        existReleaseCustomComp.setModifyUserName(publishCustomComp.getModifyUserName());
        existReleaseCustomComp.setModifyTime(WorkbenchUtils.formatTime((LocalDateTime)LocalDateTime.now()));
        return existReleaseCustomComp;
    }

    public static LabelSystemCustom toNewReleaseCustomComponent(LabelSystemCustom publishCustomComp) {
        LabelSystemCustom releaseCustomComp = new LabelSystemCustom();
        BeanUtils.copyProperties((Object)publishCustomComp, (Object)releaseCustomComp);
        releaseCustomComp.setId(null);
        releaseCustomComp.setModifyTime(WorkbenchUtils.formatTime((LocalDateTime)LocalDateTime.now()));
        releaseCustomComp.setVersion(EnvOperateEnum.SWITCH.getVersion());
        return releaseCustomComp;
    }

    public static RelatedApp toNewReleaseRelatedApp(RelatedApp relatedApp) {
        RelatedApp newRelatedApp = new RelatedApp();
        BeanUtils.copyProperties((Object)relatedApp, (Object)newRelatedApp);
        newRelatedApp.setId(null);
        newRelatedApp.setModifyTime(WorkbenchUtils.formatTime((LocalDateTime)LocalDateTime.now()));
        newRelatedApp.setVersion(EnvOperateEnum.SWITCH.getVersion());
        return newRelatedApp;
    }

    public static PortalInfo toUpdateReleasePortal(PortalInfo oldReleasePortal, PortalInfo publishPortal) {
        PortalInfo newRelPortal = new PortalInfo();
        BeanUtils.copyProperties((Object)publishPortal, (Object)newRelPortal);
        newRelPortal.setId(oldReleasePortal.getId());
        newRelPortal.setDefaultFlag(publishPortal.getDefaultFlag());
        newRelPortal.setVersion(EnvOperateEnum.SWITCH.getVersion());
        newRelPortal.setModifyUserId(publishPortal.getModifyUserId());
        newRelPortal.setModifyUserName(publishPortal.getModifyUserName());
        newRelPortal.setModifyUserId(WorkbenchUtils.formatTime((LocalDateTime)LocalDateTime.now()));
        return newRelPortal;
    }

    public static PortalInfo toNewReleasePortal(PortalInfo portalInfo) {
        PortalInfo relPortal = new PortalInfo();
        BeanUtils.copyProperties((Object)portalInfo, (Object)relPortal);
        relPortal.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        relPortal.setVersion(EnvOperateEnum.SWITCH.getVersion());
        return relPortal;
    }

    public static PortalInfoContent toNewReleasePortalContent(PortalInfoContent portalContent, PortalInfo portal) {
        PortalInfoContent newRelPortalContent = new PortalInfoContent();
        BeanUtils.copyProperties((Object)portalContent, (Object)newRelPortalContent);
        newRelPortalContent.setPortalId(portal.getId());
        newRelPortalContent.setId(null);
        newRelPortalContent.setVersion(EnvOperateEnum.SWITCH.getVersion());
        return newRelPortalContent;
    }

    public static CustomizedMenuTemplate toNewReleaseMenu(CustomizedMenuTemplate publishMenu) {
        CustomizedMenuTemplate releaseMenu = new CustomizedMenuTemplate();
        BeanUtils.copyProperties((Object)publishMenu, (Object)releaseMenu);
        releaseMenu.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
        releaseMenu.setVersion(EnvOperateEnum.SWITCH.getVersion());
        return releaseMenu;
    }

    public static CustomizedMenuTemplate toUpdateReleaseMenu(CustomizedMenuTemplate publishMenu, Long releaseMenuId) {
        CustomizedMenuTemplate releaseMenu = new CustomizedMenuTemplate();
        BeanUtils.copyProperties((Object)publishMenu, (Object)releaseMenu);
        releaseMenu.setId(releaseMenuId);
        releaseMenu.setVersion(EnvOperateEnum.SWITCH.getVersion());
        return releaseMenu;
    }

    public static CustomizedMenuWork toNewReleaseMenuItem(CustomizedMenuWork menuItem, Long id) {
        CustomizedMenuWork newRelMenuItem = new CustomizedMenuWork();
        BeanUtils.copyProperties((Object)menuItem, (Object)newRelMenuItem);
        newRelMenuItem.setTemplateId(null);
        newRelMenuItem.setId(id);
        newRelMenuItem.setVersion(EnvOperateEnum.SWITCH.getVersion());
        return newRelMenuItem;
    }

    public static AppCustomSetting toReleaseAppCustomSetting(AppCustomSetting publishCustomSetting) {
        AppCustomSetting releaseCustomSetting = new AppCustomSetting();
        BeanUtils.copyProperties((Object)publishCustomSetting, (Object)releaseCustomSetting);
        releaseCustomSetting.setId(null);
        releaseCustomSetting.setVersion(EnvOperateEnum.SWITCH.getVersion());
        return releaseCustomSetting;
    }

    public static CustomizedMenuWork toMenuItem(String application, WorkBenchMenuItem menuItem, Long menuItemId, Long templateId, Long parentId, String version) {
        CustomizedMenuWork menuWork = new CustomizedMenuWork();
        menuWork.setId(menuItemId);
        menuWork.setTemplateId(templateId);
        menuWork.setMenuIcon(menuItem.getMenuItemIcon());
        menuWork.setMenuName(menuItem.getMenuItemName());
        menuWork.setOriginalName(menuItem.getMenuItemName());
        if (null != menuItem.getLang() && null != menuItem.getLang().get("name")) {
            menuWork.setMenuNameTw(String.valueOf(((MultiLanguageDTO)menuItem.getLang().get("name")).getZh_TW()));
        }
        menuWork.setMenuType(menuItem.getMenuItemType());
        menuWork.setAppCode(menuItem.getApplication());
        menuWork.setWorkConfig(menuItem.getMenuItemWorkConfig());
        menuWork.setLevel(menuItem.getMenuItemLevel());
        menuWork.setMenuOrder(menuItem.getMenuItemOrder());
        menuWork.setParentId(parentId);
        menuWork.setParentName(menuItem.getMenuItemParentName());
        menuWork.setLabelTypeSource(Constants.SourceEnum.ISV.getFlag());
        menuWork.setTenantId("SYSTEM_TENANT");
        menuWork.setWorkbenchAppCode(application);
        menuWork.setVersion(version);
        menuWork.setDesTemplateId(menuItem.getMenuId());
        return menuWork;
    }
}

