/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.workbench.util;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuWork;
import com.digiwin.athena.semc.entity.portal.PortalInfoContent;
import com.digiwin.athena.semc.service.workbench.constant.ClientTypeEnum;
import com.digiwin.athena.semc.service.workbench.constant.MenuItemSubTypeEnum;
import com.digiwin.athena.semc.service.workbench.constant.MenuItemTypeEnum;
import com.digiwin.athena.semc.service.workbench.constant.PortalContentTypeEnum;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchMenuItem;
import com.digiwin.athena.semc.service.workbench.designer.mongo.WorkBenchPortalContent;
import com.digiwin.athena.semc.util.Utils;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

public abstract class WorkbenchUtils {
    private WorkbenchUtils() {
    }

    public static boolean applyToPC(String clientType) {
        return ClientTypeEnum.PC.name().equals(clientType);
    }

    public static boolean applyToMobile(String clientType) {
        return ClientTypeEnum.MOBILE.name().equals(clientType);
    }

    public static boolean isPreComponent(WorkBenchMenuItem menuItem) {
        return MenuItemTypeEnum.COMPONENT.getType() == menuItem.getMenuItemType() && MenuItemSubTypeEnum.PRE_COMPONENT.getType() == menuItem.getMenuItemSubType();
    }

    public static boolean isPreComponent(WorkBenchPortalContent portalContent) {
        return PortalContentTypeEnum.PRE_COMPONENT.getType().equals(portalContent.getContentType());
    }

    public static boolean isCustomComponent(WorkBenchMenuItem menuItem) {
        return MenuItemTypeEnum.COMPONENT.getType() == menuItem.getMenuItemType() && MenuItemSubTypeEnum.CUSTOM_COMPONENT.getType() == menuItem.getMenuItemSubType();
    }

    public static boolean isRoot(WorkBenchMenuItem menuItem) {
        return "".equals(menuItem.getMenuItemParentId()) || null == menuItem.getMenuItemParentId();
    }

    public static boolean isCustomComponent(CustomizedMenuWork menuItem) {
        return MenuItemTypeEnum.COMPONENT.getType() == menuItem.getMenuType() && MenuItemSubTypeEnum.CUSTOM_COMPONENT.getType() == menuItem.getMenuLabelType();
    }

    public static boolean isCustomComponent(WorkBenchPortalContent portalContent) {
        return PortalContentTypeEnum.CUSTOM_COMPONENT.getType().equals(portalContent.getContentType());
    }

    public static boolean isMobileCustomComponent(WorkBenchPortalContent portalContent) {
        return PortalContentTypeEnum.MOBILE_CUSTOM_COMPONENT.getType().equals(portalContent.getContentType());
    }

    public static boolean isCustomComponent(PortalInfoContent portalContent) {
        return PortalContentTypeEnum.CUSTOM_COMPONENT.getType().equals(portalContent.getContentType());
    }

    public static String formatTime(LocalDateTime dateTime) {
        return LocalDateTimeUtil.format((LocalDateTime)dateTime, (String)"yyyy/MM/dd HH:mm:ss");
    }

    public static List<String> getTenantIds() {
        return Arrays.asList(Utils.getTenantId(), "SYSTEM_TENANT");
    }
}

