/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.util;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.semc.util.SecurityLogUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.util.WebToolUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

/*
 * Exception performing whole class analysis ignored.
 */
public class SecurityLogUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityLogUtil.class);

    public static void writeSecurityLog(HttpServletRequest request, String rawRequest) {
        SecurityLogUtil.writeSecurityLog((MessageEnum)MessageEnum.VERTICAL, (HttpServletRequest)request, (String)rawRequest);
    }

    public static void writeSecurityLog(MessageEnum message, HttpServletRequest request, String rawRequest) {
        SecurityLog securityLog = new SecurityLog();
        securityLog.setMessage(message.getValue());
        securityLog.setPath(request.getServletPath());
        securityLog.setTraceId(MDC.get((String)"PtxId"));
        SecurityLogErrorMessage securityLogErrorMessage = new SecurityLogErrorMessage();
        securityLogErrorMessage.setUserId(Utils.getUserId());
        securityLogErrorMessage.setUserName(Utils.getUserName());
        securityLogErrorMessage.setUserIp(WebToolUtils.getRemortIP((HttpServletRequest)request));
        securityLogErrorMessage.setTenantId(Utils.getTenantId());
        securityLogErrorMessage.setRawRequest(rawRequest);
        String userToken = request.getHeader("Token");
        if (StringUtils.isBlank((CharSequence)userToken)) {
            userToken = request.getHeader("digi-middleware-auth-user");
        }
        securityLogErrorMessage.setUserToken(userToken);
        securityLogErrorMessage.setAppKey(request.getHeader("digi-middleware-auth-app"));
        securityLog.setErrorMessage(securityLogErrorMessage);
        SecurityLogUtil.writeSecurityLog((SecurityLog)securityLog);
    }

    public static void writeSecurityLog(SecurityLog securityLog) {
        JSONObject jsonObject = new JSONObject(true);
        jsonObject.put("errorType", (Object)securityLog.getErrorType());
        jsonObject.put("timestamp", (Object)securityLog.getTimestamp());
        jsonObject.put("code", (Object)securityLog.getCode());
        jsonObject.put("Message", (Object)securityLog.getMessage());
        jsonObject.put("Path", (Object)securityLog.getPath());
        jsonObject.put("Success", (Object)securityLog.getSuccess());
        jsonObject.put("sourceId", (Object)securityLog.getSourceId());
        jsonObject.put("traceId", (Object)securityLog.getTraceId());
        jsonObject.put("errorCode", (Object)securityLog.getErrorCode());
        jsonObject.put("errorInstructors", (Object)securityLog.getErrorInstructors());
        SecurityLogErrorMessage errorMessage = securityLog.getErrorMessage();
        JSONObject errorMessageJson = new JSONObject(true);
        errorMessageJson.put("type", (Object)errorMessage.getType());
        errorMessageJson.put("userID", (Object)errorMessage.getUserId());
        errorMessageJson.put("userName", (Object)errorMessage.getUserName());
        errorMessageJson.put("userIp", (Object)errorMessage.getUserIp());
        if (StringUtils.isNotBlank((CharSequence)errorMessage.getRawRequest())) {
            errorMessageJson.put("rawRequest", (Object)Base64.getEncoder().encodeToString(errorMessage.getRawRequest().getBytes(StandardCharsets.UTF_8)));
        } else {
            errorMessageJson.put("rawRequest", (Object)errorMessage.getRawRequest());
        }
        errorMessageJson.put("userToken", (Object)errorMessage.getUserToken());
        errorMessageJson.put("appKey", (Object)errorMessage.getAppKey());
        errorMessageJson.put("logEnd", (Object)errorMessage.getLogEnd());
        jsonObject.put("errorMessage", (Object)errorMessageJson);
        SecurityLogUtil.writeSecurityLog((String)jsonObject.toString(new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
    }

    private static File getSecurityFile() {
        String nowDate;
        File[] files;
        String logPath = "/usr/local/semc/.logs/error/";
        String logName = "log-security-";
        File logDirectory = new File(logPath);
        if (!logDirectory.exists()) {
            logDirectory.mkdirs();
        }
        if ((files = logDirectory.listFiles(arg_0 -> SecurityLogUtil.lambda$getSecurityFile$0(logName, nowDate = DateUtil.formatDate((Date)new Date()), arg_0))) == null || files.length == 0) {
            File newLog = new File(logPath + logName + nowDate + ".0.log");
            return newLog;
        }
        File file = Arrays.stream(files).max(Comparator.comparing(File::getName)).get();
        long fileSize = file.length();
        if (fileSize < 0x1400000L) {
            return file;
        }
        String seq = file.getName().split("\\.")[1];
        return new File(logPath + logName + nowDate + "." + (Integer.parseInt(seq) + 1) + ".log");
    }

    private static void writeSecurityLog(String content) {
        File logFile = SecurityLogUtil.getSecurityFile();
        try {
            FileUtils.writeStringToFile((File)logFile, (String)(content + System.lineSeparator()), (Charset)StandardCharsets.UTF_8, (boolean)true);
        }
        catch (Exception e) {
            log.error("\u5b89\u5168\u65e5\u5fd7\u5199\u5165\u5f02\u5e38\uff1a{}\uff0c{}", new Object[]{logFile.getName(), content, e});
        }
    }

    private static /* synthetic */ boolean lambda$getSecurityFile$0(String logName, String nowDate, File file) {
        return file.isFile() && file.getName().startsWith(logName + nowDate);
    }
}

