/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SpecialValidator {
    private SpecialValidator() {
    }

    public static boolean isValidIPAddress(String ipAddress) {
        if (ipAddress != null && !ipAddress.isEmpty()) {
            return Pattern.matches("^([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}$", ipAddress);
        }
        return false;
    }

    public static boolean validateEmail(String email) {
        Pattern pattern = Pattern.compile("^[a-zA-Z0-9+_.-]+@[a-zA-Z0-9.-]+$");
        Matcher matcher = pattern.matcher(email);
        return matcher.matches();
    }

    public static boolean validateTelephone(String telephone) {
        Pattern pattern = Pattern.compile("^1[3456789]\\d{9}$");
        Matcher matcher = pattern.matcher(telephone);
        return matcher.matches();
    }

    public static boolean validatePositiveNumber(String number) {
        Pattern pattern = Pattern.compile("^[\\+]?[\\d]*$");
        Matcher matcher = pattern.matcher(number);
        return matcher.matches();
    }
}

