/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.util;

import java.util.regex.Pattern;

public class SqlUtils {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private static final Pattern TRAILING_SEMICOLON_PATTERN = Pattern.compile(";\\s*$");

    public static String preprocessSql(String originalSql) {
        if (originalSql == null) {
            return null;
        }
        String processedSql = WHITESPACE_PATTERN.matcher(originalSql).replaceAll(" ");
        processedSql = TRAILING_SEMICOLON_PATTERN.matcher(processedSql).replaceAll("");
        return processedSql.trim();
    }

    private static String formatSqlKeywords(String sql) {
        return sql.replaceAll(",\\s*", ", ");
    }
}

