/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.BizAuthTypeEnum;
import com.digiwin.athena.semc.dto.news.SaveAnnouncementReq;
import com.digiwin.athena.semc.dto.news.UpdateNewsStatusReq;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementAut;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementAuthMapper;
import com.digiwin.athena.semc.proxy.athena.service.audc.AudcService;
import com.digiwin.athena.semc.proxy.athena.service.audc.model.UserTrackExtendDTO;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TrackingUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrackingUtil.class);
    @Resource
    private AudcService audcService;
    @Resource
    private NewsAnnouncementAuthMapper newsAnnouncementAuthMapper;
    @Resource(name="semcAsyncExecutor")
    private Executor asyncTaskExecutor;

    public void reportUserTrackForSaveNews(SaveAnnouncementReq saveAnnouncementReq) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        CompletableFuture.runAsync(() -> {
            if (!Constants.NewsAnnouncementStatusEnum.PUBLISHED.getFlag().equals(saveAnnouncementReq.getNewsStatus())) {
                return;
            }
            if (!Constants.NEWS_ALL_AUTH_FLAG_YES.equals(saveAnnouncementReq.getAllAuthFlag()) && CollectionUtils.isEmpty((Collection)saveAnnouncementReq.getExternalUserList())) {
                return;
            }
            List userTrackExtendDTOS = this.buildRequestParam(authoredUser, "function_analysis", "news", null, String.valueOf(saveAnnouncementReq.getId()), "\u5916\u90e8\u7528\u6237\u516c\u544a");
            this.audcService.reportUserTrack(authoredUser, userTrackExtendDTOS);
        }, this.asyncTaskExecutor);
    }

    public void reportUserTrackForUpdatePublishStatus(UpdateNewsStatusReq updateNewsStatusReq) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        CompletableFuture.runAsync(() -> {
            if (!Constants.NewsAnnouncementStatusEnum.PUBLISHED.getFlag().equals(updateNewsStatusReq.getNewsStatus())) {
                return;
            }
            if (CollectionUtils.isEmpty((Collection)updateNewsStatusReq.getIdList())) {
                return;
            }
            QueryWrapper condition = new QueryWrapper();
            condition.in((Object)"news_id", (Collection)updateNewsStatusReq.getIdList());
            List authList = this.newsAnnouncementAuthMapper.selectList((Wrapper)condition);
            if (CollectionUtils.isEmpty((Collection)authList)) {
                return;
            }
            Map<Long, List<NewsAnnouncementAut>> authMap = authList.stream().collect(Collectors.groupingBy(NewsAnnouncementAut::getNewsId));
            ArrayList requestParamList = new ArrayList();
            for (Map.Entry<Long, List<NewsAnnouncementAut>> entry : authMap.entrySet()) {
                List<NewsAnnouncementAut> value = entry.getValue();
                Optional<NewsAnnouncementAut> any = value.stream().filter(e -> Constants.NEWS_ALL_AUTH_FLAG_YES.equals(e.getAllAuthFlag()) || BizAuthTypeEnum.EXTERNAL_USER.getValue().equals(e.getAuthType())).findAny();
                if (!any.isPresent()) continue;
                requestParamList.addAll(this.buildRequestParam(authoredUser, "function_analysis", "news", null, String.valueOf(entry.getKey()), "\u5916\u90e8\u7528\u6237\u516c\u544a"));
            }
            this.audcService.reportUserTrack(authoredUser, requestParamList);
        }, this.asyncTaskExecutor);
    }

    private List<UserTrackExtendDTO> buildRequestParam(AuthoredUser authoredUser, String source, String workType, String appCode, String code, String description) {
        ArrayList<UserTrackExtendDTO> list = new ArrayList<UserTrackExtendDTO>();
        UserTrackExtendDTO extendDTO = new UserTrackExtendDTO();
        extendDTO.setSource(source);
        extendDTO.setWorkType(workType);
        extendDTO.setWorkCode(code);
        extendDTO.setUserId(authoredUser.getUserId());
        extendDTO.setTenantId(authoredUser.getTenantId());
        Long createTime = LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        extendDTO.setTimestamp(createTime);
        HashMap<String, String> workContent = new HashMap<String, String>();
        workContent.put("code", code);
        workContent.put("description", description);
        HashMap<String, String> attachData = new HashMap<String, String>();
        attachData.put("appCode", appCode);
        extendDTO.setWorkContent(workContent);
        extendDTO.setAttachData(attachData);
        list.add(extendDTO);
        return list;
    }
}

