/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.net.URLEncodeUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.VirtualApplicationEnum;
import com.digiwin.athena.semc.dto.portal.LabelSystemLinkParamDTO;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.proxy.km.service.model.AppJobDTO;
import com.digiwin.athena.semc.util.DateUtils;
import java.lang.reflect.Field;
import java.sql.Date;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.Base64Utils;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final String URL_REGEX = "^(https?|ftp|file)://.*$";

    public static boolean isPrimitive(Class<?> c) {
        return c != null && (c.isPrimitive() || c.equals(String.class) || Number.class.isAssignableFrom(c) || Boolean.class.equals(c) || Character.class.isAssignableFrom(c) || java.util.Date.class.equals(c) || Date.class.equals(c));
    }

    public static String randomNum(int count) {
        return RandomStringUtils.randomNumeric((int)count);
    }

    public static String generateToken(String username) {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static boolean isValidURL(String url) {
        Pattern pattern = Pattern.compile("^(https?|ftp|file)://.*$");
        Matcher matcher = pattern.matcher(url);
        return matcher.matches();
    }

    public static boolean isAllFieldsNull(Object obj) throws IllegalAccessException {
        Field[] fields;
        Class<?> clazz = obj.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(Deprecated.class) || field.get(obj) == null) continue;
            return false;
        }
        return true;
    }

    public static boolean jsonParamValid(String jsonStr) {
        if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
            try {
                JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
                if (jsonObject.isEmpty()) {
                    return true;
                }
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    public static String getInfo(String url, String userToken, String locale, String userId, String tenantId) {
        HashMap<String, String> map = new HashMap<String, String>();
        Pattern regex = Pattern.compile("\\$\\{([^}]*)\\}");
        Matcher matcher = regex.matcher(url);
        StringBuilder s = new StringBuilder();
        while (matcher.find()) {
            s.append(matcher.group(1) + ",");
        }
        if (s.length() > 0) {
            s.deleteCharAt(s.length() - 1);
        }
        String str = s.toString();
        String[] split = str.split(",");
        String template = "${%s}";
        for (String x : split) {
            if ("mobile_user_token".equals(x)) {
                map.put(String.format(template, x), userToken);
            }
            if ("locale".equals(x)) {
                map.put(String.format(template, x), locale);
            }
            if (!"tenantId_userId".equals(x)) continue;
            map.put(String.format(template, x), tenantId + "_" + userId);
        }
        String pattern = "\\$\\{(.*?)}";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(url);
        StringBuffer sr = new StringBuffer();
        while (m.find()) {
            String group = m.group();
            m.appendReplacement(sr, (String)map.get(group));
        }
        m.appendTail(sr);
        return sr.toString();
    }

    public static String getTenantName() {
        return AppAuthContextHolder.getContext().getAuthoredUser().getTenantName();
    }

    public static String getTenantId() {
        return AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
    }

    public static String getUserToken() {
        return AppAuthContextHolder.getContext().getAuthoredUser().getToken();
    }

    public static Long getUserSid() {
        return AppAuthContextHolder.getContext().getAuthoredUser().getSid();
    }

    public static String getUserId() {
        return AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
    }

    public static String getUserName() {
        return AppAuthContextHolder.getContext().getAuthoredUser().getUserName();
    }

    public static List<String> union(List<String> list1, List<String> list2) {
        list1.addAll(list2);
        return list1.stream().distinct().collect(Collectors.toList());
    }

    public static List<String> intersect(List<String> list1, List<String> list2) {
        List<String> intersect = list1.stream().filter(item -> list2.contains(item)).collect(Collectors.toList());
        return intersect;
    }

    public static String encodeSignArg(Map<String, Object> paramMap) {
        HashMap<String, String> signMap = new HashMap<String, String>();
        signMap.put("timestamp", LocalDateTimeUtil.format((LocalDateTime)LocalDateTime.now(), (DateTimeFormatter)DatePattern.PURE_DATETIME_FORMATTER));
        signMap.put("nonce", RandomUtil.randomString((int)32));
        String signHeaderParams = MapUtil.sortJoin(signMap, (String)"&", (String)"=", (boolean)true, (String[])new String[0]);
        String appSecret = "YynG+rekaI3spXtHwIxbbtJel21bJR7V8KSGPXReMdPKtaRNe0onimEUu3bzTCjj";
        String beanParams = MapUtil.sortJoin((Map)BeanUtil.beanToMap(paramMap, (String[])new String[0]), (String)"&", (String)"=", (boolean)true, (String[])new String[0]);
        LinkedList linkedList = ListUtil.toLinkedList((Object[])new String[]{signHeaderParams, beanParams});
        CollUtil.removeEmpty((Collection)linkedList);
        String signString = CollUtil.join((Iterable)linkedList, (CharSequence)"&");
        String sign = SecureUtil.hmacSha256((String)appSecret).digestBase64(signString, CharsetUtil.CHARSET_UTF_8, true);
        signMap.put("sign", sign);
        String signInfoString = JSONUtil.toJsonStr(signMap);
        return URLEncodeUtil.encode((String)signInfoString);
    }

    public static String encryptionTokenKey(String systemCode, String outerLoginUserId) {
        String encode;
        String base64String = "28682266";
        try {
            JSONObject info = new JSONObject();
            info.put("System", (Object)systemCode);
            info.put("Account", (Object)outerLoginUserId);
            info.put("Date", (Object)DateUtils.getNowTime(null));
            String token = info.toString();
            byte[] keyData = Base64Utils.encode((byte[])"28682266".getBytes());
            SecretKeySpec spec = new SecretKeySpec(keyData, "BlowFish");
            Cipher cipher = Cipher.getInstance("BlowFish");
            cipher.init(1, spec);
            byte[] hasil = cipher.doFinal(token.getBytes());
            encode = new String(Base64Utils.encode((byte[])hasil));
            encode = encode.replaceAll("\\+", "_plus_");
        }
        catch (Exception e) {
            log.error("encrypt token key occur error", (Throwable)e);
            return null;
        }
        return encode;
    }

    public static List<String> strToList(String userIds) {
        List<String> strList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)userIds)) {
            strList = Arrays.asList(userIds.split(","));
        }
        return strList;
    }

    public static String subToName(String name, int length) {
        try {
            length = Math.abs(length - 11);
            if (length > name.length()) {
                length = name.length();
            }
            String nameApp = name.substring(0, length);
            long time = System.currentTimeMillis();
            String timeStr = time + "";
            timeStr = timeStr.substring(3, timeStr.length());
            name = nameApp + "_" + timeStr;
        }
        catch (Exception e) {
            log.error("subToName occur error.", (Throwable)e);
            return name;
        }
        return name;
    }

    public static List<AppJobDTO.Job> subList(List<AppJobDTO.Job> list, int pageSize, int pageNum) {
        return list.stream().skip((pageNum - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
    }

    public static String getPortCard(int index) {
        String[] portlCardStrs = "portal_card_performance,portal_card_report,portal_card_todo,portal_card_collect,portal_card_news,portal_card_common,portal_card_global".split(",");
        List<String> portlCardList = Arrays.asList(portlCardStrs);
        return portlCardList.get(index);
    }

    public static HorizontalCellStyleStrategy initHorizontalCell() {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        WriteFont headWriteFont = new WriteFont();
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.LEFT);
        headWriteFont.setFontHeightInPoints(Short.valueOf((short)11));
        headWriteFont.setFontName("\u5b8b\u4f53");
        headWriteCellStyle.setWriteFont(headWriteFont);
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        WriteFont contentWriteFont = new WriteFont();
        contentWriteFont.setFontHeightInPoints(Short.valueOf((short)11));
        contentWriteFont.setFontName("\u5b8b\u4f53");
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        HorizontalCellStyleStrategy horizontalCellStyleStrategy = new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
        return horizontalCellStyleStrategy;
    }

    public static Boolean isIntersection(List<Long> lf, List<Long> ng) {
        lf.retainAll(ng);
        if (lf.size() > 0) {
            return true;
        }
        return false;
    }

    public static String padZeros(String str, int length) {
        StringBuilder sb = new StringBuilder();
        int padding = length - str.length();
        for (int i = 0; i < padding; ++i) {
            sb.append("0");
        }
        sb.append(str);
        return sb.toString();
    }

    public static AppLinkDTO initFineReportApp() {
        AppLinkDTO athenaAppLinkDTO = new AppLinkDTO();
        athenaAppLinkDTO.setPrimaryId(VirtualApplicationEnum.FINE_REPORT_APP.getPrimaryId());
        athenaAppLinkDTO.setName(VirtualApplicationEnum.FINE_REPORT_APP.getName());
        athenaAppLinkDTO.setCode(VirtualApplicationEnum.FINE_REPORT_APP.getCode());
        athenaAppLinkDTO.setType(String.valueOf(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType()));
        athenaAppLinkDTO.setDataSource(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType());
        return athenaAppLinkDTO;
    }

    public static AppLinkDTO initAthenaApp() {
        AppLinkDTO athenaAppLinkDTO = new AppLinkDTO();
        athenaAppLinkDTO.setPrimaryId(VirtualApplicationEnum.ATHENA_APP.getPrimaryId());
        athenaAppLinkDTO.setName(VirtualApplicationEnum.ATHENA_APP.getName());
        athenaAppLinkDTO.setCode(VirtualApplicationEnum.ATHENA_APP.getCode());
        athenaAppLinkDTO.setIsNeedSsoUrl(Integer.valueOf(1));
        athenaAppLinkDTO.setType(String.valueOf(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType()));
        athenaAppLinkDTO.setDataSource(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType());
        return athenaAppLinkDTO;
    }

    public static AppLinkDTO initAppInteraction() {
        AppLinkDTO appLinkDTO = new AppLinkDTO();
        appLinkDTO.setPrimaryId(VirtualApplicationEnum.ATHENA_AGILE_INTERACTION.getPrimaryId());
        appLinkDTO.setName(VirtualApplicationEnum.ATHENA_AGILE_INTERACTION.getName());
        appLinkDTO.setCode(VirtualApplicationEnum.ATHENA_AGILE_INTERACTION.getCode());
        appLinkDTO.setType(String.valueOf(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType()));
        appLinkDTO.setDataSource(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType());
        return appLinkDTO;
    }

    public static StringBuilder buildWebLinkDisplayUrl(String linkParam) {
        List linkParamList = JSONArray.parseArray((String)linkParam, LabelSystemLinkParamDTO.class);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < linkParamList.size(); ++i) {
            LabelSystemLinkParamDTO paramDTO = (LabelSystemLinkParamDTO)linkParamList.get(i);
            if (Constants.WebLabelLinkEnum.COMMON_PARAM.getType().equals(paramDTO.getType())) {
                if (StringUtils.isNotBlank((CharSequence)paramDTO.getValue())) {
                    stringBuilder.append(paramDTO.getKey()).append("=${").append(paramDTO.getValue()).append("}");
                } else {
                    stringBuilder.append(paramDTO.getKey()).append("=");
                }
            } else {
                stringBuilder.append(paramDTO.getKey()).append("=").append(paramDTO.getValue());
            }
            if (i == linkParamList.size() - 1) continue;
            stringBuilder.append("&");
        }
        return stringBuilder;
    }

    public static StringBuilder buildWebLinkUrl(String linkParam) {
        List linkParamList = JSONArray.parseArray((String)linkParam, LabelSystemLinkParamDTO.class);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < linkParamList.size(); ++i) {
            LabelSystemLinkParamDTO paramDTO = (LabelSystemLinkParamDTO)linkParamList.get(i);
            if (Constants.WebLabelLinkEnum.COMMON_PARAM.getType().equals(paramDTO.getType())) {
                String value = "";
                if (Constants.WebLabelCommonParamEnum.USER_ID.getKey().equals(paramDTO.getValue())) {
                    value = Utils.getUserId();
                } else if (Constants.WebLabelCommonParamEnum.USER_TOKEN.getKey().equals(paramDTO.getValue())) {
                    value = Utils.getUserToken();
                } else if (Constants.WebLabelCommonParamEnum.TIMESTAMP.getKey().equals(paramDTO.getValue())) {
                    value = String.valueOf(new java.util.Date().getTime());
                } else if (Constants.WebLabelCommonParamEnum.LANGUAGE.getKey().equals(paramDTO.getValue())) {
                    value = LocaleContextHolder.getLocale().toString();
                }
                stringBuilder.append(paramDTO.getKey()).append("=").append(value);
            } else {
                stringBuilder.append(paramDTO.getKey()).append("=").append(paramDTO.getValue());
            }
            if (i == linkParamList.size() - 1) continue;
            stringBuilder.append("&");
        }
        return stringBuilder;
    }

    public static Integer toInt(String str, Integer defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

