/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.smartdata.sdk.mq;

import com.digiwin.athena.smartdata.sdk.constant.Constant;
import com.digiwin.athena.smartdata.sdk.model.MqPublishParam;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.MessageProperties;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeoutException;

public class RabbitMqManager {
    private static RabbitMqManager rabbitMQManager = null;
    private Connection connection = null;

    public static RabbitMqManager getRabbitMQManager() {
        if (rabbitMQManager == null) {
            throw new RuntimeException("RabbitMQ created failed");
        }
        return rabbitMQManager;
    }

    private RabbitMqManager() throws Exception {
        if (null == Constant.RABBIT_MQ_URI || Constant.RABBIT_MQ_URI.length() == 0) {
            throw new RuntimeException("esp-proxy.properties config error");
        }
        ConnectionFactory factory = new ConnectionFactory();
        factory.setUri(Constant.RABBIT_MQ_URI);
        this.connection = factory.newConnection();
    }

    private Channel CreateChannel(String exchangeName, String exchangeType, boolean durable, String queueName, String routingKey) throws NoSuchAlgorithmException, KeyManagementException, URISyntaxException, IOException, TimeoutException {
        Channel channel = this.connection.createChannel();
        channel.exchangeDeclare(exchangeName, exchangeType, durable);
        channel.queueDeclare(queueName, durable, false, false, null);
        channel.queueBind(queueName, exchangeName, routingKey);
        return channel;
    }

    @Deprecated
    private boolean PublishMessage(MqPublishParam publishParam) throws Exception {
        boolean result = false;
        if (null == publishParam.getMessage() || publishParam.getMessage().isEmpty()) {
            throw new RuntimeException("message can't be empty");
        }
        if (publishParam.getQueueName() == null || publishParam.getQueueName().isEmpty()) {
            throw new RuntimeException("queueName can't be empty");
        }
        if (publishParam.getRoutingKey() == null || publishParam.getRoutingKey().isEmpty()) {
            throw new RuntimeException("routingKey can't be empty");
        }
        Channel channel = this.CreateChannel(publishParam.getExchangeName(), publishParam.getExchangeType(), publishParam.getPersistent(), publishParam.getQueueName(), publishParam.getRoutingKey());
        AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties().builder();
        builder.contentType("text/plain");
        if (publishParam.getPersistent().booleanValue()) {
            builder.deliveryMode(Integer.valueOf(2));
        }
        try {
            channel.txSelect();
            channel.basicPublish(publishParam.getExchangeName(), publishParam.getRoutingKey(), builder.build(), publishParam.getMessage().getBytes());
            channel.txCommit();
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            channel.txRollback();
        }
        channel.close();
        return result;
    }

    public boolean publishMessage(MqPublishParam publishParam) {
        boolean result = false;
        if (null == publishParam.getMessage() || publishParam.getMessage().isEmpty()) {
            throw new RuntimeException("message can't be empty");
        }
        if (publishParam.getQueueName() == null || publishParam.getQueueName().isEmpty()) {
            throw new RuntimeException("queueName can't be empty");
        }
        if (publishParam.getRoutingKey() == null || publishParam.getRoutingKey().isEmpty()) {
            throw new RuntimeException("routingKey can't be empty");
        }
        try (Channel channel = this.connection.createChannel();){
            channel.exchangeDeclare(publishParam.getExchangeName(), publishParam.getExchangeType(), publishParam.getPersistent().booleanValue());
            channel.queueDeclare(publishParam.getQueueName(), publishParam.getPersistent().booleanValue(), false, false, null);
            channel.queueBind(publishParam.getQueueName(), publishParam.getExchangeName(), publishParam.getRoutingKey());
            channel.confirmSelect();
            channel.addConfirmListener(new ConfirmListener(){

                public void handleAck(long deliveryTag, boolean multiple) throws IOException {
                }

                public void handleNack(long deliveryTag, boolean multiple) throws IOException {
                    System.out.println("Broker\u53d1\u9001\u786e\u8ba4\u5931\u8d25\uff01deliveryTag=" + deliveryTag + ",multiple=" + multiple);
                }
            });
            channel.basicPublish(publishParam.getExchangeName(), publishParam.getRoutingKey(), MessageProperties.PERSISTENT_TEXT_PLAIN, publishParam.getMessage().getBytes());
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    static {
        try {
            rabbitMQManager = new RabbitMqManager();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

