/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.smartdata.sdk.util;

import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.smartdata.sdk.model.InvokerParam;
import com.digiwin.athena.smartdata.sdk.model.MqPublishParam;
import com.digiwin.athena.smartdata.sdk.mq.RabbitMqManager;
import com.digiwin.athena.smartdata.sdk.util.JsonUtil;
import com.digiwin.athena.smartdata.sdk.util.ResponseUtil;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RabbitMqUtil {
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() << 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private static final String MQ_EXCHANGE_NAME = "footprint";
    private static final String MQ_EXCHANGE_TYPE = "direct";
    private static final String MQ_QUEUE_NAME = "FootprintEventQueue";
    private static final String MQ_ROUTING_KEY = "FootprintEvent";

    private RabbitMqUtil() {
    }

    @Deprecated
    public static boolean sendSyncMsg(String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, String bodyJsonString, Map<String, String> eocId, String response) {
        InvokerParam espSdkParam = new InvokerParam();
        espSdkParam.setHostProd(hostProd);
        espSdkParam.setHostVer(hostVer);
        espSdkParam.setHostId(hostId);
        espSdkParam.setHostAcct(hostAcct);
        espSdkParam.setTenantId(tenantId);
        espSdkParam.setServiceProd(serviceProd);
        espSdkParam.setServiceProdUid(serviceProdUid);
        espSdkParam.setServiceName(serviceName);
        espSdkParam.setBodyJsonString(bodyJsonString);
        espSdkParam.setEocId(eocId);
        espSdkParam.setStatus(ResponseUtil.getRespCode(response));
        RabbitMqUtil.sendEspReqMsg(espSdkParam);
        espSdkParam.setBodyJsonString(response);
        RabbitMqUtil.sendEspRespMsg(espSdkParam);
        return true;
    }

    public static boolean sendSyncMsg(RequestModel requestModel, ResponseModel responseModel) {
        InvokerParam espSdkParam = new InvokerParam();
        espSdkParam.setHostProd(requestModel.getHostProd());
        espSdkParam.setHostVer(requestModel.getHostVer());
        espSdkParam.setHostId(requestModel.getHostId());
        espSdkParam.setHostAcct(requestModel.getHostAcct());
        espSdkParam.setTenantId(requestModel.getTenantId());
        espSdkParam.setServiceProd(requestModel.getServiceProd());
        espSdkParam.setServiceProdUid(requestModel.getServiceProdUid());
        espSdkParam.setServiceName(requestModel.getServiceName());
        espSdkParam.setBodyJsonString(requestModel.getBodyJsonString());
        espSdkParam.setEocId(requestModel.getEocMap());
        espSdkParam.setStatus(ResponseUtil.getRespCode(responseModel.getBodyJsonString()));
        RabbitMqUtil.sendEspReqMsg(espSdkParam);
        espSdkParam.setBodyJsonString(responseModel.getBodyJsonString());
        RabbitMqUtil.sendEspRespMsg(espSdkParam);
        return true;
    }

    @Deprecated
    public static boolean sendFasyncMsg(String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, String bodyJsonString, Map<String, String> eocId, String reqId) {
        InvokerParam espSdkParam = new InvokerParam();
        espSdkParam.setHostProd(hostProd);
        espSdkParam.setHostVer(hostVer);
        espSdkParam.setHostId(hostId);
        espSdkParam.setHostAcct(hostAcct);
        espSdkParam.setTenantId(tenantId);
        espSdkParam.setServiceProd(serviceProd);
        espSdkParam.setServiceProdUid(serviceProdUid);
        espSdkParam.setServiceName(serviceName);
        espSdkParam.setBodyJsonString(bodyJsonString);
        espSdkParam.setReqId(reqId);
        espSdkParam.setEocId(eocId);
        RabbitMqUtil.sendEspReqMsg(espSdkParam);
        return true;
    }

    public static boolean sendFasyncMsg(RequestModel requestModel, String reqId) {
        InvokerParam espSdkParam = new InvokerParam();
        espSdkParam.setHostProd(requestModel.getHostProd());
        espSdkParam.setHostVer(requestModel.getHostVer());
        espSdkParam.setHostId(requestModel.getHostId());
        espSdkParam.setHostAcct(requestModel.getHostAcct());
        espSdkParam.setTenantId(requestModel.getTenantId());
        espSdkParam.setServiceProd(requestModel.getServiceProd());
        espSdkParam.setServiceProdUid(requestModel.getServiceProdUid());
        espSdkParam.setServiceName(requestModel.getServiceName());
        espSdkParam.setBodyJsonString(requestModel.getBodyJsonString());
        espSdkParam.setReqId(reqId);
        espSdkParam.setEocId(requestModel.getEocMap());
        RabbitMqUtil.sendEspReqMsg(espSdkParam);
        return true;
    }

    private static boolean sendEspReqMsg(InvokerParam espSdkParam) {
        espSdkParam.setType("request");
        espSdkParam.setSource("esp");
        return RabbitMqUtil.sendMsg(espSdkParam);
    }

    private static boolean sendEspRespMsg(InvokerParam espSdkParam) {
        espSdkParam.setType("response");
        espSdkParam.setSource("esp");
        return RabbitMqUtil.sendMsg(espSdkParam);
    }

    public static boolean sendCallbackRespMsg(InvokerParam espSdkParam) {
        espSdkParam.setType("response");
        espSdkParam.setSource("callback");
        return RabbitMqUtil.sendMsg(espSdkParam);
    }

    private static boolean sendMsg(InvokerParam details) {
        try {
            MqPublishParam publishParam = new MqPublishParam();
            publishParam.setExchangeName(MQ_EXCHANGE_NAME);
            publishParam.setExchangeType(MQ_EXCHANGE_TYPE);
            publishParam.setQueueName(MQ_QUEUE_NAME);
            publishParam.setRoutingKey(MQ_ROUTING_KEY);
            publishParam.setMessage(JsonUtil.toString(details));
            RabbitMqManager mqManager = RabbitMqManager.getRabbitMQManager();
            EXECUTOR_SERVICE.execute(() -> mqManager.publishMessage(publishParam));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

