/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.smartdata.sdk.service.impl;

import com.digiwin.athena.smartdata.sdk.config.DatasourceUrl;
import com.digiwin.athena.smartdata.sdk.model.AthenaBasicHttpRequestHead;
import com.digiwin.athena.smartdata.sdk.service.BmdService;
import com.digiwin.athena.smartdata.sdk.service.HttpService;
import com.digiwin.athena.smartdata.sdk.util.DataSourceJsonUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="bmdService")
public class BmdServiceImpl
implements BmdService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BmdServiceImpl.class);
    private final HttpService httpService;

    public BmdServiceImpl(HttpService httpService) {
        this.httpService = httpService;
    }

    @Override
    public Map<String, Object> getBmdModelDataQuery(Map<String, Object> querySchema, String tenantId, String locale, String userToken, String userId, String routerKey) {
        String url = DatasourceUrl.bmdUrl + "/restful/service/dataModel/semantic/modelDataQuery";
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        try {
            ResponseEntity<Map<String, Object>> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken).setUserId(userId).setRouterKey(routerKey), DataSourceJsonUtil.getJsonString(querySchema), responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && !CollectionUtils.isEmpty((Map)responseEntity.getBody()) && ((Map)responseEntity.getBody()).get("data") instanceof Map && ((Map)responseEntity.getBody()).get("data") != null) {
                return (Map)((Map)responseEntity.getBody()).get("data");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u4e1a\u52a1\u4e2d\u53f0\u51fa\u9519\u4e86\uff0cquerySchema\uff1a" + DataSourceJsonUtil.getJsonString(querySchema) + ",\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return null;
    }
}

