/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.smartdata.sdk;

import com.digiwin.athena.smartdata.sdk.service.BmdService;
import com.digiwin.athena.smartdata.sdk.service.DcpService;
import com.digiwin.athena.smartdata.sdk.service.impl.BmdServiceImpl;
import com.digiwin.athena.smartdata.sdk.service.impl.DcpServiceImpl;
import com.digiwin.athena.smartdata.sdk.service.impl.HttpServiceImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class DataSourceInvokerProxy {
    private static final DataSourceInvokerProxy INSTANCE = new DataSourceInvokerProxy();
    private BmdService bmdService;
    private DcpService dcpService;

    private DataSourceInvokerProxy() {
        HttpServiceImpl httpService = new HttpServiceImpl();
        this.bmdService = new BmdServiceImpl(httpService);
        this.dcpService = new DcpServiceImpl(httpService);
    }

    public static DataSourceInvokerProxy getInstance() {
        return INSTANCE;
    }

    public BmdService getBmdService() {
        return this.bmdService;
    }

    public void setBmdService(BmdService bmdService) {
        this.bmdService = bmdService;
    }

    public DcpService getDcpService() {
        return this.dcpService;
    }

    public void setDcpService(DcpService dcpService) {
        this.dcpService = dcpService;
    }

    public Map<String, Object> getData(String dataSource, Map<String, Object> querySchema, String tenantId, String locale, String userToken, String routerKey) {
        return this.getData(dataSource, querySchema, tenantId, locale, userToken, "", routerKey);
    }

    public Map<String, Object> getData(String dataSource, Map<String, Object> querySchema, String tenantId, String locale, String userToken, String userId, String routerKey) {
        DataSourceInvokerProxy invokerProxy = DataSourceInvokerProxy.getInstance();
        return invokerProxy.getData(dataSource, querySchema, tenantId, locale, userToken, userId, routerKey, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public Map<String, Object> getData(String dataSource, Map<String, Object> querySchema, String tenantId, String locale, String userToken, String userId, String routerKey, List<Map<String, Object>> eocMaps, List<String> roles) {
        return this.getData(dataSource, querySchema, tenantId, locale, userToken, userId, routerKey, eocMaps, roles, "");
    }

    public Map<String, Object> getData(String dataSource, Map<String, Object> querySchema, String tenantId, String locale, String userToken, String userId, String routerKey, List<Map<String, Object>> eocMaps, List<String> roles, String messageId) {
        HashMap<String, Object> responseData = new HashMap<String, Object>(3);
        Map<Object, Object> data = new HashMap(3);
        if ("bmd".equals(dataSource)) {
            data = this.bmdService.getBmdModelDataQuery(querySchema, tenantId, locale, userToken, userId, routerKey, messageId);
        } else if ("dcp".equals(dataSource)) {
            data = this.dcpService.getDcpModelDataQuery(querySchema, tenantId, locale, userToken, userId, routerKey, eocMaps, roles, messageId);
            if (data == null) {
                data = new HashMap(1);
                data.put("data", Collections.EMPTY_LIST);
            } else if (data.get("list") == null || CollectionUtils.isEmpty((Collection)data.get("list"))) {
                data.put("data", Collections.EMPTY_LIST);
            } else {
                data.put("data", data.get("list"));
                data.remove("list");
            }
        }
        responseData.put("code", 200);
        responseData.put("data", data);
        return responseData;
    }

    public Map<String, Object> getData(String dataSource, String selectSql, String totalSql, String tenantId, String locale, String userToken, String userId, String routerKey) {
        HashMap<String, Object> responseData = new HashMap<String, Object>(3);
        Map<Object, Object> data = new HashMap(3);
        if (!"bmd".equals(dataSource) && "dcp".equals(dataSource)) {
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("totalSQL", totalSql);
            param.put("selectSQL", selectSql);
            data = this.dcpService.getDcpModelDataQueryBySQL(param, tenantId, locale, userToken, userId, routerKey);
            if (data == null) {
                data = new HashMap(1);
                data.put("data", Collections.EMPTY_LIST);
            } else if (data.get("list") == null || CollectionUtils.isEmpty((Collection)data.get("list"))) {
                data.put("data", Collections.EMPTY_LIST);
            } else {
                data.put("data", data.get("list"));
                data.remove("list");
            }
        }
        responseData.put("code", 200);
        responseData.put("data", data);
        return responseData;
    }

    public Map<String, Object> getCountData(String dataSource, Map<String, Object> querySchema, String tenantId, String locale, String userToken, String userId, String routerKey, List<Map<String, Object>> eocMaps, List<String> roles, String messageId) {
        HashMap<String, Object> responseData = new HashMap<String, Object>(3);
        HashMap<String, Integer> data = new HashMap<String, Integer>(3);
        Integer count = new Integer(0);
        if (!"bmd".equals(dataSource) && "dcp".equals(dataSource)) {
            count = this.dcpService.countDcpModelDataQuery(querySchema, tenantId, locale, userToken, userId, routerKey, eocMaps, roles, messageId);
        }
        data.put("total", count);
        responseData.put("code", 200);
        responseData.put("data", data);
        return responseData;
    }
}

