/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.smartdata.sdk.service.impl;

import com.digiwin.athena.smartdata.sdk.config.DatasourceUrl;
import com.digiwin.athena.smartdata.sdk.exception.CustomException;
import com.digiwin.athena.smartdata.sdk.model.AthenaBasicHttpRequestHead;
import com.digiwin.athena.smartdata.sdk.model.ErrorCodeDto;
import com.digiwin.athena.smartdata.sdk.service.DcpService;
import com.digiwin.athena.smartdata.sdk.service.HttpService;
import com.digiwin.athena.smartdata.sdk.util.DataSourceJsonUtil;
import com.digiwin.athena.smartdata.sdk.util.DataSourceUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

@Service(value="dcpService")
public class DcpServiceImpl
implements DcpService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DcpServiceImpl.class);
    private final HttpService httpService;

    public DcpServiceImpl(HttpService httpService) {
        this.httpService = httpService;
    }

    @Override
    public Map<String, Object> getDcpModelDataQuery(Map<String, Object> querySchema, String tenantId, String locale, String userToken, String userId, String routerKey, List<Map<String, Object>> eocMaps, List<String> roles, String messageId) {
        String url = DatasourceUrl.dcpUrl + "/api/ddl/parse/and/return";
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        String role = this.buildRole(roles);
        if (!CollectionUtils.isEmpty(eocMaps)) {
            querySchema.put("eocMaps", eocMaps);
        }
        try {
            ResponseEntity<Map<String, Object>> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken).setUserId(userId).setRouterKey(routerKey).setRoles(role).setMessageId(messageId), DataSourceJsonUtil.getJsonString(querySchema), responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && !CollectionUtils.isEmpty((Map)responseEntity.getBody()) && ((Map)responseEntity.getBody()).get("data") instanceof Map && ((Map)responseEntity.getBody()).get("data") != null) {
                return (Map)((Map)((Map)responseEntity.getBody()).get("data")).get("detail");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u8fb9\u7f18\u6570\u636e\u4e2d\u53f0\u51fa\u9519\u4e86\uff0cquerySchema\uff1a" + DataSourceJsonUtil.getJsonString(querySchema) + ",\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            ErrorCodeDto errorCodeDto = this.buildErrorCode(e);
            throw new CustomException(errorCodeDto.getErrorCode(), errorCodeDto.getMessage());
        }
        return null;
    }

    @Override
    public Map<String, Object> getDcpModelDataQueryBySQL(Map<String, Object> param, String tenantId, String locale, String userToken, String userId, String routerKey) {
        String url = DatasourceUrl.dcpUrl + "/api/ddl/execute/and/return";
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        try {
            ResponseEntity<Map<String, Object>> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken).setUserId(userId).setRouterKey(routerKey), DataSourceJsonUtil.getJsonString(param), responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && !CollectionUtils.isEmpty((Map)responseEntity.getBody()) && ((Map)responseEntity.getBody()).get("data") instanceof Map && ((Map)responseEntity.getBody()).get("data") != null) {
                return (Map)((Map)((Map)responseEntity.getBody()).get("data")).get("detail");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u8fb9\u7f18\u6570\u636e\u4e2d\u53f0\u51fa\u9519\u4e86\uff0cSQL\u4e3a\uff1a" + DataSourceJsonUtil.getJsonString(param) + ",\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            ErrorCodeDto errorCodeDto = this.buildErrorCode(e);
            throw new CustomException(errorCodeDto.getErrorCode(), errorCodeDto.getMessage());
        }
        return null;
    }

    @Override
    public Integer countDcpModelDataQuery(Map<String, Object> querySchema, String tenantId, String locale, String userToken, String userId, String routerKey, List<Map<String, Object>> eocMaps, List<String> roles, String messageId) {
        String url = DatasourceUrl.dcpUrl + "/api/ddl/parse/return/count";
        ParameterizedTypeReference<Map<String, Object>> responseType = new ParameterizedTypeReference<Map<String, Object>>(){};
        String role = this.buildRole(roles);
        if (!CollectionUtils.isEmpty(eocMaps)) {
            querySchema.put("eocMaps", eocMaps);
        }
        try {
            ResponseEntity<Map<String, Object>> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken).setUserId(userId).setRouterKey(routerKey).setRoles(role).setMessageId(messageId), DataSourceJsonUtil.getJsonString(querySchema), responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && !CollectionUtils.isEmpty((Map)responseEntity.getBody()) && ((Map)responseEntity.getBody()).get("data") instanceof Map && ((Map)responseEntity.getBody()).get("data") != null && ((Map)((Map)responseEntity.getBody()).get("data")).get("detail") instanceof Map && ((Map)((Map)responseEntity.getBody()).get("data")).get("detail") != null) {
                String total = (String)((Map)((Map)((Map)responseEntity.getBody()).get("data")).get("detail")).get("total");
                if (StringUtils.hasLength(total)) {
                    return Integer.valueOf(total);
                }
                return 0;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u8fb9\u7f18\u6570\u636e\u4e2d\u53f0\u51fa\u9519\u4e86\uff0cquerySchema\uff1a" + DataSourceJsonUtil.getJsonString(querySchema) + ",\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            ErrorCodeDto errorCodeDto = this.buildErrorCode(e);
            throw new CustomException(errorCodeDto.getErrorCode(), errorCodeDto.getMessage());
        }
        return 0;
    }

    private String buildRole(List<String> roles) {
        String role = "";
        if (!CollectionUtils.isEmpty(roles)) {
            for (int i = 0; i < roles.size(); ++i) {
                role = i == roles.size() - 1 ? role + roles.get(i) : role + roles.get(i) + ",";
            }
        }
        return role;
    }

    private ErrorCodeDto buildErrorCode(Exception e) {
        ErrorCodeDto errorCodeDto = e instanceof HttpClientErrorException ? DataSourceUtil.parseErrorInfo(new String(((HttpClientErrorException)e).getResponseBodyAsByteArray(), StandardCharsets.UTF_8)) : (e instanceof HttpServerErrorException ? DataSourceUtil.parseErrorInfo(new String(((HttpServerErrorException)e).getResponseBodyAsByteArray(), StandardCharsets.UTF_8)) : new ErrorCodeDto("500", "\u8c03\u7528\u8fb9\u7f18\u6570\u636e\u4e2d\u53f0\u51fa\u9519\u4e86"));
        return errorCodeDto;
    }
}

