/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.smartdata.sdk.service.impl;

import com.digiwin.athena.smartdata.sdk.exception.CustomException;
import com.digiwin.athena.smartdata.sdk.model.AthenaBasicHttpRequestHead;
import com.digiwin.athena.smartdata.sdk.service.HttpService;
import com.digiwin.athena.smartdata.sdk.util.DataSourceUtil;
import java.util.Map;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class HttpServiceImpl
implements HttpService {
    private static final Logger logger = LoggerFactory.getLogger(HttpServiceImpl.class);
    private static final int MAX_RETRY = 5;
    @Autowired
    private RestTemplate restTemplate = new RestTemplate(new HttpComponentsClientHttpRequestFactory(this.httpClient()));

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    HttpClient httpClient() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(Integer.valueOf(DataSourceUtil.getConfigPropertyValueByKey("httpClientMaxTotal")).intValue());
        connectionManager.setDefaultMaxPerRoute(Integer.valueOf(DataSourceUtil.getConfigPropertyValueByKey("httpClientMaxPerRoute")).intValue());
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(Integer.valueOf(DataSourceUtil.getConfigPropertyValueByKey("httpClientRequestTimeOutMilliSecond")).intValue()).setConnectTimeout(Integer.valueOf(DataSourceUtil.getConfigPropertyValueByKey("httpClientConnectTimeOutMilliSecond")).intValue()).setConnectionRequestTimeout(Integer.valueOf(DataSourceUtil.getConfigPropertyValueByKey("httpClientSocketTimeOutMilliSecond")).intValue()).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).setRetryHandler((exception, executionCount, context) -> {
            if (exception instanceof NoHttpResponseException && executionCount <= 5) {
                logger.warn("[HttpClient]No response from server on " + executionCount + " call");
                return true;
            }
            return false;
        }).build();
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    private HttpHeaders processHeaders(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead) {
        String proxyToken;
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("digi-middleware-auth-app", athenaBasicHttpRequestHead.getAppToken());
        httpHeaders.set("digi-middleware-auth-user", athenaBasicHttpRequestHead.getUserToken());
        httpHeaders.set("token", athenaBasicHttpRequestHead.getUserToken());
        httpHeaders.set("client-agent", athenaBasicHttpRequestHead.getClientAgent());
        httpHeaders.set("locale", athenaBasicHttpRequestHead.getLocale());
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        httpHeaders.setContentType(type);
        String tenantId = this.getTenantId(url, athenaBasicHttpRequestHead);
        if (StringUtils.hasLength(tenantId)) {
            httpHeaders.set("routerKey", tenantId);
        }
        if (StringUtils.hasLength(athenaBasicHttpRequestHead.getUserId())) {
            httpHeaders.set("userId", athenaBasicHttpRequestHead.getUserId());
        }
        if (StringUtils.hasLength(athenaBasicHttpRequestHead.getMessageId())) {
            httpHeaders.set("messageId", athenaBasicHttpRequestHead.getMessageId());
        }
        if (StringUtils.hasLength(athenaBasicHttpRequestHead.getRoles())) {
            httpHeaders.set("roles", athenaBasicHttpRequestHead.getRoles());
        }
        if (StringUtils.hasLength(proxyToken = this.getProxyToken(athenaBasicHttpRequestHead))) {
            httpHeaders.set("digi-proxy-token", proxyToken);
        }
        return httpHeaders;
    }

    private String getTenantId(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead) {
        String tenantId = athenaBasicHttpRequestHead.getTenantId();
        if (StringUtils.hasLength(tenantId)) {
            return tenantId;
        }
        throw new CustomException("API request header tenantId is empty! url\uff1a" + url);
    }

    private String getProxyToken(AthenaBasicHttpRequestHead athenaBasicHttpRequestHead) {
        String proxyToken = athenaBasicHttpRequestHead.getProxyToken();
        if (StringUtils.hasLength(proxyToken)) {
            return proxyToken;
        }
        return null;
    }

    @Override
    public <T> ResponseEntity<T> doGet(String url, Class<T> clazz) {
        ResponseEntity<T> responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, HttpEntity.EMPTY, clazz, new Object[0]);
        this.checkResponse(url, responseEntity, "zh_CN");
        return responseEntity;
    }

    @Override
    public <T> ResponseEntity<T> doGet(String url, ParameterizedTypeReference<T> responseType) {
        ResponseEntity<T> responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, HttpEntity.EMPTY, responseType, new Object[0]);
        this.checkResponse(url, responseEntity, "zh_CN");
        return responseEntity;
    }

    @Override
    public <T> ResponseEntity<T> doGet(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Map<String, ?> uriVariables, Class<T> clazz) {
        HttpEntity<Object> requestEntity = new HttpEntity<Object>(null, this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity<T> responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, clazz, uriVariables);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    @Override
    public <T> ResponseEntity<T> doGet(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Map<String, ?> uriVariables, ParameterizedTypeReference<T> responseType) {
        HttpEntity<Object> requestEntity = new HttpEntity<Object>(null, this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity<T> responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, responseType, uriVariables);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    @Override
    public <T> ResponseEntity<T> doGet(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, ParameterizedTypeReference<T> responseType) {
        HttpEntity<Object> requestEntity = new HttpEntity<Object>(null, this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity<T> responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, responseType, new Object[0]);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    @Override
    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Map<String, ?> uriVariables, Class<T> clazz) {
        HttpEntity<Object> requestEntity = new HttpEntity<Object>(null, this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity<T> responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, clazz, uriVariables);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    @Override
    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, String bodyPayload, Class<T> clazz) {
        HttpEntity<String> requestEntity = new HttpEntity<String>(bodyPayload, this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity<T> responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, clazz, new Object[0]);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    @Override
    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, String bodyPayload, ParameterizedTypeReference<T> responseType) {
        HttpEntity<String> requestEntity = new HttpEntity<String>(bodyPayload, this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity<T> responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, responseType, new Object[0]);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    @Override
    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Map<String, ?> uriVariables, ParameterizedTypeReference<T> responseType) {
        HttpEntity<Object> requestEntity = new HttpEntity<Object>(null, this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity<T> responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, responseType, uriVariables);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    @Override
    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, ParameterizedTypeReference<T> responseType) {
        HttpEntity<Object> requestEntity = new HttpEntity<Object>(null, this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity<T> responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, responseType, new Object[0]);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    @Override
    public <T> ResponseEntity<T> doPost(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, Class<T> clazz) {
        HttpEntity<Object> requestEntity = new HttpEntity<Object>(null, this.processHeaders(url, athenaBasicHttpRequestHead));
        ResponseEntity<T> responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, clazz, new Object[0]);
        this.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        return responseEntity;
    }

    private void checkResponse(String url, ResponseEntity responseEntity, String locale) {
        if (responseEntity.getStatusCode() == HttpStatus.UNAUTHORIZED) {
            if (!StringUtils.hasLength(locale)) {
                locale = "zh_CN";
            }
            Exception exception = new Exception("\u767b\u5f55\u8fc7\u671f");
            throw exception;
        }
    }

    @Override
    public <T> ResponseEntity<T> doPost(String url, ParameterizedTypeReference<T> responseType) {
        ResponseEntity<T> responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, HttpEntity.EMPTY, responseType, new Object[0]);
        this.checkResponse(url, responseEntity, "zh_CN");
        return responseEntity;
    }
}

