/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.smartdata.sdk.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public final class DataSourceJsonUtil {
    private DataSourceJsonUtil() {
    }

    public static <T> T getObject(String jsonText, Class<T> clazz) {
        return JSONObject.parseObject(jsonText, clazz);
    }

    public static JSONObject getObject(String jsonText) {
        return JSONObject.parseObject(jsonText);
    }

    public static <T> T parseObject(String text, TypeReference<T> type) {
        return JSONObject.parseObject(text, type, new Feature[0]);
    }

    public static <T> T getObjectByKey(String data, String key, Class<T> cls) {
        return DataSourceJsonUtil.getObject(data, JSONObject.class).getObject(key, cls);
    }

    public static String getJsonString(Object object) {
        return JSONObject.toJSONString(object);
    }

    public static <T> List<T> getList(String jsonStr, Class<T> clazz) {
        return JSONObject.parseArray(jsonStr, clazz);
    }

    public static <T> List<T> getListByKey(String data, String key, Class<T> cls) {
        return DataSourceJsonUtil.getObject(data, JSONObject.class).getJSONArray(key).toJavaList(cls);
    }

    public static Map<String, Object> json2Map(String jsonStr) {
        return JSONObject.parseObject(jsonStr, Map.class);
    }

    public static <T> List<T> listMapToListT(List<Map<String, Object>> listmap, Class<T> object) {
        ArrayList<T> paramList = new ArrayList<T>();
        if (!CollectionUtils.isEmpty(listmap)) {
            for (Map<String, Object> map : listmap) {
                paramList.add(DataSourceJsonUtil.parseMapObject(map, object));
            }
        }
        return paramList;
    }

    public static <T> T parseMapObject(Map<String, Object> paramMap, Class<T> cls) {
        return JSONObject.parseObject(JSONObject.toJSONString(paramMap), cls);
    }

    public static <T> Map<String, T> deepCopyMaps(Map<String, T> maps) {
        if (CollectionUtils.isEmpty(maps)) {
            return new HashMap(1);
        }
        HashMap<String, T> newMaps = new HashMap<String, T>(maps.size());
        if (maps instanceof Map) {
            for (String key : maps.keySet()) {
                newMaps.put(key, maps.get(key));
            }
        }
        return newMaps;
    }
}

