/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.smartdata.sdk.util;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.smartdata.sdk.model.ErrorCodeDto;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DataSourceUtil {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceUtil.class);
    public static final String DATASOURCE_PROXY_PATH = "conf.datasource-proxy";
    private static Map<String, String> cacheMap = new ConcurrentHashMap<String, String>();

    public static String getPropertyValueByKey(String key) {
        return DataSourceUtil.getPropertyValueByKey(DATASOURCE_PROXY_PATH, key);
    }

    public static String getPropertyValueByKey(String propertiesPath, String key) {
        String value = null;
        String index = propertiesPath + "_" + key;
        if (cacheMap.get(index) != null) {
            value = cacheMap.get(index);
        } else {
            value = DataSourceUtil.readPropertires(propertiesPath, key);
            if (!StringUtils.isEmpty(value)) {
                cacheMap.put(index, value);
            }
        }
        return value;
    }

    public static String getDcpUrl(String regionType) {
        String url = "";
        switch (regionType) {
            case "cn_test": {
                url = DataSourceUtil.getPropertyValueByKey("digiDCP.cn.test.url");
                break;
            }
            case "cn_prod": {
                url = DataSourceUtil.getPropertyValueByKey("digiDCP.cn.prod.url");
                break;
            }
            case "tw_test": {
                url = DataSourceUtil.getPropertyValueByKey("digiDCP.tw.test.url");
                break;
            }
            case "tw_prod": {
                url = DataSourceUtil.getPropertyValueByKey("digiDCP.tw.prod.url");
                break;
            }
            case "paas": {
                url = DataSourceUtil.getPropertyValueByKey("digiDCP.paas.url");
                break;
            }
            default: {
                url = DataSourceUtil.getPropertyValueByKey("digiDCP.huzhou.url");
            }
        }
        return url;
    }

    public static String getBmdUrl(String regionType) {
        String url = "";
        switch (regionType) {
            case "cn_test": {
                url = DataSourceUtil.getPropertyValueByKey("digiBMD.cn.test.url");
                break;
            }
            case "cn_prod": {
                url = DataSourceUtil.getPropertyValueByKey("digiBMD.cn.prod.url");
                break;
            }
            case "tw_test": {
                url = DataSourceUtil.getPropertyValueByKey("digiBMD.tw.test.url");
                break;
            }
            case "tw_prod": {
                url = DataSourceUtil.getPropertyValueByKey("digiBMD.tw.prod.url");
                break;
            }
            case "paas": {
                url = DataSourceUtil.getPropertyValueByKey("digiBMD.paas.url");
                break;
            }
            default: {
                url = DataSourceUtil.getPropertyValueByKey("digiBMD.huzhou.url");
            }
        }
        return url;
    }

    public static String getConfigPropertyValueByKey(String key) {
        return DataSourceUtil.getPropertyValueByKey(DATASOURCE_PROXY_PATH, key);
    }

    public static String readPropertires(String propertiesPath, String key) {
        String value = null;
        try {
            ResourceBundle rb = ResourceBundle.getBundle(propertiesPath);
            value = rb.getString(key);
        }
        catch (Exception e) {
            logger.error("DataSourceUtil.getValue(String propertiesFilePath:" + propertiesPath + ",String key:" + key + ") exception ,return null", e);
        }
        return value;
    }

    public static ErrorCodeDto parseErrorInfo(String message) {
        String errorCode = Optional.ofNullable(JSONObject.parseObject(message)).map(item -> item.getString("errorCode")).orElse(null);
        String errorMessage = Optional.ofNullable(JSONObject.parseObject(message)).map(item -> item.getString("errorMessage")).orElse(null);
        if (!StringUtils.isEmpty(errorCode) && !StringUtils.isEmpty(errorMessage)) {
            return new ErrorCodeDto(errorCode, errorMessage);
        }
        return null;
    }
}

