/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter DATETIME_FMT_BY_DATE_AND_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter YMD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtils.class);
    private static final String[] POSSIBLE_PATTERN = new String[]{"yyyy-MM-dd", "yyyy-MM", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyyMMdd", "yyyyMM", "yyyyMMddHHmmss", "yyyyMMddHHmmssSSS", "yyyy/MM/dd", "yyyy/MM", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss.SSS", "yyyy.MM.dd HH:mm:ss", "yyyy.MM", "yyyy.MM.dd HH:mm:ss.SSS"};

    private DateUtils() {
    }

    public static LocalDateTime parseUseDefaultPattern(String dateTime) {
        if (null == dateTime || dateTime.trim().isEmpty()) {
            return LocalDateTime.MIN;
        }
        return LocalDateTime.parse(dateTime, DATETIME_FMT_BY_DATE_AND_TIME);
    }

    public static String getCurrentDateTime() {
        return LocalDateTime.now().format(DATETIME_FMT_BY_DATE_AND_TIME);
    }

    public static long convertTimeToLong(String time, String format) {
        String formatTime = DateUtils.getFormatTime(time, format);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.parse(formatTime).getTime();
        }
        catch (Exception e) {
            LOGGER.error("\u8f93\u5165\u65e5\u671f\u548c\u7ed9\u5b9a\u7684\u683c\u5f0f\u4e0d\u5339\u914d,\u65e5\u671f:{}\uff0c\u683c\u5f0f:{}", (Object)time, (Object)format);
            return -1L;
        }
    }

    private static String getFormatTime(String time, String format) {
        if (StringUtils.isEmpty(time) || StringUtils.isEmpty(format)) {
            return time;
        }
        if (time.length() > format.length()) {
            return time.substring(0, 10);
        }
        if (time.length() < format.length()) {
            return time + " 00:00:00";
        }
        return time;
    }

    public static String transferFormat(String inTime, String format) {
        SimpleDateFormat s1 = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        SimpleDateFormat s2 = new SimpleDateFormat(format);
        String outTime = null;
        try {
            Date tempDate = s1.parse(inTime);
            outTime = s2.format(s2.parse(s1.format(tempDate)));
        }
        catch (ParseException e) {
            LOGGER.error("\u8f93\u5165\u65e5\u671f\u548c\u7ed9\u5b9a\u7684\u683c\u5f0f\u4e0d\u5339\u914d,\u65e5\u671f:{}\uff0c\u683c\u5f0f:{}", (Object)inTime, (Object)format);
        }
        return outTime;
    }

    public static String getCurrentDateTime(String format) {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(format));
    }

    public static int getWeekOfYear(String dateString) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date date = format.parse(dateString);
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        return calendar.get(3);
    }

    public static int getWeekOfYear(String dateString, String formatString) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(formatString);
        Date date = format.parse(dateString);
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        return calendar.get(3);
    }

    public static BigDecimal getDateDiffInDays(String formatA, String formatB, String fieldA, String fieldB) throws ParseException {
        SimpleDateFormat dateFormatA = new SimpleDateFormat(formatA);
        Date dateA = dateFormatA.parse(fieldA);
        SimpleDateFormat dateFormatB = new SimpleDateFormat(formatB);
        Date dateB = dateFormatB.parse(fieldB);
        BigDecimal millionSeconds = new BigDecimal(dateA.getTime() - dateB.getTime());
        BigDecimal millionSecondsOneDay = new BigDecimal(86400000);
        return millionSeconds.divide(millionSecondsOneDay, 0, RoundingMode.CEILING);
    }

    public static String getFirstDayOfMonth(String pattern, String firstDay) {
        if (StringUtils.isBlank(pattern)) {
            pattern = YYYY_MM_DD_HH_MM_SS;
        }
        firstDay = firstDay + " 00:00:00";
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(pattern);
        LocalDateTime firstDateTime = DateUtils.parseUseDefaultPattern(firstDay);
        return firstDateTime.with(TemporalAdjusters.firstDayOfMonth()).withHour(0).withMinute(0).withSecond(0).format(dateFormatter);
    }

    public static String getLastDayOfMonth(String pattern, String lastDay) {
        if (StringUtils.isBlank(pattern)) {
            pattern = YYYY_MM_DD_HH_MM_SS;
        }
        lastDay = lastDay + " 23:59:59";
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(pattern);
        LocalDateTime lastDateTime = DateUtils.parseUseDefaultPattern(lastDay);
        return lastDateTime.with(TemporalAdjusters.lastDayOfMonth()).withHour(23).withMinute(59).withSecond(59).format(dateFormatter);
    }

    public static String getfirstDayOfLastMonth(String pattern) {
        if (StringUtils.isBlank(pattern)) {
            pattern = YYYY_MM_DD_HH_MM_SS;
        }
        LocalDate currentDate = LocalDate.now();
        LocalDate lastMonthDate = currentDate.minusMonths(1L);
        return DateUtils.getFirstDayOfMonth(pattern, lastMonthDate.format(YMD));
    }

    public static String firstDayOfMonthYearAgo(String pattern) {
        if (StringUtils.isBlank(pattern)) {
            pattern = YYYY_MM_DD_HH_MM_SS;
        }
        LocalDate currentDate = LocalDate.now();
        LocalDate lastMonthDate = currentDate.minusYears(1L);
        return DateUtils.getFirstDayOfMonth(pattern, lastMonthDate.format(YMD));
    }

    public static String getLastDayOfLastMonth(String pattern) {
        if (StringUtils.isBlank(pattern)) {
            pattern = YYYY_MM_DD_HH_MM_SS;
        }
        LocalDate currentDate = LocalDate.now();
        LocalDate lastMonthDate = currentDate.minusMonths(1L);
        return DateUtils.getLastDayOfMonth(pattern, lastMonthDate.format(YMD));
    }

    public static Set<String> getTimeListByBetweenTime(String startTime, String endTime, String pattern) {
        LocalDate startDate = LocalDate.parse(startTime);
        LocalDate endDate = LocalDate.parse(endTime);
        HashSet<String> monthList = new HashSet<String>();
        DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern(pattern);
        while (!startDate.isAfter(endDate)) {
            String monthString = startDate.format(monthFormatter);
            monthList.add(monthString);
            startDate = startDate.plusMonths(1L);
        }
        return monthList;
    }

    public static String analyseFormat(String date) {
        String patternMatch = null;
        for (String pattern : POSSIBLE_PATTERN) {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            sdf.setLenient(false);
            try {
                sdf.parse(date);
                patternMatch = pattern;
                break;
            }
            catch (ParseException parseException) {
            }
        }
        return patternMatch;
    }

    public static String convertDateFormat(String inputDate, String inputFormat, String outputFormat) {
        SimpleDateFormat inputDateFormat = new SimpleDateFormat(inputFormat);
        SimpleDateFormat outputDateFormat = new SimpleDateFormat(outputFormat);
        try {
            Date date = inputDateFormat.parse(inputDate);
            return outputDateFormat.format(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String firstDayOfThisYear() {
        LocalDateTime firstDay = LocalDateTime.now().withDayOfYear(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
        return firstDay.format(DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS));
    }

    public static String lastDayOfThisYear() {
        LocalDateTime lastDay = LocalDateTime.now().withDayOfYear(1).withMonth(12).withDayOfMonth(31).withHour(23).withMinute(59).withSecond(59).withNano(999999999);
        return lastDay.format(DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS));
    }

    public static String firstDayOfThisMonth() {
        LocalDateTime firstDay = LocalDateTime.now().withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
        return firstDay.format(DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS));
    }

    public static String lastDayOfThisMonth() {
        LocalDateTime now = LocalDateTime.now();
        YearMonth currentMonth = YearMonth.from(now);
        LocalDate lastDayOfMonth = currentMonth.atEndOfMonth();
        LocalDateTime lastDayOfMonthAtEndOfDay = lastDayOfMonth.atTime(LocalTime.MAX);
        return lastDayOfMonthAtEndOfDay.format(DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS));
    }
}

