/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans.components;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.digiwin.athena.executionengine.trans.operator.OperatorFactory;
import com.digiwin.athena.executionengine.trans.pojo.element.DealResult;
import com.digiwin.athena.executionengine.trans.pojo.element.FilterItem;
import com.digiwin.athena.executionengine.trans.pojo.element.StepElement;
import com.digiwin.athena.executionengine.trans.service.ITransThemeMapClient;
import com.digiwin.athena.executionengine.trans.util.DateUtils;
import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="filter")
public class FilterStep
extends TransAbstractStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterStep.class);
    @Autowired
    private ITransThemeMapClient transThemeMapClient;

    @Override
    public boolean defineCheck(StepElement stepElement) {
        return true;
    }

    @Override
    public DealResult doDealData(Step step) {
        DealResult dealResult = new DealResult();
        try {
            Object inputData = this.getCurrentData(step.getPrevStepNameList());
            if (!(inputData instanceof List)) {
                LOGGER.warn("\u8fc7\u6ee4\u7ec4\u4ef6\u53ea\u80fd\u63a5\u53d7\u8868\u72b6\u6570\u636e\uff0c\u975e\u5c55\u5e73\u6570\u636e\u9700\u8981\u5148\u6267\u884c\u5c55\u5e73\u8282\u70b9\uff01Trans\u6267\u884c {} \u5931\u8d25\uff0c\u6570\u636e\u7ed3\u6784\u9519\u8bef\uff01", (Object)step.getName());
                dealResult.setDataNullFail();
                return dealResult;
            }
            List dataList = (List)inputData;
            if (CollectionUtils.isEmpty(dataList)) {
                dealResult.setSuccess(Lists.newArrayList());
                return dealResult;
            }
            dealResult.setSuccess(this.doFilter(dataList, step.getStepElement()));
            return dealResult;
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884cfilter\u7ec4\u4ef6\u8fc7\u6ee4\u5f02\u5e38");
            throw e;
        }
    }

    private List<Map<String, Object>> doFilter(List<Map<String, Object>> dataList, StepElement stepElement) {
        List itemList = stepElement.getRules();
        if (CollectionUtils.isEmpty(itemList)) {
            return dataList;
        }
        ArrayList matchData = Lists.newArrayList();
        ArrayList noMatchData = Lists.newArrayList();
        FilterItem outerFilterItem = (FilterItem)itemList.get(0);
        dataList.forEach(data -> {
            boolean isMatch = this.dataFilter((Map<String, Object>)data, itemList, outerFilterItem.getLogiType(), stepElement.getNullJudge());
            if (isMatch) {
                matchData.add(data);
            } else {
                noMatchData.add(data);
            }
        });
        return stepElement.getIsEject() != false ? noMatchData : matchData;
    }

    private boolean dataFilter(Map<String, Object> data, List<FilterItem> itemList, String logiType, String nullJudge) {
        boolean isMatch = true;
        for (FilterItem filterItem : itemList) {
            if (!"single".equalsIgnoreCase(filterItem.getLogiType())) {
                isMatch = this.dataFilter(data, filterItem.getFilterItems(), filterItem.getLogiType(), nullJudge);
            } else {
                Object leftValue = this.getLeftValue(filterItem, data);
                Map.Entry<String, Object> rightValueEntry = this.getRightValue(filterItem, data);
                if (rightValueEntry.getKey().equals("0")) {
                    isMatch = true;
                } else if (leftValue == null) {
                    isMatch = "retain".equalsIgnoreCase(nullJudge);
                } else {
                    try {
                        isMatch = OperatorFactory.getOperatorFunction(filterItem.getOp()).apply(leftValue, rightValueEntry.getValue());
                    }
                    catch (Exception e) {
                        LOGGER.error("dataFilter\u6267\u884c\u5931\u8d25", e);
                        isMatch = false;
                        break;
                    }
                }
            }
            if ((!"and".equalsIgnoreCase(logiType) || isMatch) && (!"or".equalsIgnoreCase(logiType) || !isMatch)) continue;
            break;
        }
        return isMatch;
    }

    private Object getLeftValue(FilterItem filterItem, Map<String, Object> data) {
        Object leftValue = data.get(filterItem.getLeft());
        if (leftValue == null) {
            return null;
        }
        if ("date".equalsIgnoreCase(filterItem.getLeftValueType()) || "datetime".equalsIgnoreCase(filterItem.getLeftValueType())) {
            return DateUtils.convertTimeToLong(String.valueOf(leftValue), filterItem.getLeftDateFormat());
        }
        return leftValue;
    }

    private Map.Entry<String, Object> getRightValue(FilterItem filterItem, Map<String, Object> data) {
        Object rightValue = null;
        String rightValueStatus = "1";
        if ("constant".equalsIgnoreCase(filterItem.getType())) {
            rightValue = filterItem.getRight();
        } else if ("column".equalsIgnoreCase(filterItem.getType())) {
            rightValue = data.get(filterItem.getRight());
        } else if ("var".equalsIgnoreCase(filterItem.getType())) {
            rightValue = this.getTransDataManager().getMechanismData(filterItem.getRight());
        } else if ("commonvar".equalsIgnoreCase(filterItem.getType())) {
            HashMap<String, Object> commonVarMap = this.getTransDataManager().getCommonVarCollection();
            if (commonVarMap == null || !commonVarMap.containsKey(filterItem.getRight())) {
                ArrayList varList = Lists.newArrayList();
                varList.add(filterItem.getRight());
                JSONObject respData = this.transThemeMapClient.querySmartDataVariable(this.getTransDataManager().getTenantId(), varList, this.getTransDataManager().getToken(), this.getTransDataManager().getSecurityToken());
                commonVarMap = commonVarMap == null ? new HashMap<String, Object>() : commonVarMap;
                commonVarMap.put(filterItem.getRight(), Optional.ofNullable(respData).map(item -> item.get((Object)filterItem.getRight())).orElse(null));
                this.getTransDataManager().setCommonVarCollection(commonVarMap);
            }
            if (commonVarMap.get(filterItem.getRight()) != null) {
                JSONObject commonVar = (JSONObject)commonVarMap.get(filterItem.getRight());
                String status = commonVar.getString("status");
                if ("1".equals(status)) {
                    rightValue = ((JSONObject)commonVarMap.get(filterItem.getRight())).get((Object)"value");
                } else {
                    rightValueStatus = "0";
                }
            } else {
                rightValueStatus = "0";
            }
        } else if ("systemvar".equalsIgnoreCase(filterItem.getType())) {
            switch (filterItem.getRight()) {
                case "s_runTime": {
                    rightValue = DateUtils.getCurrentDateTime("yyyy-MM-dd HH:mm:ss");
                    filterItem.setRightDateFormat("yyyy-MM-dd HH:mm:ss");
                    break;
                }
                case "s_runDate": {
                    rightValue = DateUtils.getCurrentDateTime("yyyy-MM-dd");
                    filterItem.setRightDateFormat("yyyy-MM-dd");
                    break;
                }
                case "s_userName": {
                    rightValue = this.getTransDataManager().getLoginUserName();
                    break;
                }
                case "s_userId": {
                    rightValue = this.getTransDataManager().getUserId();
                }
            }
        } else {
            LOGGER.warn("dataFilter, \u5728\u903b\u8f91\u5224\u65ad\u7684\u53f3\u4fa7\uff0c\u672a\u9884\u671f\u7684\u6570\u636e\u7c7b\u578b");
        }
        if ("date".equalsIgnoreCase(filterItem.getRightValueType()) || "datetime".equalsIgnoreCase(filterItem.getLeftValueType())) {
            rightValue = DateUtils.convertTimeToLong(String.valueOf(rightValue), filterItem.getRightDateFormat());
        }
        if ("collection".equalsIgnoreCase(filterItem.getRightValueType())) {
            rightValue = JSONArray.parseArray((String)String.valueOf(rightValue));
        }
        return new AbstractMap.SimpleImmutableEntry<String, Object>(rightValueStatus, rightValue);
    }
}

