/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans.components;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.core.constant.ConfigConstant;
import com.digiwin.athena.executionengine.trans.pojo.element.DealResult;
import com.digiwin.athena.executionengine.trans.pojo.element.StepElement;
import com.digiwin.athena.executionengine.trans.service.ITransHttpClient;
import com.digiwin.athena.executionengine.trans.util.ServiceResponseUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="mechanism")
public class MechanismStep
extends TransAbstractStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(MechanismStep.class);
    @Autowired
    private ITransHttpClient transHttpClient;

    @Override
    public boolean defineCheck(StepElement stepElement) {
        return true;
    }

    @Override
    public DealResult doDealData(Step step) {
        DealResult dealResult = new DealResult();
        StepElement stepElement = step.getStepElement();
        try {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", "application/json;charset=UTF-8");
            header.put("token", this.getTransDataManager().getToken());
            header.put("routerKey", this.getTransDataManager().getTenantId());
            header.put("security-token", this.getTransDataManager().getSecurityToken());
            Map<String, Object> param = this.buildRequestBody(stepElement.getVariableName(), stepElement.getEocLevel());
            LOGGER.info("\u6267\u884c\u5f15\u64ce\u8c03\u7528themeMap\u83b7\u53d6\u673a\u5236\u53d8\u91cf\u5165\u53c2:{}", (Object)param);
            String httpRespContent = this.transHttpClient.doPost(ConfigConstant.KM_DOMAIN_URL + "/service/knowledgegraph/Mechanism/queryVariable", header, JSONObject.toJSONString(param));
            LOGGER.info("\u6267\u884c\u5f15\u64ce\u8c03\u7528themeMap\u83b7\u53d6\u673a\u5236\u53d8\u91cf\u8fd4\u56de\u7ed3\u679c:{}", (Object)httpRespContent);
            JSONObject respData = ServiceResponseUtils.getThemeMapResp(httpRespContent);
            if (respData == null) {
                dealResult.setDataNullFail();
                return dealResult;
            }
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put(stepElement.getVariableName(), Optional.ofNullable(respData).map(data -> data.get((Object)stepElement.getVariableName())).orElse(null));
            this.getTransDataManager().setMechanismData(resultMap);
            dealResult.setSuccess(this.getCurrentData(step.getPrevStepNameList()));
            return dealResult;
        }
        catch (Exception e) {
            LOGGER.error("\u673a\u5236\u53d8\u91cf\u7ec4\u4ef6\u83b7\u53d6\u673a\u5236\u53d8\u91cf\u5f02\u5e38");
            throw e;
        }
    }

    private Map<String, Object> buildRequestBody(String variableName, String eocLevel) {
        TransDataManger transDataManager = this.getTransDataManager();
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        HashMap<String, Object> queryData = new HashMap<String, Object>(8);
        queryData.put("variableName", variableName);
        queryData.put("tenantId", transDataManager.getTenantId());
        Map<String, String> eocMap = transDataManager.getEocMap();
        if (MapUtils.isNotEmpty(eocMap) && StringUtils.isNotBlank(eocLevel)) {
            queryData.put("eocMap", eocMap);
        }
        queryData.put("eocLevel", eocLevel);
        result.put("queryData", queryData);
        return result;
    }
}

