/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans.components;

import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.digiwin.athena.executionengine.trans.pojo.element.DealResult;
import com.digiwin.athena.executionengine.trans.pojo.element.StepElement;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="chooseColumn")
public class ChooseColumnStep
extends TransAbstractStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChooseColumnStep.class);

    @Override
    public boolean defineCheck(StepElement stepElement) {
        return true;
    }

    @Override
    public DealResult doDealData(Step step) {
        DealResult dealResult = new DealResult();
        Object inputData = this.getCurrentData(step.getPrevStepNameList());
        if (!(inputData instanceof List)) {
            LOGGER.error("addColumnstep\u7ec4\u4ef6\u53ea\u80fd\u5904\u7406\u8868\u72b6\u6570\u636e\uff0c\u975e\u8868\u72b6\u6570\u636e\u9700\u8981\u5148\u6267\u884c\u5c55\u5e73\u8282\u70b9\uff01Trans\u6267\u884c {} \u5931\u8d25\uff0c\u6570\u636e\u7ed3\u6784\u9519\u8bef\uff01", (Object)step.getName());
            dealResult.setDataNullFail();
            return dealResult;
        }
        List dataList = (List)inputData;
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            dealResult.setSuccess(Lists.newArrayList());
            return dealResult;
        }
        List<String> fieldList = step.getStepElement().getFields();
        if (CollectionUtils.isEmpty(fieldList)) {
            LOGGER.warn("chooseColumn\u5b9a\u4e49\u6ca1\u6709field\u5b57\u6bb5");
            dealResult.setSuccess(dataList);
            return dealResult;
        }
        if (step.getStepElement().getType().equals("remove")) {
            dataList.forEach(item -> item.remove(fieldList));
        } else if (step.getStepElement().getType().equals("retain")) {
            List<String> removeColumn = this.getRemoveColumnMap(fieldList, dataList);
            dataList.forEach(item -> removeColumn.forEach(k -> item.remove(k)));
        } else {
            LOGGER.error("chooseColumn\u9009\u62e9\u7c7b\u578b\u6ca1\u6709\u5b9a\u4e49\uff1a{}", (Object)step.getStepElement().getType());
            dealResult.setDataNullFail();
            return dealResult;
        }
        dealResult.setSuccess(dataList);
        return dealResult;
    }

    private List<String> getRemoveColumnMap(List<String> fieldList, List<Map<String, Object>> dataList) {
        Map<String, Object> record = dataList.get(0);
        ArrayList<String> removeKey = new ArrayList<String>();
        for (String key : record.keySet()) {
            if (fieldList.contains(key)) continue;
            removeKey.add(key);
        }
        return removeKey;
    }
}

