/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans.components;

import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.digiwin.athena.executionengine.trans.core.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.trans.core.exception.VerificationException;
import com.digiwin.athena.executionengine.trans.pojo.element.AddColumnElement;
import com.digiwin.athena.executionengine.trans.pojo.element.DealResult;
import com.digiwin.athena.executionengine.trans.pojo.element.StepElement;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="addColumn")
public class AddColumnStep
extends TransAbstractStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddColumnStep.class);

    @Override
    public DealResult doDealData(Step step) {
        DealResult dealResult = new DealResult();
        Object inputData = this.getCurrentData(step.getPrevStepNameList());
        if (!(inputData instanceof List)) {
            LOGGER.error("addColumnstep\u7ec4\u4ef6\u53ea\u80fd\u5904\u7406\u8868\u72b6\u6570\u636e\uff0c\u975e\u8868\u72b6\u6570\u636e\u9700\u8981\u5148\u6267\u884c\u5c55\u5e73\u8282\u70b9\uff01Trans\u6267\u884c {} \u5931\u8d25\uff0c\u6570\u636e\u7ed3\u6784\u9519\u8bef\uff01", (Object)step.getName());
            dealResult.setDataNullFail();
            return dealResult;
        }
        if (!this.ruleKeyExistsInCurrentData(step)) {
            LOGGER.error("\u89c4\u5219\u5b9a\u4e49\u4e2d\u914d\u7f6e\u7684newField\uff0c\u5728\u6e90\u6570\u636e\u4e2d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5stepName:{}", (Object)step.getName());
            dealResult.setDataNullFail();
            return dealResult;
        }
        List dataList = (List)inputData;
        if (CollectionUtils.isEmpty(dataList)) {
            dealResult.setSuccess(Lists.newArrayList());
            return dealResult;
        }
        Map<String, Object> columnMap = this.getColumnMap(step.getStepElement());
        dataList.forEach(item -> item.putAll(columnMap));
        dealResult.setSuccess(dataList);
        return dealResult;
    }

    private Map<String, Object> getColumnMap(StepElement stepElement) {
        List<AddColumnElement> rules = stepElement.getRules();
        HashMap<String, Object> columnMap = new HashMap<String, Object>();
        rules.forEach(addColumnElement -> {
            Object value = this.getColumnValue((AddColumnElement)addColumnElement, stepElement.getTechnique());
            columnMap.put(addColumnElement.getNewField(), value);
        });
        return columnMap;
    }

    private Object getColumnValue(AddColumnElement addColumnElement, String technique) {
        String type = addColumnElement.getType();
        String valueType = addColumnElement.getValueType();
        Object value = null;
        if ("constant".equalsIgnoreCase(type)) {
            value = addColumnElement.getValue();
        } else if ("var".equalsIgnoreCase(type)) {
            value = this.getTransDataManager().getMechanismData(addColumnElement.getValue());
        }
        if (value == null) {
            LOGGER.error("addColumn\u7ec4\u4ef6\u83b7\u53d6\u5217\u503c\u5931\u8d25\uff01");
            throw new VerificationException(ErrorCodeEnum.TRANS_RULE_DEFINE_ERROR.getMessage());
        }
        if ("string".equalsIgnoreCase(valueType)) {
            return String.valueOf(value);
        }
        try {
            return Integer.parseInt(String.valueOf(value));
        }
        catch (NumberFormatException e) {
            LOGGER.error("value\u65e0\u6cd5\u8f6c\u6362\u6210integer\uff01value:{},type:{}", value, (Object)type);
            throw e;
        }
    }

    @Override
    public boolean defineCheck(StepElement stepElement) {
        List rules = stepElement.getRules();
        if (CollectionUtils.isEmpty(rules)) {
            LOGGER.error("rules\u5b9a\u4e49\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5stepName:{}", (Object)stepElement.getName());
            return false;
        }
        boolean ruleCheck = rules.stream().anyMatch(this::addColumnElementCheck);
        if (!ruleCheck) {
            return ruleCheck;
        }
        return this.ruleKeyDefinedCheck(stepElement);
    }

    private boolean ruleKeyDefinedCheck(StepElement stepElement) {
        List rules = stepElement.getRules();
        HashSet<String> newFieldSet = new HashSet<String>();
        for (AddColumnElement addColumnElement : rules) {
            newFieldSet.add(addColumnElement.getNewField());
        }
        if (newFieldSet.size() != rules.size()) {
            LOGGER.error("rules\u4e2d\u7684newField\u5b58\u5728\u91cd\u590d\u7684\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5stepName:{}", (Object)stepElement.getName());
            return false;
        }
        return true;
    }

    private boolean ruleKeyExistsInCurrentData(Step step) {
        List rules = step.getStepElement().getRules();
        HashSet<String> newFieldSet = new HashSet<String>();
        for (AddColumnElement addColumnElement : rules) {
            newFieldSet.add(addColumnElement.getNewField());
        }
        Set<String> inputDataKeySet = this.getInputDataKeys(step);
        return this.compare2Set(inputDataKeySet, newFieldSet);
    }

    public boolean compare2Set(Set<String> inputDataKeySet, Set<String> newFieldSet) {
        for (String inputKey : inputDataKeySet) {
            if (!newFieldSet.contains(inputKey)) continue;
            return false;
        }
        return true;
    }

    private Set<String> getInputDataKeys(Step step) {
        List dataList = (List)this.getCurrentData(step.getPrevStepNameList());
        HashSet<String> inputDataKeys = new HashSet<String>();
        dataList.forEach(item -> inputDataKeys.addAll(item.keySet()));
        return inputDataKeys;
    }

    private boolean addColumnElementCheck(AddColumnElement rule) {
        if (StringUtils.isEmpty(rule.getNewField()) || StringUtils.isEmpty(rule.getValueType()) || StringUtils.isEmpty(rule.getType()) || rule.getValue() == null) {
            return false;
        }
        if (!"constant".equalsIgnoreCase(rule.getType()) && !"var".equalsIgnoreCase(rule.getType())) {
            return false;
        }
        return "number".equalsIgnoreCase(rule.getValueType()) || "string".equalsIgnoreCase(rule.getValueType());
    }
}

