/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans.components;

import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.digiwin.athena.executionengine.trans.core.exception.BusinessException;
import com.digiwin.athena.executionengine.trans.pojo.dto.CalculateRuleDto;
import com.digiwin.athena.executionengine.trans.pojo.element.DealResult;
import com.digiwin.athena.executionengine.trans.pojo.element.StepElement;
import com.digiwin.athena.executionengine.trans.util.DateUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="calculate")
public class CalculateStep
extends TransAbstractStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculateStep.class);
    private static final long ONE_DAY_MILLISECOND = 86400000L;

    @Override
    public boolean defineCheck(StepElement stepElement) {
        List<CalculateRuleDto> rules = stepElement.getCalculateRuleDtoList();
        boolean checkResult = false;
        for (CalculateRuleDto rule : rules) {
            if ("WeekOfYearOfDate".equals(rule.getCalcType())) {
                checkResult = this.checkWeekOfYearOfDate(rule);
            } else if ("Add".equals(rule.getCalcType())) {
                checkResult = this.checkAdd(rule);
            } else if ("Abs".equals(rule.getCalcType())) {
                checkResult = this.checkAbs(rule);
            } else if ("Minus".equals(rule.getCalcType())) {
                checkResult = this.checkMinus(rule);
            } else if ("Multiply".equals(rule.getCalcType())) {
                checkResult = this.checkMultiply(rule);
            } else if ("Divide".equals(rule.getCalcType())) {
                checkResult = this.checkDivide(rule);
            } else if ("DateDiffInDays".equals(rule.getCalcType())) {
                checkResult = this.checkDateDiffInDays(rule);
            } else if ("NumberOfIntervalByDay".equals(rule.getCalcType())) {
                checkResult = this.checkNumberOfIntervalByDay(rule);
            } else if ("Precision".equals(rule.getCalcType())) {
                checkResult = this.checkPrecision(rule);
            } else if ("FormatDate".equals(rule.getCalcType())) {
                checkResult = this.checkFormatDate(rule);
            } else if ("DateFormat".equals(rule.getCalcType())) {
                checkResult = this.checkDateFormat(rule);
            } else if ("Rooting".equals(rule.getCalcType())) {
                checkResult = this.checkRootingDate(rule);
            } else if ("Power".equals(rule.getCalcType())) {
                checkResult = this.checkPowerDate(rule);
            } else if ("GrowthRate".equals(rule.getCalcType())) {
                checkResult = this.checkGrowthRateDate(rule);
            } else {
                LOGGER.error("\u672a\u9884\u6599\u7684\u7b97\u6cd5:{}", (Object)rule.getCalcType());
                checkResult = false;
            }
            if (checkResult) continue;
            break;
        }
        return checkResult;
    }

    private boolean checkFormatDate(CalculateRuleDto rule) {
        return rule.getFieldA() != null && rule.getNewField() != null && rule.getValueType() != null && rule.getFormatA() != null;
    }

    private boolean checkDateFormat(CalculateRuleDto rule) {
        return rule.getFieldA() != null && rule.getNewField() != null && rule.getValueType() != null && rule.getFormatA() != null;
    }

    private boolean checkRootingDate(CalculateRuleDto rule) {
        return rule.getFieldA() != null && rule.getFieldB() != null && rule.getNewField() != null && rule.getValueType() != null && rule.getRetain() != null;
    }

    private boolean checkPowerDate(CalculateRuleDto rule) {
        return rule.getFieldA() != null && rule.getFieldB() != null && rule.getNewField() != null && rule.getValueType() != null && rule.getRetain() != null;
    }

    private boolean checkGrowthRateDate(CalculateRuleDto rule) {
        return rule.getFieldA() != null && rule.getFieldB() != null && rule.getNewField() != null && rule.getValueType() != null && rule.getRetain() != null;
    }

    private boolean checkAbs(CalculateRuleDto rule) {
        return rule.getFieldA() != null && rule.getNewField() != null && rule.getValueType() != null && rule.getRetain() != null;
    }

    private boolean checkPrecision(CalculateRuleDto rule) {
        if (rule.getFieldA() == null || rule.getPrecisionType() == null || rule.getPrecision() == null || rule.getNewField() == null || rule.getValueType() == null || rule.getRetain() == null) {
            LOGGER.error("\u8ba1\u7b97\u5668step Precision \u5b9a\u4e49\u9519\u8bef\uff01Trans\u6267\u884c {} \u5931\u8d25");
            return false;
        }
        return true;
    }

    @Override
    public DealResult doDealData(Step step) {
        DealResult dataResult = new DealResult();
        try {
            Object inputData = this.getCurrentData(step.getPrevStepNameList());
            if (!(inputData instanceof List)) {
                LOGGER.warn("\u8ba1\u7b97\u7ec4\u4ef6\u53ea\u80fd\u63a5\u53d7\u8868\u72b6\u6570\u636e\uff0c\u975e\u5c55\u5e73\u6570\u636e\u9700\u8981\u5148\u6267\u884c\u5c55\u5e73\u8282\u70b9\uff01Trans\u6267\u884c {} \u5931\u8d25\uff0c\u6570\u636e\u7ed3\u6784\u9519\u8bef\uff01", (Object)step.getName());
                dataResult.setDataNullFail();
                return dataResult;
            }
            List dataList = (List)inputData;
            for (Map data : dataList) {
                this.calculate(data, step.getStepElement());
            }
            dataResult.setSuccess(dataList);
            return dataResult;
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884c\u8ba1\u7b97\u7ec4\u4ef6\u51fa\u73b0\u5f02\u5e38", e);
            throw new BusinessException(e.getMessage());
        }
    }

    private void calculate(Map<String, Object> data, StepElement stepElement) throws ParseException {
        HashMap<String, Object> extraData = new HashMap<String, Object>();
        List<CalculateRuleDto> rules = stepElement.getCalculateRuleDtoList();
        for (CalculateRuleDto rule : rules) {
            boolean result;
            if ("WeekOfYearOfDate".equals(rule.getCalcType())) {
                result = this.calcWeekOfYearOfDate(data, extraData, rule);
            } else if ("Add".equals(rule.getCalcType())) {
                result = this.calcAdd(data, extraData, rule);
            } else if ("Abs".equals(rule.getCalcType())) {
                result = this.calcAbs(data, extraData, rule);
            } else if ("Minus".equals(rule.getCalcType())) {
                result = this.calcMinus(data, extraData, rule);
            } else if ("Multiply".equals(rule.getCalcType())) {
                result = this.calcMultiply(data, extraData, rule);
            } else if ("Divide".equals(rule.getCalcType())) {
                result = this.calcDivide(data, extraData, rule);
            } else if ("DateDiffInDays".equals(rule.getCalcType())) {
                result = this.calcDateDiffInDays(data, extraData, rule);
            } else if ("NumberOfIntervalByDay".equals(rule.getCalcType())) {
                result = this.calcNumberOfIntervalByDay(data, extraData, rule);
            } else if ("Precision".equals(rule.getCalcType())) {
                result = this.calcPrecision(data, extraData, rule);
            } else if ("FormatDate".equals(rule.getCalcType())) {
                result = this.calcFormatDate(data, extraData, rule);
            } else if ("DateFormat".equals(rule.getCalcType())) {
                result = this.calcDateFormat(data, extraData, rule);
            } else if ("Rooting".equals(rule.getCalcType())) {
                result = this.rooting(data, extraData, rule);
            } else if ("Power".equals(rule.getCalcType())) {
                result = this.power(data, extraData, rule);
            } else if ("GrowthRate".equals(rule.getCalcType())) {
                result = this.growthRate(data, extraData, rule);
            } else {
                LOGGER.error("\u672a\u9884\u6599\u7684\u7b97\u6cd5:{}", (Object)rule.getCalcType());
                return;
            }
            if (result) continue;
            LOGGER.error("\u8ba1\u7b97\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u8ba1\u7b97\u4e2d\u65ad\uff01");
            return;
        }
    }

    private boolean calcDateFormat(Map<String, Object> data, Map<String, Object> extraData, CalculateRuleDto rule) {
        if (StringUtils.isEmpty(String.valueOf(data.get(rule.getFieldA())))) {
            return true;
        }
        if ("true".equals(rule.getRetain())) {
            data.put(rule.getNewField(), data.get(rule.getFieldA()));
        }
        extraData.put(rule.getNewField(), data.get(rule.getFieldA()));
        return true;
    }

    private boolean calcFormatDate(Map<String, Object> data, Map<String, Object> extraData, CalculateRuleDto rule) {
        String fieldA = this.getData(data, extraData, rule.getFieldA(), rule.getFieldAType());
        if (StringUtils.isEmpty(fieldA)) {
            return true;
        }
        String inputFormat = this.analyseDatePattern(fieldA);
        String outputFormat = this.convertOutputFormat(rule.getFormatA(), rule.getSuffix());
        String date = DateUtils.convertDateFormat(fieldA, inputFormat, outputFormat);
        if ("true".equals(rule.getRetain())) {
            data.put(rule.getNewField(), date);
        }
        extraData.put(rule.getNewField(), date);
        return true;
    }

    private String convertOutputFormat(String formatA, String suffix) {
        if (StringUtils.isEmpty(suffix)) {
            return formatA;
        }
        if (StringUtils.isNotEmpty(this.getTransDataManager().getOutputFormat())) {
            return this.getTransDataManager().getOutputFormat();
        }
        formatA = formatA.replaceFirst("yyyy", "yyyy\u5e74");
        formatA = formatA.replaceFirst("MM", "MM\u6708");
        formatA = formatA.replaceFirst("dd", "dd\u65e5");
        this.getTransDataManager().setOutputFormat(formatA);
        return formatA;
    }

    private String analyseDatePattern(String date) {
        if (StringUtils.isNotEmpty(this.getTransDataManager().getInputFormat())) {
            return this.getTransDataManager().getInputFormat();
        }
        String pattern = DateUtils.analyseFormat(date);
        this.getTransDataManager().setInputFormat(pattern);
        return pattern;
    }

    private boolean calcPrecision(Map<String, Object> data, Map<String, Object> extraData, CalculateRuleDto rule) {
        String fieldA = this.getData(data, extraData, rule.getFieldA(), rule.getFieldAType());
        if (StringUtils.isEmpty(fieldA)) {
            LOGGER.error("\u6267\u884c\u8ba1\u7b97\u7ec4\u4ef6Precision\u6b65\u9aa4\u65f6\u9519\u8bef\uff0cfieldA\u6ca1\u6709\u53d6\u5230\u6570\u636e, data: {}", (Object)data);
            return false;
        }
        try {
            BigDecimal bigDecimal;
            switch (rule.getPrecisionType()) {
                case "ceil": {
                    bigDecimal = new BigDecimal(fieldA).setScale(Integer.parseInt(rule.getPrecision()), 2);
                    break;
                }
                case "floor": {
                    bigDecimal = new BigDecimal(fieldA).setScale(Integer.parseInt(rule.getPrecision()), 3);
                    break;
                }
                case "rounding": {
                    bigDecimal = new BigDecimal(fieldA).setScale(Integer.parseInt(rule.getPrecision()), 4);
                    break;
                }
                case "round_up": {
                    bigDecimal = new BigDecimal(fieldA).setScale(Integer.parseInt(rule.getPrecision()), 0);
                    break;
                }
                case "round_down": {
                    bigDecimal = new BigDecimal(fieldA).setScale(Integer.parseInt(rule.getPrecision()), 1);
                    break;
                }
                default: {
                    LOGGER.error("\u672a\u5339\u914d\u5230\u7684precisionType, precisionType: {}", (Object)rule.getPrecisionType());
                    return false;
                }
            }
            BigDecimal value = new BigDecimal(bigDecimal.toPlainString());
            if ("true".equals(rule.getRetain())) {
                data.put(rule.getNewField(), this.getValueByType(value, rule.getValueType()));
            }
            extraData.put(rule.getNewField(), value);
        }
        catch (NumberFormatException e) {
            LOGGER.error("\u6267\u884c\u8ba1\u7b97\u7ec4\u4ef6Precision\u6b65\u9aa4\u65f6\u9519\u8bef\uff0cfieldA\u4e3a\u975enumber\u7c7b\u578b, data: {}", (Object)data);
            return false;
        }
        return true;
    }

    private boolean calcNumberOfIntervalByDay(Map<String, Object> data, Map<String, Object> extraData, CalculateRuleDto rule) throws ParseException {
        String fieldA = this.getData(data, extraData, rule.getFieldA(), rule.getFieldAType());
        String fieldB = this.getData(data, extraData, rule.getFieldB(), rule.getFieldBType());
        if (StringUtils.isEmpty(fieldA)) {
            LOGGER.error("\u6267\u884c\u8ba1\u7b97\u7ec4\u4ef6Interval\u6b65\u9aa4\u65f6\u9519\u8bef\uff0cfieldA\u6ca1\u6709\u53d6\u5230\u6570\u636e, data: {}", (Object)data);
            return false;
        }
        if (StringUtils.isEmpty(fieldB)) {
            LOGGER.error("\u6267\u884c\u8ba1\u7b97\u7ec4\u4ef6Interval\u6b65\u9aa4\u65f6\u9519\u8bef\uff0cfieldB\u6ca1\u6709\u53d6\u5230\u6570\u636e, data: {}", (Object)data);
            return false;
        }
        long fieldALongTime = this.getFieldLongTime(fieldA, rule.getFormatA());
        long fieldBLongTime = this.getFieldLongTime(fieldB, rule.getFormatB());
        long difference = Math.abs(fieldALongTime - fieldBLongTime);
        double day = (double)difference / 8.64E7 + 1.0;
        int period = (int)Math.ceil(day / (double)rule.getIntervalDays());
        if ("true".equals(rule.getRetain())) {
            data.put(rule.getNewField(), this.getValueByType(new BigDecimal(period), rule.getValueType()));
        }
        extraData.put(rule.getNewField(), period);
        return true;
    }

    private long getFieldLongTime(String time, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = sdf.parse(time);
        Calendar calendar = sdf.getCalendar();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    private boolean calcAdd(Map<String, Object> data, Map<String, Object> extraData, CalculateRuleDto rule) {
        String fieldA = this.getData(data, extraData, rule.getFieldA(), rule.getFieldAType());
        String fieldB = this.getData(data, extraData, rule.getFieldB(), rule.getFieldBType());
        if (StringUtils.isEmpty(fieldA)) {
            fieldA = "0";
        }
        if (StringUtils.isEmpty(fieldB)) {
            fieldB = "0";
        }
        BigDecimal valueA = new BigDecimal(fieldA);
        BigDecimal valueB = new BigDecimal(fieldB);
        BigDecimal value = valueA.add(valueB);
        value = CalculateStep.getResultValue(rule.getPrecision(), value, CalculateStep.getRoundingMode(rule.getPrecisionType()));
        if ("true".equals(rule.getRetain())) {
            data.put(rule.getNewField(), this.getValueByType(value, rule.getValueType()));
        }
        extraData.put(rule.getNewField(), value);
        return true;
    }

    private boolean calcAbs(Map<String, Object> data, Map<String, Object> extraData, CalculateRuleDto rule) {
        String fieldA = this.getData(data, extraData, rule.getFieldA(), rule.getFieldAType());
        if (StringUtils.isEmpty(fieldA)) {
            fieldA = "0";
        }
        BigDecimal valueA = new BigDecimal(fieldA);
        BigDecimal value = valueA.abs();
        value = CalculateStep.getResultValue(rule.getPrecision(), value, CalculateStep.getRoundingMode(rule.getPrecisionType()));
        if ("true".equals(rule.getRetain())) {
            data.put(rule.getNewField(), this.getValueByType(value, rule.getValueType()));
        }
        extraData.put(rule.getNewField(), value);
        return true;
    }

    private boolean checkAdd(CalculateRuleDto rule) {
        return rule.getFieldA() != null && rule.getFieldB() != null && rule.getNewField() != null && rule.getValueType() != null && rule.getRetain() != null;
    }

    private boolean calcMinus(Map<String, Object> data, Map<String, Object> extraData, CalculateRuleDto rule) {
        String fieldA = this.getData(data, extraData, rule.getFieldA(), rule.getFieldAType());
        String fieldB = this.getData(data, extraData, rule.getFieldB(), rule.getFieldBType());
        if (StringUtils.isEmpty(fieldA)) {
            fieldA = "0";
        }
        if (StringUtils.isEmpty(fieldB)) {
            fieldB = "0";
        }
        BigDecimal valueA = new BigDecimal(fieldA);
        BigDecimal valueB = new BigDecimal(fieldB);
        BigDecimal value = valueA.subtract(valueB);
        value = CalculateStep.getResultValue(rule.getPrecision(), value, CalculateStep.getRoundingMode(rule.getPrecisionType()));
        if ("true".equals(rule.getRetain())) {
            data.put(rule.getNewField(), this.getValueByType(value, rule.getValueType()));
        }
        extraData.put(rule.getNewField(), value);
        return true;
    }

    private boolean checkMinus(CalculateRuleDto rule) {
        return rule.getFieldA() != null && rule.getFieldB() != null && rule.getNewField() != null && rule.getValueType() != null && rule.getRetain() != null;
    }

    private boolean calcMultiply(Map<String, Object> data, Map<String, Object> extraData, CalculateRuleDto rule) {
        String fieldA = this.getData(data, extraData, rule.getFieldA(), rule.getFieldAType());
        String fieldB = this.getData(data, extraData, rule.getFieldB(), rule.getFieldBType());
        if (StringUtils.isEmpty(fieldA)) {
            fieldA = "0";
        }
        if (StringUtils.isEmpty(fieldB)) {
            fieldB = "0";
        }
        BigDecimal valueA = new BigDecimal(fieldA);
        BigDecimal valueB = new BigDecimal(fieldB);
        BigDecimal value = valueA.multiply(valueB);
        value = CalculateStep.getResultValue(rule.getPrecision(), value, CalculateStep.getRoundingMode(rule.getPrecisionType()));
        if ("true".equals(rule.getRetain())) {
            data.put(rule.getNewField(), this.getValueByType(value, rule.getValueType()));
        }
        extraData.put(rule.getNewField(), value);
        return true;
    }

    private boolean checkMultiply(CalculateRuleDto rule) {
        return rule.getFieldA() != null && rule.getFieldB() != null && rule.getNewField() != null && rule.getValueType() != null && rule.getRetain() != null;
    }

    private boolean calcDivide(Map<String, Object> data, Map<String, Object> extraData, CalculateRuleDto rule) {
        String fieldA = this.getData(data, extraData, rule.getFieldA(), rule.getFieldAType());
        String fieldB = this.getData(data, extraData, rule.getFieldB(), rule.getFieldBType());
        if (StringUtils.isEmpty(fieldA)) {
            fieldA = "0";
        }
        if (StringUtils.isEmpty(fieldB)) {
            fieldB = "0";
        }
        BigDecimal valueA = new BigDecimal(fieldA);
        BigDecimal valueB = new BigDecimal(fieldB);
        BigDecimal value = new BigDecimal(0);
        if (valueB.compareTo(BigDecimal.ZERO) == 0) {
            if (rule.getExceptionHandling() == null || "divideDefault".equals(rule.getExceptionHandling())) {
                value = valueA.compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal(0) : new BigDecimal(1);
            } else if ("DividedZeroToZero".equals(rule.getExceptionHandling())) {
                value = new BigDecimal(0);
            }
        } else {
            value = valueA.divide(valueB, (int)CalculateStep.getPrecision(rule.getPrecision()), CalculateStep.getRoundingMode(rule.getPrecisionType()));
            value = new BigDecimal(value.stripTrailingZeros().toPlainString());
        }
        if ("true".equals(rule.getRetain())) {
            data.put(rule.getNewField(), this.getValueByType(value, rule.getValueType()));
        }
        extraData.put(rule.getNewField(), value);
        return true;
    }

    private boolean checkDivide(CalculateRuleDto rule) {
        return rule.getFieldA() != null && rule.getFieldB() != null && rule.getNewField() != null && rule.getValueType() != null && rule.getRetain() != null;
    }

    private boolean calcDateDiffInDays(Map<String, Object> data, Map<String, Object> extraData, CalculateRuleDto rule) {
        BigDecimal value;
        String fieldA = this.getData(data, extraData, rule.getFieldA(), rule.getFieldAType());
        String fieldB = this.getData(data, extraData, rule.getFieldB(), rule.getFieldBType());
        if (fieldA == null || fieldA.isEmpty()) {
            LOGGER.error("\u6267\u884c\u8ba1\u7b97\u7ec4\u4ef6DateDiffInDays\u6b65\u9aa4\u65f6\uff0cfieldA\u6ca1\u6709\u53d6\u5230\u6570\u636e, data: {}", (Object)data);
            return false;
        }
        if (fieldB == null || fieldB.isEmpty()) {
            LOGGER.error("\u6267\u884c\u8ba1\u7b97\u7ec4\u4ef6DateDiffInDays\u6b65\u9aa4\u65f6\uff0cfieldB\u6ca1\u6709\u53d6\u5230\u6570\u636e, data: {}", (Object)data);
            return false;
        }
        try {
            value = DateUtils.getDateDiffInDays(rule.getFormatA(), rule.getFormatB(), fieldA, fieldB);
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884c\u8ba1\u7b97\u7ec4\u4ef6DateDiffInDays\u6b65\u9aa4\u65f6\u51fa\u73b0\u5f02\u5e38, data: {}, extraData: {}", (Object)data, (Object)extraData);
            return false;
        }
        if ("true".equals(rule.getRetain())) {
            data.put(rule.getNewField(), this.getValueByType(value, rule.getValueType()));
        }
        extraData.put(rule.getNewField(), value);
        return true;
    }

    private boolean power(Map<String, Object> data, Map<String, Object> extraData, CalculateRuleDto rule) {
        String fieldA = this.getData(data, extraData, rule.getFieldA(), rule.getFieldAType());
        String fieldB = this.getData(data, extraData, rule.getFieldB(), rule.getFieldBType());
        if (StringUtils.isEmpty(fieldA)) {
            fieldA = "0";
        }
        if (StringUtils.isEmpty(fieldB) || Integer.parseInt(fieldB) < 0) {
            fieldB = "0";
        }
        BigDecimal valueA = new BigDecimal(fieldA);
        int n = Integer.parseInt(fieldB);
        BigDecimal value = valueA.pow(n);
        value = CalculateStep.getResultValue(rule.getPrecision(), value, CalculateStep.getRoundingMode(rule.getPrecisionType()));
        if ("true".equals(rule.getRetain())) {
            data.put(rule.getNewField(), this.getValueByType(value, rule.getValueType()));
        }
        extraData.put(rule.getNewField(), value);
        return true;
    }

    private boolean rooting(Map<String, Object> data, Map<String, Object> extraData, CalculateRuleDto rule) {
        String fieldA = this.getData(data, extraData, rule.getFieldA(), rule.getFieldAType());
        String fieldB = this.getData(data, extraData, rule.getFieldB(), rule.getFieldBType());
        if (StringUtils.isEmpty(fieldA)) {
            fieldA = "0";
        }
        if (StringUtils.isEmpty(fieldB)) {
            fieldB = "0";
        }
        BigDecimal valueA = new BigDecimal(fieldA);
        BigDecimal value = new BigDecimal(0);
        if (Integer.parseInt(fieldA) < 0) {
            if (rule.getExceptionHandling() == null || "baseLessThanZero".equals(rule.getExceptionHandling())) {
                value = new BigDecimal(0);
            }
        } else if (Integer.parseInt(fieldB) < 0) {
            if (rule.getExceptionHandling() == null || "radicandLessEqualZero".equals(rule.getExceptionHandling())) {
                value = new BigDecimal(0);
            }
        } else {
            int n = Integer.parseInt(fieldB);
            value = BigDecimal.valueOf(Math.pow(valueA.doubleValue(), 1.0 / (double)n));
            value = CalculateStep.getResultValue(rule.getPrecision(), value, CalculateStep.getRoundingMode(rule.getPrecisionType()));
        }
        if ("true".equals(rule.getRetain())) {
            data.put(rule.getNewField(), this.getValueByType(value, rule.getValueType()));
        }
        extraData.put(rule.getNewField(), value);
        return true;
    }

    private boolean growthRate(Map<String, Object> data, Map<String, Object> extraData, CalculateRuleDto rule) {
        String fieldA = this.getData(data, extraData, rule.getFieldA(), rule.getFieldAType());
        String fieldB = this.getData(data, extraData, rule.getFieldB(), rule.getFieldBType());
        if (StringUtils.isEmpty(fieldA)) {
            fieldA = "0";
        }
        if (StringUtils.isEmpty(fieldB)) {
            fieldB = "0";
        }
        BigDecimal valueA = new BigDecimal(fieldA);
        BigDecimal valueB = new BigDecimal(fieldB);
        BigDecimal value = new BigDecimal(0);
        if (valueB.compareTo(BigDecimal.ZERO) == 0) {
            if (rule.getExceptionHandling() == null || "divideDefault".equals(rule.getExceptionHandling())) {
                value = valueA.compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal(0) : new BigDecimal(1);
            }
        } else {
            value = valueA.subtract(valueB).divide(valueB.abs(), (int)CalculateStep.getPrecision(rule.getPrecision()), CalculateStep.getRoundingMode(rule.getPrecisionType()));
            value = new BigDecimal(value.stripTrailingZeros().toPlainString());
        }
        if ("true".equals(rule.getRetain())) {
            data.put(rule.getNewField(), this.getValueByType(value, rule.getValueType()));
        }
        extraData.put(rule.getNewField(), value);
        return true;
    }

    public static BigDecimal getResultValue(String precision, BigDecimal value, RoundingMode roundingMode) {
        Integer precisionValue = CalculateStep.getPrecision(precision);
        value = value.setScale((int)precisionValue, roundingMode);
        value = new BigDecimal(value.stripTrailingZeros().toPlainString());
        return value;
    }

    public static Integer getPrecision(String precision) {
        int i = precision == null || !precision.matches("\\d+") ? 32 : Integer.parseInt(precision);
        return i;
    }

    public static RoundingMode getRoundingMode(String precisionType) {
        RoundingMode roundingMode;
        if (null == precisionType) {
            return RoundingMode.valueOf(4);
        }
        switch (precisionType) {
            case "ceil": {
                roundingMode = RoundingMode.valueOf(2);
                break;
            }
            case "floor": {
                roundingMode = RoundingMode.valueOf(3);
                break;
            }
            case "round_up": {
                roundingMode = RoundingMode.valueOf(0);
                break;
            }
            case "round_down": {
                roundingMode = RoundingMode.valueOf(1);
                break;
            }
            default: {
                roundingMode = RoundingMode.valueOf(4);
            }
        }
        return roundingMode;
    }

    private boolean checkDateDiffInDays(CalculateRuleDto rule) {
        return rule.getFieldA() != null && rule.getFieldB() != null && rule.getFormatA() != null && rule.getFormatB() != null && rule.getNewField() != null && rule.getValueType() != null && rule.getRetain() != null;
    }

    private boolean checkNumberOfIntervalByDay(CalculateRuleDto rule) {
        return rule.getFieldA() != null && rule.getFormatA() != null && rule.getFieldAType() != null && rule.getFieldB() != null && rule.getFormatB() != null && rule.getFieldBType() != null && rule.getNewField() != null && rule.getValueType() != null && rule.getRetain() != null && rule.getIntervalDays() != 0;
    }

    private boolean calcWeekOfYearOfDate(Map<String, Object> data, Map<String, Object> extraData, CalculateRuleDto rule) {
        try {
            String fieldA = this.getData(data, extraData, rule.getFieldA(), rule.getFieldAType());
            if (StringUtils.isEmpty(fieldA)) {
                LOGGER.error("\u6267\u884c\u8ba1\u7b97\u7ec4\u4ef6WeekOfYearOfDate\u6b65\u9aa4\u65f6\u9519\u8bef\uff0cfieldA\u6ca1\u6709\u53d6\u5230\u6570\u636e, data: {}", (Object)data);
                return false;
            }
            BigDecimal value = new BigDecimal(DateUtils.getWeekOfYear(fieldA, rule.getFormatA()));
            if ("true".equals(rule.getRetain())) {
                data.put(rule.getNewField(), this.getValueByType(value, rule.getValueType()));
            }
            extraData.put(rule.getNewField(), value);
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884c\u8ba1\u7b97\u7ec4\u4ef6WeekOfYearOfDate\u6b65\u9aa4\u65f6\u51fa\u73b0\u5f02\u5e38, data: {}, extraData: {}", (Object)data, (Object)extraData);
        }
        return true;
    }

    private boolean checkWeekOfYearOfDate(CalculateRuleDto rule) {
        return rule.getFieldA() != null && rule.getFormatA() != null && !rule.getFormatA().isEmpty() && rule.getNewField() != null && rule.getValueType() != null && rule.getRetain() != null;
    }

    private String getData(Map<String, Object> data, Map<String, Object> extraData, String fieldName, String fieldType) {
        if (StringUtils.isEmpty(fieldType)) {
            fieldType = "column";
        }
        if ("constant".equalsIgnoreCase(fieldType)) {
            return fieldName;
        }
        if ("column".equalsIgnoreCase(fieldType)) {
            return this.getData(data, extraData, fieldName);
        }
        return null;
    }

    private String getData(Map<String, Object> data, Map<String, Object> extraData, String fieldName) {
        Object value = data.get(fieldName);
        if (value != null) {
            return value.toString();
        }
        value = extraData.get(fieldName);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    private Object getValueByType(BigDecimal value, String valueType) {
        if (value == null) {
            LOGGER.error("\u8ba1\u7b97\u7ed3\u679c\u8f6c\u6362\u65f6\u9519\u8bef\uff0c\u8ba1\u7b97\u7ed3\u679c\u4e3anull!");
            return null;
        }
        if ("String".equals(valueType) || "string".equals(valueType)) {
            return value.toString();
        }
        if ("Number".equals(valueType) || "number".equals(valueType)) {
            return value;
        }
        LOGGER.error("\u6267\u884c\u8ba1\u7b97\u7ec4\u4ef6add\u6b65\u9aa4\u65f6\u9519\u8bef\uff0c\u672a\u9884\u6599\u7684valueType: {}", (Object)valueType);
        return null;
    }
}

