/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans.components;

import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.digiwin.athena.executionengine.trans.pojo.element.DealResult;
import com.digiwin.athena.executionengine.trans.pojo.element.StepElement;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="distinct")
public class DistinctStep
extends TransAbstractStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistinctStep.class);

    @Override
    public boolean defineCheck(StepElement stepElement) {
        return true;
    }

    @Override
    public DealResult doDealData(Step step) {
        DealResult dealResult = new DealResult();
        Object inputData = this.getCurrentData(step.getPrevStepNameList());
        if (!(inputData instanceof List)) {
            LOGGER.warn("\u6570\u636e\u53bb\u91cd\u7ec4\u4ef6\u53ea\u80fd\u63a5\u53d7\u8868\u72b6\u6570\u636e\uff0c\u975e\u5c55\u5e73\u6570\u636e\u9700\u8981\u5148\u6267\u884c\u5c55\u5e73\u8282\u70b9\uff01Trans\u6267\u884c {} \u5931\u8d25\uff0c\u6570\u636e\u7ed3\u6784\u9519\u8bef\uff01", (Object)step.getName());
            dealResult.setDataNullFail();
            return dealResult;
        }
        List dataList = (List)inputData;
        if (CollectionUtils.isEmpty(dataList)) {
            dealResult.setSuccess(Lists.newArrayList());
            return dealResult;
        }
        List<String> fieldList = step.getStepElement().getFields();
        if (CollectionUtils.isEmpty(fieldList)) {
            LOGGER.warn("\u5bf9\u5e94\u7684distinct\u5143\u7d20\u4e2d\u6ca1\u6709field\u5b57\u6bb5");
            dealResult.setSuccess(dataList);
            return dealResult;
        }
        dealResult.setSuccess(this.distinctByFieldMap(dataList, fieldList, step.getStepElement().isReturnAll()));
        return dealResult;
    }

    private List<Map<String, Object>> distinctByFieldMap(List<Map<String, Object>> dataList, List<String> fieldList, boolean returnAll) {
        List<Map<String, Object>> collect = dataList.stream().filter(DistinctStep.distinctByKey(map -> this.createFunction((Map<String, Object>)map, fieldList))).collect(Collectors.toList());
        if (returnAll) {
            return collect;
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        collect.forEach(value -> {
            LinkedHashMap rowMap = new LinkedHashMap();
            fieldList.forEach(field -> rowMap.put(field, value.get(field)));
            resultList.add(rowMap);
        });
        return resultList;
    }

    private Map<String, Object> createFunction(Map<String, Object> map, List<String> fieldList) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldList.forEach(field -> fieldMap.put((String)field, String.valueOf(map.get(field))));
        return fieldMap;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

