/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans;

import com.digiwin.athena.executionengine.trans.ITransStep;
import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.StepLine;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.core.exception.VerificationException;
import com.digiwin.athena.executionengine.trans.pojo.element.OrderElement;
import com.digiwin.athena.executionengine.trans.pojo.element.StepElement;
import com.digiwin.athena.executionengine.trans.util.TransAnalysisUtils;
import com.digiwin.athena.executionengine.trans.util.TransSpringContextUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class TransEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransEngine.class);
    private static ThreadLocal<TransDataManger> LOCAL_CONTEXT = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runEngine(TransDataManger transDataManger) {
        try {
            LOCAL_CONTEXT.set(transDataManger);
            StepLine stepLine = this.runTrans();
            Object object = transDataManger.getCurrentData(stepLine.getEndStep().getName());
            return object;
        }
        finally {
            LOCAL_CONTEXT.remove();
        }
    }

    protected StepLine runTrans() {
        StepLine stepLine = this.buildStepLine();
        if (stepLine == null) {
            throw new VerificationException("trans rule is error");
        }
        int runResult = 0;
        for (Step startStep : stepLine.getStartStepList()) {
            List stepOrders = (List)stepLine.getOrderFromIndex().get((Object)startStep.getName());
            if (stepOrders == null || stepOrders.size() <= 0) {
                runResult = this.run(startStep, null, stepLine);
            } else {
                OrderElement order;
                Iterator iterator = stepOrders.iterator();
                while (iterator.hasNext() && (runResult = this.run(startStep, order = (OrderElement)iterator.next(), stepLine)) != 0) {
                }
            }
            if (runResult != 0) continue;
            break;
        }
        return stepLine;
    }

    private StepLine buildStepLine() {
        TransDataManger transDataManger = TransEngine.getLocalContext();
        if (transDataManger.getOriginData() == null) {
            LOGGER.error("\u4f20\u5165\u7684originData\u4e3anull");
            return null;
        }
        StepLine stepLine = new StepLine();
        stepLine.setStepElementList(TransAnalysisUtils.parseStep(transDataManger.getRuleJsonObj()));
        if (CollectionUtils.isEmpty(stepLine.getStepElementList())) {
            LOGGER.error("trans\u65e0\u9700\u8981\u6267\u884c\u7684\u8ba1\u7b97\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5trans\u5b9a\u4e49\u662f\u5426\u5b8c\u6574\uff01");
            return null;
        }
        stepLine.setOrderElementList(TransAnalysisUtils.parseOrder(transDataManger.getRuleJsonObj()));
        if (stepLine.getStepElementList().size() > 1 && CollectionUtils.isEmpty(stepLine.getOrderElementList())) {
            LOGGER.error("\u7f3a\u5c11order\u90e8\u5206\u7684\u89c4\u5219\uff0c\u6709\u4e9b\u8282\u70b9\u5c06\u65e0\u6cd5\u88ab\u6267\u884c\uff01");
            return null;
        }
        this.setIndexOfOrder(stepLine);
        for (StepElement stepElement : stepLine.getStepElementList()) {
            List<String> prevStepNameList = this.getFromNameInOrderToIndex(stepElement, stepLine);
            Step step = new Step(prevStepNameList, stepElement);
            ITransStep component = (ITransStep)TransSpringContextUtils.getBean(step.getTechnique(), new Object[0]);
            if (!component.defineCheck(stepElement)) {
                LOGGER.error("\u89c4\u5219\u5b9a\u4e49\u6821\u9a8c\u5931\u8d25\uff0cstep name:{},technique:{}", (Object)stepElement.getName(), (Object)stepElement.getTechnique());
                return null;
            }
            stepLine.getStepMap().put(stepElement.getName(), step);
        }
        this.setStartAndEndStep(stepLine);
        return stepLine;
    }

    private void setStartAndEndStep(StepLine stepLine) {
        ArrayList<Step> steps = new ArrayList<Step>();
        if (CollectionUtils.isEmpty(stepLine.getOrderElementList())) {
            String stepName = stepLine.getStepElementList().get(0).getName();
            steps.add(stepLine.getStepMap().get(stepName));
            stepLine.setStartStepList(steps);
            stepLine.setEndStep(stepLine.getStepMap().get(stepName));
            return;
        }
        for (StepElement step : stepLine.getStepElementList()) {
            if (!stepLine.getOrderToIndex().containsKey((Object)step.getName())) {
                steps.add(stepLine.getStepMap().get(step.getName()));
            }
            if (stepLine.getEndStep() != null || stepLine.getOrderFromIndex().containsKey((Object)step.getName())) continue;
            stepLine.setEndStep(stepLine.getStepMap().get(step.getName()));
        }
        stepLine.setStartStepList(steps);
    }

    private int run(Step step, OrderElement order, StepLine stepLine) {
        String stepName = step.getName();
        try {
            ITransStep component = (ITransStep)TransSpringContextUtils.getBean(step.getTechnique(), new Object[0]);
            int result = component.dealData(step);
            if (result == 0) {
                String orderStr = order == null ? "EndStep" : order.getFrom() + "->" + order.getTo();
                LOGGER.error("TransEngine\u6267\u884cstep\uff1a{} \u5931\u8d25\uff0corder\uff1a{}", (Object)stepName, (Object)orderStr);
                return result;
            }
            if (result == 2) {
                String orderStr = order == null ? "EndStep" : order.getFrom() + "->" + order.getTo();
                LOGGER.warn("TransEngine\u6267\u884cstep\uff1a{} \u7f3a\u5c11\u6570\u636e\uff0corder\uff1a{}", (Object)stepName, (Object)orderStr);
                return result;
            }
            if (order == null) {
                return result;
            }
            List stepOrders = (List)stepLine.getOrderFromIndex().get((Object)order.getTo());
            if (stepOrders == null || stepOrders.size() <= 0) {
                result = this.run(stepLine.getStepMap().get(order.getTo()), null, stepLine);
            } else {
                for (OrderElement nextOrder : stepOrders) {
                    result = this.run(stepLine.getStepMap().get(order.getTo()), nextOrder, stepLine);
                    if (result != 0) continue;
                    break;
                }
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("TransEngine\u6267\u884c[" + stepName + "]step\u65f6\u5f02\u5e38", e);
            return 0;
        }
    }

    private List<String> getFromNameInOrderToIndex(StepElement stepElement, StepLine stepLine) {
        ArrayList<String> stepNameList = new ArrayList<String>();
        if (CollectionUtils.isEmpty(stepLine.getOrderElementList())) {
            return stepNameList;
        }
        List orderElementList = (List)stepLine.getOrderToIndex().get((Object)stepElement.getName());
        if (orderElementList == null) {
            return stepNameList;
        }
        for (OrderElement orderElement : orderElementList) {
            stepNameList.add(orderElement.getFrom());
        }
        return stepNameList;
    }

    private void setIndexOfOrder(StepLine stepLine) {
        if (CollectionUtils.isEmpty(stepLine.getOrderElementList())) {
            return;
        }
        for (OrderElement order : stepLine.getOrderElementList()) {
            stepLine.getOrderFromIndex().put((Object)order.getFrom(), (Object)order);
            stepLine.getOrderToIndex().put((Object)order.getTo(), (Object)order);
        }
    }

    protected static TransDataManger getLocalContext() {
        return LOCAL_CONTEXT.get();
    }
}

