/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.afc.report;

import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.uibot.domain.AFCOperationDTO;
import com.digiwin.athena.uibot.domain.ReportReleaseDTO;
import com.digiwin.athena.uibot.domain.dto.ExcelParamsDTO;
import com.digiwin.athena.uibot.domain.po.ReportMongoReportResultPO;
import com.digiwin.athena.uibot.service.ReportExcelService;
import com.digiwin.athena.uibot.service.ReportGetModelAPIService;
import com.digiwin.athena.uibot.service.ReportService;
import com.digiwin.athena.uibot.service.ReportSynCore;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/ai/report"})
public class AFCReportController {
    @Autowired
    private ReportService reportService;
    @Autowired
    private ReportSynCore reportSynCore;
    @Autowired
    private ReportGetModelAPIService reportGetModelAPIService;
    @Autowired
    private ReportExcelService reportExcelService;

    @PostMapping(value={"/{oper}"})
    public ResponseEntity<?> operReport(HttpServletRequest request, @RequestBody AFCOperationDTO afcOperationDTO) {
        return this.reportService.oper(request, afcOperationDTO);
    }

    @GetMapping(value={"/query/{modular}"})
    public ResponseEntity<?> queryReport(HttpServletRequest request, @PathVariable(value="modular") String modular) {
        return this.reportService.query(request, modular);
    }

    @GetMapping(value={"/query/{modular}/{id}"})
    public ResponseEntity<?> queryReport(HttpServletRequest request, @PathVariable(value="modular") String modular, @PathVariable(value="id") String id) {
        return this.reportService.design(request, modular, id);
    }

    @GetMapping(value={"/query/isSysRole"})
    public ResponseEntity<?> isSysRole(HttpServletRequest request) {
        return this.reportService.isSysRole(request);
    }

    @PostMapping(value={"reportModel/release"})
    public ResponseEntity<?> releaseReport(HttpServletRequest request, @RequestBody ReportReleaseDTO reportReleaseDTO) {
        return this.reportSynCore.synReportDatas(reportReleaseDTO);
    }

    @GetMapping(value={"/queryModelInfo"})
    public ResponseEntity<Map<String, Object>> queryModelInfo(HttpServletRequest request) {
        return this.reportGetModelAPIService.getModelAPIInfo(request);
    }

    @PostMapping(value={"/queryExcelInfo"})
    public ResponseEntity<List<ReportMongoReportResultPO>> queryExcelInfo(HttpServletRequest request, @RequestBody ExcelParamsDTO excelParamsDTO) {
        return ResponseEntityWrapper.wrapperOk((Object)this.reportExcelService.getExcelInfo(request, excelParamsDTO));
    }
}

