/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.loadbalance.scan.DWPathScan;
import java.net.InetAddress;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@DWPathScan
@EnableAsync
@EnableScheduling
@MapperScan(basePackages={"com.digiwin.athena.uibot.mapper"}, markerInterface=BaseMapper.class)
@EnableTransactionManagement
@SpringBootApplication(scanBasePackages={"com.digiwin.athena.uibot", "com.digiwin.athena.afc"})
public class UibotApplication {
    private static final Logger log = LoggerFactory.getLogger(UibotApplication.class);

    public static void main(String[] args) {
        ConfigurableApplicationContext application = SpringApplication.run(UibotApplication.class, (String[])args);
        ConfigurableEnvironment env = application.getEnvironment();
        String host = InetAddress.getLocalHost().getHostAddress();
        String port = env.getProperty("server.port");
        log.info("\n\t----------------------------------------------------------\n\tApplication '{}' is running! Access URLs:\n\tLocal: \t\thttp://localhost:{}\n\tExternal: \thttp://{}:{}\n\tDoc: \thttp://{}:{}/doc.html\n\tSwaggerDoc: \thttp://{}:{}/swagger-ui/index.html\n\t----------------------------------------------------------", new Object[]{env.getProperty("spring.application.name"), env.getProperty("server.port"), host, port, host, port, host, port});
    }
}

