/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.api;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.activity.domain.DataSourceSetDTO;
import com.digiwin.athena.uibot.activity.domain.QueryAction;
import com.digiwin.athena.uibot.activity.domain.TmActivity;
import com.digiwin.athena.uibot.activity.domain.TmPage;
import com.digiwin.athena.uibot.activity.domain.TmQueryAction;
import com.digiwin.athena.uibot.activity.service.ProjectDataSourceAnalysisService;
import com.digiwin.athena.uibot.activity.service.TaskDataSourceAnalysisService;
import com.digiwin.athena.uibot.support.atmc.domain.ActivityData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/v1/bot/action"})
public class ActionController {
    @Autowired
    private TaskDataSourceAnalysisService taskDataSourceAnalysisService;
    @Autowired
    private ProjectDataSourceAnalysisService projectDataSourceAnalysisService;

    @PostMapping(value={"project/reassign"})
    public ResponseEntity<?> generateProjectReassignAction(HttpServletRequest request, @RequestBody Map data) {
        String tmTaskId = MapUtils.getString((Map)data, (Object)"tmTaskId");
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("project-card", tmTaskId, null, "charge", Boolean.valueOf(false));
        if (data.containsKey("activityData")) {
            ActivityData activityData = (ActivityData)JsonUtils.jsonToObject((String)JsonUtils.objectToString(data.get("activityData")), ActivityData.class);
            executeContext.appendTaskData(activityData);
        }
        HashMap<String, TmQueryAction> dataSources = new HashMap<String, TmQueryAction>();
        if (data.containsKey("action")) {
            TmQueryAction action = (TmQueryAction)JsonUtils.jsonToObject((String)JsonUtils.objectToString(data.get("action")), TmQueryAction.class);
            dataSources.put("action", action);
        }
        TmActivity tmActivity = new TmActivity();
        TmPage page = new TmPage();
        page.setMergeQuery(Boolean.valueOf(true));
        tmActivity.setPages(page);
        DataSourceSetDTO dataSourceSetDTO = this.projectDataSourceAnalysisService.analysis(executeContext, tmActivity, dataSources, null);
        return ResponseEntityWrapper.wrapperOk((Object)this.getActions(dataSourceSetDTO));
    }

    @PostMapping(value={"task/reassign"})
    public ResponseEntity<?> generateTaskReassignAction(HttpServletRequest request, @RequestBody Map data) {
        String tmTaskId = MapUtils.getString((Map)data, (Object)"tmTaskId");
        String tmActivityId = MapUtils.getString((Map)data, (Object)"tmActivityId");
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("project-card", tmTaskId, tmActivityId, "performer", Boolean.valueOf(false));
        if (data.containsKey("activityData")) {
            ActivityData activityData = (ActivityData)JsonUtils.jsonToObject((String)JsonUtils.objectToString(data.get("activityData")), ActivityData.class);
            executeContext.appendTaskData(activityData);
        }
        HashMap<String, TmQueryAction> dataSources = new HashMap<String, TmQueryAction>();
        if (data.containsKey("action")) {
            TmQueryAction action = (TmQueryAction)JsonUtils.jsonToObject((String)JsonUtils.objectToString(data.get("action")), TmQueryAction.class);
            dataSources.put("action", action);
        }
        DataSourceSetDTO dataSourceSetDTO = this.taskDataSourceAnalysisService.analysis(executeContext, null, dataSources, null);
        return ResponseEntityWrapper.wrapperOk((Object)this.getActions(dataSourceSetDTO));
    }

    private List<QueryAction> getActions(DataSourceSetDTO dataSourceSetDTO) {
        ArrayList<QueryAction> list = new ArrayList<QueryAction>();
        if (dataSourceSetDTO != null && CollectionUtils.isNotEmpty((Collection)dataSourceSetDTO.getDataSourceList())) {
            dataSourceSetDTO.getDataSourceList().forEach(dataSourceDTO -> {
                if (dataSourceDTO.getAction() != null) {
                    list.add(dataSourceDTO.getAction());
                }
            });
        }
        return list;
    }
}

