/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.api;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.uibot.env.EnvProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/api/test"})
public class ApolloTestController {
    @Value(value="${key:default}")
    private String key;
    @Autowired
    EnvProperties envProperties;
    @Autowired(required=false)
    RestTemplate restTemplate;

    @GetMapping(value={"apollo/test"})
    public String test() {
        return this.key;
    }

    @GetMapping(value={"/nacos/info"})
    public String nacosInfo() {
        String statemode = System.getenv("STATEMODE");
        if (statemode == null) {
            statemode = "null";
        }
        return "uibot ,stateMode:" + statemode;
    }

    @GetMapping(value={"/nacos/atmc"})
    public String atmc(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        String url = this.envProperties.getAtmcUri() + "api/test/nacos/info";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", user.getToken());
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, String.class, new Object[0]);
        return (String)respEntity.getBody();
    }

    @GetMapping(value={"/nacos/atdm"})
    public String atdm(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        String url = this.envProperties.getAtdmUri() + "api/test/nacos/info";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", user.getToken());
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, String.class, new Object[0]);
        return (String)respEntity.getBody();
    }

    @GetMapping(value={"/nacos/audc"})
    public String audc(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        String url = this.envProperties.getAudcUri() + "/api/test/nacos/info";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", user.getToken());
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, String.class, new Object[0]);
        return (String)respEntity.getBody();
    }
}

