/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.api;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.activity.domain.PageDefine;
import com.digiwin.athena.uibot.activity.domain.QueryDTO;
import com.digiwin.athena.uibot.activity.domain.TaskPageDefine;
import com.digiwin.athena.uibot.api.domain.ShowLayoutActionIdDTO;
import com.digiwin.athena.uibot.api.domain.ShowLayoutByActionVO;
import com.digiwin.athena.uibot.domain.DynamicForm;
import com.digiwin.athena.uibot.dto.TaskPageDefineConvertor;
import com.digiwin.athena.uibot.dto.TaskPageDefineDTO;
import com.digiwin.athena.uibot.service.GeneralPageService;
import com.digiwin.athena.uibot.service.TaskPageService;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/v1/bot/"})
public class BotController {
    @Autowired
    private GeneralPageService generalPageService;
    @Autowired
    private TaskPageService taskPageService;
    @Autowired
    private TaskPageDefineConvertor taskPageDefineConvertor;

    @PostMapping(value={"action/show"})
    public ResponseEntity<?> actionShow(HttpServletRequest request, @RequestBody TaskPageDefineDTO pageDefineDTO) {
        DynamicForm dynamicForm;
        String isShared;
        TaskPageDefine pageDefine = this.taskPageDefineConvertor.to(pageDefineDTO);
        ExecuteContext executeContext = pageDefine.getExecuteContext();
        if (executeContext == null) {
            executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        } else {
            executeContext.appendHttpRequest(request);
        }
        if (StringUtils.hasText((String)executeContext.getProxyToken())) {
            AppAuthContextHolder.getContext().setProxyToken(executeContext.getProxyToken());
        }
        if (!StringUtils.isEmpty((Object)(isShared = request.getParameter("isShared")))) {
            executeContext.setIsShared(Boolean.valueOf(isShared));
        }
        if (!"DIALOG".equals(pageDefine.getQueryTagSuffix()) && ("project-detail".equals(executeContext.getPageCode()) || "task-detail".equals(executeContext.getPageCode()))) {
            dynamicForm = this.taskPageService.createPage(executeContext, pageDefine);
            if (CollectionUtils.isNotEmpty((Collection)dynamicForm.getRules())) {
                this.filterEditRules(dynamicForm.getRules());
            }
        } else {
            if ((executeContext.getOpenWindow() != null && executeContext.getOpenWindow().booleanValue() || "DIALOG".equals(pageDefine.getQueryTagSuffix())) && ("CUSTOM".equals(executeContext.getPattern()) || "DATA_ENTRY".equals(executeContext.getPattern()))) {
                executeContext.setPattern("DIALOG");
                pageDefine.setCanEdit(Boolean.valueOf(false));
            }
            dynamicForm = this.generalPageService.createOpenPage(executeContext, (PageDefine)pageDefine);
        }
        return ResponseEntityWrapper.wrapperOk((Object)dynamicForm);
    }

    private void filterEditRules(List<Map<String, Object>> rules) {
        ListIterator<Map<String, Object>> iterator = rules.listIterator();
        while (iterator.hasNext()) {
            Map rule = (Map)iterator.next();
            if (!rule.containsKey("scope") || !Objects.equals("EDIT", rule.get("scope"))) continue;
            iterator.remove();
        }
    }

    @PostMapping(value={"show/by/query/without/data"})
    public ResponseEntity<?> getLayoutByQuery(HttpServletRequest request, @RequestBody TaskPageDefineDTO pageDefineDTO) {
        TaskPageDefine pageDefine = this.taskPageDefineConvertor.to(pageDefineDTO);
        ExecuteContext executeContext = pageDefine.getExecuteContext();
        if (executeContext == null) {
            executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        } else {
            executeContext.appendHttpRequest(request);
        }
        if (StringUtils.hasText((String)executeContext.getProxyToken())) {
            AppAuthContextHolder.getContext().setProxyToken(executeContext.getProxyToken());
        }
        DynamicForm dynamicForm = this.generalPageService.createEmptyPage(executeContext, (PageDefine)pageDefine);
        return ResponseEntityWrapper.wrapperOk((Object)dynamicForm);
    }

    @PostMapping(value={"show/by/action"})
    public ResponseEntity<?> getLayoutByAction(HttpServletRequest request, @RequestBody ShowLayoutByActionVO queryDataByActionVO) {
        if (queryDataByActionVO.getTmAction() == null) {
            DynamicForm dynamicForm = new DynamicForm();
            return ResponseEntityWrapper.wrapperOk((Object)dynamicForm);
        }
        ExecuteContext executeContext = queryDataByActionVO.getExecuteContext();
        if (executeContext == null) {
            executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
            executeContext.setBusinessUnit(queryDataByActionVO.getBusinessUnit());
        } else {
            executeContext.appendHttpRequest(request);
        }
        if (StringUtils.hasText((String)executeContext.getProxyToken())) {
            AppAuthContextHolder.getContext().setProxyToken(executeContext.getProxyToken());
        }
        DynamicForm dynamicForm = this.generalPageService.createPage(executeContext, queryDataByActionVO.getTmAction(), queryDataByActionVO.getParameter(), queryDataByActionVO.getSubmitActions());
        return ResponseEntityWrapper.wrapperOk((Object)dynamicForm);
    }

    @PostMapping(value={"show/by/action/without/data"})
    public ResponseEntity<?> getLayoutByActionWithoutData(HttpServletRequest request, @RequestBody ShowLayoutByActionVO queryDataByActionVO) {
        if (queryDataByActionVO.getTmAction() == null) {
            DynamicForm dynamicForm = new DynamicForm();
            return ResponseEntityWrapper.wrapperOk((Object)dynamicForm);
        }
        ExecuteContext executeContext = queryDataByActionVO.getExecuteContext();
        if (executeContext == null) {
            executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
            executeContext.setBusinessUnit(queryDataByActionVO.getBusinessUnit());
        } else {
            executeContext.appendHttpRequest(request);
        }
        if (StringUtils.hasText((String)executeContext.getProxyToken())) {
            AppAuthContextHolder.getContext().setProxyToken(executeContext.getProxyToken());
        }
        DynamicForm dynamicForm = this.generalPageService.createEmptyPage(executeContext, queryDataByActionVO.getTmAction(), queryDataByActionVO.getParameter(), queryDataByActionVO.getSubmitActions());
        return ResponseEntityWrapper.wrapperOk((Object)dynamicForm);
    }

    @PostMapping(value={"show/by/actionId"})
    public ResponseEntity<?> getLayoutByAction(HttpServletRequest request, @RequestBody ShowLayoutActionIdDTO queryDataByActionVO) {
        if (StringUtils.isEmpty((Object)queryDataByActionVO.getActionId())) {
            DynamicForm dynamicForm = new DynamicForm();
            return ResponseEntityWrapper.wrapperOk((Object)dynamicForm);
        }
        ExecuteContext executeContext = queryDataByActionVO.getExecuteContext();
        if (executeContext == null) {
            executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
            executeContext.setBusinessUnit(queryDataByActionVO.getBusinessUnit());
        } else {
            executeContext.appendHttpRequest(request);
        }
        if (StringUtils.hasText((String)executeContext.getProxyToken())) {
            AppAuthContextHolder.getContext().setProxyToken(executeContext.getProxyToken());
        }
        DynamicForm dynamicForm = this.generalPageService.createPage(executeContext, queryDataByActionVO.getActionId(), queryDataByActionVO.getParameter(), queryDataByActionVO.getSubmitActionId());
        return ResponseEntityWrapper.wrapperOk((Object)dynamicForm);
    }

    @PostMapping(value={"show/by/actionId/without/data"})
    public ResponseEntity<?> getLayoutByActionWithoutData(HttpServletRequest request, @RequestBody ShowLayoutActionIdDTO queryDataByActionVO) {
        if (StringUtils.isEmpty((Object)queryDataByActionVO.getActionId())) {
            DynamicForm dynamicForm = new DynamicForm();
            return ResponseEntityWrapper.wrapperOk((Object)dynamicForm);
        }
        ExecuteContext executeContext = queryDataByActionVO.getExecuteContext();
        if (executeContext == null) {
            executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
            executeContext.setBusinessUnit(queryDataByActionVO.getBusinessUnit());
        } else {
            executeContext.appendHttpRequest(request);
        }
        if (StringUtils.hasText((String)executeContext.getProxyToken())) {
            AppAuthContextHolder.getContext().setProxyToken(executeContext.getProxyToken());
        }
        DynamicForm dynamicForm = this.generalPageService.createEmptyPage(executeContext, queryDataByActionVO.getActionId(), queryDataByActionVO.getParameter(), queryDataByActionVO.getSubmitActionId());
        return ResponseEntityWrapper.wrapperOk((Object)dynamicForm);
    }

    @Deprecated
    @PostMapping(value={"pageInfo/show"})
    public ResponseEntity<?> pageInfoShow(HttpServletRequest request, @RequestBody QueryDTO queryDTO) {
        ExecuteContext executeContext = new ExecuteContext();
        executeContext.appendHttpRequest(request);
        DynamicForm dynamicForm = this.generalPageService.createPageInfoData(executeContext, queryDTO);
        return ResponseEntityWrapper.wrapperOk((Object)dynamicForm);
    }
}

