/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.api;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.activity.analyzer.TaskPageDefineAnalyzer;
import com.digiwin.athena.uibot.activity.domain.DataSourceDTO;
import com.digiwin.athena.uibot.activity.domain.DataSourceSetDTO;
import com.digiwin.athena.uibot.activity.domain.PageDefine;
import com.digiwin.athena.uibot.activity.domain.TaskPageDefine;
import com.digiwin.athena.uibot.activity.domain.TmQueryAction;
import com.digiwin.athena.uibot.activity.service.ActionDataSourceAnalysisService;
import com.digiwin.athena.uibot.api.domain.QueryActionAnalysisReq;
import com.digiwin.athena.uibot.domain.QueryResult;
import com.digiwin.athena.uibot.domain.QueryResultSet;
import com.digiwin.athena.uibot.support.atdm.DataQueryService;
import com.digiwin.athena.uibot.support.atmc.AtmcService;
import com.digiwin.athena.uibot.support.atmc.domain.ActivityData;
import com.digiwin.athena.uibot.support.atmc.domain.TaskWithBacklogData;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/v1/data/"})
public class DataQueryController {
    @Autowired
    private DataQueryService dataQueryService;
    @Autowired
    private ActionDataSourceAnalysisService tmActionDataSourceService;
    @Autowired
    TaskPageDefineAnalyzer taskPageAnalysisService;
    @Autowired
    private AtmcService atmcService;

    @PostMapping(value={"query/action"})
    public ResponseEntity<?> analysisQueryAction(HttpServletRequest request, @RequestBody QueryActionAnalysisReq queryActionAnalysisReq) {
        ExecuteContext executeContext = queryActionAnalysisReq.getExecuteContext();
        if (executeContext == null) {
            executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        } else {
            executeContext.appendHttpRequest(request);
        }
        TmQueryAction tmQueryAction = (TmQueryAction)JsonUtils.jsonToObject((String)queryActionAnalysisReq.getTmAction().toString(), TmQueryAction.class);
        executeContext.setAuthoredUser(AppAuthContextHolder.getContext().getAuthoredUser());
        PageDefine pageDefine = new PageDefine();
        pageDefine.setExecuteContext(executeContext);
        DataSourceDTO dataSourceBase = this.tmActionDataSourceService.analysis(executeContext, tmQueryAction.getName(), tmQueryAction, tmQueryAction.getParas());
        DataSourceSetDTO dataSourceSet = DataSourceSetDTO.create((DataSourceDTO)dataSourceBase);
        pageDefine.setDataSourceSet(dataSourceSet);
        pageDefine.setTitle(tmQueryAction.getTitle());
        pageDefine.setRelationTag(executeContext.getRelationTag());
        return ResponseEntityWrapper.wrapperOk((Object)pageDefine);
    }

    @PostMapping(value={"query/by/activity"})
    public ResponseEntity<?> queryByActivity(HttpServletRequest request, @RequestBody ActivityData activityData) {
        List actionVOS;
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        if (StringUtils.isEmpty((String)executeContext.getPageCode())) {
            executeContext.setPageCode("task-detail");
        }
        if (StringUtils.isEmpty((String)executeContext.getTmProjectId())) {
            executeContext.setTmProjectId(activityData.getProject().getTmProjectId());
        }
        if (StringUtils.isEmpty((String)executeContext.getTmActivityId())) {
            executeContext.setTmActivityId(((TaskWithBacklogData)activityData.getTasks().get(0)).getTmActivityId());
        }
        if ((actionVOS = this.taskPageAnalysisService.analysis(executeContext, activityData)).size() == 0) {
            return ResponseEntityWrapper.wrapperOk();
        }
        PageDefine actionVO = (PageDefine)actionVOS.get(0);
        for (TaskPageDefine taskPageDefine : actionVOS) {
            if (taskPageDefine.getDataStateCode() != null && taskPageDefine.getDataStateCode().startsWith("waitting")) {
                actionVO = taskPageDefine;
                break;
            }
            if (!taskPageDefine.isDefaultShow()) continue;
            actionVO = taskPageDefine;
            break;
        }
        QueryResult queryResult = this.dataQueryService.querySingleResultByActivityQueryDTO(actionVO.getExecuteContext(), actionVO, null);
        return ResponseEntityWrapper.wrapperOk((Object)queryResult.getPageData());
    }

    @GetMapping(value={"query/task/data/{tmTaskId}/{tmActivityId}/{backlogId}"})
    public ResponseEntity<?> templateActivityShow(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="backlogId") String backlogId, @RequestParam(value="isShared", required=false) Boolean isShared, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("task-detail", tmTaskId, tmActivityId, "performer", isShared);
        ActivityData activityData = this.atmcService.getTaskData(backlogId, executeContext);
        executeContext.appendTaskData(activityData);
        List actionVOS = this.taskPageAnalysisService.analysis(executeContext, activityData);
        if (actionVOS.size() == 0) {
            return ResponseEntityWrapper.wrapperOk();
        }
        PageDefine pageDefine = (PageDefine)actionVOS.get(0);
        for (TaskPageDefine taskPageDefine : actionVOS) {
            if (taskPageDefine.getDataStateCode() != null && taskPageDefine.getDataStateCode().startsWith("waitting")) {
                pageDefine = taskPageDefine;
                break;
            }
            if (!taskPageDefine.isDefaultShow()) continue;
            pageDefine = taskPageDefine;
            break;
        }
        QueryResultSet queryResultSet = this.dataQueryService.queryByPagedefineWithMetaData(pageDefine.getExecuteContext(), pageDefine);
        return ResponseEntityWrapper.wrapperOk((Object)queryResultSet.getPageData());
    }

    @GetMapping(value={"query/task/dataByState/{tmTaskId}/{tmActivityId}/{backlogId}/{dataStateCode}"})
    public ResponseEntity<?> templateActivityShowByState(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="backlogId") String backlogId, @PathVariable(value="dataStateCode") String dataStateCode) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("task-detail", tmTaskId, tmActivityId, "performer", Boolean.valueOf(true));
        ActivityData activityData = this.atmcService.getTaskData(backlogId, executeContext);
        executeContext.appendTaskData(activityData);
        List actionVOS = this.taskPageAnalysisService.analysis(executeContext, activityData);
        if (actionVOS.size() > 0) {
            for (TaskPageDefine pageDefine : actionVOS) {
                if (null == pageDefine.getDataStateCode() || !pageDefine.getDataStateCode().startsWith(dataStateCode)) continue;
                QueryResultSet queryResultSet = this.dataQueryService.queryByPagedefineWithMetaData(pageDefine.getExecuteContext(), (PageDefine)pageDefine);
                return ResponseEntityWrapper.wrapperOk((Object)queryResultSet.getPageData());
            }
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"query/unfinished/task/data/{tmTaskId}/{tmActivityId}/{backlogId}"})
    public ResponseEntity<?> getUnfinishedData(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="backlogId") String backlogId, @RequestParam(value="isShared", required=false) Boolean isShared, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        ArrayList resultDataList = new ArrayList();
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("task-detail", tmTaskId, tmActivityId, "performer", isShared);
        ActivityData activityData = this.atmcService.getMainTaskData(backlogId, executeContext);
        executeContext.appendTaskData(activityData);
        List actionVOS = this.taskPageAnalysisService.analysis(executeContext, activityData);
        if (actionVOS.size() == 0) {
            return ResponseEntityWrapper.wrapperOk();
        }
        PageDefine pageDefine = (PageDefine)actionVOS.get(0);
        for (TaskPageDefine taskPageDefine : actionVOS) {
            if (taskPageDefine.getDataStateCode() != null && taskPageDefine.getDataStateCode().startsWith("waitting")) {
                pageDefine = taskPageDefine;
                break;
            }
            if (!taskPageDefine.isDefaultShow()) continue;
            pageDefine = taskPageDefine;
            break;
        }
        QueryResultSet wattingResultSet = this.dataQueryService.queryByPagedefineWithMetaData(pageDefine.getExecuteContext(), pageDefine);
        resultDataList.addAll(wattingResultSet.getQueryResultData());
        TaskPageDefine tracingPageDefine = null;
        for (TaskPageDefine taskPageDefine : actionVOS) {
            if (taskPageDefine.getDataStateCode() == null || !taskPageDefine.getDataStateCode().startsWith("tracing")) continue;
            tracingPageDefine = taskPageDefine;
            break;
        }
        if (tracingPageDefine != null) {
            QueryResultSet tracingResultSet = this.dataQueryService.queryByPagedefineWithMetaData(tracingPageDefine.getExecuteContext(), tracingPageDefine);
            resultDataList.addAll(tracingResultSet.getQueryResultData());
        }
        return ResponseEntityWrapper.wrapperOk(resultDataList);
    }
}

