/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.api;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.aspect.LogPrint;
import com.digiwin.athena.uibot.constant.ErrorCodeEnum;
import com.digiwin.athena.uibot.designering.service.DesignerTaskPageService;
import com.digiwin.athena.uibot.designering.service.DesignerViewService;
import com.digiwin.athena.uibot.designering.service.DesignerViewWordsService;
import com.digiwin.athena.uibot.domain.DynamicForm;
import com.digiwin.athena.uibot.param.req.DimensionRequest;
import com.digiwin.athena.uibot.param.req.WordAndDimensionSaveRequest;
import com.digiwin.athena.uibot.param.req.WordDimensionRequest;
import com.digiwin.athena.uibot.param.req.WordRequest;
import com.digiwin.athena.uibot.param.req.WordRequestV2;
import com.digiwin.athena.uibot.param.resp.WordCategoryResponse;
import com.digiwin.athena.uibot.param.resp.WordDimensionResponse;
import com.digiwin.athena.uibot.param.resp.WordResponse;
import com.digiwin.athena.uibot.util.ResponseWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8bbe\u8ba1\u5668\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/ai/v1/bot/designer"})
public class DesignerPageController {
    @Autowired
    private DesignerTaskPageService designerTaskPageService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private DesignerViewWordsService designerViewWordsService;
    @Resource
    private DesignerViewService designerViewService;

    @GetMapping(value={"/page/preview/show"})
    public ResponseEntity<?> pagePreview(HttpServletRequest request, String key) {
        return ResponseEntityWrapper.wrapperOk((Object)this.designerViewService.pagePreview(request, key));
    }

    @PostMapping(value={"/template/task/show/bydatasources"})
    ResponseEntity<?> templateDesigerTaskShowNew(HttpServletRequest request, @RequestBody Map<String, Object> dataBady) {
        if (MapUtils.isEmpty(dataBady)) {
            return ResponseEntityWrapper.wrapperOk((Object)new DynamicForm());
        }
        String tmActivityId = "";
        if (dataBady.containsKey("tmActivityId")) {
            tmActivityId = dataBady.get("tmActivityId").toString();
        }
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("task-detail", null, tmActivityId, "performer", Boolean.valueOf(false), Boolean.valueOf(true));
        Map dataSources = new HashMap();
        if (dataBady.containsKey("dataSources")) {
            if (dataBady.get("dataSources") instanceof Map) {
                dataSources = (Map)dataBady.get("dataSources");
            } else {
                return ResponseEntityWrapper.wrapperOk((Object)new DynamicForm());
            }
        }
        DynamicForm templateForm = this.designerTaskPageService.createNewActionsPage(executeContext, dataSources);
        return ResponseEntityWrapper.wrapperOk((Object)templateForm);
    }

    @PostMapping(value={"/template/task/save"})
    ResponseEntity<?> saveOrderConditionsActions(@RequestBody JSONObject fieldJson, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        this.designerTaskPageService.save(user, fieldJson);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/template/task/release/{version}/{tenantId}/{tmActivityId}"})
    public ResponseEntity<?> templateDesigerTaskRelease(HttpServletRequest request, @PathVariable(value="version") String version, @PathVariable(value="tenantId") String tenantId, @PathVariable(value="tmActivityId") String tmActivityId, @RequestParam(value="isShared", required=false) Boolean isShared, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        if (StringUtils.isEmpty((String)tmActivityId)) {
            String message = this.messageUtils.getMessage("exception.missing.input.parameter") + "tmActivityId\uff01";
            throw BusinessException.create((String)ErrorCodeEnum.TMP_TASK_RELEASE_MISSING_INPUT_PARAMETER.getErrCode(), (String)message);
        }
        if (StringUtils.isEmpty((String)tenantId)) {
            String message = this.messageUtils.getMessage("exception.missing.input.parameter") + "tenantId\uff01";
            throw BusinessException.create((String)ErrorCodeEnum.TMP_TASK_RELEASE_MISSING_INPUT_PARAMETER.getErrCode(), (String)message);
        }
        if (StringUtils.isEmpty((String)version)) {
            String message = this.messageUtils.getMessage("exception.missing.input.parameter") + "version\uff01";
            throw BusinessException.create((String)ErrorCodeEnum.TMP_TASK_RELEASE_MISSING_INPUT_PARAMETER.getErrCode(), (String)message);
        }
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("task-detail", null, tmActivityId, "performer", isShared);
        this.designerTaskPageService.release(executeContext, tenantId, version);
        return ResponseEntityWrapper.wrapperOk();
    }

    @LogPrint
    @ApiOperation(value="\u6839\u636e\u8bcd\u67e5\u5173\u7cfb")
    @PostMapping(value={"/relation/by/words"})
    public ResponseEntity<BaseResultDTO<List<WordDimensionResponse>>> queryWordDimension(@Validated @RequestBody WordDimensionRequest wordDimensionRequest) {
        return ResponseWrapper.ok((Object)this.designerViewWordsService.queryWordDimension(wordDimensionRequest));
    }

    @LogPrint
    @ApiOperation(value="\u83b7\u53d6\u63a8\u8350\u8bcd\u6761")
    @PostMapping(value={"/view/words"})
    @Deprecated
    public ResponseEntity<BaseResultDTO<WordResponse>> recommendWords(@Validated @RequestBody WordRequest wordRequest) {
        return ResponseWrapper.ok((Object)this.designerViewWordsService.recommendWords(wordRequest));
    }

    @LogPrint
    @ApiOperation(value="\u83b7\u53d6\u63a8\u8350\u8bcd\u6761V2.0")
    @PostMapping(value={"/view/words/v2"})
    public ResponseEntity<BaseResultDTO<WordResponse>> recommendWordsV2(@Validated @RequestBody WordRequestV2 wordRequestV2) {
        return ResponseWrapper.ok((Object)this.designerViewWordsService.recommendWordsV2(wordRequestV2));
    }

    @LogPrint
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u573a\u666f\u7ef4\u5ea6")
    @GetMapping(value={"/view/category"})
    public ResponseEntity<BaseResultDTO<List<WordCategoryResponse>>> queryCategoryList() {
        return ResponseWrapper.ok((Object)this.designerViewWordsService.queryCategoryList());
    }

    @LogPrint
    @ApiOperation(value="\u65b0\u589e\u573a\u666f\u7ef4\u5ea6")
    @PostMapping(value={"/word/dimension/save"})
    public ResponseEntity<BaseResultDTO<String>> saveDimension(@RequestBody DimensionRequest dimensionRequest) {
        return ResponseWrapper.ok((Object)this.designerViewWordsService.saveDimension(dimensionRequest));
    }

    @LogPrint
    @ApiOperation(value="\u7ffb\u8bd1\u5e76\u66f4\u65b0\u8868\u4e2d\u6570\u636e")
    @GetMapping(value={"/word/translate"})
    public ResponseEntity<BaseResultDTO<Boolean>> wordTranslate(String type) {
        return ResponseWrapper.ok((Object)this.designerViewWordsService.wordTranslate(type));
    }

    @LogPrint
    @ApiOperation(value="\u4fdd\u5b58\u8bcd\u6761\u548c\u7ef4\u5ea6\u5173\u7cfb")
    @PostMapping(value={"/view/word/save"})
    public ResponseEntity<BaseResultDTO<Boolean>> saveWordAndDimensionRelation(@Validated @RequestBody WordAndDimensionSaveRequest saveRequest) {
        return ResponseWrapper.ok((Object)this.designerViewWordsService.saveWordAndDimensionRelation(saveRequest));
    }
}

