/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.api;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.activity.analyzer.ProjectPageDefineAnalyzer;
import com.digiwin.athena.uibot.activity.analyzer.RetrieveDataPageDefineAnalyzer;
import com.digiwin.athena.uibot.activity.analyzer.TaskPageDefineAnalyzer;
import com.digiwin.athena.uibot.activity.analyzer.TerminateDataPageDefineAnalyzer;
import com.digiwin.athena.uibot.activity.domain.TaskPageDefine;
import com.digiwin.athena.uibot.activity.domain.TmActivity;
import com.digiwin.athena.uibot.api.domain.TaskWithdrawReqDTO;
import com.digiwin.athena.uibot.constant.ActivityConstants;
import com.digiwin.athena.uibot.domain.DynamicForm;
import com.digiwin.athena.uibot.service.TaskDataQueryService;
import com.digiwin.athena.uibot.service.TaskPageService;
import com.digiwin.athena.uibot.support.atmc.AtmcService;
import com.digiwin.athena.uibot.support.atmc.domain.ActivityData;
import com.digiwin.athena.uibot.support.iam.RoleService;
import com.digiwin.athena.uibot.support.thememap.service.ThemeMapService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/v1/bot/"})
public class TaskPageController {
    private static final Logger log = LoggerFactory.getLogger(TaskPageController.class);
    @Autowired
    private AtmcService atmcService;
    @Autowired
    private TaskPageDefineAnalyzer taskPageDefineAnalyzer;
    @Autowired
    private TerminateDataPageDefineAnalyzer terminateDataPageDefineAnalyzer;
    @Autowired
    private RetrieveDataPageDefineAnalyzer retrieveDataPageDefineAnalyzer;
    @Autowired
    private ProjectPageDefineAnalyzer projectPageDefineAnalyzer;
    @Autowired
    private TaskPageService taskPageService;
    @Resource
    private TaskDataQueryService taskDataQueryService;
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private RoleService roleService;

    @PostMapping(value={"project/card/{tmTaskId}/{projectId}"})
    public ResponseEntity<?> generateProjectCard(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="projectId") Long projectId, @RequestBody ActivityData activityData) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("project-card", tmTaskId, null, "charge", Boolean.valueOf(false));
        executeContext.appendTaskData(activityData);
        LogDto logDto = new LogDto("\u83b7\u53d6\u9879\u76ee\u5361\u4e0a\u7684\u6458\u8981\u4fe1\u606f\u5f00\u59cb,\u9879\u76eeid:" + projectId, executeContext.getAuthoredUser().getTenantId() + ";" + projectId);
        log.info(logDto.toString());
        DynamicForm projectCard = this.taskPageService.generateProjectCard(executeContext, activityData);
        LogDto logDtoEnd = new LogDto("\u83b7\u53d6\u9879\u76ee\u5361\u4e0a\u7684\u6458\u8981\u4fe1\u606f\u7ed3\u675f,\u9879\u76eeid:" + projectId, executeContext.getAuthoredUser().getTenantId() + ";" + projectId);
        log.info(logDtoEnd.toString());
        return ResponseEntityWrapper.wrapperOk((Object)projectCard);
    }

    @PostMapping(value={"project/card/{tmTaskId}/{tmActivityId}/{taskId}"})
    public ResponseEntity<?> generateTaskCardInProject(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="taskId") Long taskId, @RequestBody ActivityData activityData) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("project-card", tmTaskId, tmActivityId, "charge", Boolean.valueOf(false));
        executeContext.appendTaskData(activityData);
        return ResponseEntityWrapper.wrapperOk((Object)this.taskPageService.generateTaskCard(executeContext, activityData));
    }

    @GetMapping(value={"project/detail/{tmTaskId}/{tmActivityId}/{taskId}"})
    public ResponseEntity<?> generateProjectDetailButton(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="taskId") String taskId) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("project-detail", tmTaskId, tmActivityId, "charge", Boolean.valueOf(false));
        List queryList = this.projectPageDefineAnalyzer.analysis(executeContext, taskId);
        return ResponseEntityWrapper.wrapperOk((Object)queryList);
    }

    @PostMapping(value={"task/card/{tmTaskId}/{tmActivityId}/{backlogId}"})
    public ResponseEntity<?> generateTaskCard(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="backlogId") String backlogId, @RequestParam(value="flag", required=false) String flag, @RequestBody ActivityData activityData) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        if (StringUtils.isNotEmpty((String)flag)) {
            executeContext.appendPageInfo("task-card", tmTaskId, tmActivityId, "performer", Boolean.valueOf(false), flag);
        } else {
            executeContext.appendPageInfo("task-card", tmTaskId, tmActivityId, "performer", Boolean.valueOf(false));
        }
        executeContext.appendTaskData(activityData);
        return ResponseEntityWrapper.wrapperOk((Object)this.taskPageService.generateTaskCard(executeContext, activityData));
    }

    @PostMapping(value={"task/{tmTaskId}/{tmActivityId}/data/size"})
    public ResponseEntity<?> getTaskDataSize(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @RequestBody ActivityData activityData) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("task-card", tmTaskId, tmActivityId, "performer", Boolean.valueOf(false));
        executeContext.appendTaskData(activityData);
        return ResponseEntityWrapper.wrapperOk((Object)this.taskDataQueryService.queryTaskDataSize(executeContext, activityData));
    }

    @PostMapping(value={"project/{tmTaskId}/{tmActivityId}/data/size"})
    public ResponseEntity<?> getProjectDataSize(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @RequestBody ActivityData activityData) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("project-card", tmTaskId, tmActivityId, "performer", Boolean.valueOf(false));
        executeContext.appendTaskData(activityData);
        return ResponseEntityWrapper.wrapperOk((Object)this.taskDataQueryService.queryTaskDataSize(executeContext, activityData));
    }

    @GetMapping(value={"project/{tmTaskId}/{tmActivityId}/{taskId}/data/size"})
    public ResponseEntity<?> getProjectDataSize(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="taskId") String taskId) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("project-card", tmTaskId, tmActivityId, "performer", Boolean.valueOf(false));
        ActivityData activityData = this.atmcService.getProjectData(taskId, executeContext);
        executeContext.appendTaskData(activityData);
        return ResponseEntityWrapper.wrapperOk((Object)this.taskDataQueryService.queryTaskDataSize(executeContext, activityData));
    }

    @GetMapping(value={"task/{tmTaskId}/{tmActivityId}/{backlogId}/data/size"})
    public ResponseEntity<?> getTaskDataSizeByBacklogId(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="backlogId") String backlogId) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("project-card", tmTaskId, tmActivityId, "performer", Boolean.valueOf(false));
        ActivityData activityData = this.atmcService.getTaskData(backlogId, executeContext);
        executeContext.appendTaskData(activityData);
        return ResponseEntityWrapper.wrapperOk((Object)this.taskDataQueryService.queryTaskDataSize(executeContext, activityData));
    }

    @GetMapping(value={"template/task/show/{tmTaskId}/{tmActivityId}/{backlogId}"})
    public ResponseEntity<?> templateActivityShow(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="backlogId") String backlogId, @RequestParam(value="isShared", required=false) Boolean isShared, @RequestParam(value="isHistory", required=false) Boolean isHistory, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Boolean isSuperAdmin = Boolean.FALSE;
        if (isShared != null && isShared.booleanValue()) {
            isSuperAdmin = this.roleService.judgeSuperAdmin(user.getUserId(), user.getToken());
        }
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfoAndSuperAdmin("task-detail", tmTaskId, tmActivityId, "performer", isShared, isHistory, isSuperAdmin);
        if (Objects.equals(tmActivityId, "uibotManualTask")) {
            DynamicForm templateForm = this.taskPageService.createManuaTaskPage(executeContext, backlogId);
            return ResponseEntityWrapper.wrapperOk((Object)templateForm);
        }
        DynamicForm templateForm = this.taskPageService.createPage(executeContext, backlogId);
        return ResponseEntityWrapper.wrapperOk((Object)templateForm);
    }

    @PostMapping(value={"terminateData/page/define/{tmTaskId}/{tmActivityId}/{backlogId}"})
    public ResponseEntity<?> queryTerminateDataPageDefine(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="backlogId") Long backlogId, @RequestBody Map body) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("task-detail", tmTaskId, tmActivityId, "performer", Boolean.valueOf(false));
        ActivityData activityData = this.atmcService.getTaskData(String.valueOf(backlogId), executeContext);
        executeContext.appendTaskData(activityData);
        TmActivity tmActivity = this.themeMapService.getActivityAction(executeContext.getPageCode(), executeContext.getTmProjectId(), executeContext.getTmActivityId(), executeContext.getLocale());
        TaskPageDefine pageDefine = this.terminateDataPageDefineAnalyzer.analysis(executeContext, tmActivity, body);
        return ResponseEntityWrapper.wrapperOk((Object)pageDefine);
    }

    @PostMapping(value={"taskWithdraw/page/define"})
    public ResponseEntity<?> queryTaskWithdrawPageDefine(HttpServletRequest request, @RequestBody List<TaskWithdrawReqDTO> taskWithdrawReqList) {
        HashMap<Long, List> workItemPageDefineMap = new HashMap<Long, List>();
        if (CollectionUtils.isNotEmpty(taskWithdrawReqList)) {
            try {
                for (TaskWithdrawReqDTO taskWithdrawReq : taskWithdrawReqList) {
                    log.info("[ptm-task-withdraw-{}-{}] \u89e3\u6790pageDefine\u5b9a\u4e49, state: {}", new Object[]{taskWithdrawReq.getBacklogId(), taskWithdrawReq.getWorkItemId(), taskWithdrawReq.getState()});
                    ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
                    executeContext.appendPageInfo("task-detail", taskWithdrawReq.getProjectDefCode(), taskWithdrawReq.getTaskDefCode(), "performer", Boolean.valueOf(false));
                    ActivityData activityData = this.atmcService.getTaskData(String.valueOf(taskWithdrawReq.getWorkItemId()), executeContext);
                    executeContext.appendTaskData(activityData);
                    TmActivity tmActivity = this.themeMapService.getActivityAction(executeContext.getPageCode(), executeContext.getTmProjectId(), executeContext.getTmActivityId(), executeContext.getLocale());
                    List pageDefines = this.retrieveDataPageDefineAnalyzer.analysis(taskWithdrawReq.getBacklogId(), taskWithdrawReq.getWorkItemId(), executeContext, tmActivity, taskWithdrawReq.getBkList(), taskWithdrawReq.getState(), taskWithdrawReq.isCheckCompleted());
                    log.info("[ptm-task-withdraw-{}-{}] \u89e3\u6790pageDefine\u5b9a\u4e49, state:{}, pageDefines: {}", new Object[]{taskWithdrawReq.getBacklogId(), taskWithdrawReq.getWorkItemId(), taskWithdrawReq.getState(), JsonUtils.objectToString((Object)pageDefines)});
                    workItemPageDefineMap.put(taskWithdrawReq.getWorkItemId(), pageDefines);
                }
            }
            catch (Exception ex) {
                log.error("\u6784\u9020\u64a4\u56de\u540e\u7f6e\u5173\u8054\u4efb\u52a1\u7684\u5b9a\u4e49\u65f6\u62a5\u9519\uff1a\u5165\u53c2\uff1a{}\uff0c\u9519\u8bef\uff1a", (Object)JsonUtils.objectToString(taskWithdrawReqList), (Object)ex);
                throw ex;
            }
        }
        return ResponseEntityWrapper.wrapperOk(workItemPageDefineMap);
    }

    @GetMapping(value={"task/detail/show/{tmTaskId}/{tmActivityId}/{backlogId}"})
    public ResponseEntity<?> showTaskDetail(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="backlogId") String backlogId, @RequestParam(value="isShared", required=false) Boolean isShared, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("task-detail", tmTaskId, tmActivityId, "performer", isShared);
        DynamicForm templateForm = this.taskPageService.createPage(executeContext, backlogId);
        return ResponseEntityWrapper.wrapperOk((Object)templateForm);
    }

    @GetMapping(value={"task/page-data/{tmTaskId}/{tmActivityId}/{backlogId}"})
    public ResponseEntity<?> queryTaskAllPageData(HttpServletRequest request, @PathVariable String tmTaskId, @PathVariable String tmActivityId, @PathVariable String backlogId, @RequestAttribute(value="digi-middleware-auth-user-data") AuthoredUser user) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("task-detail", tmTaskId, tmActivityId, "performer", Boolean.valueOf(false));
        Map taskPageData = this.taskDataQueryService.queryTaskAllPageData(executeContext, backlogId);
        return ResponseEntityWrapper.wrapperOk((Object)taskPageData);
    }

    @PostMapping(value={"task/submitactions/{tmTaskId}/{tmActivityId}"})
    public ResponseEntity<?> getTaskSubmitActions(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @RequestBody ActivityData activityData) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("task-detail", tmTaskId, tmActivityId, "performer", Boolean.valueOf(false));
        executeContext.appendTaskData(activityData);
        TaskPageDefine taskPageDefine = this.taskPageDefineAnalyzer.analysisCheckCompleteAction(executeContext, activityData);
        if (taskPageDefine != null) {
            return ResponseEntityWrapper.wrapperOk((Object)taskPageDefine.getSubmitActions());
        }
        return ResponseEntityWrapper.wrapperOk(new ArrayList());
    }

    @PostMapping(value={"task/card/abstract/{tmTaskId}/{tmActivityId}/{backlogId}"})
    public ResponseEntity<?> getTaskCardAbstractStr(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="backlogId") String backlogId, @RequestBody ActivityData activityData, @RequestParam(value="flag", required=false) String flag) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        if (StringUtils.isNotEmpty((String)flag)) {
            executeContext.appendPageInfo("task-card", tmTaskId, tmActivityId, "performer", Boolean.valueOf(false), flag);
        } else {
            executeContext.appendPageInfo("task-card", tmTaskId, tmActivityId, "performer", Boolean.valueOf(false));
        }
        executeContext.appendTaskData(activityData);
        LogDto logDto = new LogDto("\u6839\u636e\u4efb\u52a1\u83b7\u53d6\u4efb\u52a1\u5361\u4e0a\u7684\u6458\u8981\u4fe1\u606f\u5f00\u59cb,\u5f85\u529eid:" + backlogId, executeContext.getAuthoredUser().getTenantId() + ";" + backlogId);
        log.info(logDto.toString());
        Map taskCardAbstractStr = this.taskPageService.getTaskCardAbstractStr(executeContext, activityData);
        LogDto logDtoEnd = new LogDto("\u6839\u636e\u4efb\u52a1\u83b7\u53d6\u4efb\u52a1\u5361\u4e0a\u7684\u6458\u8981\u4fe1\u606f\u7ed3\u675f,\u5f85\u529eid:" + backlogId, executeContext.getAuthoredUser().getTenantId() + ";" + backlogId);
        log.info(logDtoEnd.toString());
        return ResponseEntityWrapper.wrapperOk((Object)taskCardAbstractStr);
    }

    @PostMapping(value={"task/getCardTitle/{tmTaskId}/{tmActivityId}"})
    public ResponseEntity<?> getCardTitle(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @RequestBody ActivityData activityData) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("task-card", tmTaskId, tmActivityId, "performer", Boolean.valueOf(false));
        executeContext.appendTaskData(activityData);
        log.info("\u6839\u636e\u4efb\u52a1\u83b7\u53d6\u4efb\u52a1\u5361\u4e0a\u6807\u9898,tmTaskId:{},tmActivityId:{}", (Object)tmTaskId, (Object)tmActivityId);
        Map cardTitle = this.taskPageService.getCardTitle(executeContext, activityData);
        log.info("\u6839\u636e\u4efb\u52a1\u83b7\u53d6\u4efb\u52a1\u5361\u4e0a\u6807\u9898\u7ed3\u675f,tmTaskId:{},tmActivityId:{},\u6807\u9898\u6570\u636e:{}", new Object[]{tmTaskId, tmActivityId, cardTitle});
        return ResponseEntityWrapper.wrapperOk((Object)cardTitle);
    }

    @GetMapping(value={"task/card/abstract/{tmTaskId}/{tmActivityId}/{backlogId}/{needHistoryInfo}"})
    public ResponseEntity<?> getTaskCardAbstractStr(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="backlogId") String backlogId, @RequestParam(value="flag", required=false) String flag) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        if (StringUtils.isNotEmpty((String)flag)) {
            executeContext.appendPageInfo("task-card", tmTaskId, tmActivityId, "performer", Boolean.valueOf(false), flag);
        } else {
            executeContext.appendPageInfo("task-card", tmTaskId, tmActivityId, "performer", Boolean.valueOf(false));
        }
        ActivityData activityData = this.atmcService.getTaskData(backlogId, executeContext);
        executeContext.appendTaskData(activityData);
        return ResponseEntityWrapper.wrapperOk((Object)this.taskPageService.getTaskCardAbstractStr(executeContext, activityData));
    }

    @PostMapping(value={"project/card/abstract/{tmTaskId}/{projectId}"})
    public ResponseEntity<?> geteProjectCardAbstractStr(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="projectId") Long projectId, @RequestBody ActivityData activityData) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("project-card", tmTaskId, null, "charge", Boolean.valueOf(false));
        executeContext.appendTaskData(activityData);
        LogDto logDto = new LogDto("\u83b7\u53d6\u9879\u76ee\u5361\u4e0a\u7684\u6458\u8981\u4fe1\u606f\u5f00\u59cb,\u9879\u76eeid:" + projectId, executeContext.getAuthoredUser().getTenantId() + ";" + projectId);
        log.info(logDto.toString());
        Map projectCardAbstract = this.taskPageService.getProjectCardAbstractStr(executeContext, activityData);
        LogDto logDtoEnd = new LogDto("\u83b7\u53d6\u9879\u76ee\u5361\u4e0a\u7684\u6458\u8981\u4fe1\u606f\u7ed3\u675f,\u9879\u76eeid:" + projectId, executeContext.getAuthoredUser().getTenantId() + ";" + projectId);
        log.info(logDtoEnd.toString());
        return ResponseEntityWrapper.wrapperOk((Object)projectCardAbstract);
    }

    @PostMapping(value={"project/card/abstract/{tmTaskId}/{tmActivityId}/{taskId}"})
    public ResponseEntity<?> generateTaskCardInProjectAbstractStr(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="taskId") Long taskId, @RequestBody ActivityData activityData) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("project-card", tmTaskId, tmActivityId, "charge", Boolean.valueOf(false));
        executeContext.appendTaskData(activityData);
        return ResponseEntityWrapper.wrapperOk((Object)this.taskPageService.getTaskCardAbstractStr(executeContext, activityData));
    }

    @GetMapping(value={"project/card/abstract/{tmTaskId}/{tmActivityId}/{taskId}/{needHistoryInfo}"})
    public ResponseEntity<?> generateTaskCardInProjectAbstractStr(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="taskId") String taskId) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("project-card", tmTaskId, tmActivityId, "charge", Boolean.valueOf(false));
        ActivityData activityData = this.atmcService.getProjectData(taskId, executeContext);
        executeContext.appendTaskData(activityData);
        return ResponseEntityWrapper.wrapperOk((Object)this.taskPageService.getTaskCardAbstractStr(executeContext, activityData));
    }

    @PostMapping(value={"template/simple/show"})
    public ResponseEntity<?> templateManuaTaskShow(HttpServletRequest request, @RequestBody Map<String, Object> body, @RequestParam(value="isShared", required=false) Boolean isShared, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        String tmActivityId = null;
        if (body.get("tmActivityId") != null) {
            tmActivityId = body.get("tmActivityId").toString();
            executeContext.setTmActivityId(tmActivityId);
            executeContext.setPageCode("task-detail");
        }
        if (StringUtils.isEmpty(tmActivityId)) {
            return ResponseEntityWrapper.wrapperOk((Object)new DynamicForm());
        }
        if (Objects.equals(tmActivityId, "uibotManualTask")) {
            Long teamId;
            BaseResultDTO baseResultDTO;
            if (MapUtils.isNotEmpty(body) && null != body.get("teamId") && !(baseResultDTO = this.atmcService.checkUserInCalendarTeam(teamId = Long.valueOf(Long.parseLong(body.get("teamId").toString())))).isOK()) {
                return ResponseEntity.ok((Object)baseResultDTO);
            }
            DynamicForm templateForm = this.taskPageService.createManuaTaskPage(executeContext, null);
            return ResponseEntityWrapper.wrapperOk((Object)templateForm);
        }
        Map parameter = null;
        if (body.get("params") != null) {
            parameter = (Map)body.get("params");
        }
        executeContext.appendPageInfo("task-detail", null, tmActivityId, "performer", isShared);
        ArrayList<Map> bpmDataList = new ArrayList<Map>();
        bpmDataList.add(parameter);
        executeContext.setAllBpmData(bpmDataList);
        DynamicForm templateForm = this.taskPageService.createSimplePage(executeContext, parameter);
        return ResponseEntityWrapper.wrapperOk((Object)templateForm);
    }

    @GetMapping(value={"dataUniformity/pageDefine/{tmTaskId}/{tmActivityId}/{backlogId}"})
    public ResponseEntity<?> getTaskPageDefine(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="backlogId") String backlogId, @RequestParam(value="isShared", required=false) Boolean isShared, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("task-detail", tmTaskId, tmActivityId, "performer", isShared);
        return ResponseEntityWrapper.wrapperOk((Object)this.taskPageService.analysisDataUniformityPageDefine(executeContext, backlogId));
    }

    @GetMapping(value={"task/dataUniformity/history/{backlogId}"})
    public ResponseEntity<?> getTaskPageDefine(HttpServletRequest request, @PathVariable(value="backlogId") String backlogId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        return ResponseEntityWrapper.wrapperOk((Object)this.taskPageService.analysisDataUniformityHistory(executeContext, backlogId));
    }

    @PostMapping(value={"task/card/abstract/up/to/date/{tmTaskId}/{tmActivityId}/{backlogId}"})
    public ResponseEntity<?> getUpToDateTaskCardAbstractStr(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="backlogId") String backlogId, @RequestBody ActivityData activityData, @RequestParam(value="flag", required=false) String flag) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        if (StringUtils.isNotEmpty((String)flag)) {
            executeContext.appendPageInfo("task-card", tmTaskId, tmActivityId, "performer", Boolean.valueOf(false), flag);
        } else {
            executeContext.appendPageInfo("task-card", tmTaskId, tmActivityId, "performer", Boolean.valueOf(false));
        }
        executeContext.appendTaskData(activityData);
        LogDto logDto = new LogDto("\u83b7\u53d6\u4efb\u52a1\u5361\u4e0a\u7684\u6700\u65b0\u7684\u6458\u8981\u4fe1\u606f\u5f00\u59cb,\u5f85\u529eid:" + backlogId, executeContext.getAuthoredUser().getTenantId() + ";" + backlogId);
        log.info(logDto.toString());
        Map upToDateTaskCardAbstractStr = this.taskPageService.getUpToDateTaskCardAbstractStr(executeContext, activityData, backlogId);
        LogDto logDtoEnd = new LogDto("\u83b7\u53d6\u4efb\u52a1\u5361\u4e0a\u7684\u6700\u65b0\u7684\u6458\u8981\u4fe1\u606f\u5b8c\u6210,\u5f85\u529eid:" + backlogId, executeContext.getAuthoredUser().getTenantId() + ";" + backlogId);
        log.info(logDtoEnd.toString());
        return ResponseEntityWrapper.wrapperOk((Object)upToDateTaskCardAbstractStr);
    }

    @PostMapping(value={"/submitactions/{tmTaskId}/{tmActivityId}/{pageCode}"})
    public ResponseEntity<?> getSubmitActions(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="pageCode") String pageCode, @RequestBody ActivityData activityData) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo(pageCode, tmTaskId, tmActivityId, (String)ActivityConstants.PAGE_CODE_TO_IDENTITY.get(pageCode), Boolean.valueOf(false));
        executeContext.appendTaskData(activityData);
        TaskPageDefine taskPageDefine = this.taskPageDefineAnalyzer.analysisCheckCompleteAction(executeContext, activityData);
        if (taskPageDefine != null) {
            return ResponseEntityWrapper.wrapperOk((Object)taskPageDefine.getSubmitActions());
        }
        return ResponseEntityWrapper.wrapperOk(new ArrayList());
    }
}

